/**
 *	@file	np2arg.cpp
 *	@brief	NX̓̒`s܂
 */

#include "compiler.h"
#include "np2arg.h"
#include "dosio.h"

#define	MAXARG		32				//!< őGg
#define	ARG_BASE	1				//!< win32  lpszCmdLine ̏ꍇ̊JnGg

//! B̃CX^Xł
Np2Arg Np2Arg::sm_instance;

/**
 * RXgN^
 */
Np2Arg::Np2Arg()
{
	ZeroMemory(this, sizeof(*this));
}

/**
 * fXgN^
 */
Np2Arg::~Np2Arg()
{
	free(m_lpArg);
}

/**
 * p[X
 */
void Np2Arg::Parse()
{
	// ǂݏo
	free(m_lpArg);
	m_lpArg = _tcsdup(::GetCommandLine());

	LPTSTR argv[MAXARG];
	const int argc = ::milstr_getarg(m_lpArg, argv, _countof(argv));

	int nDrive = 0;

	for (int i = ARG_BASE; i < argc; i++)
	{
		LPCTSTR lpArg = argv[i];
		if ((lpArg[0] == TEXT('/')) || (lpArg[0] == TEXT('-')))
		{
			switch (_totlower(lpArg[1]))
			{
				case 'f':
					m_fFullscreen = true;
					break;

				case 'i':
					m_lpIniFile = &lpArg[2];
					break;
			}
		}
		else
		{
			LPCTSTR lpExt = ::file_getext(lpArg);
			if (::file_cmpname(lpExt, TEXT("ini")) == 0)
			{
				m_lpIniFile = lpArg;
			}
			else if (nDrive < _countof(m_lpDisk))
			{
				m_lpDisk[nDrive++] = lpArg;
			}
		}
	}
}

/**
 * fBXNNA
 */
void Np2Arg::ClearDisk()
{
	ZeroMemory(m_lpDisk, sizeof(m_lpDisk));
}
