/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink;

import com.almworks.tracker.eapi.alpha.TrackerApplication;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.codelinks.CodeLinkTypeColumns;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.ListTableModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueLinkModel {
    public static final int INTEGRATE_WITH_NONE = 0;
    public static final int INTEGRATE_WITH_DESKZILLA = 1;
    public static final int INTEGRATE_WITH_JIRA_CLIENT = 2;
    private final List<CodeLinkType> myInitialTypeList = new ArrayList<CodeLinkType>(1);
    private final ListTableModel<CodeLinkType> myListTableModel;
    private final List<Runnable> myApplyingJobs = new ArrayList<Runnable>(1);
    private final List<Runnable> myResetJobs = new ArrayList<Runnable>(1);
    private String myInitialDeskzillaWorkspace = "";
    private boolean myInitialStartAutomatically = false;
    private boolean myInitialAutodetectStatus = true;
    private int myInitialIntegrateWith = 0;
    public List<CodeLinkType> myCurrentTypeList = new ArrayList<CodeLinkType>(1);
    public boolean myStartAutomatically = false;
    public String myDeskzillaWorkspace = "";
    public int myIntegrateWith = 0;
    public boolean myAutodetectStatus = true;

    public IssueLinkModel() {
        this.myListTableModel = new ListTableModel(CodeLinkTypeColumns.getColumnInfos());
        this.myListTableModel.setItems(this.myCurrentTypeList);
    }

    public ListTableModel<CodeLinkType> getListTableModel() {
        return this.myListTableModel;
    }

    public void add(CodeLinkType type) {
        this.myCurrentTypeList.add(type);
        this.myListTableModel.fireTableRowsInserted(this.myCurrentTypeList.size() - 1, this.myCurrentTypeList.size() - 1);
    }

    @Nullable
    public CodeLinkType get(int row) {
        return this.myCurrentTypeList.size() > row ? this.myCurrentTypeList.get(row) : null;
    }

    @Nullable
    public CodeLinkType getOld(int row) {
        return this.myInitialTypeList.size() > row ? this.myInitialTypeList.get(row) : null;
    }

    public synchronized void replace(CodeLinkType oldType, CodeLinkType newType) {
        int i = this.myCurrentTypeList.indexOf((Object)oldType);
        if (i != -1) {
            this.myCurrentTypeList.remove(i);
            this.myCurrentTypeList.add(i, newType);
            this.myListTableModel.fireTableRowsUpdated(i, i);
        }
    }

    public void remove(int row) {
        this.myCurrentTypeList.remove(row);
        this.myListTableModel.fireTableRowsDeleted(row, row);
    }

    public int size() {
        return this.myCurrentTypeList.size();
    }

    public void loadState(IssueLinkModel state) {
        this.myCurrentTypeList.addAll(state.myCurrentTypeList);
        this.setIntegrateWith(state.getIntegrateWith());
        this.setDeskzillaWorkspace(state.getDeskzillaWorkspace());
        this.setAutodetectStatus(state.getAutodetectStatus());
        this.setAutoStartingAllowed(state.isAutoStartingAllowed());
        this.apply();
    }

    private int validateIntegrateWith(int integrateWith) {
        if (integrateWith != 1 && integrateWith != 2 && integrateWith != 0) {
            return 0;
        }
        return integrateWith;
    }

    public synchronized boolean isModified() {
        return !((Object)this.myInitialTypeList).equals(this.myCurrentTypeList) || this.myInitialStartAutomatically != this.isAutoStartingAllowed() || this.myInitialAutodetectStatus != this.myAutodetectStatus || !Comparing.strEqual((String)this.myInitialDeskzillaWorkspace, (String)this.myDeskzillaWorkspace) || this.myInitialIntegrateWith != this.myIntegrateWith;
    }

    public synchronized boolean apply() {
        boolean result = !((Object)this.myInitialTypeList).equals(this.myCurrentTypeList);
        this.myInitialTypeList.clear();
        this.myInitialTypeList.addAll(this.myCurrentTypeList);
        this.myInitialStartAutomatically = this.myStartAutomatically;
        this.myInitialAutodetectStatus = this.myAutodetectStatus;
        this.myInitialDeskzillaWorkspace = this.myDeskzillaWorkspace;
        this.myInitialIntegrateWith = this.myIntegrateWith;
        for (Runnable runnable : this.myApplyingJobs) {
            runnable.run();
        }
        return result;
    }

    public void addApplyingJob(Runnable job) {
        this.myApplyingJobs.add(job);
    }

    public void removeApplyingJob(Runnable job) {
        this.myApplyingJobs.remove(job);
    }

    public void addResetJob(Runnable job) {
        this.myResetJobs.add(job);
    }

    public void removeResetJob(Runnable job) {
        this.myResetJobs.remove(job);
    }

    public synchronized void reset() {
        this.myCurrentTypeList.clear();
        this.myCurrentTypeList.addAll(this.myInitialTypeList);
        this.myListTableModel.fireTableDataChanged();
        this.myStartAutomatically = this.myInitialStartAutomatically;
        this.myAutodetectStatus = this.myInitialAutodetectStatus;
        this.myDeskzillaWorkspace = this.myInitialDeskzillaWorkspace;
        this.myIntegrateWith = this.myInitialIntegrateWith;
        for (Runnable runnable : this.myResetJobs) {
            runnable.run();
        }
    }

    public List<CodeLinkType> getReferenceTypes() {
        return Collections.unmodifiableList(this.myInitialTypeList);
    }

    public void setAutoStartingAllowed(boolean status) {
        this.myStartAutomatically = status;
    }

    public boolean isAutoStartingAllowed() {
        return this.myStartAutomatically;
    }

    public String getDeskzillaWorkspace() {
        return this.myDeskzillaWorkspace;
    }

    public void setDeskzillaWorkspace(String deskzillaWorkspace) {
        String dirName = deskzillaWorkspace == null ? "" : deskzillaWorkspace.trim();
        try {
            new File(dirName);
        }
        catch (Exception e) {
            dirName = "";
        }
        this.myDeskzillaWorkspace = dirName;
    }

    public boolean getAutodetectStatus() {
        return this.myAutodetectStatus;
    }

    public void setAutodetectStatus(boolean autodetectStatus) {
        this.myAutodetectStatus = autodetectStatus;
    }

    public String getDeskzillaWorkspaceSelector() {
        return this.getAutodetectStatus() ? null : this.getDeskzillaWorkspace();
    }

    public int getIntegrateWith() {
        return this.myIntegrateWith;
    }

    public void setIntegrateWith(int integrateWith) {
        this.myIntegrateWith = this.validateIntegrateWith(integrateWith);
    }

    public void getSettingsFrom(IssueLinkModel model) {
        this.myStartAutomatically = model.myStartAutomatically;
        this.myAutodetectStatus = model.myAutodetectStatus;
        this.myDeskzillaWorkspace = model.myDeskzillaWorkspace;
        this.myIntegrateWith = model.myIntegrateWith;
        List<CodeLinkType> linkTypes = model.getReferenceTypes();
        this.myCurrentTypeList.clear();
        for (CodeLinkType codeLinkType : linkTypes) {
            this.myCurrentTypeList.add(new CodeLinkType(codeLinkType.getPatternString(), codeLinkType.getReplacePattern()));
        }
        this.apply();
    }

    public TrackerApplication getApplication() {
        int integrateWith = this.getIntegrateWith();
        Object application = integrateWith == 1 ? TrackerApplication.DESKZILLA : (integrateWith == 2 ? TrackerApplication.JIRA_CLIENT : null);
        return application;
    }

    public String getApplicationDisplayName() {
        return IssueLinkModel.getApplicationDisplayName(this.getApplication());
    }

    public String getApplicationDisplayNameNotNull() {
        return Utils.notNull(this.getApplicationDisplayName(), "");
    }

    public static String getApplicationDisplayName(TrackerApplication app) {
        if (app == null) {
            return null;
        }
        switch (app) {
            case DESKZILLA: {
                return StringBundle.get("application.deskzilla.name", new Object[0]);
            }
            case JIRA_CLIENT: {
                return StringBundle.get("application.jiraclient.name", new Object[0]);
            }
        }
        return null;
    }
}

