/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.runtime.io.ContentDirection;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.content.ContentReader;
import io.smallrye.openapi.runtime.io.example.ExampleReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.io.schema.SchemaReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.annotations.enums.Explode;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ParameterReader {
    private static final Map<String, Parameter.In> PARAMETER_IN_LOOKUP;
    private static final Map<String, Parameter.Style> PARAMETER_STYLE_LOOKUP;

    private ParameterReader() {
    }

    public static Optional<List<Parameter>> readParametersList(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue != null) {
            AnnotationInstance[] nestedArray;
            IoLogging.logger.annotationsList("@Parameter");
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
                Parameter parameter = ParameterReader.readParameter(context, nested);
                if (parameter == null) continue;
                parameters.add(parameter);
            }
            return Optional.of(parameters);
        }
        return Optional.empty();
    }

    public static Optional<List<Parameter>> readParameterList(JsonNode node) {
        if (node != null && node.isArray()) {
            IoLogging.logger.jsonList("Parameter");
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode paramNode : arrayNode) {
                params.add(ParameterReader.readParameter(paramNode));
            }
            return Optional.of(params);
        }
        return Optional.empty();
    }

    public static Map<String, Parameter> readParameters(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@Parameter");
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            Parameter parameter;
            String name = (String)context.annotations().value(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null || (parameter = ParameterReader.readParameter(context, nested)) == null) continue;
            parameters.put(name, parameter);
        }
        return parameters;
    }

    public static Map<String, Parameter> readParameters(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.jsonMap("Parameters");
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            parameters.put(fieldName, ParameterReader.readParameter(childNode));
        }
        return parameters;
    }

    public static Parameter readParameter(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@Parameter");
        ParameterImpl parameter = new ParameterImpl();
        parameter.setName((String)context.annotations().value(annotationInstance, "name"));
        parameter.setIn(context.annotations().enumValue(annotationInstance, "in", Parameter.In.class));
        Boolean isHidden = (Boolean)context.annotations().value(annotationInstance, "hidden");
        if (Boolean.TRUE.equals(isHidden)) {
            ParameterImpl.setHidden(parameter, true);
            return parameter;
        }
        parameter.setDescription((String)context.annotations().value(annotationInstance, "description"));
        parameter.setRequired((Boolean)context.annotations().value(annotationInstance, "required"));
        parameter.setDeprecated((Boolean)context.annotations().value(annotationInstance, "deprecated"));
        parameter.setAllowEmptyValue((Boolean)context.annotations().value(annotationInstance, "allowEmptyValue"));
        parameter.setStyle(context.annotations().enumValue(annotationInstance, "style", Parameter.Style.class));
        parameter.setExplode(ParameterReader.readExplode(context, annotationInstance));
        parameter.setAllowReserved((Boolean)context.annotations().value(annotationInstance, "allowReserved"));
        parameter.setSchema(SchemaFactory.readSchema(context, annotationInstance.value("schema")));
        parameter.setContent(ContentReader.readContent(context, annotationInstance.value("content"), ContentDirection.PARAMETER));
        parameter.setExamples(ExampleReader.readExamples(context, annotationInstance.value("examples")));
        parameter.setExample(ExampleReader.parseValue(context, (String)context.annotations().value(annotationInstance, "example")));
        parameter.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.PARAMETER));
        if (annotationInstance.target() != null) {
            switch (annotationInstance.target().kind()) {
                case FIELD: 
                case METHOD_PARAMETER: {
                    parameter.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
                    break;
                }
            }
            parameter.setParamRef(JandexUtil.createUniqueAnnotationTargetRef(annotationInstance.target()));
        }
        return parameter;
    }

    public static Parameter readParameter(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonObject("Parameter");
        ParameterImpl parameter = new ParameterImpl();
        parameter.setName(JsonUtil.stringProperty(node, "name"));
        parameter.setIn(ParameterReader.readParameterIn(node.get("in")));
        parameter.setDescription(JsonUtil.stringProperty(node, "description"));
        parameter.setRequired(JsonUtil.booleanProperty(node, "required").orElse(null));
        parameter.setDeprecated(JsonUtil.booleanProperty(node, "deprecated").orElse(null));
        parameter.setAllowEmptyValue(JsonUtil.booleanProperty(node, "allowEmptyValue").orElse(null));
        parameter.setStyle(ParameterReader.readParameterStyle(node.get("style")));
        parameter.setExplode(JsonUtil.booleanProperty(node, "explode").orElse(null));
        parameter.setAllowReserved(JsonUtil.booleanProperty(node, "allowReserved").orElse(null));
        parameter.setSchema(SchemaReader.readSchema(node.get("schema")));
        parameter.setContent(ContentReader.readContent(node.get("content")));
        parameter.setExamples(ExampleReader.readExamples(node.get("examples")));
        parameter.setExample(JsonUtil.readObject(node.get("example")));
        parameter.setRef(JsonUtil.stringProperty(node, "$ref"));
        ExtensionReader.readExtensions(node, parameter);
        return parameter;
    }

    private static Boolean readExplode(AnnotationScannerContext context, AnnotationInstance parameterAnnoatation) {
        Explode explode = context.annotations().enumValue(parameterAnnoatation, "explode", Explode.class);
        if (explode == Explode.TRUE) {
            return Boolean.TRUE;
        }
        if (explode == Explode.FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static Parameter.In readParameterIn(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return PARAMETER_IN_LOOKUP.get(node.asText());
    }

    private static Parameter.Style readParameterStyle(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return PARAMETER_STYLE_LOOKUP.get(node.asText());
    }

    static {
        Parameter.Style[] parameterStyleValues;
        Parameter.In[] parameterIns;
        PARAMETER_IN_LOOKUP = new LinkedHashMap<String, Parameter.In>();
        PARAMETER_STYLE_LOOKUP = new LinkedHashMap<String, Parameter.Style>();
        for (Parameter.In type : parameterIns = Parameter.In.values()) {
            PARAMETER_IN_LOOKUP.put(type.toString(), type);
        }
        for (Parameter.Style style : parameterStyleValues = Parameter.Style.values()) {
            PARAMETER_STYLE_LOOKUP.put(style.toString(), style);
        }
    }
}

