/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.servervariable;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.servers.ServerVariableImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ServerVariableReader {
    private ServerVariableReader() {
    }

    public static Map<String, ServerVariable> readServerVariables(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsArray("@ServerVariable");
        AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
        LinkedHashMap<String, ServerVariable> variables = new LinkedHashMap<String, ServerVariable>();
        for (AnnotationInstance serverVariableAnno : nestedArray) {
            String name = (String)context.annotations().value(serverVariableAnno, "name");
            if (name == null) continue;
            variables.put(name, ServerVariableReader.readServerVariable(context, serverVariableAnno));
        }
        return variables;
    }

    public static Map<String, ServerVariable> readServerVariables(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.logger.jsonNodeMap("ServerVariable");
        LinkedHashMap<String, ServerVariable> variables = new LinkedHashMap<String, ServerVariable>();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            if (ExtensionConstant.isExtensionField(fieldName)) continue;
            JsonNode varNode = node.get(fieldName);
            variables.put(fieldName, ServerVariableReader.readServerVariable(varNode));
        }
        return variables;
    }

    private static ServerVariable readServerVariable(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@ServerVariable");
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setDescription((String)context.annotations().value(annotationInstance, "description"));
        String[] enumeration = (String[])context.annotations().value(annotationInstance, "enumeration");
        if (enumeration != null) {
            variable.setEnumeration(new ArrayList<String>(Arrays.asList(enumeration)));
        }
        variable.setDefaultValue((String)context.annotations().value(annotationInstance, "defaultValue"));
        variable.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return variable;
    }

    private static ServerVariable readServerVariable(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.logger.singleJsonNode("ServerVariable");
        ServerVariableImpl variable = new ServerVariableImpl();
        JsonNode enumNode = node.get("enum");
        if (enumNode != null && enumNode.isArray()) {
            ArrayList<String> enums = new ArrayList<String>(enumNode.size());
            for (JsonNode n : enumNode) {
                enums.add(n.asText());
            }
            variable.setEnumeration(enums);
        }
        variable.setDefaultValue(JsonUtil.stringProperty(node, "default"));
        variable.setDescription(JsonUtil.stringProperty(node, "description"));
        ExtensionReader.readExtensions(node, variable);
        return variable;
    }
}

