/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.serial.SerialPort;
import org.openhab.core.io.transport.serial.SerialPortEvent;
import org.openhab.core.io.transport.serial.SerialPortEventListener;
import org.openhab.core.io.transport.serial.UnsupportedCommOperationException;
import org.openhab.core.io.transport.serial.internal.SerialPortEventImpl;

@NonNullByDefault
public class SerialPortImpl
implements SerialPort {
    private final javax.comm.SerialPort sp;

    public SerialPortImpl(javax.comm.SerialPort sp) {
        this.sp = sp;
    }

    public void close() {
        this.sp.close();
    }

    public void setSerialPortParams(int baudrate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        try {
            this.sp.setSerialPortParams(baudrate, dataBits, stopBits, parity);
        }
        catch (javax.comm.UnsupportedCommOperationException ex) {
            throw new UnsupportedCommOperationException((Throwable)ex);
        }
    }

    public @Nullable InputStream getInputStream() throws IOException {
        return this.sp.getInputStream();
    }

    public @Nullable OutputStream getOutputStream() throws IOException {
        return this.sp.getOutputStream();
    }

    public void addEventListener(final SerialPortEventListener listener) throws TooManyListenersException {
        this.sp.addEventListener(new javax.comm.SerialPortEventListener(){

            public void serialEvent(@Nullable javax.comm.SerialPortEvent event) {
                if (event == null) {
                    return;
                }
                listener.serialEvent((SerialPortEvent)new SerialPortEventImpl(event));
            }
        });
    }

    public void removeEventListener() {
        this.sp.removeEventListener();
    }

    public void notifyOnDataAvailable(boolean enable) {
        this.sp.notifyOnDataAvailable(enable);
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        this.sp.notifyOnBreakInterrupt(enable);
    }

    public void notifyOnFramingError(boolean enable) {
        this.sp.notifyOnFramingError(enable);
    }

    public void notifyOnOverrunError(boolean enable) {
        this.sp.notifyOnOverrunError(enable);
    }

    public void notifyOnParityError(boolean enable) {
        this.sp.notifyOnParityError(enable);
    }

    public void setRTS(boolean enable) {
        this.sp.setRTS(enable);
    }

    public void enableReceiveTimeout(int timeout) throws UnsupportedCommOperationException {
        if (timeout < 0) {
            throw new IllegalArgumentException(String.format("timeout must be non negative (is: %d)", timeout));
        }
        try {
            this.sp.enableReceiveTimeout(timeout);
        }
        catch (javax.comm.UnsupportedCommOperationException ex) {
            throw new UnsupportedCommOperationException((Throwable)ex);
        }
    }

    public void disableReceiveTimeout() {
        this.sp.disableReceiveTimeout();
    }

    public String getName() {
        return this.sp.getName();
    }

    public void setFlowControlMode(int flowcontrolRtsctsOut) throws UnsupportedCommOperationException {
        try {
            this.sp.setFlowControlMode(flowcontrolRtsctsOut);
        }
        catch (javax.comm.UnsupportedCommOperationException e) {
            throw new UnsupportedCommOperationException((Throwable)e);
        }
    }

    public void enableReceiveThreshold(int i) throws UnsupportedCommOperationException {
        try {
            this.sp.enableReceiveThreshold(i);
        }
        catch (javax.comm.UnsupportedCommOperationException e) {
            throw new UnsupportedCommOperationException((Throwable)e);
        }
    }

    public int getBaudRate() {
        return this.sp.getBaudRate();
    }

    public int getDataBits() {
        return this.sp.getDataBits();
    }

    public int getStopBits() {
        return this.sp.getStopBits();
    }

    public int getParity() {
        return this.sp.getParity();
    }

    public void notifyOnOutputEmpty(boolean enable) {
        this.sp.notifyOnOutputEmpty(enable);
    }

    public void notifyOnCTS(boolean enable) {
        this.sp.notifyOnCTS(enable);
    }

    public void notifyOnDSR(boolean enable) {
        this.sp.notifyOnDSR(enable);
    }

    public void notifyOnRingIndicator(boolean enable) {
        this.sp.notifyOnRingIndicator(enable);
    }

    public void notifyOnCarrierDetect(boolean enable) {
        this.sp.notifyOnCarrierDetect(enable);
    }

    public int getFlowControlMode() {
        return this.sp.getFlowControlMode();
    }

    public boolean isRTS() {
        return this.sp.isRTS();
    }

    public void setDTR(boolean state) {
        this.sp.setDTR(state);
    }

    public boolean isDTR() {
        return this.sp.isDTR();
    }

    public boolean isCTS() {
        return this.sp.isCTS();
    }

    public boolean isDSR() {
        return this.sp.isDSR();
    }

    public boolean isCD() {
        return this.sp.isCD();
    }

    public boolean isRI() {
        return this.sp.isRI();
    }

    public void sendBreak(int duration) {
        this.sp.sendBreak(duration);
    }
}

