/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.SnapshotsListener;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSession;
import org.graalvm.visualvm.lib.profiler.v2.impl.SnapshotsWindowHelper;
import org.graalvm.visualvm.lib.profiler.v2.impl.SnapshotsWindowUI;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SnapshotsWindow {
    private static SnapshotsWindow INSTANCE;
    private final SnapshotsListener snapshotsListener = (SnapshotsListener)Lookup.getDefault().lookup(SnapshotsWindowHelper.class);
    private SnapshotsWindowUI ui;

    public static synchronized SnapshotsWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new SnapshotsWindow();
        }
        return INSTANCE;
    }

    private SnapshotsWindow() {
        TopComponent.getRegistry().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("tcClosed".equals(evt.getPropertyName()) && SnapshotsWindow.this.ui != null && evt.getNewValue() == SnapshotsWindow.this.ui) {
                    SnapshotsWindow.this.ui = null;
                }
            }
        });
    }

    public void showStandalone() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(true);
                ui.open();
                ui.requestActive();
            }
        });
    }

    public void sessionOpened(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(false);
                if (ui == null && ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy() == 1) {
                    ui = SnapshotsWindow.this.getUI(true);
                    ui.setProject(session.getProject());
                    ui.open();
                } else if (ui != null) {
                    ui.setProject(session.getProject());
                }
            }
        });
    }

    public void sessionActivated(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(false);
                if (ui == null && ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy() == 2) {
                    ui = SnapshotsWindow.this.getUI(true);
                    ui.setProject(session.getProject());
                    ui.open();
                } else if (ui != null) {
                    ui.setProject(session.getProject());
                }
            }
        });
    }

    public void sessionDeactivated(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(false);
                if (ui != null) {
                    if (ProfilerIDESettings.getInstance().getSnapshotWindowClosePolicy() == 2) {
                        ui.close();
                    }
                    ui.resetProject(session.getProject());
                }
            }
        });
    }

    public void sessionClosed(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(false);
                if (ui != null) {
                    if (ProfilerIDESettings.getInstance().getSnapshotWindowClosePolicy() == 1) {
                        ui.close();
                    }
                    ui.resetProject(session.getProject());
                }
            }
        });
    }

    public void snapshotSaved(LoadedSnapshot snapshot) {
        assert (!SwingUtilities.isEventDispatchThread());
        int policy = ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy();
        if (policy == 3 && ResultsManager.getDefault().getSnapshotsCountFor(snapshot.getProject()) == 1 || policy == 4) {
            final Lookup.Provider project = snapshot.getProject();
            ProfilerSession session = ProfilerSession.currentSession();
            if (session != null && Objects.equals(session.getProject(), project)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(false);
                        if (ui == null) {
                            ui = SnapshotsWindow.this.getUI(true);
                            ui.setProject(project);
                            ui.open();
                        }
                    }
                });
            }
        }
    }

    public void refreshFolder(final FileObject folder, final boolean fullRefresh) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(false);
                if (ui != null) {
                    ui.refreshFolder(folder, fullRefresh);
                }
            }
        });
    }

    private SnapshotsWindowUI getUI(boolean create) {
        if (this.ui == null) {
            WindowManager wm = WindowManager.getDefault();
            for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                if (tc.getClientProperty((Object)"SnapshotsWindowUI") == null) continue;
                this.ui = (SnapshotsWindowUI)tc;
            }
            if (this.ui == null && create) {
                this.ui = (SnapshotsWindowUI)wm.findTopComponent("SnapshotsWindowUI");
            }
            if (this.ui == null && create) {
                this.ui = new SnapshotsWindowUI();
            }
        }
        return this.ui;
    }
}

