/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DispatchMacroFunction;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.ReaderError;
import org.armedbear.lisp.ReaderMacroFunction;
import org.armedbear.lisp.Readtable;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class LispReader {
    public static final ReaderMacroFunction READ_COMMENT = new ReaderMacroFunction("read-comment", Lisp.PACKAGE_SYS, false, "stream character"){

        @Override
        public LispObject execute(Stream stream, char ignored) {
            try {
                int n;
                do {
                    if ((n = stream._readChar()) >= 0) continue;
                    return LispThread.currentThread().setValues();
                } while (n != 10);
                return LispThread.currentThread().setValues();
            }
            catch (IOException e) {
                return LispThread.currentThread().setValues();
            }
        }
    };
    public static final ReaderMacroFunction READ_STRING = new ReaderMacroFunction("read-string", Lisp.PACKAGE_SYS, false, "stream character"){

        @Override
        public LispObject execute(Stream stream, char terminator) {
            return stream.readString(terminator, Stream.currentReadtable);
        }
    };
    public static final ReaderMacroFunction READ_LIST = new ReaderMacroFunction("read-list", Lisp.PACKAGE_SYS, false, "stream character"){

        @Override
        public LispObject execute(Stream stream, char ignored) {
            return stream.readList(false, Stream.currentReadtable);
        }
    };
    public static final ReaderMacroFunction READ_RIGHT_PAREN = new ReaderMacroFunction("read-right-paren", Lisp.PACKAGE_SYS, false, "stream character"){

        @Override
        public LispObject execute(Stream stream, char ignored) {
            return Lisp.error(new ReaderError("Unmatched right parenthesis.", stream));
        }
    };
    public static final ReaderMacroFunction READ_QUOTE = new ReaderMacroFunction("read-quote", Lisp.PACKAGE_SYS, false, "stream character"){

        @Override
        public LispObject execute(Stream stream, char ignored) {
            return new Cons(Symbol.QUOTE, (LispObject)new Cons(stream.read(true, Lisp.NIL, true, LispThread.currentThread(), Stream.currentReadtable)));
        }
    };
    public static final ReaderMacroFunction READ_DISPATCH_CHAR = new ReaderMacroFunction("read-dispatch-char", Lisp.PACKAGE_SYS, false, "stream character"){

        @Override
        public LispObject execute(Stream stream, char c) {
            return stream.readDispatchChar(c, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_LEFT_PAREN = new DispatchMacroFunction("sharp-left-paren", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readSharpLeftParen(c, n, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_STAR = new DispatchMacroFunction("sharp-star", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char ignored, int n) {
            return stream.readSharpStar(ignored, n, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_DOT = new DispatchMacroFunction("sharp-dot", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readSharpDot(c, n, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_COLON = new DispatchMacroFunction("sharp-colon", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readSymbol();
        }
    };
    public static final DispatchMacroFunction SHARP_A = new DispatchMacroFunction("sharp-a", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readArray(n, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_B = new DispatchMacroFunction("sharp-b", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(2, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_C = new DispatchMacroFunction("sharp-c", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readComplex(Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_O = new DispatchMacroFunction("sharp-o", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(8, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_P = new DispatchMacroFunction("sharp-p", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readPathname(Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_R = new DispatchMacroFunction("sharp-r", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(n, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_S = new DispatchMacroFunction("sharp-s", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readStructure(Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_X = new DispatchMacroFunction("sharp-x", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(16, Stream.currentReadtable);
        }
    };
    public static final DispatchMacroFunction SHARP_QUOTE = new DispatchMacroFunction("sharp-quote", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            return new Cons(Symbol.FUNCTION, (LispObject)new Cons(stream.read(true, Lisp.NIL, true, LispThread.currentThread(), Stream.currentReadtable)));
        }
    };
    public static final DispatchMacroFunction SHARP_BACKSLASH = new DispatchMacroFunction("sharp-backslash", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            LispThread thread = LispThread.currentThread();
            Readtable rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
            return stream.readCharacterLiteral(rt, thread);
        }
    };
    public static final DispatchMacroFunction SHARP_VERTICAL_BAR = new DispatchMacroFunction("sharp-vertical-bar", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            stream.skipBalancedComment();
            return LispThread.currentThread().setValues();
        }
    };
    public static final DispatchMacroFunction SHARP_ILLEGAL = new DispatchMacroFunction("sharp-illegal", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        @Override
        public LispObject execute(Stream stream, char c, int n) {
            StringBuilder sb = new StringBuilder("Illegal # macro character: #\\");
            String s = LispCharacter.charToName(c);
            if (s != null) {
                sb.append(s);
            } else {
                sb.append(c);
            }
            return Lisp.error(new ReaderError(sb.toString(), stream));
        }
    };
}

