/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.xtext.formatting2.debug.TextRegionsWithTitleToString;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.Pair;

public class RegionsOutsideFrameException
extends RuntimeException {
    private static final long serialVersionUID = 3957771424755606694L;
    private final ITextSegment frameRegion;
    private final String frameTitle;
    private final Pair<String, ITextSegment>[] regions;

    @SafeVarargs
    public RegionsOutsideFrameException(String title, ITextSegment frame, Pair<String, ITextSegment> ... regions) {
        this.frameTitle = title;
        this.frameRegion = frame;
        this.regions = regions;
    }

    @Override
    public String getMessage() {
        int n;
        String regionsStr;
        if (this.regions.length == 1) {
            regionsStr = "region " + (String)this.regions[0].getFirst();
        } else {
            ArrayList titles = Lists.newArrayList();
            Pair<String, ITextSegment>[] pairArray = this.regions;
            n = this.regions.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<String, ITextSegment> p = pairArray[n2];
                titles.add((String)p.getFirst());
                ++n2;
            }
            regionsStr = "regions " + Joiner.on((String)", ").join((Iterable)titles);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("The " + regionsStr + " must not be outside " + this.frameTitle + ".\n");
        TextRegionsWithTitleToString toStr = new TextRegionsWithTitleToString();
        toStr.add(this.frameTitle, this.frameRegion);
        Pair<String, ITextSegment>[] pairArray = this.regions;
        int n3 = this.regions.length;
        n = 0;
        while (n < n3) {
            Pair<String, ITextSegment> p = pairArray[n];
            toStr.add((String)p.getFirst(), (ITextSegment)p.getSecond());
            ++n;
        }
        builder.append(toStr);
        return builder.toString();
    }
}

