untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWe51C8Gam47eg7RRRhW6r/piBkN2cjLj4MwphR0rNOjCA3a7TUh1dtU25MYd6FzarBT8l2eqFugnHdRxd1jwyg0=

OpenBSD 7.8 errata 011, December 3, 2025:

Due to a race, the kernel could crash when adding IPv6 neighbor
discovery entries.

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 011_nd6.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet6/nd6.c
===================================================================
RCS file: /cvs/src/sys/netinet6/nd6.c,v
diff -u -p -r1.303 nd6.c
--- sys/netinet6/nd6.c	16 Sep 2025 09:19:43 -0000	1.303
+++ sys/netinet6/nd6.c	28 Nov 2025 12:17:48 -0000
@@ -829,6 +829,9 @@ nd6_rtrequest(struct ifnet *ifp, int req
 				ln_end = TAILQ_LAST(&nd6_list, llinfo_nd6_head);
 				if (ln_end == ln)
 					break;
+				/* cannot move the iterator, try next time */
+				if (ln_end->ln_rt == NULL)
+					break;
 
 				/* Move this entry to the head */
 				TAILQ_REMOVE(&nd6_list, ln_end, ln_list);
