/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.function.IntFunction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;

public interface ForeignKeyDescriptor
extends VirtualModelPart,
ValuedModelPart {
    public static final String PART_NAME = "{fk}";
    public static final String TARGET_PART_NAME = "{fk-target}";

    @Override
    default public String getPartName() {
        return PART_NAME;
    }

    public String getKeyTable();

    public String getTargetTable();

    public ValuedModelPart getKeyPart();

    public ValuedModelPart getTargetPart();

    public boolean isKeyPart(ValuedModelPart var1);

    default public ValuedModelPart getPart(Nature nature) {
        if (nature == Nature.KEY) {
            return this.getKeyPart();
        }
        return this.getTargetPart();
    }

    public Side getKeySide();

    public Side getTargetSide();

    default public Side getSide(Nature nature) {
        if (nature == Nature.KEY) {
            return this.getKeySide();
        }
        return this.getTargetSide();
    }

    @Override
    default public String getContainingTableExpression() {
        return this.getKeyTable();
    }

    public int compare(Object var1, Object var2);

    public DomainResult<?> createKeyDomainResult(NavigablePath var1, TableGroup var2, FetchParent var3, DomainResultCreationState var4);

    public DomainResult<?> createKeyDomainResult(NavigablePath var1, TableGroup var2, Nature var3, FetchParent var4, DomainResultCreationState var5);

    public DomainResult<?> createTargetDomainResult(NavigablePath var1, TableGroup var2, FetchParent var3, DomainResultCreationState var4);

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath var1, TableGroup var2, String var3, DomainResultCreationState var4);

    public Predicate generateJoinPredicate(TableGroup var1, TableGroup var2, SqlAstCreationState var3);

    public Predicate generateJoinPredicate(TableReference var1, TableReference var2, SqlAstCreationState var3);

    public boolean isSimpleJoinPredicate(Predicate var1);

    @Override
    public SelectableMapping getSelectable(int var1);

    @Override
    default public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.visitKeySelectables(offset, consumer);
    }

    default public Object getAssociationKeyFromSide(Object targetObject, Nature nature, SharedSessionContractImplementor session) {
        return this.getAssociationKeyFromSide(targetObject, this.getSide(nature), session);
    }

    public Object getAssociationKeyFromSide(Object var1, Side var2, SharedSessionContractImplementor var3);

    public int visitKeySelectables(int var1, SelectableConsumer var2);

    default public int visitKeySelectables(SelectableConsumer consumer) {
        return this.visitKeySelectables(0, consumer);
    }

    public int visitTargetSelectables(int var1, SelectableConsumer var2);

    default public int visitTargetSelectables(SelectableConsumer consumer) {
        return this.visitTargetSelectables(0, consumer);
    }

    public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType var1, TableGroupProducer var2, IntFunction<SelectableMapping> var3, MappingModelCreationProcess var4);

    public ForeignKeyDescriptor withTargetPart(ValuedModelPart var1);

    public AssociationKey getAssociationKey();

    public boolean hasConstraint();

    public boolean isEmbedded();

    public static interface Side {
        public Nature getNature();

        public ValuedModelPart getModelPart();
    }

    public static enum Nature {
        KEY,
        TARGET;


        public Nature inverse() {
            return this == KEY ? TARGET : KEY;
        }
    }
}

