/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalTopologyManagerImpl;

class LocalCacheStatus {
    private final String name;
    private final CacheJoinInfo joinInfo;
    private final CacheTopologyHandler handler;
    private final PartitionHandlingManager partitionHandlingManager;
    private final CompletableFuture<Boolean> stable;
    private final int stableMembersSize;
    private volatile List<Address> knownMembers;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;
    private volatile boolean waitingRecovery;

    LocalCacheStatus(CacheJoinInfo joinInfo, CacheTopologyHandler handler, PartitionHandlingManager phm, int stableMembersSize, ComponentRegistry cr) {
        this.joinInfo = joinInfo;
        this.handler = handler;
        this.partitionHandlingManager = phm;
        this.knownMembers = Collections.emptyList();
        this.stableMembersSize = stableMembersSize;
        this.stable = new CompletableFuture();
        String string = this.name = cr != null ? cr.getCacheName() : null;
        if (cr != null) {
            this.stable.thenCompose(recovered -> {
                PersistenceManager pm;
                if (!recovered.booleanValue() && (pm = cr.getComponent(PersistenceManager.class)) != null) {
                    Predicate<StoreConfiguration> predicate = PersistenceManager.AccessMode.PRIVATE;
                    if (!this.needRecovery()) {
                        predicate = predicate.and(StoreConfiguration::purgeOnStartup);
                    } else if (LocalTopologyManagerImpl.log.isDebugEnabled()) {
                        LocalTopologyManagerImpl.log.debugf("%s: Clearing stores for %s", cr.getRpcManager().running().getAddress(), cr.getCacheName());
                    }
                    return pm.clearAllStores(predicate);
                }
                return CompletableFutures.completedNull();
            });
        }
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public CacheTopologyHandler getHandler() {
        return this.handler;
    }

    public PartitionHandlingManager getPartitionHandlingManager() {
        return this.partitionHandlingManager;
    }

    CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    void setCurrentTopology(CacheTopology currentTopology) {
        this.currentTopology = currentTopology;
    }

    CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    void setStableTopology(CacheTopology stableTopology) {
        this.stableTopology = stableTopology;
        this.partitionHandlingManager.onTopologyUpdate(this.currentTopology);
        if (stableTopology != null) {
            LocalTopologyManagerImpl.log.debugf("Cache %s stable topology complete %s", this.name, stableTopology);
            this.stable.complete(stableTopology.wasTopologyRestoredFromState());
        }
    }

    List<Address> knownMembers() {
        return Collections.unmodifiableList(this.knownMembers);
    }

    void setCurrentMembers(List<Address> members) {
        this.knownMembers = members;
    }

    CompletionStage<Void> getStableTopologyCompletion() {
        return this.stable.thenApply(CompletableFutures.toNullFunction());
    }

    boolean isTopologyRestored() {
        return this.stableMembersSize < 0 || this.stable.isDone();
    }

    boolean needRecovery() {
        return this.stableMembersSize > 0;
    }

    int getStableMembersSize() {
        return this.stableMembersSize;
    }

    void setWaitingRecovery(boolean value) {
        this.waitingRecovery = value;
    }

    boolean isWaitingRecovery() {
        return this.waitingRecovery;
    }
}

