/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import java.util.ServiceLoader;
import java.util.logging.Filter;

public interface LogFilterFactory {
    public static final int MIN_PRIORITY = Integer.MAX_VALUE;
    public static final int DEFAULT_PRIORITY = 0;

    public Filter create(String var1) throws Exception;

    default public int priority() {
        return 0;
    }

    public static LogFilterFactory load() {
        LogFilterFactory result = null;
        ServiceLoader<LogFilterFactory> load = ServiceLoader.load(LogFilterFactory.class);
        for (LogFilterFactory next : load) {
            if (result == null) {
                result = next;
                continue;
            }
            if (next.priority() >= result.priority()) continue;
            result = next;
        }
        if (result == null) {
            result = new ReflectionLogFilterFactory();
        }
        return result;
    }

    public static class ReflectionLogFilterFactory
    implements LogFilterFactory {
        @Override
        public Filter create(String className) throws Exception {
            return (Filter)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }

        @Override
        public int priority() {
            return Integer.MAX_VALUE;
        }
    }
}

