/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class ITextBuiltInFontRecord
implements FontRecord,
FontIdentifier {
    private FontFamily family;
    private String fullName;
    private boolean bold;
    private boolean italics;
    private boolean oblique;

    public ITextBuiltInFontRecord(FontFamily family, String fullName, boolean bold, boolean italics, boolean oblique) {
        if (family == null) {
            throw new NullPointerException();
        }
        if (fullName == null) {
            throw new NullPointerException();
        }
        this.family = family;
        this.fullName = fullName;
        this.bold = bold;
        this.italics = italics;
        this.oblique = oblique;
    }

    @Override
    public FontFamily getFamily() {
        return this.family;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italics;
    }

    @Override
    public boolean isOblique() {
        return this.oblique;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.OTHER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ITextBuiltInFontRecord that = (ITextBuiltInFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        if (this.oblique != that.oblique) {
            return false;
        }
        if (!this.family.equals(that.family)) {
            return false;
        }
        return this.fullName.equals(that.fullName);
    }

    @Override
    public int hashCode() {
        int result = this.family.hashCode();
        result = 29 * result + this.fullName.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italics ? 1 : 0);
        result = 29 * result + (this.oblique ? 1 : 0);
        return result;
    }
}

