/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.saml.acs.AssertedIdentity;
import org.apache.guacamole.auth.saml.acs.SAMLAuthenticationSessionManager;
import org.apache.guacamole.auth.saml.acs.SAMLService;
import org.apache.guacamole.auth.saml.user.SAMLAuthenticatedUser;
import org.apache.guacamole.auth.sso.SSOAuthenticationProviderService;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

@Singleton
public class AuthenticationProviderService
implements SSOAuthenticationProviderService {
    public static final String AUTH_SESSION_QUERY_PARAM = "state";
    @Inject
    private Provider<SAMLAuthenticatedUser> authenticatedUserProvider;
    @Inject
    private SAMLAuthenticationSessionManager sessionManager;
    @Inject
    private SAMLService saml;

    public static String getSessionIdentifier(Credentials credentials) {
        return credentials != null ? credentials.getParameter(AUTH_SESSION_QUERY_PARAM) : null;
    }

    public SAMLAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        AssertedIdentity identity = this.sessionManager.getIdentity(AuthenticationProviderService.getSessionIdentifier(credentials));
        if (identity != null) {
            SAMLAuthenticatedUser authenticatedUser = (SAMLAuthenticatedUser)((Object)this.authenticatedUserProvider.get());
            authenticatedUser.init(identity, credentials);
            return authenticatedUser;
        }
        throw new GuacamoleInvalidCredentialsException("Redirecting to SAML IdP.", new CredentialsInfo(Arrays.asList(new RedirectField(AUTH_SESSION_QUERY_PARAM, this.getLoginURI(), new TranslatableMessage("LOGIN.INFO_IDP_REDIRECT_PENDING")))));
    }

    public URI getLoginURI() throws GuacamoleException {
        return this.saml.createRequest();
    }

    public void shutdown() {
        this.sessionManager.shutdown();
    }
}

