/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.CustomControlsContext;
import java2d.DemoInstVarsAccessor;
import java2d.Surface;
import java2d.Tools;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public class DemoPanel
extends JPanel {
    private final DemoInstVarsAccessor demoInstVars;
    public Surface surface;
    public CustomControlsContext ccc;
    public Tools tools;
    public String className;

    public DemoPanel(Object obj, DemoInstVarsAccessor demoInstVars) {
        this.demoInstVars = demoInstVars;
        this.setLayout(new BorderLayout());
        try {
            if (obj instanceof String) {
                this.className = (String)obj;
                obj = Class.forName(this.className).newInstance();
            }
            if (obj instanceof Component) {
                this.add((Component)obj);
            }
            if (obj instanceof Surface) {
                this.surface = (Surface)obj;
                this.tools = new Tools(this.surface, demoInstVars);
                this.add("South", this.tools);
            }
            if (obj instanceof CustomControlsContext) {
                this.ccc = (CustomControlsContext)obj;
                Component[] cmps = this.ccc.getControls();
                String[] cons = this.ccc.getConstraints();
                for (int i = 0; i < cmps.length; ++i) {
                    this.add(cmps[i], cons[i]);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(DemoPanel.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void start() {
        if (this.surface != null) {
            this.surface.startClock();
        }
        if (this.tools != null && this.surface != null && this.tools.startStopB != null && this.tools.startStopB.isSelected()) {
            this.surface.animating.start();
        }
        if (this.ccc != null && this.demoInstVars.getCcthreadCB() != null && this.demoInstVars.getCcthreadCB().isSelected()) {
            this.ccc.handleThread(CustomControlsContext.State.START);
        }
    }

    public void stop() {
        if (this.surface != null) {
            if (this.surface.animating != null) {
                this.surface.animating.stop();
            }
            this.surface.bimg = null;
        }
        if (this.ccc != null) {
            this.ccc.handleThread(CustomControlsContext.State.STOP);
        }
    }

    public void setDemoBorder(JPanel p) {
        int top = p.getComponentCount() + 1 >= 3 ? 0 : 5;
        int left = (p.getComponentCount() + 1) % 2 == 0 ? 0 : 5;
        EmptyBorder eb = new EmptyBorder(top, left, 5, 5);
        SoftBevelBorder sbb = new SoftBevelBorder(0);
        this.setBorder(new CompoundBorder(eb, sbb));
    }
}

