/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java2d.AnimatingSurface;

public class Arcs
extends AnimatingSurface {
    private static String[] types = new String[]{"Arc2D.OPEN", "Arc2D.CHORD", "Arc2D.PIE"};
    private static final int CLOSE = 0;
    private static final int OPEN = 1;
    private static final int FORWARD = 0;
    private static final int BACKWARD = 1;
    private static final int DOWN = 2;
    private static final int UP = 3;
    private int aw;
    private int ah;
    private int x;
    private int y;
    private int angleStart = 45;
    private int angleExtent = 270;
    private int mouth = 0;
    private int direction = 0;

    public Arcs() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void reset(int w, int h) {
        this.x = 0;
        this.y = 0;
        this.aw = w / 12;
        this.ah = h / 12;
    }

    @Override
    public void step(int w, int h) {
        if (this.x + this.aw >= w - 5 && this.direction == 0) {
            this.direction = 2;
        }
        if (this.y + this.ah >= h - 5 && this.direction == 2) {
            this.direction = 1;
        }
        if (this.x - this.aw <= 5 && this.direction == 1) {
            this.direction = 3;
        }
        if (this.y - this.ah <= 5 && this.direction == 3) {
            this.direction = 0;
        }
        if (this.mouth == 0) {
            this.angleStart -= 5;
            this.angleExtent += 10;
        }
        if (this.mouth == 1) {
            this.angleStart += 5;
            this.angleExtent -= 10;
        }
        if (this.direction == 0) {
            this.x += 5;
            this.y = 0;
        }
        if (this.direction == 2) {
            this.x = w;
            this.y += 5;
        }
        if (this.direction == 1) {
            this.x -= 5;
            this.y = h;
        }
        if (this.direction == 3) {
            this.x = 0;
            this.y -= 5;
        }
        if (this.angleStart == 0) {
            this.mouth = 1;
        }
        if (this.angleStart > 45) {
            this.mouth = 0;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        g2.setStroke(new BasicStroke(5.0f));
        for (int i = 0; i < types.length; ++i) {
            Arc2D.Float arc = new Arc2D.Float(i);
            arc.setFrame((double)((i + 1) * w) * 0.2, (double)((i + 1) * h) * 0.2, (double)w * 0.17, (double)h * 0.17);
            ((Arc2D)arc).setAngleStart(45.0);
            ((Arc2D)arc).setAngleExtent(270.0);
            g2.setColor(Color.BLUE);
            g2.draw(arc);
            g2.setColor(Color.GRAY);
            g2.fill(arc);
            g2.setColor(Color.BLACK);
            g2.drawString(types[i], (int)((double)((i + 1) * w) * 0.2), (int)((double)((i + 1) * h) * 0.2 - 3.0));
        }
        Arc2D.Float pieArc = new Arc2D.Float(2);
        pieArc.setFrame(0.0, 0.0, this.aw, this.ah);
        ((Arc2D)pieArc).setAngleStart(this.angleStart);
        ((Arc2D)pieArc).setAngleExtent(this.angleExtent);
        AffineTransform at = AffineTransform.getTranslateInstance(this.x, this.y);
        switch (this.direction) {
            case 2: {
                at.rotate(Math.toRadians(90.0));
                break;
            }
            case 1: {
                at.rotate(Math.toRadians(180.0));
                break;
            }
            case 3: {
                at.rotate(Math.toRadians(270.0));
            }
        }
        g2.setColor(Color.BLUE);
        g2.fill(at.createTransformedShape(pieArc));
    }

    public static void main(String[] argv) {
        Arcs.createDemoFrame(new Arcs());
    }
}

