/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Areas
extends ControlsSurface {
    protected String areaType = "nop";

    public Areas() {
        this.setBackground(Color.WHITE);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        GeneralPath p1 = new GeneralPath();
        p1.moveTo((float)w * 0.25f, 0.0f);
        p1.lineTo((float)w * 0.75f, (float)h * 0.5f);
        p1.lineTo((float)w * 0.25f, h);
        p1.lineTo(0.0f, (float)h * 0.5f);
        p1.closePath();
        GeneralPath p2 = new GeneralPath();
        p2.moveTo((float)w * 0.75f, 0.0f);
        p2.lineTo(w, (float)h * 0.5f);
        p2.lineTo((float)w * 0.75f, h);
        p2.lineTo((float)w * 0.25f, (float)h * 0.5f);
        p2.closePath();
        Area area = new Area(p1);
        g2.setColor(Color.YELLOW);
        if (this.areaType.equals("nop")) {
            g2.fill(p1);
            g2.fill(p2);
            g2.setColor(Color.RED);
            g2.draw(p1);
            g2.draw(p2);
            return;
        }
        if (this.areaType.equals("add")) {
            area.add(new Area(p2));
        } else if (this.areaType.equals("sub")) {
            area.subtract(new Area(p2));
        } else if (this.areaType.equals("xor")) {
            area.exclusiveOr(new Area(p2));
        } else if (this.areaType.equals("int")) {
            area.intersect(new Area(p2));
        } else if (this.areaType.equals("pear")) {
            double sx = w / 100;
            double sy = h / 140;
            g2.scale(sx, sy);
            double x = (double)w / sx / 2.0;
            double y = (double)h / sy / 2.0;
            Ellipse2D.Double leaf = new Ellipse2D.Double(x - 16.0, y - 29.0, 15.0, 15.0);
            Area leaf1 = new Area(leaf);
            ((RectangularShape)leaf).setFrame(x - 14.0, y - 47.0, 30.0, 30.0);
            Area leaf2 = new Area(leaf);
            leaf1.intersect(leaf2);
            g2.setColor(Color.GREEN);
            g2.fill(leaf1);
            ((RectangularShape)leaf).setFrame(x + 1.0, y - 29.0, 15.0, 15.0);
            leaf1 = new Area(leaf);
            leaf2.intersect(leaf1);
            g2.fill(leaf2);
            Ellipse2D.Double stem = new Ellipse2D.Double(x, y - 42.0, 40.0, 40.0);
            Area st1 = new Area(stem);
            ((RectangularShape)stem).setFrame(x + 3.0, y - 47.0, 50.0, 50.0);
            st1.subtract(new Area(stem));
            g2.setColor(Color.BLACK);
            g2.fill(st1);
            Ellipse2D.Double circle = new Ellipse2D.Double(x - 25.0, y, 50.0, 50.0);
            Ellipse2D.Double oval = new Ellipse2D.Double(x - 19.0, y - 20.0, 40.0, 70.0);
            Area circ = new Area(circle);
            circ.add(new Area(oval));
            g2.setColor(Color.YELLOW);
            g2.fill(circ);
            return;
        }
        g2.fill(area);
        g2.setColor(Color.RED);
        g2.draw(area);
    }

    public static void main(String[] argv) {
        Areas.createDemoFrame(new Areas());
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        Areas demo;
        JToolBar toolbar;
        JComboBox combo;

        public DemoControls(Areas demo) {
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("nop", "no area operation", true);
            this.addTool("add", "add", false);
            this.addTool("sub", "subtract", false);
            this.addTool("xor", "exclusiveOr", false);
            this.addTool("int", "intersection", false);
            this.addTool("pear", "pear", false);
        }

        public void addTool(String str, String tooltip, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setToolTipText(tooltip);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Component comp : this.toolbar.getComponents()) {
                ((JToggleButton)comp).setSelected(false);
            }
            JToggleButton b = (JToggleButton)e.getSource();
            b.setSelected(true);
            this.demo.areaType = b.getText();
            this.demo.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1111L);
            }
            catch (Exception e) {
                return;
            }
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (Component comp : this.toolbar.getComponents()) {
                    ((AbstractButton)comp).doClick();
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

