/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="limits exposure to abuse from request flooding, whether malicious, or as a result of a misconfigured client")
public class DoSFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(DoSFilter.class);
    private static final String IPv4_GROUP = "(\\d{1,3})";
    private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final String IPv6_GROUP = "(\\p{XDigit}{1,4})";
    private static final Pattern IPv6_PATTERN = Pattern.compile("(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4}):(\\p{XDigit}{1,4})");
    private static final Pattern CIDR_PATTERN = Pattern.compile("([^/]+)/(\\d+)");
    private static final String __TRACKER = "DoSFilter.Tracker";
    private static final String __THROTTLED = "DoSFilter.Throttled";
    private static final int __DEFAULT_MAX_REQUESTS_PER_SEC = 25;
    private static final int __DEFAULT_DELAY_MS = 100;
    private static final int __DEFAULT_THROTTLE = 5;
    private static final int __DEFAULT_MAX_WAIT_MS = 50;
    private static final long __DEFAULT_THROTTLE_MS = 30000L;
    private static final long __DEFAULT_MAX_REQUEST_MS_INIT_PARAM = 30000L;
    private static final long __DEFAULT_MAX_IDLE_TRACKER_MS_INIT_PARAM = 30000L;
    static final String MANAGED_ATTR_INIT_PARAM = "managedAttr";
    static final String MAX_REQUESTS_PER_S_INIT_PARAM = "maxRequestsPerSec";
    static final String DELAY_MS_INIT_PARAM = "delayMs";
    static final String THROTTLED_REQUESTS_INIT_PARAM = "throttledRequests";
    static final String MAX_WAIT_INIT_PARAM = "maxWaitMs";
    static final String THROTTLE_MS_INIT_PARAM = "throttleMs";
    static final String MAX_REQUEST_MS_INIT_PARAM = "maxRequestMs";
    static final String MAX_IDLE_TRACKER_MS_INIT_PARAM = "maxIdleTrackerMs";
    static final String INSERT_HEADERS_INIT_PARAM = "insertHeaders";
    @Deprecated
    static final String TRACK_SESSIONS_INIT_PARAM = "trackSessions";
    static final String REMOTE_PORT_INIT_PARAM = "remotePort";
    static final String IP_WHITELIST_INIT_PARAM = "ipWhitelist";
    static final String ENABLED_INIT_PARAM = "enabled";
    static final String TOO_MANY_CODE = "tooManyCode";
    private final String _suspended = "DoSFilter@" + Integer.toHexString(this.hashCode()) + ".SUSPENDED";
    private final String _resumed = "DoSFilter@" + Integer.toHexString(this.hashCode()) + ".RESUMED";
    private final ConcurrentHashMap<String, RateTracker> _rateTrackers = new ConcurrentHashMap();
    private final List<String> _whitelist = new CopyOnWriteArrayList<String>();
    private int _tooManyCode;
    private volatile long _delayMs;
    private volatile long _throttleMs;
    private volatile long _maxWaitMs;
    private volatile long _maxRequestMs;
    private volatile long _maxIdleTrackerMs;
    private volatile boolean _insertHeaders;
    private volatile boolean _remotePort;
    private volatile boolean _enabled;
    private volatile String _name;
    private Listener _listener = new Listener();
    private Semaphore _passes;
    private volatile int _throttledRequests;
    private volatile int _maxRequestsPerSec;
    private final Queue<AsyncContext> _queue = new ConcurrentLinkedQueue<AsyncContext>();
    private final AsyncListener _asyncListener = new DoSAsyncListener();
    private Scheduler _scheduler;
    private ServletContext _context;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this._rateTrackers.clear();
        int maxRequests = 25;
        String parameter = filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM);
        if (parameter != null) {
            maxRequests = Integer.parseInt(parameter);
        }
        this.setMaxRequestsPerSec(maxRequests);
        long delay = 100L;
        parameter = filterConfig.getInitParameter(DELAY_MS_INIT_PARAM);
        if (parameter != null) {
            delay = Long.parseLong(parameter);
        }
        this.setDelayMs(delay);
        int throttledRequests = 5;
        parameter = filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM);
        if (parameter != null) {
            throttledRequests = Integer.parseInt(parameter);
        }
        this.setThrottledRequests(throttledRequests);
        long maxWait = 50L;
        parameter = filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM);
        if (parameter != null) {
            maxWait = Long.parseLong(parameter);
        }
        this.setMaxWaitMs(maxWait);
        long throttle = 30000L;
        parameter = filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM);
        if (parameter != null) {
            throttle = Long.parseLong(parameter);
        }
        this.setThrottleMs(throttle);
        long maxRequestMs = 30000L;
        parameter = filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM);
        if (parameter != null) {
            maxRequestMs = Long.parseLong(parameter);
        }
        this.setMaxRequestMs(maxRequestMs);
        long maxIdleTrackerMs = 30000L;
        parameter = filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM);
        if (parameter != null) {
            maxIdleTrackerMs = Long.parseLong(parameter);
        }
        this.setMaxIdleTrackerMs(maxIdleTrackerMs);
        String whiteList = "";
        parameter = filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM);
        if (parameter != null) {
            whiteList = parameter;
        }
        this.setWhitelist(whiteList);
        parameter = filterConfig.getInitParameter(INSERT_HEADERS_INIT_PARAM);
        this.setInsertHeaders(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(TRACK_SESSIONS_INIT_PARAM);
        this.setTrackSessions(Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(REMOTE_PORT_INIT_PARAM);
        this.setRemotePort(Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(ENABLED_INIT_PARAM);
        this.setEnabled(parameter == null || Boolean.parseBoolean(parameter));
        parameter = filterConfig.getInitParameter(TOO_MANY_CODE);
        this.setTooManyCode(parameter == null ? 429 : Integer.parseInt(parameter));
        this.setName(filterConfig.getFilterName());
        this._context = filterConfig.getServletContext();
        if (this._context != null) {
            this._context.setAttribute(filterConfig.getFilterName(), this);
        }
        this._scheduler = this.startScheduler();
    }

    protected Scheduler startScheduler() throws ServletException {
        try {
            ScheduledExecutorScheduler result = new ScheduledExecutorScheduler(String.format("DoS-Scheduler-%x", this.hashCode()), false);
            result.start();
            return result;
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        OverLimit overLimit;
        if (!this.isEnabled()) {
            filterChain.doFilter(request, response);
            return;
        }
        RateTracker tracker2 = (RateTracker)request.getAttribute(__TRACKER);
        if (tracker2 != null) {
            this.throttleRequest(request, response, filterChain, tracker2);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering {}", (Object)request);
        }
        if ((overLimit = (tracker2 = this.getRateTracker(request)).isRateExceeded(NanoTime.now())) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Allowing {}", (Object)request);
            }
            this.doFilterChain(filterChain, request, response);
            return;
        }
        Action action = this._listener.onRequestOverLimit(request, overLimit, this);
        long delayMs = this.getDelayMs();
        boolean insertHeaders = this.isInsertHeaders();
        switch (action.ordinal()) {
            case 0: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allowing over-limit request {}", (Object)request);
                }
                this.doFilterChain(filterChain, request, response);
                break;
            }
            case 1: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aborting over-limit request {}", (Object)request);
                }
                response.sendError(-1);
                return;
            }
            case 2: {
                if (insertHeaders) {
                    response.addHeader("DoSFilter", "unavailable");
                }
                response.sendError(this.getTooManyCode());
                return;
            }
            case 3: {
                if (insertHeaders) {
                    response.addHeader("DoSFilter", "delayed");
                }
                request.setAttribute(__TRACKER, tracker2);
                AsyncContext asyncContext = request.startAsync();
                if (delayMs > 0L) {
                    asyncContext.setTimeout(delayMs);
                }
                asyncContext.addListener(new DoSTimeoutAsyncListener());
                break;
            }
            case 4: {
                this.throttleRequest(request, response, filterChain, tracker2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throttleRequest(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, RateTracker tracker2) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Throttling {}", (Object)request);
        }
        boolean accepted = false;
        try {
            accepted = this._passes.tryAcquire(this.getMaxWaitMs(), TimeUnit.MILLISECONDS);
            if (!accepted) {
                Boolean throttled = (Boolean)request.getAttribute(__THROTTLED);
                long throttleMs = this.getThrottleMs();
                if (!Boolean.TRUE.equals(throttled) && throttleMs > 0L) {
                    request.setAttribute(__THROTTLED, Boolean.TRUE);
                    if (this.isInsertHeaders()) {
                        response.addHeader("DoSFilter", "throttled");
                    }
                    AsyncContext asyncContext = request.startAsync();
                    request.setAttribute(this._suspended, Boolean.TRUE);
                    asyncContext.setTimeout(throttleMs);
                    asyncContext.addListener(this._asyncListener);
                    this._queue.add(asyncContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Throttled {}, {}ms", (Object)request, (Object)throttleMs);
                    }
                    return;
                }
                Boolean resumed = (Boolean)request.getAttribute(this._resumed);
                if (Boolean.TRUE.equals(resumed)) {
                    this._passes.acquire();
                    accepted = true;
                }
            }
            if (accepted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allowing {}", (Object)request);
                }
                this.doFilterChain(filterChain, request, response);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Rejecting {}", (Object)request);
                }
                if (this.isInsertHeaders()) {
                    response.addHeader("DoSFilter", "unavailable");
                }
                response.sendError(this.getTooManyCode());
            }
        }
        catch (InterruptedException e) {
            LOG.trace("IGNORED", e);
            response.sendError(this.getTooManyCode());
        }
        finally {
            if (accepted) {
                try {
                    ServletRequest candidate;
                    Boolean suspended;
                    AsyncContext asyncContext = this._queue.poll();
                    if (asyncContext != null && Boolean.TRUE.equals(suspended = (Boolean)(candidate = asyncContext.getRequest()).getAttribute(this._suspended))) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Resuming {}", (Object)request);
                        }
                        candidate.setAttribute(this._resumed, Boolean.TRUE);
                        asyncContext.dispatch();
                    }
                }
                finally {
                    this._passes.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterChain(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Thread thread2 = Thread.currentThread();
        Runnable requestTimeout = () -> this.onRequestTimeout(request, response, thread2);
        Scheduler.Task task = this._scheduler.schedule(requestTimeout, this.getMaxRequestMs(), TimeUnit.MILLISECONDS);
        try {
            chain.doFilter(request, response);
        }
        finally {
            task.cancel();
        }
    }

    protected void onRequestTimeout(HttpServletRequest request, HttpServletResponse response, Thread handlingThread) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out {}", (Object)request);
            }
            try {
                response.sendError(503);
            }
            catch (IllegalStateException ise) {
                LOG.trace("IGNORED", ise);
                response.sendError(-1);
            }
        }
        catch (Throwable x) {
            LOG.info("Failed to sendError", x);
        }
        handlingThread.interrupt();
    }

    @Deprecated
    protected RateType getMaxPriority() {
        return null;
    }

    public void setListener(Listener listener) {
        this._listener = Objects.requireNonNull(listener, "Listener may not be null");
    }

    public Listener getListener() {
        return this._listener;
    }

    private void schedule(RateTracker tracker2) {
        this._scheduler.schedule(tracker2, this.getMaxIdleTrackerMs(), TimeUnit.MILLISECONDS);
    }

    RateTracker getRateTracker(ServletRequest request) {
        String loadId = this.isRemotePort() ? this.createRemotePortId(request) : request.getRemoteAddr();
        RateTracker tracker2 = this._rateTrackers.get(loadId);
        if (tracker2 == null) {
            boolean allowed = this.checkWhitelist(request.getRemoteAddr());
            int maxRequestsPerSec = this.getMaxRequestsPerSec();
            tracker2 = allowed ? new FixedRateTracker(this._context, this._name, loadId, maxRequestsPerSec) : new RateTracker(this._context, this._name, loadId, maxRequestsPerSec);
            tracker2.setContext(this._context);
            RateTracker existing = this._rateTrackers.putIfAbsent(loadId, tracker2);
            if (existing != null) {
                tracker2 = existing;
            }
            this._scheduler.schedule(tracker2, this.getMaxIdleTrackerMs(), TimeUnit.MILLISECONDS);
        }
        return tracker2;
    }

    private void addToRateTracker(RateTracker tracker2) {
        this._rateTrackers.put(tracker2.getId(), tracker2);
    }

    public void removeFromRateTracker(String id) {
        this._rateTrackers.remove(id);
    }

    protected boolean checkWhitelist(String candidate) {
        for (String address : this._whitelist) {
            if (!(address.contains("/") ? this.subnetMatch(address, candidate) : address.equals(candidate))) continue;
            return true;
        }
        return false;
    }

    protected boolean subnetMatch(String subnetAddress, String address) {
        int prefix;
        Matcher cidrMatcher = CIDR_PATTERN.matcher(subnetAddress);
        if (!cidrMatcher.matches()) {
            return false;
        }
        String subnet = cidrMatcher.group(1);
        try {
            prefix = Integer.parseInt(cidrMatcher.group(2));
        }
        catch (NumberFormatException x) {
            LOG.info("Ignoring malformed CIDR address {}", (Object)subnetAddress);
            return false;
        }
        byte[] subnetBytes = this.addressToBytes(subnet);
        if (subnetBytes == null) {
            LOG.info("Ignoring malformed CIDR address {}", (Object)subnetAddress);
            return false;
        }
        byte[] addressBytes = this.addressToBytes(address);
        if (addressBytes == null) {
            LOG.info("Ignoring malformed remote address {}", (Object)address);
            return false;
        }
        int length = subnetBytes.length;
        if (length != addressBytes.length) {
            return false;
        }
        byte[] mask = this.prefixToBytes(prefix, length);
        for (int i = 0; i < length; ++i) {
            if ((subnetBytes[i] & mask[i]) == (addressBytes[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    private byte[] addressToBytes(String address) {
        Matcher ipv4Matcher = IPv4_PATTERN.matcher(address);
        if (ipv4Matcher.matches()) {
            byte[] result = new byte[4];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.valueOf(ipv4Matcher.group(i + 1)).byteValue();
            }
            return result;
        }
        Matcher ipv6Matcher = IPv6_PATTERN.matcher(address);
        if (ipv6Matcher.matches()) {
            byte[] result = new byte[16];
            for (int i = 0; i < result.length; i += 2) {
                int word = Integer.parseInt(ipv6Matcher.group(i / 2 + 1), 16);
                result[i] = (byte)((word & 0xFF00) >>> 8);
                result[i + 1] = (byte)(word & 0xFF);
            }
            return result;
        }
        return null;
    }

    private byte[] prefixToBytes(int prefix, int length) {
        byte[] result = new byte[length];
        int index = 0;
        while (prefix / 8 > 0) {
            result[index] = -1;
            prefix -= 8;
            ++index;
        }
        if (index == result.length) {
            return result;
        }
        result[index] = (byte)(-(1 << 8 - prefix));
        return result;
    }

    @Override
    public void destroy() {
        LOG.debug("Destroy {}", (Object)this);
        this.stopScheduler();
        this._rateTrackers.clear();
        this._whitelist.clear();
    }

    protected void stopScheduler() {
        try {
            this._scheduler.stop();
        }
        catch (Exception x) {
            LOG.trace("IGNORED", x);
        }
    }

    @Deprecated
    protected String extractUserId(ServletRequest request) {
        return null;
    }

    @ManagedAttribute(value="maximum number of requests allowed from a connection per second")
    public int getMaxRequestsPerSec() {
        return this._maxRequestsPerSec;
    }

    public void setMaxRequestsPerSec(int value2) {
        this._maxRequestsPerSec = value2;
    }

    @ManagedAttribute(value="delay applied to all requests over the rate limit (in ms)")
    public long getDelayMs() {
        return this._delayMs;
    }

    public void setDelayMs(long value2) {
        this._delayMs = value2;
    }

    @ManagedAttribute(value="maximum time the filter will block waiting throttled connections, (0 for no delay, -1 to reject requests)")
    public long getMaxWaitMs() {
        return this._maxWaitMs;
    }

    public void setMaxWaitMs(long value2) {
        this._maxWaitMs = value2;
    }

    @ManagedAttribute(value="number of requests over rate limit")
    public int getThrottledRequests() {
        return this._throttledRequests;
    }

    public void setThrottledRequests(int value2) {
        int permits = this._passes == null ? 0 : this._passes.availablePermits();
        this._passes = new Semaphore(value2 - this._throttledRequests + permits, true);
        this._throttledRequests = value2;
    }

    @ManagedAttribute(value="amount of time to async wait for semaphore")
    public long getThrottleMs() {
        return this._throttleMs;
    }

    public void setThrottleMs(long value2) {
        this._throttleMs = value2;
    }

    @ManagedAttribute(value="maximum time to allow requests to process (in ms)")
    public long getMaxRequestMs() {
        return this._maxRequestMs;
    }

    public void setMaxRequestMs(long value2) {
        this._maxRequestMs = value2;
    }

    @ManagedAttribute(value="maximum time to track of request rates for connection before discarding")
    public long getMaxIdleTrackerMs() {
        return this._maxIdleTrackerMs;
    }

    public void setMaxIdleTrackerMs(long value2) {
        this._maxIdleTrackerMs = value2;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @ManagedAttribute(value="inser DoSFilter headers in response")
    public boolean isInsertHeaders() {
        return this._insertHeaders;
    }

    public void setInsertHeaders(boolean value2) {
        this._insertHeaders = value2;
    }

    @Deprecated
    public boolean isTrackSessions() {
        return false;
    }

    @Deprecated
    public void setTrackSessions(boolean value2) {
        if (value2) {
            LOG.warn("Session Tracking is not supported");
        }
    }

    @ManagedAttribute(value="usage rate is tracked by IP+port is session tracking not used")
    public boolean isRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(boolean value2) {
        this._remotePort = value2;
    }

    @ManagedAttribute(value="whether this filter is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled2) {
        this._enabled = enabled2;
    }

    public int getTooManyCode() {
        return this._tooManyCode;
    }

    public void setTooManyCode(int tooManyCode) {
        this._tooManyCode = tooManyCode;
    }

    @ManagedAttribute(value="list of IPs that will not be rate limited")
    public String getWhitelist() {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator2 = this._whitelist.iterator();
        while (iterator2.hasNext()) {
            String address = iterator2.next();
            result.append(address);
            if (!iterator2.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    public void setWhitelist(String commaSeparatedList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String address : StringUtil.csvSplit(commaSeparatedList)) {
            this.addWhitelistAddress(result, address);
        }
        this.clearWhitelist();
        this._whitelist.addAll(result);
        LOG.debug("Whitelisted IP addresses: {}", (Object)result);
    }

    @ManagedOperation(value="clears the list of IP addresses that will not be rate limited")
    public void clearWhitelist() {
        this._whitelist.clear();
    }

    @ManagedOperation(value="adds an IP address that will not be rate limited")
    public boolean addWhitelistAddress(@Name(value="address") String address) {
        return this.addWhitelistAddress(this._whitelist, address);
    }

    private boolean addWhitelistAddress(List<String> list, String address) {
        if ((address = address.trim()).length() <= 0) {
            return false;
        }
        list.add(address);
        return true;
    }

    @ManagedOperation(value="removes an IP address that will not be rate limited")
    public boolean removeWhitelistAddress(@Name(value="address") String address) {
        return this._whitelist.remove(address);
    }

    private String createRemotePortId(ServletRequest request) {
        String addr = request.getRemoteAddr();
        int port2 = request.getRemotePort();
        return addr + ":" + port2;
    }

    public static class Listener {
        public Action onRequestOverLimit(HttpServletRequest request, OverLimit overlimit, DoSFilter dosFilter) {
            Action action = Action.fromDelay(dosFilter.getDelayMs());
            switch (action.ordinal()) {
                case 2: {
                    LOG.warn("DoS ALERT: Request rejected ip={}, overlimit={}, user={}", request.getRemoteAddr(), overlimit, request.getUserPrincipal());
                    break;
                }
                case 3: {
                    LOG.warn("DoS ALERT: Request delayed={}ms, ip={}, overlimit={}, user={}", dosFilter.getDelayMs(), request.getRemoteAddr(), overlimit, request.getUserPrincipal());
                    break;
                }
                case 4: {
                    LOG.warn("DoS ALERT: Request throttled ip={}, overlimit={}, user={}", request.getRemoteAddr(), overlimit, request.getUserPrincipal());
                }
            }
            return action;
        }
    }

    private class DoSAsyncListener
    extends DoSTimeoutAsyncListener {
        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
            DoSFilter.this._queue.remove(event.getAsyncContext());
            super.onTimeout(event);
        }
    }

    static class RateTracker
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 3534663738034577872L;
        final AutoLock _lock = new AutoLock();
        protected final String _filterName;
        protected transient ServletContext _context;
        protected final String _id;
        protected final int _maxRequestsPerSecond;
        protected final long[] _timestamps;
        protected int _next;

        RateTracker(ServletContext context, String filterName, String id, int maxRequestsPerSecond) {
            this._context = context;
            this._filterName = filterName;
            this._id = id;
            this._maxRequestsPerSecond = maxRequestsPerSecond;
            this._timestamps = new long[maxRequestsPerSecond];
            this._next = 0;
        }

        public OverLimit isRateExceeded(long now) {
            long last;
            try (AutoLock l = this._lock.lock();){
                last = this._timestamps[this._next];
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            if (last == 0L) {
                return null;
            }
            long rate = NanoTime.elapsed(last, now);
            if (TimeUnit.NANOSECONDS.toSeconds(rate) < 1L) {
                return new Overage(Duration.ofNanos(rate), this._maxRequestsPerSecond);
            }
            return null;
        }

        public String getId() {
            return this._id;
        }

        public void setContext(ServletContext context) {
            this._context = context;
        }

        protected void removeFromRateTrackers(DoSFilter filter, String id) {
            if (filter == null) {
                return;
            }
            filter.removeFromRateTracker(id);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tracker removed: {}", (Object)this.getId());
            }
        }

        private void addToRateTrackers(DoSFilter filter, RateTracker tracker2) {
            if (filter == null) {
                return;
            }
            filter.addToRateTracker(tracker2);
        }

        @Override
        public void run() {
            if (this._context == null) {
                LOG.warn("Unknown context for rate tracker {}", (Object)this);
                return;
            }
            int latestIndex = this._next == 0 ? this._timestamps.length - 1 : this._next - 1;
            long last = this._timestamps[latestIndex];
            boolean hasRecentRequest = last != 0L && NanoTime.secondsSince(last) < 1L;
            DoSFilter filter = (DoSFilter)this._context.getAttribute(this._filterName);
            if (hasRecentRequest) {
                if (filter != null) {
                    filter.schedule(this);
                } else {
                    LOG.warn("No filter {}", (Object)this._filterName);
                }
            } else {
                this.removeFromRateTrackers(filter, this._id);
            }
        }

        public String toString() {
            return "RateTracker/" + this._id;
        }

        public class Overage
        implements OverLimit {
            private final Duration duration;
            private final long count;

            public Overage(Duration dur, long count) {
                this.duration = dur;
                this.count = count;
            }

            @Override
            public String getRateId() {
                return RateTracker.this._id;
            }

            @Override
            public Duration getDuration() {
                return this.duration;
            }

            @Override
            public long getCount() {
                return this.count;
            }

            public String toString() {
                return OverLimit.class.getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[id=" + this.getRateId() + ", duration=" + String.valueOf(this.duration) + ", count=" + this.count + "]";
            }
        }
    }

    public static interface OverLimit {
        public String getRateId();

        public Duration getDuration();

        public long getCount();
    }

    public static enum Action {
        NO_ACTION,
        ABORT,
        REJECT,
        DELAY,
        THROTTLE;


        public static Action fromDelay(long delayMs) {
            if (delayMs < 0L) {
                return REJECT;
            }
            if (delayMs == 0L) {
                return THROTTLE;
            }
            return DELAY;
        }
    }

    private static class DoSTimeoutAsyncListener
    implements AsyncListener {
        private DoSTimeoutAsyncListener() {
        }

        @Override
        public void onStartAsync(AsyncEvent event) {
        }

        @Override
        public void onComplete(AsyncEvent event) {
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().dispatch();
        }

        @Override
        public void onError(AsyncEvent event) {
        }
    }

    private static class FixedRateTracker
    extends RateTracker {
        public FixedRateTracker(ServletContext context, String filterName, String id, int numRecentRequestsTracked) {
            super(context, filterName, id, numRecentRequestsTracked);
        }

        @Override
        public OverLimit isRateExceeded(long now) {
            try (AutoLock l = this._lock.lock();){
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return null;
        }

        @Override
        public String toString() {
            return "Fixed" + super.toString();
        }
    }

    @Deprecated
    public static enum RateType {
        AUTH,
        SESSION,
        IP,
        UNKNOWN;

    }
}

