/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.visitors.VisitorsConfig;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.VisitorsIqFilter;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.visitors.VisitorsIq;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0016\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/jitsi/jicofo/xmpp/VisitorsManager;", "Lorg/jivesoftware/smack/StanzaListener;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/ConferenceStore;)V", "address", "Lorg/jxmpp/jid/DomainBareJid;", "getAddress", "()Lorg/jxmpp/jid/DomainBareJid;", "setAddress", "(Lorg/jxmpp/jid/DomainBareJid;)V", "getConferenceStore", "()Lorg/jitsi/jicofo/ConferenceStore;", "enabled", "", "getEnabled", "()Z", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getXmppProvider", "()Lorg/jitsi/jicofo/xmpp/XmppProvider;", "processStanza", "", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "sendIqToComponent", "roomJid", "Lorg/jxmpp/jid/EntityBareJid;", "extensions", "", "Lorg/jivesoftware/smack/packet/ExtensionElement;", "updateAddress", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "jicofo"})
@SourceDebugExtension(value={"SMAP\nVisitorsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisitorsManager.kt\norg/jitsi/jicofo/xmpp/VisitorsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class VisitorsManager
implements StanzaListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final Logger logger;
    @Nullable
    private DomainBareJid address;

    /*
     * WARNING - void declaration
     */
    public VisitorsManager(@NotNull XmppProvider xmppProvider, @NotNull ConferenceStore conferenceStore) {
        void $this$logger_u24lambda_u240;
        Logger logger;
        Intrinsics.checkNotNullParameter(xmppProvider, "xmppProvider");
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        this.xmppProvider = xmppProvider;
        this.conferenceStore = conferenceStore;
        this.xmppProvider.getXmppConnection().addSyncStanzaListener(this, new VisitorsIqFilter());
        Logger logger2 = logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        VisitorsManager visitorsManager = this;
        boolean bl = false;
        $this$logger_u24lambda_u240.addContext("connection", this.xmppProvider.getConfig().getName());
        visitorsManager.logger = logger;
        this.updateAddress(this.xmppProvider.getComponents());
        this.xmppProvider.addListener(new XmppProvider.Listener(){

            @Override
            public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
                Intrinsics.checkNotNullParameter(components, "components");
                this.updateAddress(components);
            }

            @Override
            public void registrationChanged(boolean registered) {
                XmppProvider.Listener.DefaultImpls.registrationChanged(this, registered);
            }
        });
    }

    @NotNull
    public final XmppProvider getXmppProvider() {
        return this.xmppProvider;
    }

    @NotNull
    public final ConferenceStore getConferenceStore() {
        return this.conferenceStore;
    }

    @Nullable
    public final DomainBareJid getAddress() {
        return this.address;
    }

    public final void setAddress(@Nullable DomainBareJid domainBareJid) {
        this.address = domainBareJid;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAddress(Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        Object v0;
        VisitorsManager visitorsManager;
        block3: {
            Iterable iterable = components;
            visitorsManager = this;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), "visitors")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        VisitorsManager visitorsManager2 = visitorsManager;
        Object object = v0;
        if (object != null && (object = ((XmppProvider.Component)object).getAddress()) != null) {
            void it;
            Object object2 = object;
            visitorsManager = visitorsManager2;
            boolean bl = false;
            domainBareJid = JidCreate.domainBareFrom((String)it);
            visitorsManager2 = visitorsManager;
        } else {
            domainBareJid = null;
        }
        visitorsManager2.address = domainBareJid;
        this.logger.info("VisitorsComponentManager is now " + (this.getEnabled() ? "en" : "dis") + "abled with address " + this.address);
    }

    public final void sendIqToComponent(@NotNull EntityBareJid roomJid, @NotNull List<? extends ExtensionElement> extensions) {
        VisitorsIq.Builder builder;
        Intrinsics.checkNotNullParameter(roomJid, "roomJid");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        DomainBareJid domainBareJid = this.address;
        if (domainBareJid == null) {
            throw new Exception("Component not available.");
        }
        DomainBareJid address = domainBareJid;
        VisitorsIq.Builder $this$sendIqToComponent_u24lambda_u243 = builder = new VisitorsIq.Builder(this.xmppProvider.getXmppConnection());
        boolean bl = false;
        $this$sendIqToComponent_u24lambda_u243.to(address);
        $this$sendIqToComponent_u24lambda_u243.ofType(IQ.Type.get);
        $this$sendIqToComponent_u24lambda_u243.setRoom(roomJid);
        $this$sendIqToComponent_u24lambda_u243.addExtensions((Collection<ExtensionElement>)extensions);
        VisitorsIq iq = builder.build();
        TaskPools.Companion.getIoPool().submit(() -> VisitorsManager.sendIqToComponent$lambda$4(this, iq));
    }

    public final boolean getEnabled() {
        return VisitorsConfig.config.getEnabled() && this.address != null;
    }

    @Override
    public void processStanza(@NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter(stanza, "stanza");
        if (!(stanza instanceof VisitorsIq)) {
            this.logger.error("Received unexpected stanza type received: " + stanza.getClass().getName());
            return;
        }
        if (this.conferenceStore.getConference(((VisitorsIq)stanza).getRoom()) == null) {
            VisitorsManager $this$processStanza_u24lambda_u245 = this;
            boolean bl = false;
            $this$processStanza_u24lambda_u245.logger.warn("Ignoring VisitorsIq for unknown conference " + ((VisitorsIq)stanza).getRoom() + ".");
            return;
        }
        this.logger.info("Received VisitorsIq: " + XmlStringBuilderUtil.Companion.toStringOpt((IQ)stanza));
    }

    private static final void sendIqToComponent$lambda$4(VisitorsManager this$0, VisitorsIq $iq) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($iq, "$iq");
        IQ response = UtilKt.sendIqAndGetResponse(this$0.xmppProvider.getXmppConnection(), $iq);
        if (response == null) {
            this$0.logger.warn("Timeout waiting for VisitorsIq response.");
        } else if (response.getType() == IQ.Type.result) {
            this$0.logger.info("Received VisitorsIq response: " + XmlStringBuilderUtil.Companion.toStringOpt(response));
        } else {
            this$0.logger.warn("Received error response: " + XmlStringBuilderUtil.Companion.toStringOpt(response));
        }
    }
}

