/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import java.util.List;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jibri.StanzaErrorPE;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.Jid;

public class RecordingStatus
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/jibri";
    public static final String ELEMENT = "jibri-recording-status";
    private static final String STATUS_ATTRIBUTE = "status";
    public static final String INITIATOR_ATTR_NAME = "initiator";
    private Jid initiator;

    public RecordingStatus() {
        super(NAMESPACE, ELEMENT);
    }

    public JibriIq.Status getStatus() {
        String statusAttr = this.getAttributeAsString(STATUS_ATTRIBUTE);
        return JibriIq.Status.parse(statusAttr);
    }

    public void setStatus(JibriIq.Status status) {
        this.setAttribute(STATUS_ATTRIBUTE, (Object)status);
    }

    public String getSessionId() {
        return this.getAttributeAsString("session_id");
    }

    public void setSessionId(String sessionId) {
        this.setAttribute("session_id", sessionId);
    }

    public JibriIq.RecordingMode getRecordingMode() {
        String recordingMode = this.getAttributeAsString("recording_mode");
        return JibriIq.RecordingMode.parse(recordingMode);
    }

    public void setRecordingMode(JibriIq.RecordingMode recordingMode) {
        this.setAttribute("recording_mode", recordingMode.toString());
    }

    public JibriIq.FailureReason getFailureReason() {
        String failureReasonStr = this.getAttributeAsString("failure_reason");
        return JibriIq.FailureReason.parse(failureReasonStr);
    }

    public void setFailureReason(JibriIq.FailureReason failureReason) {
        if (failureReason != null) {
            this.setAttribute("failure_reason", failureReason.toString());
        }
    }

    public StanzaError getError() {
        StanzaErrorPE errorPe = this.getErrorPE();
        return errorPe != null ? errorPe.getError() : null;
    }

    private StanzaErrorPE getErrorPE() {
        List<StanzaErrorPE> errorPe = this.getChildExtensionsOfType(StanzaErrorPE.class);
        return (StanzaErrorPE)(!errorPe.isEmpty() ? (ExtensionElement)errorPe.get(0) : null);
    }

    public void setError(StanzaError error) {
        if (error != null) {
            StanzaErrorPE errorPe = this.getErrorPE();
            if (errorPe == null) {
                errorPe = new StanzaErrorPE(error);
                this.addChildExtension(errorPe);
            }
            errorPe.setError(error);
        } else {
            this.getChildExtensions().remove(this.getErrorPE());
        }
    }

    public void setInitiator(Jid initiator) {
        this.setAttribute(INITIATOR_ATTR_NAME, initiator);
        this.initiator = initiator;
    }

    public Jid getInitiator() {
        return this.initiator;
    }
}

