/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;

public class UserSearch
extends SimpleIQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:search";

    public UserSearch() {
        super(ELEMENT, NAMESPACE);
    }

    public DataForm getSearchForm(XMPPConnection con, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.get);
        search.setTo(searchService);
        IQ response = (IQ)con.createStanzaCollectorAndSend(search).nextResultOrThrow();
        return DataForm.from(response, NAMESPACE);
    }

    public ReportedData sendSearchForm(XMPPConnection con, DataForm searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.set);
        search.setTo(searchService);
        search.addExtension(searchForm);
        IQ response = (IQ)con.createStanzaCollectorAndSend(search).nextResultOrThrow();
        return ReportedData.getReportedDataFrom(response);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection con, DataForm searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        SimpleUserSearch search = new SimpleUserSearch();
        search.setForm(searchForm);
        search.setType(IQ.Type.set);
        search.setTo(searchService);
        SimpleUserSearch response = (SimpleUserSearch)con.createStanzaCollectorAndSend(search).nextResultOrThrow();
        return response.getReportedData();
    }

    public static class Provider
    extends IQProvider<IQ> {
        @Override
        public IQ parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            UserSearch search = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("item")) {
                    simpleUserSearch.parseItems(parser);
                    return simpleUserSearch;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getNamespace().equals("jabber:x:data")) {
                    search = new UserSearch();
                    PacketParserUtils.addExtensionElement(search, parser, xmlEnvironment);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(UserSearch.ELEMENT)) continue;
                done = true;
            }
            if (search != null) {
                return search;
            }
            return simpleUserSearch;
        }
    }
}

