/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.form;

import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FormReader;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public abstract class FilledForm
implements FormReader {
    private final DataForm dataForm;
    protected final TextSingleFormField formTypeFormField;

    public FilledForm(DataForm dataForm) {
        this.dataForm = Objects.requireNonNull(dataForm);
        if (dataForm.getType() == DataForm.Type.cancel) {
            throw new IllegalArgumentException("Forms of type 'cancel' are not filled nor fillable");
        }
        this.formTypeFormField = dataForm.getHiddenFormTypeField();
    }

    @Override
    public FormField getField(String fieldName) {
        return this.dataForm.getField(fieldName);
    }

    public String getTitle() {
        return this.dataForm.getTitle();
    }

    public StringBuilder getInstructions() {
        StringBuilder sb = new StringBuilder();
        for (String instruction : this.dataForm.getInstructions()) {
            sb.append(instruction).append('\n');
        }
        return sb;
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    public String getFormType() {
        if (this.formTypeFormField == null) {
            return null;
        }
        return this.formTypeFormField.getValue();
    }

    public boolean hasField(String fieldName) {
        return this.dataForm.hasField(fieldName);
    }

    protected FormField getFieldOrThrow(String fieldName) {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            throw new IllegalArgumentException("No field named " + fieldName);
        }
        return formField;
    }

    protected static void ensureFormType(DataForm dataForm, String formType) {
        String dataFormType = dataForm.getFormType();
        if (!formType.equals(dataFormType)) {
            throw new IllegalArgumentException("The provided data form must be of type '" + formType + "', this one was of type '" + dataFormType + '\'');
        }
    }
}

