/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.identity;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.ast.TableInsert;

public class H2FinalTableIdentityColumnSupport
extends H2IdentityColumnSupport {
    public static final H2FinalTableIdentityColumnSupport INSTANCE = new H2FinalTableIdentityColumnSupport();

    private H2FinalTableIdentityColumnSupport() {
    }

    @Override
    public boolean supportsInsertSelectIdentity() {
        return true;
    }

    @Override
    public String appendIdentitySelectToInsert(String identityColumnName, String insertString) {
        return "select " + identityColumnName + " from final table ( " + insertString + " )";
    }

    @Override
    @Deprecated
    public void render(TableInsert tableInsert, Consumer<String> sqlAppender, Consumer<ColumnReference> returnColumnHandler, H2IdentityColumnSupport.InsertValuesHandler insertValuesHandler, SessionFactoryImplementor sessionFactory) {
        sqlAppender.accept("select ");
        List<ColumnReference> returningColumns = tableInsert.getReturningColumns();
        for (int i = 0; i < returningColumns.size(); ++i) {
            if (i > 0) {
                sqlAppender.accept(", ");
            }
            returnColumnHandler.accept(returningColumns.get(i));
        }
        sqlAppender.accept(" from final table ( ");
        insertValuesHandler.renderInsertValues();
        sqlAppender.accept(")");
    }
}

