/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.protocol.AbstractStaxSamlProtocolParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;

public class SAMLStatusCodeParser
extends AbstractStaxSamlProtocolParser<StatusCodeType> {
    private static final SAMLStatusCodeParser INSTANCE = new SAMLStatusCodeParser();

    private SAMLStatusCodeParser() {
        super(SAMLProtocolQNames.STATUS_CODE);
    }

    public static SAMLStatusCodeParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected StatusCodeType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        StatusCodeType res = new StatusCodeType();
        res.setValue(StaxParserUtil.getUriAttributeValue(element, SAMLProtocolQNames.ATTR_VALUE));
        return res;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, StatusCodeType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case STATUS_CODE: {
                target.setStatusCode((StatusCodeType)SAMLStatusCodeParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

