/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerEdDSASignatureSignerContext;
import org.keycloak.crypto.ServerEdDSASignatureVerifierContext;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.models.KeycloakSession;

public class EdDSASignatureProvider
implements SignatureProvider {
    private final KeycloakSession session;

    public EdDSASignatureProvider(KeycloakSession session) {
        this.session = session;
    }

    public SignatureSignerContext signer() throws SignatureException {
        return new ServerEdDSASignatureSignerContext(this.session, "EdDSA");
    }

    public SignatureSignerContext signer(KeyWrapper key) throws SignatureException {
        SignatureProvider.checkKeyForSignature((KeyWrapper)key, (String)"EdDSA", (String)"OKP");
        return new ServerEdDSASignatureSignerContext(key);
    }

    public SignatureVerifierContext verifier(String kid) throws VerificationException {
        return new ServerEdDSASignatureVerifierContext(this.session, kid, "EdDSA");
    }

    public SignatureVerifierContext verifier(KeyWrapper key) throws VerificationException {
        SignatureProvider.checkKeyForVerification((KeyWrapper)key, (String)"EdDSA", (String)"OKP");
        return new ServerEdDSASignatureVerifierContext(key);
    }

    public boolean isAsymmetricAlgorithm() {
        return true;
    }
}

