/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.CommandResult;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;

public class MongoCommandException
extends MongoException {
    private static final long serialVersionUID = 8160676451944215078L;
    private final CommandResult commandResult;

    public MongoCommandException(CommandResult commandResult) {
        super(ServerError.getCode(commandResult), commandResult.toString());
        this.commandResult = commandResult;
    }

    public ServerAddress getServerAddress() {
        return this.commandResult.getServerUsed();
    }

    public int getErrorCode() {
        return this.getCode();
    }

    public String getErrorMessage() {
        return this.commandResult.getErrorMessage();
    }

    CommandResult getCommandResult() {
        return this.commandResult;
    }
}

