/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleData;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.util.Exceptions;

final class NetigsoModule
extends Module {
    private static final Logger LOG = Logger.getLogger(NetigsoModule.class.getName());
    private final File jar;
    private final Manifest manifest;
    private int startLevel = -1;
    private InvalidException problem;

    public NetigsoModule(Manifest manifest, File file, ModuleManager moduleManager, Events events, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(moduleManager, events, object, bl, bl2, bl3);
        this.jar = file;
        this.manifest = manifest;
    }

    @Override
    ModuleData createData(ObjectInput objectInput, Manifest manifest) throws IOException {
        if (objectInput != null) {
            return new ModuleData(objectInput);
        }
        return new ModuleData(manifest, this);
    }

    @Override
    boolean isNetigsoImpl() {
        return true;
    }

    @Override
    protected void parseManifest() throws InvalidException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    @Override
    public List<File> getAllJars() {
        return Collections.singletonList(this.jar);
    }

    @Override
    public void setReloadable(boolean bl) {
        this.reloadable = true;
    }

    @Override
    public void reload() throws IOException {
        this.mgr.netigso().reload(this);
    }

    final void start() throws IOException {
        ProxyClassLoader proxyClassLoader = (ProxyClassLoader)this.classloader;
        try {
            Set<String> set = this.mgr.netigso().createLoader(this, proxyClassLoader, this.jar);
            proxyClassLoader.addCoveredPackages(set);
        }
        catch (IOException iOException) {
            this.classloader = null;
            throw iOException;
        }
    }

    @Override
    protected void classLoaderUp(Set<Module> set) throws IOException {
        LOG.log(Level.FINE, "classLoaderUp {0}", this.getCodeNameBase());
        assert (this.classloader == null) : "already had " + this.classloader + " for " + (Object)((Object)this);
        this.classloader = new DelegateCL();
        this.mgr.netigsoLoaderUp(this);
    }

    @Override
    protected void classLoaderDown() {
        LOG.log(Level.FINE, "classLoaderDown {0}", this.getCodeNameBase());
        ProxyClassLoader proxyClassLoader = (ProxyClassLoader)this.classloader;
        this.classloader = null;
        ClassLoader classLoader = proxyClassLoader.firstParent();
        if (classLoader == null) {
            this.mgr.netigsoLoaderDown(this);
            return;
        }
        this.mgr.netigso().stopLoader(this, classLoader);
    }

    @Override
    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (this.classloader == null) {
            try {
                this.classLoaderUp(null);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.classloader == null) {
            throw new IllegalArgumentException("No classloader for " + this.getCodeNameBase());
        }
        return this.classloader;
    }

    @Override
    public Set<Object> getProblems() {
        InvalidException invalidException = this.problem;
        return invalidException == null ? Collections.emptySet() : Collections.singleton(invalidException);
    }

    final void setProblem(InvalidException invalidException) {
        this.problem = invalidException;
    }

    @Override
    public Enumeration<URL> findResources(String string) {
        return this.mgr.netigso().findResources(this, string);
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void destroy() {
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest != null) {
            return this.manifest;
        }
        try {
            return this.getManager().loadManifest(this.jar);
        }
        catch (IOException iOException) {
            Util.err.log(Level.WARNING, "While loading manifest for " + (Object)((Object)this), iOException);
            return new Manifest();
        }
    }

    public Object getLocalizedAttribute(String string) {
        return null;
    }

    @Override
    public String toString() {
        return "Netigso: " + this.jar;
    }

    @Override
    final int getStartLevelImpl() {
        return this.startLevel;
    }

    final void setStartLevel(int n) {
        this.startLevel = n;
    }

    private final class DelegateCL
    extends ProxyClassLoader
    implements Util.ModuleProvider {
        public DelegateCL() {
            super(new ClassLoader[0], false);
        }

        private ProxyClassLoader delegate() {
            ClassLoader classLoader = this.firstParent();
            assert (classLoader != null);
            return (ProxyClassLoader)classLoader;
        }

        @Override
        public URL findResource(String string) {
            try {
                return this.delegate().findResource(string);
            }
            catch (IllegalStateException illegalStateException) {
                LOG.log(Level.SEVERE, "Can't load " + string, illegalStateException);
                return null;
            }
        }

        @Override
        public Enumeration<URL> findResources(String string) throws IOException {
            try {
                return this.delegate().findResources(string);
            }
            catch (IllegalStateException illegalStateException) {
                throw new IOException("Can't load " + string, illegalStateException);
            }
        }

        @Override
        protected Class<?> doLoadClass(String string, String string2) {
            try {
                return this.delegate().doLoadClass(string, string2);
            }
            catch (IllegalStateException illegalStateException) {
                LOG.log(Level.INFO, "Can't load " + string2 + " in package " + string, illegalStateException);
                return null;
            }
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            try {
                return this.delegate().loadClass(string, bl);
            }
            catch (IllegalStateException illegalStateException) {
                throw new ClassNotFoundException("Can't load " + string, illegalStateException);
            }
        }

        public String toString() {
            ClassLoader classLoader = this.firstParent();
            return classLoader == null ? "Netigso[uninitialized]" : "Netigso[" + classLoader.toString() + "]";
        }

        @Override
        public Module getModule() {
            return NetigsoModule.this;
        }
    }
}

