/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.memory;

import java.util.Map;
import java.util.Properties;
import org.graalvm.visualvm.sampler.SamplerParameters;

public final class MemorySamplerParameters
extends SamplerParameters {
    static final String SAMPLING_RATE = "sampling-rate";

    private MemorySamplerParameters(String parametersS) {
        super(parametersS);
    }

    public static MemorySamplerParameters parse(String parameters) {
        return new MemorySamplerParameters(parameters);
    }

    @Override
    protected void parseParameters(String parametersS, Map<String, String> parameters) {
        if (parametersS.startsWith("settings-file=")) {
            this.parseParametersFile(MemorySamplerParameters.decode(parametersS.substring("settings-file".length() + 1)), parameters);
        } else {
            for (String parameter : parametersS.split(",")) {
                int idx = parameter.indexOf("sampling-rate=");
                if (idx != 0) continue;
                parameters.put(SAMPLING_RATE, MemorySamplerParameters.decode(parameter.substring(SAMPLING_RATE.length() + 1)));
            }
        }
    }

    private void parseParametersFile(String file, Map<String, String> parameters) {
        Properties properties = MemorySamplerParameters.loadProperties(file);
        String prop = properties.getProperty(SAMPLING_RATE);
        if (prop != null) {
            parameters.put(SAMPLING_RATE, MemorySamplerParameters.decode(prop));
        }
    }
}

