/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.AWTKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.ui.UIConstants;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.JExtendedTable;
import org.graalvm.visualvm.lib.ui.components.table.ClassNameTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.ExtendedTableModel;
import org.graalvm.visualvm.lib.ui.components.table.LabelBracketTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.SortableTableModel;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.MemoryResultsPanel;

public abstract class SampledResultsPanel
extends MemoryResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String FILTER_MENU_ITEM_NAME = messages.getString("SampledResultsPanel_FilterMenuItemName");
    private static final String CLASS_COLUMN_NAME = messages.getString("SampledResultsPanel_ClassColumnName");
    private static final String BYTES_REL_COLUMN_NAME = messages.getString("SampledResultsPanel_BytesRelColumnName");
    private static final String BYTES_COLUMN_NAME = messages.getString("SampledResultsPanel_BytesColumnName");
    private static final String OBJECTS_COLUMN_NAME = messages.getString("SampledResultsPanel_ObjectsColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("SampledResultsPanel_ClassColumnToolTip");
    private static final String BYTES_REL_COLUMN_TOOLTIP = messages.getString("SampledResultsPanel_BytesRelColumnToolTip");
    private static final String BYTES_COLUMN_TOOLTIP = messages.getString("SampledResultsPanel_BytesColumnToolTip");
    private static final String OBJECTS_COLUMN_TOOLTIP = messages.getString("SampledResultsPanel_ObjectsColumnToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("SampledResultsPanel_TableAccessName");
    protected int[] nTotalLiveObjects;
    protected long[] totalLiveObjectsSize;
    protected long nTotalLiveBytes;
    protected long nTotalClasses;
    private int initialSortingColumn;
    private int minNamesColumnWidth;

    public SampledResultsPanel(MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler);
        this.setDefaultSorting();
        this.initColumnsData();
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = sColumn;
            this.sortBy = this.getSortBy(this.initialSortingColumn);
            this.sortOrder = sOrder;
        }
    }

    public int getSortingColumn() {
        if (this.resTableModel == null) {
            return -1;
        }
        return this.resTableModel.getRealColumn(this.resTableModel.getSortingColumn());
    }

    public boolean getSortingOrder() {
        if (this.resTableModel == null) {
            return false;
        }
        return this.resTableModel.getSortingOrder();
    }

    @Override
    protected abstract JPopupMenu getPopupMenu();

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new CustomBarCellRenderer(0L, 100L);
    }

    protected void getResultsSortedByLiveObjNumber() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTotalLiveObjects, (int[][])null, (long[][])new long[][]{this.totalLiveObjectsSize}, (float[][])null, 0, visibleLines, false);
        this.totalAllocations = 0L;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.totalAllocations += (long)this.nTotalLiveObjects[i];
        }
    }

    protected void getResultsSortedByLiveObjSize() {
        this.getResultsSortedByClassName(true);
        int visibleLines = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.totalLiveObjectsSize, (int[][])new int[][]{this.nTotalLiveObjects}, (long[][])null, (float[][])null, 0, visibleLines, false);
        this.totalAllocations = 0L;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.totalAllocations += (long)this.nTotalLiveObjects[i];
        }
    }

    protected void getResultsSortedByClassName(boolean presortOnly) {
        this.nInfoLines = this.sortResultsByClassName(new int[][]{this.nTotalLiveObjects}, new long[][]{this.totalLiveObjectsSize}, null, this.nTrackedItems, this.truncateZeroItems());
        if (!presortOnly) {
            this.totalAllocations = 0L;
            for (int i = 0; i < this.nInfoLines; ++i) {
                this.totalAllocations += (long)this.nTotalLiveObjects[i];
            }
        }
    }

    @Override
    protected JExtendedTable getResultsTable() {
        this.sortResults();
        if (this.resTable == null) {
            this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

                @Override
                public String getColumnName(int col) {
                    return SampledResultsPanel.this.columnNames[col];
                }

                @Override
                public int getRowCount() {
                    return SampledResultsPanel.this.nDisplayedItems;
                }

                @Override
                public int getColumnCount() {
                    return SampledResultsPanel.this.columnNames.length;
                }

                public Class getColumnClass(int col) {
                    return SampledResultsPanel.this.columnTypes[col];
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return SampledResultsPanel.this.computeValueAt(row, col);
                }

                @Override
                public String getColumnToolTipText(int col) {
                    return SampledResultsPanel.this.columnToolTips[col];
                }

                @Override
                public void sortByColumn(int column, boolean order) {
                    SampledResultsPanel.this.sortBy = SampledResultsPanel.this.getSortBy(column);
                    SampledResultsPanel.this.sortOrder = order;
                    int selectedRow = SampledResultsPanel.this.resTable.getSelectedRow();
                    String selectedRowContents = null;
                    if (selectedRow != -1) {
                        selectedRowContents = (String)SampledResultsPanel.this.resTable.getValueAt(selectedRow, 0);
                    }
                    SampledResultsPanel.this.prepareResults();
                    if (selectedRowContents != null) {
                        SampledResultsPanel.this.resTable.selectRowByContents(selectedRowContents, 0, true);
                    }
                }

                @Override
                public boolean getInitialSorting(int column) {
                    switch (column) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            });
            this.resTable = new JExtendedTable(this.resTableModel){

                @Override
                public void doLayout() {
                    int columnsWidthsSum = 0;
                    int realFirstColumn = -1;
                    for (int i = 0; i < SampledResultsPanel.this.resTableModel.getColumnCount(); ++i) {
                        int index = SampledResultsPanel.this.resTableModel.getRealColumn(i);
                        if (index == 0) {
                            realFirstColumn = i;
                            continue;
                        }
                        columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                    }
                    if (realFirstColumn != -1) {
                        this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, SampledResultsPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
            this.resTableModel.setTable(this.resTable);
            this.resTableModel.setInitialSorting(this.initialSortingColumn, this.sortOrder);
            this.resTable.setRowSelectionAllowed(true);
            this.resTable.setSelectionMode(0);
            this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.resTable.setShowHorizontalLines(false);
            this.resTable.setShowVerticalLines(true);
            this.resTable.setRowMargin(0);
            this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
            keys.add(KeyStroke.getKeyStroke(9, 0));
            this.resTable.setFocusTraversalKeys(0, keys);
            keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
            keys.add(KeyStroke.getKeyStroke(9, 1));
            this.resTable.setFocusTraversalKeys(1, keys);
            this.setColumnsData();
        }
        return this.resTable;
    }

    protected Object computeValueAt(int row, int col) {
        int index = (Integer)this.filteredToFullIndexes.get(row);
        switch (col) {
            case 0: {
                return this.sortedClassNames[index];
            }
            case 1: {
                return this.nTotalLiveBytes == 0L ? 0.0 : (double)this.totalLiveObjectsSize[index] / (double)this.nTotalLiveBytes * 100.0;
            }
            case 2: {
                return this.intFormat.format(this.totalLiveObjectsSize[index]) + " B (" + (this.nTotalLiveBytes == 0L ? "-%" : this.percentFormat.format((double)this.totalLiveObjectsSize[index] / (double)this.nTotalLiveBytes)) + ")";
            }
            case 3: {
                return this.intFormat.format(this.nTotalLiveObjects[index]) + " (" + (this.nTotalClasses == 0L ? "-%" : this.percentFormat.format((double)this.nTotalLiveObjects[index] / (double)this.nTotalClasses)) + ")";
            }
        }
        return null;
    }

    @Override
    protected void initColumnSelectorItems() {
        this.headerPopup.removeAll();
        for (int i = 0; i < this.columnNames.length; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(Integer.toString(i));
            this.addMenuItemListener(menuItem);
            if (this.resTable != null) {
                menuItem.setState(this.resTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.headerPopup.add(menuItem);
        }
        this.headerPopup.addSeparator();
        JCheckBoxMenuItem filterMenuItem = new JCheckBoxMenuItem(FILTER_MENU_ITEM_NAME);
        filterMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(filterMenuItem);
        if (this.filterComponent == null) {
            filterMenuItem.setState(true);
        } else {
            filterMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.headerPopup.add(filterMenuItem);
        this.headerPopup.pack();
    }

    protected void initColumnsData() {
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{CLASS_COLUMN_NAME, BYTES_REL_COLUMN_NAME, BYTES_COLUMN_NAME, OBJECTS_COLUMN_NAME};
        this.columnToolTips = new String[]{CLASS_COLUMN_TOOLTIP, BYTES_REL_COLUMN_TOOLTIP, BYTES_COLUMN_TOOLTIP, OBJECTS_COLUMN_TOOLTIP};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelBracketTableCellRenderer, labelBracketTableCellRenderer};
        this.columnWidths = new int[]{maxWidth + 15, maxWidth, maxWidth};
    }

    @Override
    protected boolean passesValueFilter(int i) {
        return (double)this.totalLiveObjectsSize[i] / (double)this.nTotalLiveBytes * 100.0 >= this.valueFilterValue;
    }

    @Override
    protected void performDefaultAction(int classId) {
        this.showSourceForClass(classId);
    }

    private void setColumnsData() {
        this.barRenderer = this.getBarCellRenderer();
        TableColumnModel colModel = this.resTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            if (index == 1) {
                colModel.getColumn(i).setCellRenderer(this.barRenderer);
                continue;
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private int getSortBy(int column) {
        switch (column) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 2;
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Filter")) {
                    SampledResultsPanel.this.filterComponent.getComponent().setVisible(!SampledResultsPanel.this.filterComponent.getComponent().isVisible());
                    return;
                }
                SampledResultsPanel.this.saveColumnsData();
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                int sortingColumn = SampledResultsPanel.this.resTableModel.getSortingColumn();
                int realSortingColumn = SampledResultsPanel.this.resTableModel.getRealColumn(sortingColumn);
                boolean isColumnVisible = SampledResultsPanel.this.resTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    sortingColumn = sortingColumn + 1 == SampledResultsPanel.this.resTableModel.getColumnCount() ? sortingColumn - 1 : sortingColumn + 1;
                    realSortingColumn = SampledResultsPanel.this.resTableModel.getRealColumn(sortingColumn);
                    sortResults = true;
                }
                SampledResultsPanel.this.resTableModel.setRealColumnVisibility(column, !isColumnVisible);
                SampledResultsPanel.this.resTable.createDefaultColumnsFromModel();
                SampledResultsPanel.this.resTableModel.setTable(SampledResultsPanel.this.resTable);
                sortingColumn = SampledResultsPanel.this.resTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    SampledResultsPanel.this.sortOrder = SampledResultsPanel.this.resTableModel.getInitialSorting(sortingColumn);
                    SampledResultsPanel.this.sortBy = SampledResultsPanel.this.getSortBy(realSortingColumn);
                    SampledResultsPanel.this.sortResults();
                    SampledResultsPanel.this.resTable.repaint();
                }
                SampledResultsPanel.this.resTableModel.setInitialSorting(sortingColumn, SampledResultsPanel.this.sortOrder);
                SampledResultsPanel.this.resTable.getTableHeader().repaint();
                SampledResultsPanel.this.setColumnsData();
            }
        });
    }

    private void saveColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
    }

    private void sortResults() {
        switch (this.sortBy) {
            case 2: {
                this.getResultsSortedByLiveObjSize();
                break;
            }
            case 3: {
                this.getResultsSortedByLiveObjNumber();
                break;
            }
            case 1: {
                this.getResultsSortedByClassName(false);
            }
        }
        this.createFilteredIndexes();
    }
}

