/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class GenericToolbar
extends JToolBar {
    private static int PREFERRED_HEIGHT = -1;

    public GenericToolbar() {
        this.tweak();
    }

    public GenericToolbar(int orientation) {
        super(orientation);
        this.tweak();
    }

    public GenericToolbar(String name) {
        super(name);
        this.tweak();
    }

    public GenericToolbar(String name, int orientation) {
        super(name, orientation);
        this.tweak();
    }

    private void tweak() {
        if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
            int axis = this.getOrientation() == 1 ? 3 : 2;
            this.setLayout(new BoxLayout(this, axis));
        }
        if (UIUtils.isNimbusLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(-2, 0, -2, 0));
        } else if (UIUtils.isAquaLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        }
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            this.setRollover(true);
        }
    }

    @Override
    public void addSeparator() {
        if (!UIUtils.isMetalLookAndFeel()) {
            super.addSeparator();
        } else {
            final JSeparator separator = new JSeparator(1);
            final int WDTH = separator.getPreferredSize().width;
            final Dimension SIZE = new Dimension(new JToolBar.Separator().getSeparatorSize().width, 12);
            JPanel panel = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return SIZE;
                }

                @Override
                public Dimension getMaximumSize() {
                    return SIZE;
                }

                @Override
                public Dimension getMinimumSize() {
                    return SIZE;
                }

                @Override
                public void doLayout() {
                    int x = (this.getWidth() - WDTH) / 2;
                    int y = (this.getHeight() - SIZE.height) / 2;
                    separator.setBounds(x, y, WDTH, SIZE.height);
                }
            };
            panel.setOpaque(false);
            panel.add(separator);
            super.add(panel);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (UIUtils.isMetalLookAndFeel()) {
            if (comp instanceof AbstractButton && !(comp instanceof JCheckBox) && !(comp instanceof JRadioButton)) {
                final AbstractButton ab = (AbstractButton)comp;
                ab.setMargin(new Insets(1, 1, 1, 1));
                if (ab.getClientProperty("MetalListener") == null) {
                    final ButtonModel bm = ab.getModel();
                    ChangeListener cl = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ab.setBorderPainted(bm.isArmed() || bm.isPressed() || bm.isRollover() || bm.isSelected());
                            ab.setContentAreaFilled(bm.isArmed() || bm.isPressed() || bm.isRollover() || bm.isSelected());
                        }
                    };
                    cl.stateChanged(null);
                    ab.getModel().addChangeListener(cl);
                    ab.putClientProperty("MetalListener", cl);
                }
            }
        } else if (UIUtils.isNimbusLookAndFeel()) {
            if (comp instanceof AbstractButton && !(comp instanceof JCheckBox) && !(comp instanceof JRadioButton)) {
                AbstractButton ab = (AbstractButton)comp;
                ab.setMargin(new Insets(2, 2, 2, 2));
            }
        } else if (UIUtils.isAquaLookAndFeel()) {
            if (comp instanceof AbstractButton && !(comp instanceof JCheckBox) && !(comp instanceof JRadioButton)) {
                AbstractButton ab = (AbstractButton)comp;
                ab.putClientProperty("JButton.buttonType", "segmentedTextured");
                if (ab.getClientProperty("JButton.segmentPosition") == null) {
                    ab.putClientProperty("JButton.segmentPosition", "only");
                }
                ab.setMargin(new Insets(-1, -1, -2, -1));
            }
        } else if (UIUtils.isWindowsClassicLookAndFeel() && comp instanceof AbstractButton && !(comp instanceof JCheckBox) && !(comp instanceof JRadioButton)) {
            AbstractButton ab = (AbstractButton)comp;
            ab.setMargin(new Insets(1, 1, 1, 1));
        }
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((JButton)comp);
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (UIUtils.isGTKLookAndFeel() && this.getClientProperty("Toolbar.noGTKBorder") == Boolean.TRUE) {
            return;
        }
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (PREFERRED_HEIGHT == -1) {
            GenericToolbar tb = new GenericToolbar();
            tb.setBorder(this.getBorder());
            tb.setBorderPainted(this.isBorderPainted());
            tb.setRollover(this.isRollover());
            tb.setFloatable(this.isFloatable());
            Icon icon = Icons.getIcon((String)"GeneralIcons.Save");
            tb.add(new JButton("Button", icon));
            tb.add(new JToggleButton("Button", icon));
            tb.add(new JTextField("Text"));
            JComboBox<Object> c = new JComboBox<Object>();
            c.setEditor(new BasicComboBoxEditor());
            c.setRenderer(new BasicComboBoxRenderer());
            tb.add(c);
            tb.addSeparator();
            PREFERRED_HEIGHT = tb.getSuperPreferredSize().height;
        }
        dim.height = this.getParent() instanceof JToolBar ? 1 : Math.max(dim.height, PREFERRED_HEIGHT);
        return dim;
    }

    private Dimension getSuperPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void doLayout() {
        for (Component component : this.getComponents()) {
            component.setFocusable(this.isFocusableComponent(component));
        }
        super.doLayout();
    }

    protected boolean isFocusableComponent(Component component) {
        if (!component.isVisible()) {
            return false;
        }
        if (component instanceof JLabel) {
            return false;
        }
        if (component instanceof JPanel) {
            return false;
        }
        if (component instanceof JSeparator) {
            return false;
        }
        if (component instanceof JToolBar) {
            return false;
        }
        return !(component instanceof Box.Filler);
    }
}

