/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.dnd.EnhancedDragPainter;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;

public final class DropTargetGlassPane
extends JPanel
implements DropTargetListener {
    private final Observer observer;
    private final Informer informer;
    private WindowDnDManager windowDragAndDrop;
    private Point location;
    private TopComponentDroppable droppable;
    private Reference<Autoscroll> lastAutoscroll = null;
    private static final boolean DEBUG = Debug.isLoggable(DropTargetGlassPane.class);
    private Point dragLocation = null;
    private Shape currentDropIndication;
    private EnhancedDragPainter currentPainter;
    private Component componentUnderCursor;
    private TexturePaint texturePaint;
    private int modeKind = -1;
    private Stroke stroke;
    private static final Color FILL_COLOR = new Color(200, 200, 200, 120);

    public DropTargetGlassPane(WindowDnDManager windowDnDManager) {
        this.observer = windowDnDManager;
        this.informer = windowDnDManager;
        this.windowDragAndDrop = windowDnDManager;
        this.setOpaque(false);
    }

    public void initialize() {
        if (this.isVisible()) {
            this.revalidate();
        } else {
            this.setVisible(true);
        }
    }

    public void uninitialize() {
        if (this.location != null) {
            this.dragFinished();
        }
        this.setVisible(false);
        this.stopAutoscroll();
    }

    void dragOver(Point point, TopComponentDroppable topComponentDroppable) {
        this.droppable = topComponentDroppable;
        this.setDragLocation(point);
        this.autoscroll(topComponentDroppable, point);
    }

    private void setDragLocation(Point point) {
        Point point2 = this.dragLocation;
        this.dragLocation = point;
        if (point != null && point.equals(point2)) {
            return;
        }
        if (point == null) {
            return;
        }
        this.setVisible(true);
        if (this.droppable != null) {
            Shape shape;
            Serializable serializable;
            Rectangle rectangle = null;
            if (null != this.currentDropIndication) {
                rectangle = this.currentDropIndication.getBounds();
                rectangle = SwingUtilities.convertRectangle(this.componentUnderCursor, rectangle, this);
                if (null != this.currentPainter && null != (serializable = this.currentPainter.getPaintArea())) {
                    rectangle.add((Rectangle)serializable);
                }
            }
            if (null != (shape = this.droppable.getIndicationForLocation(SwingUtilities.convertPoint(this, point, serializable = this.droppable.getDropComponent()))) && shape.equals(this.currentDropIndication)) {
                return;
            }
            this.currentPainter = this.droppable instanceof EnhancedDragPainter ? (EnhancedDragPainter)((Object)this.droppable) : null;
            this.currentDropIndication = shape;
            this.componentUnderCursor = serializable;
            if (null != this.currentDropIndication) {
                Rectangle rectangle2 = this.currentDropIndication.getBounds();
                rectangle2 = SwingUtilities.convertRectangle(serializable, rectangle2, this);
                if (null != rectangle) {
                    rectangle.add(rectangle2);
                } else {
                    rectangle = rectangle2;
                }
                if (null != this.currentPainter && null != (rectangle2 = this.currentPainter.getPaintArea())) {
                    rectangle.add(rectangle2);
                }
            }
            if (null != rectangle) {
                rectangle.grow(2, 2);
                this.repaint(rectangle);
            }
        } else if (null != this.currentDropIndication) {
            Rectangle rectangle = this.currentDropIndication.getBounds();
            this.currentDropIndication = null;
            if (null != this.currentPainter) {
                Rectangle rectangle3 = this.currentPainter.getPaintArea();
                if (null != rectangle3) {
                    rectangle = rectangle.union(rectangle3);
                }
                this.currentPainter = null;
            }
            this.repaint(rectangle);
        }
    }

    private void dragExited() {
        this.clear();
    }

    public void clearIndications() {
        this.currentDropIndication = null;
        this.currentPainter = null;
        this.componentUnderCursor = null;
        this.repaint();
        this.clear();
    }

    private void dragActionChanged(Point point) {
        this.setDragLocation(point);
    }

    private void dragFinished() {
        this.clear();
    }

    private void clear() {
        this.stopAutoscroll();
        this.droppable = null;
        this.setDragLocation(null);
    }

    @Override
    public void paint(Graphics graphics) {
        if (null != this.currentDropIndication) {
            Color color;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (null != this.currentPainter) {
                this.currentPainter.additionalDragPaint(graphics2D);
            }
            if ((color = UIManager.getColor("Panel.dropTargetGlassPane")) == null) {
                color = Color.red;
            }
            graphics2D.setColor(color);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(this.componentUnderCursor, point, this);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(point.x, point.y);
            graphics2D.transform(affineTransform);
            graphics2D.setStroke(this.getIndicationStroke());
            graphics2D.setPaint(this.getIndicationPaint());
            Color color2 = Constants.SWITCH_DROP_INDICATION_FADE ? FILL_COLOR : null;
            graphics2D.draw(this.currentDropIndication);
            if (null != color2) {
                graphics2D.fill(this.currentDropIndication);
            }
            graphics2D.dispose();
        }
    }

    private TexturePaint getIndicationPaint() {
        if (this.droppable != null && this.droppable.getKind() != this.modeKind) {
            boolean bl;
            BufferedImage bufferedImage = new BufferedImage(2, 2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color = UIManager.getColor("Panel.dropTargetGlassPane");
            boolean bl2 = bl = this.droppable.getKind() == 1 && this.windowDragAndDrop.getStartingTransfer().getKind() != 1 || this.droppable.getKind() != 1 && this.windowDragAndDrop.getStartingTransfer().getKind() == 1;
            if (color == null) {
                color = new Color(255, 90, 0);
            }
            if (bl) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, 1, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 0));
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.75f));
                graphics2D.fillRect(1, 0, 1, 1);
                graphics2D.fillRect(0, 1, 1, 1);
            } else {
                graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 200));
                graphics2D.fillRect(0, 0, 2, 2);
            }
            this.texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, 2, 2));
            this.modeKind = this.droppable.getKind();
        }
        return this.texturePaint;
    }

    private Stroke getIndicationStroke() {
        if (null == this.stroke) {
            this.stroke = new BasicStroke(3.0f);
        }
        return this.stroke;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragEnter");
        }
        if ((n = dropTargetDragEvent.getDropAction()) == 0) {
            n = 2;
        }
        if ((n & 3) > 0) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        Component component;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragExit");
        }
        if ((component = dropTargetEvent.getDropTargetContext().getComponent()) == this) {
            this.dragExited();
            this.stopAutoscroll();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dragOver");
        }
        this.observer.setLastDropTarget(this);
    }

    void autoscroll(TopComponentDroppable topComponentDroppable, Point point) {
        Autoscroll autoscroll;
        Component component = topComponentDroppable.getDropComponent();
        point = SwingUtilities.convertPoint(this, point, component);
        Component component2 = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        Autoscroll autoscroll2 = component2 instanceof Autoscroll ? (Autoscroll)((Object)component2) : (Autoscroll)((Object)SwingUtilities.getAncestorOfClass(Autoscroll.class, component2));
        Autoscroll autoscroll3 = autoscroll = null == this.lastAutoscroll ? null : this.lastAutoscroll.get();
        if (null != autoscroll && autoscroll != autoscroll2) {
            autoscroll.autoscroll(new Point(Integer.MIN_VALUE, Integer.MIN_VALUE));
        }
        if (autoscroll2 != null) {
            autoscroll2.autoscroll(point);
            this.lastAutoscroll = new WeakReference<Autoscroll>(autoscroll2);
        } else {
            this.lastAutoscroll = null;
        }
    }

    void stopAutoscroll() {
        Autoscroll autoscroll = null == this.lastAutoscroll ? null : this.lastAutoscroll.get();
        this.lastAutoscroll = null;
        if (autoscroll != null) {
            autoscroll.autoscroll(new Point(Integer.MIN_VALUE, Integer.MIN_VALUE));
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        boolean bl;
        if (DEBUG) {
            DropTargetGlassPane.debugLog("");
            DropTargetGlassPane.debugLog("dropActionChanged");
        }
        if (bl = (n = dropTargetDragEvent.getDropAction()) == 2 || n == 1 && this.informer.isCopyOperationPossible()) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (component == this) {
            this.dragActionChanged(bl ? dropTargetDragEvent.getLocation() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point;
        boolean bl;
        int n;
        block6: {
            Component component;
            if (DEBUG) {
                DropTargetGlassPane.debugLog("");
                DropTargetGlassPane.debugLog("drop");
            }
            if ((component = dropTargetDropEvent.getDropTargetContext().getComponent()) == this) {
                this.dragFinished();
            }
            if ((n = dropTargetDropEvent.getDropAction()) != 2 && n != 1) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(n);
            bl = false;
            try {
                point = dropTargetDropEvent.getLocation();
                SwingUtilities.convertPointToScreen(point, component);
                if (!WindowDnDManager.isAroundCenterPanel(point)) break block6;
                this.observer.setDropSuccess(bl);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (Throwable throwable) {
                this.observer.setDropSuccess(bl);
                dropTargetDropEvent.dropComplete(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DropTargetGlassPane.this.windowDragAndDrop.dragFinished();
                        DropTargetGlassPane.this.windowDragAndDrop.dragFinishedEx();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        bl = this.windowDragAndDrop.tryPerformDrop(this.informer.getController(), this.informer.getFloatingFrames(), point, n, dropTargetDropEvent.getTransferable());
        this.observer.setDropSuccess(bl);
        dropTargetDropEvent.dropComplete(false);
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private static void debugLog(String string) {
        Debug.log(DropTargetGlassPane.class, string);
    }

    static interface Informer {
        public boolean isCopyOperationPossible();

        public Controller getController();

        public Set<Component> getFloatingFrames();
    }

    static interface Observer {
        public void setDropSuccess(boolean var1);

        public void setLastDropTarget(DropTargetGlassPane var1);
    }
}

