/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import org.netbeans.core.windows.view.ui.slides.ScaleFx;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlideOperationImpl;
import org.netbeans.core.windows.view.ui.slides.SlidingFx;

public final class SlideOperationFactory {
    private static final SlidingFx slideInFx = new ScaleFx(0.1f, 0.9f, true);
    private static final SlidingFx slideOutFx = new ScaleFx(0.9f, 0.1f, false);
    private static final SlidingFx slideIntoEdgeFx = new ScaleFx(0.9f, 0.1f, false);
    private static final SlidingFx slideIntoDesktopFx = new ScaleFx(1.0f, 1.0f, true);
    static final boolean EFFECTS_ENABLED = Boolean.getBoolean("nb.winsys.sliding.effects");

    private SlideOperationFactory() {
    }

    public static SlideOperation createSlideIn(Component component, int n, boolean bl, boolean bl2) {
        SlideOperationImpl slideOperationImpl = new SlideOperationImpl(0, component, n, bl && EFFECTS_ENABLED ? slideInFx : null, bl2);
        return slideOperationImpl;
    }

    public static SlideOperation createSlideOut(Component component, int n, boolean bl, boolean bl2) {
        SlideOperationImpl slideOperationImpl = new SlideOperationImpl(1, component, n, bl && EFFECTS_ENABLED ? slideOutFx : null, bl2);
        return slideOperationImpl;
    }

    public static SlideOperation createSlideIntoEdge(Component component, String string, boolean bl) {
        SlideOperationImpl slideOperationImpl = new SlideOperationImpl(2, component, string, bl && EFFECTS_ENABLED ? slideIntoEdgeFx : null, false);
        return slideOperationImpl;
    }

    public static SlideOperation createSlideIntoDesktop(Component component, int n, boolean bl) {
        SlideOperationImpl slideOperationImpl = new SlideOperationImpl(3, component, n, bl && EFFECTS_ENABLED ? slideIntoDesktopFx : null, false);
        return slideOperationImpl;
    }

    public static SlideOperation createSlideResize(Component component, int n) {
        SlideOperationImpl slideOperationImpl = new SlideOperationImpl(4, component, n, null, false);
        return slideOperationImpl;
    }

    public static SlideOperation createSlideResize(Component component, String string) {
        return SlideOperationFactory.createSlideResize(component, SlideOperationImpl.side2Orientation(string));
    }
}

