/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.core.network.proxy.pac.PacHelperMethods;
import org.netbeans.core.network.proxy.pac.PacUtils;
import org.netbeans.core.network.proxy.pac.datetime.PacUtilsDateTime;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.LocalAddressUtils;

public class NbPacHelperMethods
extends PacHelperMethods {
    private static final Logger LOGGER = Logger.getLogger(NbPacHelperMethods.class.getName());
    public static final int DNS_TIMEOUT_MS = 4000;

    @Override
    public boolean isPlainHostName(String string) {
        return !string.contains(".");
    }

    @Override
    public boolean dnsDomainIs(String string, String string2) {
        int n = string.indexOf(".");
        if (n != -1 && n < string.length() - 1) {
            if (string.substring(n).equals(string2)) {
                return true;
            }
            if (string.substring(n + 1).equals(string2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean localHostOrDomainIs(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.equals(NbPacHelperMethods.getDomains(string2)[0]);
    }

    @Override
    public boolean isResolvable(String string) {
        try {
            IpAddressUtils.nameResolve(string, 4000, IpAddressUtils.IpTypePreference.IPV4_ONLY);
            return true;
        }
        catch (InterruptedException | UnknownHostException | TimeoutException exception) {
            return false;
        }
    }

    @Override
    public String dnsResolve(String string) {
        try {
            return IpAddressUtils.nameResolve(string, 4000, IpAddressUtils.IpTypePreference.IPV4_ONLY).getHostAddress();
        }
        catch (InterruptedException | UnknownHostException | TimeoutException exception) {
            return null;
        }
    }

    @Override
    public String myIpAddress() {
        return LocalAddressUtils.getMostLikelyLocalInetAddress(IpAddressUtils.IpTypePreference.IPV4_ONLY).getHostAddress();
    }

    @Override
    public boolean isInNet(String string, String string2, String string3) {
        try {
            String string4 = IpAddressUtils.nameResolve(string, 4000, IpAddressUtils.IpTypePreference.IPV4_ONLY).getHostAddress();
            String[] stringArray = string4.split("\\.");
            String[] stringArray2 = string2.split("\\.");
            String[] stringArray3 = string3.split("\\.");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i >= stringArray3.length || !stringArray3[i].trim().equals("255") || stringArray[i].trim().equals(stringArray2[i].trim())) continue;
                return false;
            }
            return true;
        }
        catch (InterruptedException | UnknownHostException | TimeoutException exception) {
            return false;
        }
    }

    @Override
    public int dnsDomainLevels(String string) {
        if (string == null) {
            return 0;
        }
        return NbPacHelperMethods.getNoOfOccurrences(string, '.');
    }

    @Override
    public boolean shExpMatch(String string, String string2) {
        Pattern pattern = PacUtils.createRegexPatternFromGlob(string2);
        return pattern.matcher(string).matches();
    }

    @Override
    public boolean weekdayRange(Object ... objectArray) {
        try {
            return PacUtilsDateTime.isInWeekdayRange(new Date(), objectArray);
        }
        catch (PacUtilsDateTime.PacDateTimeInputException pacDateTimeInputException) {
            LOGGER.log(Level.WARNING, "PAC script error : arguments passed to weekdayRange() function {0} are faulty: {1}", new Object[]{Arrays.toString(objectArray), pacDateTimeInputException.getMessage()});
            return false;
        }
    }

    @Override
    public boolean dateRange(Object ... objectArray) {
        try {
            return PacUtilsDateTime.isInDateRange(new Date(), objectArray);
        }
        catch (PacUtilsDateTime.PacDateTimeInputException pacDateTimeInputException) {
            LOGGER.log(Level.WARNING, "PAC script error : arguments passed to dateRange() function {0} are faulty: {1}", new Object[]{Arrays.toString(objectArray), pacDateTimeInputException.getMessage()});
            return false;
        }
    }

    @Override
    public boolean timeRange(Object ... objectArray) {
        try {
            return PacUtilsDateTime.isInTimeRange(new Date(), objectArray);
        }
        catch (PacUtilsDateTime.PacDateTimeInputException pacDateTimeInputException) {
            LOGGER.log(Level.WARNING, "PAC script error : arguments passed to timeRange() function {0} are faulty: {1}", new Object[]{Arrays.toString(objectArray), pacDateTimeInputException.getMessage()});
            return false;
        }
    }

    @Override
    public boolean isResolvableEx(String string) {
        try {
            IpAddressUtils.nameResolve(string, 4000, IpAddressUtils.IpTypePreference.ANY_JDK_PREF).getHostAddress();
            return true;
        }
        catch (InterruptedException | UnknownHostException | TimeoutException exception) {
            return false;
        }
    }

    @Override
    public String dnsResolveEx(String string) {
        try {
            return IpAddressUtils.nameResolve(string, 4000, IpAddressUtils.IpTypePreference.ANY_JDK_PREF).getHostAddress();
        }
        catch (InterruptedException | UnknownHostException | TimeoutException exception) {
            return "";
        }
    }

    @Override
    public String myIpAddressEx() {
        InetAddress[] inetAddressArray = LocalAddressUtils.getMostLikelyLocalInetAddresses(IpAddressUtils.IpTypePreference.ANY_JDK_PREF);
        return PacUtils.toSemiColonListInetAddress(inetAddressArray);
    }

    @Override
    public String sortIpAddressList(String string) {
        if (string == null) {
            return "";
        }
        String[] stringArray = string.split(";");
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (String object : stringArray) {
            try {
                arrayList.add(InetAddress.getByName(object.trim()));
            }
            catch (UnknownHostException unknownHostException) {
                return "";
            }
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        IpAddressUtils.sortIpAddresses(arrayList2, false);
        ArrayList<String> arrayList3 = new ArrayList<String>(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            InetAddress inetAddress = (InetAddress)iterator.next();
            arrayList3.add(stringArray[arrayList.indexOf(inetAddress)].trim());
        }
        return PacUtils.toSemiColonList(arrayList3);
    }

    @Override
    public String getClientVersion() {
        return "1.0";
    }

    @Override
    public boolean isInNetEx(String string, String string2) {
        String[] stringArray;
        InetAddress inetAddress;
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        try {
            inetAddress = IpAddressUtils.nameResolve(string, 4000, IpAddressUtils.IpTypePreference.ANY_JDK_PREF);
        }
        catch (InterruptedException | UnknownHostException | TimeoutException exception) {
            return false;
        }
        for (String string3 : stringArray = string2.split(";")) {
            if (!PacUtils.ipPrefixMatch(inetAddress, string3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void alert(String string) {
        LOGGER.log(Level.INFO, "PAC script says : {0}", string);
    }

    private static String[] getDomains(String string) {
        String[] stringArray = string.split("\\.");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if (string2 == null || string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    private static int getNoOfOccurrences(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }
}

