/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.LongPreOffsetTransform;
import org.openjdk.jmc.common.unit.ScaleFactor;
import org.openjdk.jmc.common.unit.SimpleAffineTransform;

public class LongPostOffsetTransform
implements IScalarAffineTransform {
    private final double multiplier;
    private final long offset;

    public LongPostOffsetTransform(double multiplier, long offset) {
        this.multiplier = multiplier;
        this.offset = offset;
    }

    @Override
    public Number getOffset() {
        return this.offset;
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean equals(Object other) {
        if (other instanceof LongPostOffsetTransform) {
            LongPostOffsetTransform otherSAT = (LongPostOffsetTransform)other;
            return this.multiplier == otherSAT.multiplier && this.offset == otherSAT.offset;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToRawLongBits(this.multiplier) ^ Double.doubleToRawLongBits(this.offset);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (this.multiplier >= 1.0) {
            return (double)srcNumericalValue > (double)(maxAbsValue - this.offset) / this.multiplier || (double)srcNumericalValue < (double)((maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) - this.offset) / this.multiplier;
        }
        return this.targetValue(srcNumericalValue) > maxAbsValue || this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (this.multiplier >= 1.0) {
            return srcNumericalValue > (double)(maxAbsValue - this.offset) / this.multiplier || srcNumericalValue < (double)((maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) - this.offset) / this.multiplier;
        }
        return this.targetValue(srcNumericalValue) > (double)maxAbsValue || this.targetValue(srcNumericalValue) < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return Math.round((double)srcNumericalValue * this.multiplier) + this.offset;
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        return (long)Math.floor((double)srcNumericalValue * this.multiplier) + this.offset;
    }

    @Override
    public double targetFloor(double srcNumericalValue) {
        return Math.floor(srcNumericalValue * this.multiplier + (double)this.offset);
    }

    @Override
    public int targetIntFloor(Number srcNumericalValue) {
        return (int)this.targetFloor(srcNumericalValue.doubleValue());
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        return Math.round((double)srcNumericalValue * this.multiplier) + this.offset;
    }

    @Override
    public Number targetNumber(Number srcNumericalValue) {
        return Math.round(srcNumericalValue.doubleValue() * this.multiplier) + this.offset;
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return srcNumericalValue * this.multiplier + (double)this.offset;
    }

    @Override
    public IScalarAffineTransform invert() {
        return new LongPreOffsetTransform(-this.offset, 1.0 / this.multiplier);
    }

    @Override
    public boolean isUnity() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public IScalarAffineTransform concat(IScalarAffineTransform innerTransform) {
        if (innerTransform.isUnity()) {
            return this;
        }
        if (innerTransform instanceof ScaleFactor) {
            return new LongPostOffsetTransform(this.multiplier * innerTransform.getMultiplier(), this.offset);
        }
        return SimpleAffineTransform.createWithPostOffset(this.multiplier * innerTransform.getMultiplier(), this.targetNumber(innerTransform.getOffset()));
    }

    @Override
    public IScalarAffineTransform invertAndConcat(IScalarAffineTransform innerTransform) {
        if (this.equals(innerTransform)) {
            return DecimalScaleFactor.get(0);
        }
        if (innerTransform.isUnity()) {
            return this.invert();
        }
        double invertedMultiplier = 1.0 / this.multiplier;
        double otherOffset = innerTransform.getOffset().doubleValue();
        return new SimpleAffineTransform(innerTransform.getMultiplier() * invertedMultiplier, (otherOffset - (double)this.offset) * invertedMultiplier);
    }
}

