/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapFactory;
import org.openide.util.Lookup;

public class JavaHeapFragmentProvider
extends HeapFragment.Provider {
    @Override
    public List<HeapFragment> getFragments(File heapDumpFile, Lookup.Provider heapDumpProject, Heap heap) throws IOException {
        if (heap.getJavaClassByName("java.lang.Object") == null) {
            return null;
        }
        ArrayList<HeapFragment> fragments = new ArrayList<HeapFragment>();
        int segments = HeapFactory.getTotalNumberOfSegments((Heap)heap);
        if (segments == 1) {
            fragments.add(new JavaHeapFragment(heap));
        } else {
            fragments.add(new JavaHeapFragment(heap, 0));
            for (int segment = 1; segment < segments; ++segment) {
                Heap segmentHeap = HeapFactory.createHeap((File)heapDumpFile, (int)segment);
                fragments.add(new JavaHeapFragment(segmentHeap, segment));
            }
        }
        return fragments;
    }
}

