/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class ByteCounter
extends PrimitiveCounter {
    private int size;
    private final int[] counts = new int[256];

    public void count(byte key) {
        int index = key - -128;
        if (this.counts[index] == 0) {
            ++this.size;
        }
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    public void count(String value) {
        this.count(Byte.parseByte(value));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ByteCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            entry.count = ByteCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = ByteCounter.this.counts[++this.index];
            }
            entry.value = (byte)(this.index++ + -128);
            ++this.count;
            return entry;
        }
    }

    public static final class Record
    extends PrimitiveCounter.Record {
        private byte value;
        private int count;

        private Record() {
        }

        public byte getPrimitive() {
            return this.value;
        }

        @Override
        public String getValue() {
            return Byte.toString(this.value);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Byte.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

