/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SingleSelectionModel;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;

public final class ScrollingTabLayoutModel
implements TabLayoutModel {
    private int offset = -1;
    private TabLayoutModel wrapped;
    private boolean changed = true;
    TabDataModel mdl;
    SingleSelectionModel sel;
    private int makeVisibleTab = -1;
    int pixelsToAddToSelection = 0;
    private boolean lastTabClipped = false;
    private int firstVisibleTab = -1;
    private int lastVisibleTab = -1;
    private int width = -1;
    private int[] widths = null;
    private int minimumXposition = 0;
    private boolean recentlyResized = true;
    private Action fAction = null;
    private Action bAction = null;

    public ScrollingTabLayoutModel(TabLayoutModel tabLayoutModel, SingleSelectionModel singleSelectionModel, TabDataModel tabDataModel) {
        this.wrapped = tabLayoutModel;
        this.mdl = tabDataModel;
        this.sel = singleSelectionModel;
    }

    public ScrollingTabLayoutModel(TabLayoutModel tabLayoutModel, SingleSelectionModel singleSelectionModel, TabDataModel tabDataModel, int n) {
        this(tabLayoutModel, singleSelectionModel, tabDataModel);
        this.minimumXposition = n;
    }

    public void setMinimumXposition(int n) {
        this.minimumXposition = n;
        this.setChanged(true);
    }

    public void setPixelsToAddToSelection(int n) {
        this.pixelsToAddToSelection = n;
        this.setChanged(true);
    }

    public void clearCachedData() {
        this.setChanged(true);
    }

    private TabLayoutModel getWrapped() {
        return this.wrapped;
    }

    public int getOffset() {
        if (this.mdl.size() <= 1) {
            return -1;
        }
        return this.offset;
    }

    private void change() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mdl.size() == 0) {
            this.widths = new int[0];
            this.updateActions();
            this.setChanged(false);
            return;
        }
        if (this.widths == null || this.widths.length != this.mdl.size()) {
            this.widths = new int[this.mdl.size()];
        }
        Arrays.fill(this.widths, 0);
        if (this.widths.length == 1) {
            this.offset = -1;
        }
        if (this.width < this.getMinimumLeftClippedWidth()) {
            int n5 = this.makeVisibleTab != -1 ? this.makeVisibleTab : this.sel.getSelectedIndex();
            if ((n5 = Math.min(this.widths.length - 1, n5)) != -1) {
                this.widths[n5] = this.width;
            } else {
                this.widths[0] = this.width;
            }
            this.firstVisibleTab = n5;
            this.lastVisibleTab = n5;
            this.setChanged(false);
            return;
        }
        int n6 = this.minimumXposition;
        int n7 = this.offset >= 0 ? this.offset : 0;
        int n8 = -1;
        this.lastVisibleTab = -1;
        this.firstVisibleTab = n7;
        this.lastTabClipped = false;
        if (n7 == this.mdl.size() - 1 && this.width < this.getWrapped().getW(n7) + this.getMinimumLeftClippedWidth()) {
            this.lastVisibleTab = n7;
            if (n7 != 0) {
                this.firstVisibleTab = n7 - 1;
                this.widths[n7] = this.width - this.getMinimumLeftClippedWidth();
                this.widths[n7 - 1] = this.getMinimumLeftClippedWidth();
                this.lastTabClipped = this.width - this.getMinimumLeftClippedWidth() < this.getWrapped().getW(n7);
            } else {
                this.firstVisibleTab = n7;
                this.widths[n7] = this.width;
                this.lastTabClipped = this.width < this.getWrapped().getW(n7);
            }
            this.updateActions();
            this.setChanged(false);
            return;
        }
        for (n4 = n7; n4 < this.widths.length; ++n4) {
            n3 = n4 == this.offset ? this.getMinimumLeftClippedWidth() : this.getWrapped().getW(n4);
            if (n6 + n3 > this.width) {
                if (this.width - n6 < this.getMinimumRightClippedWidth() && n4 != n7) {
                    int n9 = n4 - 1;
                    this.widths[n9] = this.widths[n9] + (this.width - n6 - 1);
                    n8 = this.width - n6;
                    this.lastVisibleTab = n4 - 1;
                    this.widths[n4] = 0;
                } else {
                    this.widths[n4] = this.width - n6 - 1;
                    this.lastVisibleTab = n4;
                }
                this.lastTabClipped = true;
                break;
            }
            this.widths[n4] = n3;
            n6 += n3;
            if (n4 != this.widths.length - 1) continue;
            this.lastVisibleTab = this.widths.length - 1;
        }
        n4 = this.sel.getSelectedIndex();
        if (this.pixelsToAddToSelection != 0 && n4 > n7 && n4 < this.lastVisibleTab) {
            int n10 = n4;
            this.widths[n10] = this.widths[n10] + this.pixelsToAddToSelection;
            n3 = this.pixelsToAddToSelection - 1 / (this.lastVisibleTab - n7);
            n2 = this.pixelsToAddToSelection - 1;
            for (n = n7; n <= this.lastVisibleTab; ++n) {
                if (n == n4) continue;
                if (n3 == 0) {
                    int n11 = n;
                    this.widths[n11] = this.widths[n11] - 2;
                    if ((n2 -= 2) > 0) continue;
                    break;
                }
                int n12 = n;
                this.widths[n12] = this.widths[n12] - n3;
                if ((n2 -= n3) <= 0) break;
            }
        }
        if (n8 != -1 && this.lastVisibleTab != n7 && this.lastVisibleTab != n7 + 1) {
            n3 = n8 / (this.lastVisibleTab + 1 - n7);
            for (n2 = n7; n2 < this.lastVisibleTab; ++n2) {
                if (n3 != 0) {
                    int n13 = n2;
                    this.widths[n13] = this.widths[n13] + n3;
                    int n14 = this.lastVisibleTab;
                    this.widths[n14] = this.widths[n14] - n3;
                    continue;
                }
                n = n8 > 2 ? 2 : n8;
                int n15 = n2;
                this.widths[n15] = this.widths[n15] + n;
                int n16 = this.lastVisibleTab;
                this.widths[n16] = this.widths[n16] - n;
                if ((n8 -= n) <= 0) break;
            }
        }
        this.updateActions();
        this.setChanged(false);
    }

    private void setChanged(boolean bl) {
        if (this.changed != bl) {
            this.changed = bl;
        }
    }

    public int getPixelsToAddToSelection() {
        return this.pixelsToAddToSelection;
    }

    public boolean isLastTabClipped() {
        if (this.width < this.getMinimumLeftClippedWidth()) {
            return true;
        }
        return this.lastTabClipped;
    }

    public boolean makeVisible(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            this.setWidth(n2);
            this.makeVisibleTab = n;
            return false;
        }
        boolean bl = n2 != this.width || this.recentlyResized;
        this.recentlyResized = false;
        this.setWidth(n2);
        if (n == -1) {
            return false;
        }
        if (this.mdl.size() == 1) {
            this.setOffset(-1);
            return this.changed;
        }
        if (this.mdl.size() == 2 && (n5 = this.getWrapped().getW(0) + this.getWrapped().getW(1)) > n2) {
            this.setOffset(0);
            return this.changed;
        }
        if (this.changed) {
            this.change();
        }
        if (n == 0) {
            n5 = this.setOffset(-1);
            return n5 != -1;
        }
        n5 = this.getW(n);
        int n6 = this.getWrapped().getW(n);
        if (n6 > n2) {
            this.setOffset(n - 1);
            return this.changed;
        }
        if (n == this.mdl.size() - 1 && !this.isLastTabClipped() && !bl && n5 == n2) {
            return false;
        }
        int n7 = -2;
        int n8 = 0;
        boolean bl2 = false;
        boolean bl3 = this.changed;
        boolean bl4 = false;
        if (n >= this.getLastVisibleTab(n2)) {
            n4 = this.sel.getSelectedIndex();
            bl4 = n >= n4;
            n8 = this.getWrapped().getW(n);
            if (n == n4) {
                n8 += this.pixelsToAddToSelection;
            }
            n3 = n;
            do {
                if (--n3 <= -1) continue;
                if (n3 == n4) {
                    n8 += this.pixelsToAddToSelection;
                }
                int n9 = this.getWrapped().getW(n3);
                n8 += n9;
            } while (n8 <= n2 && n3 >= -1);
            n7 = n3;
            if ((n8 <= n2 || bl4) && this.getOffset() == -1 && ++n7 == -1) {
                n7 = 0;
            }
        } else if (n <= this.getFirstVisibleTab(n2)) {
            bl2 = true;
            n7 = n - 1;
        }
        if (bl || !bl2 || n == this.mdl.size() && this.getFirstVisibleTab(n2) == n) {
            if (n7 != -2) {
                this.setOffset(n7);
            }
            bl3 = this.ensureAvailableSpaceUsed(false);
        } else if (n7 != -2) {
            n4 = this.offset;
            n3 = this.setOffset(Math.min(this.mdl.size(), n7));
            bl3 = n4 != n3;
        }
        return bl3;
    }

    boolean ensureAvailableSpaceUsed(boolean bl) {
        int n;
        if (this.mdl.size() == 0) {
            return false;
        }
        boolean bl2 = false;
        if (this.changed && !bl) {
            bl2 = true;
            this.change();
        }
        int n2 = this.mdl.size() - 1;
        int n3 = n = bl ? this.getCachedLastVisibleTab() : this.getLastVisibleTab(this.width);
        if (n == n2 || n == this.mdl.size() && n2 > -1) {
            int n4 = this.offset;
            int n5 = this.width - (this.getX(n2) + this.getW(n2));
            while (n5 > 0 && n4 > -1) {
                if ((n5 -= this.getWrapped().getW(n4)) <= 0) continue;
                --n4;
            }
            this.setOffset(n4);
            if (this.changed) {
                bl2 = true;
                this.change();
            }
        }
        return bl2;
    }

    int getMinimumRightClippedWidth() {
        return 40;
    }

    int getMinimumLeftClippedWidth() {
        return 40;
    }

    public void setWidth(int n) {
        if (this.width != n) {
            this.recentlyResized = true;
            if (n < this.width) {
                this.makeVisibleTab = this.sel.getSelectedIndex();
            }
            boolean bl = n > 0 && this.width < 0 && this.makeVisibleTab != -1;
            this.width = n - this.minimumXposition;
            this.setChanged(n > this.getMinimumLeftClippedWidth());
            if (this.changed && bl && n > this.getMinimumLeftClippedWidth()) {
                this.makeVisible(this.makeVisibleTab, n);
                this.makeVisibleTab = -1;
            }
        }
    }

    public int setOffset(int n) {
        int n2 = this.offset;
        if (this.mdl.size() == 1) {
            if (this.offset > -1) {
                this.offset = -1;
                this.setChanged(true);
            }
            return n2;
        }
        if (this.mdl.size() == 2 && this.width < this.getMinimumLeftClippedWidth() + this.getMinimumRightClippedWidth()) {
            this.offset = -1;
            this.setChanged(false);
            return n2;
        }
        if (n < -1) {
            n = -1;
        }
        if (n != this.offset) {
            this.setChanged(true);
            this.offset = n;
        }
        return n2;
    }

    public int getFirstVisibleTab(int n) {
        this.setWidth(n);
        if (this.mdl.size() == 0) {
            return -1;
        }
        if (n < this.getMinimumLeftClippedWidth()) {
            int n2 = this.makeVisibleTab == -1 ? this.sel.getSelectedIndex() : this.makeVisibleTab;
            return n2;
        }
        if (this.changed) {
            this.change();
        }
        return this.firstVisibleTab;
    }

    public int countVisibleTabs(int n) {
        return this.getLastVisibleTab(n) + 1 - this.getFirstVisibleTab(n);
    }

    public int getLastVisibleTab(int n) {
        this.setWidth(n);
        if (this.mdl.size() == 0) {
            return -1;
        }
        if (n < this.getMinimumLeftClippedWidth()) {
            int n2 = this.makeVisibleTab == -1 ? this.sel.getSelectedIndex() : this.makeVisibleTab;
            return n2;
        }
        if (this.changed) {
            this.change();
        }
        return this.lastVisibleTab;
    }

    int getCachedLastVisibleTab() {
        return this.lastVisibleTab;
    }

    int getCachedFirstVisibleTab() {
        return this.firstVisibleTab;
    }

    @Override
    public int dropIndexOfPoint(int n, int n2) {
        if (this.changed) {
            this.change();
        }
        int n3 = this.getFirstVisibleTab(this.width);
        int n4 = this.getLastVisibleTab(this.width);
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            int n6 = n5;
            n5 += this.getW(i);
            int n7 = this.getH(i);
            int n8 = this.getY(i);
            if (n2 < 0 || n2 > n8 + n7) {
                return -1;
            }
            if (i == n4 && n > n6 + this.getW(i) / 2) {
                return n4 + 1;
            }
            if (n < n6 || n > n5) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setPadding(Dimension dimension) {
        this.getWrapped().setPadding(dimension);
        this.setChanged(true);
    }

    @Override
    public int getH(int n) {
        if (this.changed) {
            this.change();
        }
        try {
            return this.getWrapped().getH(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0;
        }
    }

    @Override
    public int getW(int n) {
        if (this.changed || this.widths == null || n > this.widths.length) {
            this.change();
        }
        if (n >= this.widths.length) {
            return 0;
        }
        return this.widths[n];
    }

    @Override
    public int getX(int n) {
        if (this.changed) {
            this.change();
        }
        int n2 = this.minimumXposition;
        for (int i = 0; i < n; ++i) {
            n2 += this.getW(i);
        }
        return n2;
    }

    @Override
    public int getY(int n) {
        if (this.changed) {
            this.change();
        }
        return this.getWrapped().getY(n);
    }

    @Override
    public int indexOfPoint(int n, int n2) {
        int n3;
        if (this.changed) {
            this.change();
        }
        int n4 = this.minimumXposition;
        int n5 = n3 = this.offset == -1 ? 0 : this.offset;
        while (n3 < this.mdl.size()) {
            int n6 = n4;
            int n7 = this.getW(n3);
            n4 += n7;
            if (n7 == 0) break;
            int n8 = this.getH(n3);
            int n9 = this.getY(n3);
            if (n2 < 0 || n2 > n9 + n8) {
                return -1;
            }
            if (n > n6 && n < n4) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public Action getForwardAction() {
        if (this.fAction == null) {
            this.fAction = new ForwardAction();
        }
        return this.fAction;
    }

    public Action getBackwardAction() {
        if (this.bAction == null) {
            this.bAction = new BackwardAction();
        }
        return this.bAction;
    }

    private void updateActions() {
        if (this.width <= this.getMinimumLeftClippedWidth()) {
            this.bAction.setEnabled(false);
            this.fAction.setEnabled(false);
        }
        if (this.bAction != null) {
            this.bAction.setEnabled(this.mdl.size() > 1 && this.offset > -1);
        }
        if (this.fAction != null) {
            this.fAction.setEnabled(this.isLastTabClipped() && this.mdl.size() > 2 && (this.lastVisibleTab - this.firstVisibleTab > 1 || this.lastVisibleTab < this.mdl.size() - 1));
        }
    }

    private class BackwardAction
    extends AbstractAction {
        private BackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollingTabLayoutModel.this.setOffset(ScrollingTabLayoutModel.this.getOffset() - 1);
            Component component = (Component)this.getValue("control");
            if (component != null) {
                component.repaint();
            }
        }
    }

    private class ForwardAction
    extends AbstractAction {
        private ForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollingTabLayoutModel.this.setOffset(ScrollingTabLayoutModel.this.getOffset() + 1);
            Component component = (Component)this.getValue("control");
            if (component != null) {
                component.repaint();
            }
        }
    }
}

