/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.classfile.BaseClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassRepository;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.PlaceholderClassInfo;
import org.graalvm.visualvm.lib.jfluid.client.RuntimeProfilingPoint;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.instrumentation.JavaClassConstants;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.RootClassLoadedCommand;

public class ClassManager
implements JavaClassConstants,
CommonConstants {
    private static final RuntimeProfilingPoint[] EMPTY_PROFILEPOINT_ARRAY = new RuntimeProfilingPoint[0];
    private static Comparator ByBciComparator = new Comparator(){

        public int compare(Object aa, Object bb) {
            RuntimeProfilingPoint a = (RuntimeProfilingPoint)aa;
            RuntimeProfilingPoint b = (RuntimeProfilingPoint)bb;
            return a.getBci() - b.getBci();
        }
    };
    protected ProfilingSessionStatus status;
    protected ClassRepository classRepo;

    protected ClassManager(ClassRepository repo, ProfilingSessionStatus status) {
        this.status = status;
        this.classRepo = repo;
    }

    protected RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, ClassInfo classInfo) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        String className = classInfo.getName().replace('/', '.');
        for (RuntimeProfilingPoint point : points) {
            if (!className.equals(point.getClassName()) || !point.resolve(this.classRepo, classInfo)) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        return newPoints.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, int methodIdx) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        for (RuntimeProfilingPoint point : points) {
            if (point.getMethodIdx() != methodIdx) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (newPoints.size() > 1) {
            Collections.sort(newPoints, ByBciComparator);
        }
        return newPoints.toArray(new RuntimeProfilingPoint[0]);
    }

    protected RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, ClassInfo classInfo, int methodIdx) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        String className = classInfo.getName().replace('/', '.');
        for (RuntimeProfilingPoint point : points) {
            if (!className.equals(point.getClassName()) || !point.resolve(this.classRepo, classInfo) || point.getMethodIdx() != methodIdx) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (newPoints.size() > 1) {
            Collections.sort(newPoints, ByBciComparator);
        }
        return newPoints.toArray(new RuntimeProfilingPoint[0]);
    }

    protected DynamicClassInfo javaClassForName(String className, int classLoaderId) {
        try {
            return this.classRepo.lookupClass(className, classLoaderId);
        }
        catch (IOException ex2) {
            MiscUtils.printWarningMessage("Error reading class " + className);
            MiscUtils.printWarningMessage(ex2.getMessage());
        }
        catch (ClassFormatError er) {
            MiscUtils.printWarningMessage(er.getMessage());
        }
        return null;
    }

    protected BaseClassInfo javaClassForObjectArrayType(String elementTypeName) {
        return this.classRepo.lookupSpecialClass("[" + elementTypeName);
    }

    protected BaseClassInfo javaClassForPrimitiveArrayType(int arrayTypeId) {
        return this.classRepo.lookupSpecialClass(PRIMITIVE_ARRAY_TYPE_NAMES[arrayTypeId]);
    }

    protected BaseClassInfo lookupSpecialClass(String className) {
        return this.classRepo.lookupSpecialClass(className);
    }

    protected Enumeration getClassEnumerationWithAllVersions() {
        return this.classRepo.getClassEnumerationWithAllVersions();
    }

    protected List getAllClassVersions(String className) {
        return this.classRepo.getAllClassVersions(className);
    }

    protected BaseClassInfo javaClassOrPlaceholderForName(String className, int classLoaderId) {
        return this.classRepo.lookupClassOrCreatePlaceholder(className, classLoaderId);
    }

    protected BaseClassInfo loadedJavaClassOrExistingPlaceholderForName(String className, int classLoaderId) {
        return this.classRepo.lookupLoadedClass(className, classLoaderId, true);
    }

    protected void registerPlaceholder(PlaceholderClassInfo pci) {
        this.classRepo.addClassInfo(pci);
    }

    protected void resetLoadedClassData() {
        this.classRepo.clearCache();
    }

    protected void storeClassFileBytesForCustomLoaderClasses(RootClassLoadedCommand rootLoaded) {
        String[] loadedClasses = rootLoaded.getAllLoadedClassNames();
        byte[][] cachedClassFileBytes = rootLoaded.getCachedClassFileBytes();
        int[] loadedClassLoaderIds = rootLoaded.getAllLoadedClassLoaderIds();
        int[] superClasses = rootLoaded.getAllLoaderSuperClassIds();
        int[][] interfaceNames = rootLoaded.getAllLoadedInterfaceIds();
        int nClasses = loadedClasses.length;
        HashSet<Integer> allInterfacesIndexes = new HashSet<Integer>();
        for (int i = 0; i < nClasses; ++i) {
            if (cachedClassFileBytes[i] == null) continue;
            String string = loadedClasses[i];
            int loaderId = loadedClassLoaderIds[i];
            byte[] bytes = cachedClassFileBytes[i];
            if (bytes != null && bytes.length == 0) {
                int sidx = superClasses[i];
                String superClass = sidx != -1 ? loadedClasses[sidx] : "java/lang/Object";
                int[] interfaceNamedIdxs = interfaceNames[i];
                ArrayList<String> interfaces = new ArrayList<String>();
                for (int j = 0; j < interfaceNamedIdxs.length; ++j) {
                    int iidx = interfaceNamedIdxs[j];
                    if (iidx == -1) continue;
                    interfaces.add(loadedClasses[iidx]);
                    allInterfacesIndexes.add(iidx);
                }
                this.classRepo.addVMSuppliedClassFile(string, loaderId, bytes, superClass, interfaces.toArray(new String[0]));
                continue;
            }
            this.classRepo.addVMSuppliedClassFile(string, loaderId, bytes);
        }
        for (Object e : allInterfacesIndexes) {
            int iidx = (Integer)e;
            if (cachedClassFileBytes[iidx] == null) continue;
            DynamicClassInfo iface = this.javaClassForName(loadedClasses[iidx], loadedClassLoaderIds[iidx]);
            iface.setInterface();
        }
    }
}

