/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.DiffCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.DiffFlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeBacked;

public class CPUResultsDiff
extends CPUResultsSnapshot {
    private final CPUResultsSnapshot snapshot1;
    private final CPUResultsSnapshot snapshot2;

    public CPUResultsDiff(CPUResultsSnapshot snapshot1, CPUResultsSnapshot snapshot2) {
        this.snapshot1 = snapshot1;
        this.snapshot2 = snapshot2;
        this.threadCCTContainers = snapshot1.threadCCTContainers;
    }

    @Override
    public boolean isCollectingTwoTimeStamps() {
        return this.snapshot1.collectingTwoTimeStamps && this.snapshot2.collectingTwoTimeStamps;
    }

    @Override
    public CPUCCTContainer getContainerForThread(int threadId, int view) {
        return this.snapshot1.getContainerForThread(threadId, view);
    }

    @Override
    public DiffFlatProfileContainer getFlatProfile(int threadId, int view) {
        FlatProfileContainer fpc1 = this.snapshot1.getFlatProfile(threadId, view);
        FlatProfileContainer fpc2 = this.snapshot2.getFlatProfile(threadId, view);
        return DiffFlatProfileContainer.create(fpc1, fpc2);
    }

    @Override
    public FlatProfileContainer getFlatProfile(Collection<Integer> threads, int view) {
        FlatProfileContainer fpc1 = this.snapshot1.getFlatProfile(threads, view);
        FlatProfileContainer fpc2 = this.snapshot2.getFlatProfile(this.threads2(threads), view);
        return DiffFlatProfileContainer.create(fpc1, fpc2);
    }

    @Override
    public String[] getInstrMethodClasses(int view) {
        return this.snapshot1.getInstrMethodClasses(view);
    }

    @Override
    public String[] getInstrMethodNames() {
        return this.snapshot1.getInstrMethodNames();
    }

    @Override
    public String[] getInstrMethodSignatures() {
        return this.snapshot1.getInstrMethodSignatures();
    }

    @Override
    public String[] getMethodClassNameAndSig(int methodId, int view) {
        return methodId < 0 ? this.snapshot2.getMethodClassNameAndSig(-methodId, view) : this.snapshot1.getMethodClassNameAndSig(methodId, view);
    }

    @Override
    public Map<Integer, ClientUtils.SourceCodeSelection> getMethodIDMap(int view) {
        int i;
        HashMap<Integer, ClientUtils.SourceCodeSelection> map = new HashMap<Integer, ClientUtils.SourceCodeSelection>();
        for (i = 0; i < this.snapshot1.instrMethodClassesViews[view].length; ++i) {
            map.put(i, this.snapshot1.getSourceCodeSelection(i, view));
        }
        for (i = 0; i < this.snapshot2.instrMethodClassesViews[view].length; ++i) {
            map.put(-i, this.snapshot2.getSourceCodeSelection(i, view));
        }
        return map;
    }

    @Override
    public int getNInstrMethods() {
        return this.snapshot1.getNInstrMethods();
    }

    @Override
    public int getNThreads() {
        return this.snapshot1.getNThreads();
    }

    @Override
    public PrestimeCPUCCTNode getReverseCCT(int threadId, int methodId, int view) {
        PrestimeCPUCCTNode root1 = this.snapshot1.getReverseCCT(threadId, methodId, view);
        PrestimeCPUCCTNode root2 = this.snapshot2.getReverseCCT(threadId, methodId, view);
        return new DiffCPUCCTNode(root1, root2);
    }

    @Override
    public PrestimeCPUCCTNode getRootNode(int view) {
        PrestimeCPUCCTNode root1 = this.snapshot1.getRootNode(view);
        PrestimeCPUCCTNode root2 = this.snapshot2.getRootNode(view);
        return new DiffCPUCCTNode(root1, root2);
    }

    @Override
    public PrestimeCPUCCTNode getRootNode(int view, Collection<Integer> threads, boolean merge) {
        PrestimeCPUCCTNode root1 = this.snapshot1.getRootNode(view, threads, merge);
        PrestimeCPUCCTNode root2 = this.snapshot2.getRootNode(view, this.threads2(threads), merge);
        return new DiffCPUCCTNode(root1, root2);
    }

    @Override
    public PrestimeCPUCCTNode getReverseRootNode(int view, Collection<Integer> threads, boolean merge) {
        PrestimeCPUCCTNode root1 = this.snapshot1.getReverseRootNode(view, threads, merge);
        PrestimeCPUCCTNode root2 = this.snapshot2.getReverseRootNode(view, this.threads2(threads), merge);
        return new DiffCPUCCTNode(root1, root2);
    }

    private Collection<Integer> threads2(Collection<Integer> threads1) {
        if (threads1 == null || threads1.isEmpty()) {
            return threads1;
        }
        HashSet<String> threads1Names = new HashSet<String>();
        for (int thread1Id : threads1) {
            threads1Names.add(this.getThreadNameForId(thread1Id));
        }
        HashSet<Integer> threads2 = new HashSet<Integer>();
        for (int thread2Id : this.snapshot2.getThreadIds()) {
            if (!threads1Names.contains(this.snapshot2.getThreadNameForId(thread2Id))) continue;
            threads2.add(thread2Id);
        }
        return threads2;
    }

    public long getBound(int view) {
        CCTNode[] children;
        long bound = Long.MIN_VALUE;
        PrestimeCPUCCTNode root = this.getRootNode(view);
        for (CCTNode child : children = root.getChildren()) {
            bound = Math.max(bound, Math.abs(((PrestimeCPUCCTNode)child).getTotalTime0()));
        }
        return bound;
    }

    @Override
    public void filterForward(String filter, int filterType, PrestimeCPUCCTNodeBacked root) {
    }

    @Override
    public void saveSortParams(int sortBy, boolean sortOrder, CCTNode node) {
    }

    @Override
    public int[] getThreadIds() {
        return this.snapshot1.getThreadIds();
    }

    @Override
    public String getThreadNameForId(int threadId) {
        return this.snapshot1.getThreadNameForId(threadId);
    }

    @Override
    public String[] getThreadNames() {
        return this.snapshot1.getThreadNames();
    }
}

