/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.graalvm.visualvm.lib.jfluid.heap.CacheDirectory;

class LongBuffer {
    private DataInputStream readStream;
    private boolean readStreamClosed;
    private DataOutputStream writeStream;
    private File backingFile;
    private long[] buffer;
    private boolean useBackingFile;
    private int bufferSize;
    private int readOffset;
    private int longs;
    private CacheDirectory cacheDirectory;

    LongBuffer(int size, CacheDirectory cacheDir) {
        this.buffer = new long[size];
        this.cacheDirectory = cacheDir;
    }

    void delete() {
        if (this.backingFile != null) {
            assert (this.writeStream == null);
            assert (this.readStreamClosed || this.readStream == null);
            this.backingFile.delete();
            this.useBackingFile = false;
            this.backingFile = null;
            this.longs = 0;
        }
    }

    boolean hasData() {
        return this.longs > 0;
    }

    long readLong() throws IOException {
        if (!this.useBackingFile) {
            if (this.readOffset < this.bufferSize) {
                return this.buffer[this.readOffset++];
            }
            return 0L;
        }
        if (this.readStreamClosed) {
            return 0L;
        }
        try {
            return this.readStream.readLong();
        }
        catch (EOFException ex) {
            this.readStreamClosed = true;
            this.readStream.close();
            return 0L;
        }
    }

    void reset() throws IOException {
        this.bufferSize = 0;
        if (this.writeStream != null) {
            this.writeStream.close();
        }
        if (this.readStream != null) {
            this.readStream.close();
        }
        this.writeStream = null;
        this.readStream = null;
        this.readStreamClosed = false;
        this.longs = 0;
        this.useBackingFile = false;
        this.readOffset = 0;
    }

    void startReading() throws IOException {
        if (this.writeStream != null) {
            this.writeStream.close();
        }
        this.writeStream = null;
        this.rewind();
    }

    void rewind() {
        this.readOffset = 0;
        if (this.useBackingFile) {
            try {
                if (this.readStream != null) {
                    this.readStream.close();
                }
                this.readStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.backingFile), this.buffer.length * 8));
                this.readStreamClosed = false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    void writeLong(long data) throws IOException {
        ++this.longs;
        if (this.bufferSize < this.buffer.length) {
            this.buffer[this.bufferSize++] = data;
            return;
        }
        if (this.backingFile == null) {
            this.backingFile = this.cacheDirectory.createTempFile("NBProfiler", ".gc");
        }
        if (this.writeStream == null) {
            this.writeStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.backingFile), this.buffer.length * 8));
            for (int i = 0; i < this.buffer.length; ++i) {
                this.writeStream.writeLong(this.buffer[i]);
            }
            this.useBackingFile = true;
        }
        this.writeStream.writeLong(data);
    }

    LongBuffer revertBuffer() throws IOException {
        LongBuffer reverted = new LongBuffer(this.buffer.length, this.cacheDirectory);
        if (this.bufferSize < this.buffer.length) {
            for (int i = 0; i < this.bufferSize; ++i) {
                reverted.writeLong(this.buffer[this.bufferSize - 1 - i]);
            }
        } else {
            if (this.writeStream != null) {
                this.writeStream.flush();
            }
            try (RandomAccessFile raf = new RandomAccessFile(this.backingFile, "r");){
                long offset = raf.length();
                while (offset > 0L) {
                    raf.seek(offset -= 8L);
                    reverted.writeLong(raf.readLong());
                }
            }
        }
        reverted.startReading();
        return reverted;
    }

    int getSize() {
        return this.longs;
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.bufferSize);
        out.writeInt(this.readOffset);
        out.writeInt(this.longs);
        out.writeInt(this.buffer.length);
        out.writeBoolean(this.useBackingFile);
        if (this.useBackingFile) {
            if (this.writeStream != null) {
                this.writeStream.flush();
            }
            out.writeUTF(this.backingFile.getAbsolutePath());
        } else {
            for (int i = 0; i < this.bufferSize; ++i) {
                out.writeLong(this.buffer[i]);
            }
        }
    }

    LongBuffer(DataInputStream dis, CacheDirectory cacheDir) throws IOException {
        this.bufferSize = dis.readInt();
        this.readOffset = dis.readInt();
        this.longs = dis.readInt();
        this.buffer = new long[dis.readInt()];
        this.useBackingFile = dis.readBoolean();
        if (this.useBackingFile) {
            this.backingFile = cacheDir.getCacheFile(dis.readUTF());
        } else {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = dis.readLong();
            }
        }
        this.cacheDirectory = cacheDir;
    }
}

