/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.actions.CustomizeAction;
import org.openide.awt.Actions;
import org.openide.awt.JInlineMenu;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class PropertiesAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 1) {
            NodeOperation.getDefault().showProperties(nodeArray[0]);
        } else {
            NodeOperation.getDefault().showProperties(nodeArray);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null;
    }

    public JMenuItem getPopupPresenter() {
        Actions.MenuItem menuItem = new Actions.MenuItem((SystemAction)this, false);
        CustomizeAction customizeAction = (CustomizeAction)SystemAction.get(CustomizeAction.class);
        if (customizeAction.isEnabled()) {
            JInlineMenu jInlineMenu = new JInlineMenu();
            jInlineMenu.setMenuItems(new JMenuItem[]{new Actions.MenuItem((SystemAction)customizeAction, false), menuItem});
            return jInlineMenu;
        }
        return menuItem;
    }

    public String getName() {
        return NbBundle.getMessage(PropertiesAction.class, (String)"Properties");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PropertiesAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/properties.gif";
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Toolbar,
    Presenter.Popup {
        private PropertiesAction delegate;
        private Lookup lookup;

        public DelegateAction(PropertiesAction propertiesAction, Lookup lookup) {
            this.delegate = propertiesAction;
            this.lookup = lookup;
        }

        private Node[] nodes() {
            Collection collection = this.lookup.lookupAll(Node.class);
            return collection.toArray(new Node[0]);
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.delegate.performAction(this.nodes());
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.enable(this.nodes());
        }

        @Override
        public void setEnabled(boolean bl) {
            assert (false);
        }

        public JMenuItem getMenuPresenter() {
            return new Actions.MenuItem((Action)this, true);
        }

        public JMenuItem getPopupPresenter() {
            Actions.MenuItem menuItem = new Actions.MenuItem((Action)this, false);
            Object object = SystemAction.get(CustomizeAction.class);
            if (this.lookup != null) {
                object = ((ContextAwareAction)object).createContextAwareInstance(this.lookup);
            }
            if (object.isEnabled()) {
                JInlineMenu jInlineMenu = new JInlineMenu();
                jInlineMenu.setMenuItems(new JMenuItem[]{new Actions.MenuItem((Action)object, false), menuItem});
                return jInlineMenu;
            }
            for (Node node : this.nodes()) {
                for (Node.PropertySet propertySet : node.getPropertySets()) {
                    if (propertySet.getProperties().length <= 0) continue;
                    return menuItem;
                }
            }
            return new JInlineMenu();
        }

        public Component getToolbarPresenter() {
            return new Actions.ToolbarButton((Action)this);
        }
    }
}

