#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoR6m2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::Google::Device',
	'Image::ExifTool::Google::GAudio',
	'Image::ExifTool::Google::GCamera',
	'Image::ExifTool::Google::GContainer',
	'Image::ExifTool::Google::GCreations',
	'Image::ExifTool::Google::GDepth',
	'Image::ExifTool::Google::GFocus',
	'Image::ExifTool::Google::GImage',
	'Image::ExifTool::Google::GPano',
	'Image::ExifTool::Google::GSpherical',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2V0100',
	'Image::ExifTool::Nikon::AFInfo2V0101',
	'Image::ExifTool::Nikon::AFInfo2V0200',
	'Image::ExifTool::Nikon::AFInfo2V0300',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v1',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::AFTargetInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::Olympus::SubjectDetectInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFInfoK3III',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CAFPointInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FaceInfoK3III',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::AudioKeys',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::QuickTime::VideoKeys',
	'Image::ExifTool::Reconyx::HyperFire',
	'Image::ExifTool::Reconyx::HyperFire2',
	'Image::ExifTool::Reconyx::HyperFire4K',
	'Image::ExifTool::Reconyx::MicroFire',
	'Image::ExifTool::Reconyx::UltraFire',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::HDRGainMap',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apdi',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::pdfx',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 115 => 0x69 },
	'about' => { 558 => 'about' },
	'aboutcvterm' => { 548 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 548 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 548 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 548 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 548 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 122 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 564 => 'absPeakAudioFilePath' },
	'academicfield' => { 554 => 'academicField' },
	'acceleration' => { 125 => 0x9404, 541 => 'Acceleration' },
	'accelerationtracking' => { 90 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 448 => 0x3 },
	'accelerometerdata' => { 435 => 'vrot' },
	'accelerometerx' => { 370 => 0x8d },
	'accelerometery' => { 370 => 0x8e },
	'accelerometerz' => { 370 => 0x8c },
	'accessoryserialnumber' => { 370 => 0x54 },
	'accessorytype' => { 370 => 0x53 },
	'acdseeregion' => { 517 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 517 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 517 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 517 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 517 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 517 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 517 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 517 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 517 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 517 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 517 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 517 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 517 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 517 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 517 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 517 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 517 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 517 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 148 => 0x2a },
	'actioninafccont' => { 381 => 0x220 },
	'actionpriority' => { 2 => 0x1d },
	'activearea' => { 125 => 0xc68d },
	'actived-lighting' => { 256 => 0x22, 314 => 0x24 },
	'actived-lightingmode' => { 314 => 0x25 },
	'adaptervoltage' => { 155 => 0x407 },
	'addaspectratioinfo' => { 90 => 0x80e },
	'addiptcinformation' => { 90 => 0x815 },
	'additionalmodelinformation' => { 548 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 90 => 0x80f, 91 => 0x11, 92 => 0x13, 95 => 0x14 },
	'address' => { 178 => 'Address' },
	'adjustmentmode' => { 455 => 0x15 },
	'adlbracketingstep' => { 218 => 0x17 },
	'adlbracketingtype' => { 218 => 0x18 },
	'adobe' => { 126 => 'Adobe' },
	'adultcontentwarning' => { 356 => 'AdultContentWarning', 557 => 'adultContentWarning' },
	'advancedfilter' => { 133 => 0x1201 },
	'advancedraw' => { 316 => 0x76a43203 },
	'advancedscenetype' => { 370 => 0x3d },
	'advisory' => { 562 => 'Advisory' },
	'ae_iso' => { 378 => 0x2, 379 => 0x4, 380 => 0x12 },
	'aeaperture' => { 378 => 0x1, 379 => 0x3, 380 => 0x11 },
	'aeaperturesteps' => { 378 => 0x8, 379 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 90 => 0x104 },
	'aebbracketvalue' => { 82 => 0x11 },
	'aebracketingsteps' => { 218 => 0xf, 219 => 0xf, 296 => 0x174c },
	'aebsequence' => { 90 => 0x105 },
	'aebsequenceautocancel' => { 88 => 0x9, 89 => 0x9, 91 => 0x8, 92 => 0x9, 95 => 0x9, 96 => 0x7 },
	'aebshotcount' => { 90 => 0x106 },
	'aebxv' => { 378 => 0x4, 379 => 0x6 },
	'aeerror' => { 379 => 0x8 },
	'aeexposuretime' => { 378 => 0x0, 379 => 0x2, 380 => 0x10 },
	'aelbutton' => { 201 => 0x45 },
	'aelexposureindicator' => { 201 => 0x51 },
	'aelock' => { 201 => 0x5b, 325 => '4.2', 334 => '4.2', 345 => 0x201, 409 => 0x48, 465 => 0x40, 466 => 0x40, 467 => [0x86,0x286] },
	'aelockbutton' => { 323 => '16.1', 325 => '4.1', 328 => '15.1', 329 => '16.1', 330 => '16.1', 332 => '30.1', 333 => '16.1', 334 => '4.1', 336 => '17.1', 338 => '17.1' },
	'aelockbuttonplusdials' => { 323 => '16.2', 332 => '32.1', 336 => '44.1' },
	'aelockformb-d80' => { 338 => '3.1' },
	'aelockmetermodeafterfocus' => { 90 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 378 => 0x9, 379 => 0x10, 380 => 0x1c },
	'aemaxaperture2' => { 378 => 0xa, 379 => 0x11, 380 => 0x1d },
	'aemeteringmode' => { 378 => 0xc },
	'aemeteringmode2' => { 378 => '13.1' },
	'aemeteringsegments' => { 204 => 0x628, 409 => 0x209 },
	'aemicroadjustment' => { 90 => 0x110 },
	'aeminaperture' => { 378 => 0xb, 379 => 0x12, 380 => 0x1e },
	'aeminexposuretime' => { 378 => 0x5, 379 => 0x13, 380 => 0x1f },
	'aeprogrammode' => { 378 => 0x6 },
	'aeprojectlink' => { 535 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 535 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 535 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 535 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 535 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 535 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 37 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 359 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 378 => 0xd },
	'aexv' => { 378 => 0x3, 379 => 0x5 },
	'af-assistilluminator' => { 339 => 0x1a, 340 => 0x19, 341 => 0x19, 342 => 0x19 },
	'af-cfocusdisplay' => { 340 => 0x234, 341 => 0x234, 342 => 0x24c },
	'af-cpriority' => { 134 => '0.2' },
	'af-cpriorityselection' => { 323 => '1.1', 324 => '1.1', 326 => '1.1', 327 => '1.1', 329 => '0.1', 330 => '0.1', 331 => '0.1', 332 => '1.1', 333 => '0.1', 336 => '1.1', 337 => '1.1', 339 => 0x3, 340 => 0x3, 341 => 0x3, 342 => 0x3 },
	'af-csetting' => { 130 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 130 => '0.2' },
	'af-ctrackingsensitivity' => { 130 => '0.1' },
	'af-czoneareaswitching' => { 130 => '0.3' },
	'af-onbutton' => { 326 => '70.1', 327 => '70.1', 337 => '70.1' },
	'af-onformb-d10' => { 323 => '3.3', 332 => '3.2' },
	'af-onformb-d11' => { 333 => '2.2' },
	'af-onformb-d12' => { 336 => '50.1' },
	'af-onoutoffocusrelease' => { 339 => 0x10, 340 => 0x10, 341 => 0x10, 342 => 0x10 },
	'af-spriority' => { 134 => '0.1' },
	'af-spriorityselection' => { 323 => '1.2', 324 => '1.2', 326 => '1.2', 327 => '1.2', 331 => '0.2', 332 => '1.2', 333 => '0.2', 336 => '1.2', 337 => '1.2', 339 => 0x5, 340 => 0x5, 341 => 0x5, 342 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 323 => '2.1', 324 => '2.1', 326 => '78.3', 327 => '78.3', 332 => '2.1', 336 => '2.1', 337 => '78.3', 339 => 0xf, 340 => 0xf, 341 => 0xf, 342 => 0xf },
	'afadjustment' => { 409 => 0x72, 418 => 0x267 },
	'afandmeteringbuttons' => { 90 => 0x701 },
	'afaperture' => { 249 => 0x5, 250 => 0x5, 254 => 0x5 },
	'afareaheight' => { 210 => 0x1a, 211 => 0x50, 213 => 0x34, 214 => 0x48 },
	'afareaillumination' => { 201 => 0x4b, 334 => '15.3' },
	'afareainitialheight' => { 271 => 0xbeb },
	'afareainitialwidth' => { 271 => 0xbea },
	'afareainitialxposition' => { 271 => 0xbe8 },
	'afareainitialyposition' => { 271 => 0xbe9 },
	'afareamode' => { 132 => '0.3', 197 => 0x33, 201 => 0xe, 209 => 0x0, 210 => 0x5, 211 => 0x5, 212 => 0x5, 213 => 0x5, 214 => 0x5, 260 => 0x340, 262 => 0x224, 265 => 0x210, 266 => 0x224, 267 => 0x224, 370 => 0xf, 445 => 0x1205, 458 => [0xa,0x3a], 465 => 0x11, 466 => 0x10, 467 => 0x24, 479 => 0xb043, 505 => 0x17 },
	'afareamodesetting' => { 325 => '11.1', 328 => '0.1', 334 => '16.1', 338 => '2.1', 479 => 0x201c },
	'afareapointsize' => { 132 => '0.4' },
	'afareas' => { 345 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 90 => 0x51b },
	'afareasize' => { 370 => 0xde },
	'afareawidth' => { 210 => 0x18, 211 => 0x4e, 213 => 0x32, 214 => 0x46 },
	'afareaxposition' => { 210 => 0x14, 211 => 0x4a, 213 => 0x2e, 214 => 0x42, 445 => 0x1203 },
	'afareaxposition1' => { 445 => 0x1201 },
	'afareayposition' => { 210 => 0x16, 211 => 0x4c, 213 => 0x30, 214 => 0x44, 445 => 0x1204 },
	'afareayposition1' => { 445 => 0x1202 },
	'afareazonesize' => { 132 => '0.5' },
	'afassist' => { 88 => 0x5, 96 => 0x5, 201 => 0x48, 323 => '2.5', 325 => '0.2', 328 => '0.2', 329 => '1.1', 330 => '1.1', 331 => '1.3', 332 => '2.4', 333 => '1.3', 334 => '0.2', 336 => '2.4', 338 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 90 => 0x50e, 91 => 0x4, 92 => 0x5, 93 => 0x4, 94 => 0x4, 95 => 0x5 },
	'afassistlamp' => { 370 => 0x31 },
	'afbuttonpressed' => { 467 => [0x83,0x283] },
	'afchold' => { 381 => 0x221 },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afcoordinatesavailable' => { 213 => 0x7, 214 => 0x7 },
	'afcpointtracking' => { 381 => '545.1' },
	'afcsensitivity' => { 381 => '545.2' },
	'afdefocus' => { 381 => 0x6 },
	'afdetectionmethod' => { 210 => 0x4, 211 => 0x4, 213 => 0x4, 214 => 0x4 },
	'afduringliveview' => { 90 => 0x511 },
	'affinea' => { 527 => 'AffineA' },
	'affineb' => { 527 => 'AffineB' },
	'affinec' => { 527 => 'AffineC' },
	'affined' => { 527 => 'AffineD' },
	'affinetune' => { 215 => 0x0, 263 => 0x6b0, 264 => 0x6c0, 265 => 0x5b0, 266 => 0x5e0, 267 => 0x5f8, 345 => 0x306 },
	'affinetuneadj' => { 215 => 0x2, 289 => 0x2d1, 290 => 0x2dc, 345 => 0x307 },
	'affinetuneadjtele' => { 215 => 0x3 },
	'affinetuneindex' => { 215 => 0x1 },
	'affinex' => { 527 => 'AffineX' },
	'affiney' => { 527 => 'AffineY' },
	'affocusarea' => { 344 => 0x2 },
	'afframesize' => { 344 => 0x0 },
	'afhold' => { 381 => 0x1fd },
	'afilluminator' => { 465 => 0x29, 479 => 0xb044 },
	'afimageheight' => { 210 => 0x12, 211 => 0x48, 213 => 0x2c, 214 => 0x40 },
	'afimagewidth' => { 210 => 0x10, 211 => 0x46, 213 => 0x2a, 214 => 0x3e },
	'afinfo' => { 382 => 0x0 },
	'afintegrationtime' => { 381 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 458 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 462 => 0x131 },
	'afmicroadjregisteredlenses' => { 462 => '305.1' },
	'afmicroadjustment' => { 90 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 462 => 0x130 },
	'afmode' => { 119 => 0x3009, 133 => 0x1022, 197 => 0x16, 382 => '0.1', 455 => 0x5 },
	'afmoderestrictions' => { 324 => '50.3', 326 => '48.3', 327 => '48.3', 336 => '48.3', 337 => '48.3' },
	'afonaelockbuttonswitch' => { 90 => 0x702 },
	'afonbutton' => { 323 => '3.1', 324 => '47.1', 339 => 0x87, 340 => 0x83, 341 => 0x83, 342 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 37 => 0x13, 118 => 0x18, 197 => 0x15, 209 => 0x1, 348 => 0x308, 455 => 0x1f, 458 => [0x37,0x7], 462 => 0x19, 463 => 0x18, 464 => [0x18,0x20] },
	'afpointactivationarea' => { 89 => 0x11, 95 => 0x11 },
	'afpointareaexpansion' => { 90 => 0x508 },
	'afpointatshutterrelease' => { 458 => [0x39,0x9] },
	'afpointautoselection' => { 90 => 0x50b },
	'afpointbrightness' => { 90 => 0x50d, 323 => '2.4', 324 => '46.5', 326 => '2.2', 327 => '2.2', 336 => '2.3', 337 => '2.2' },
	'afpointdetails' => { 348 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 90 => 0x50c },
	'afpointillumination' => { 89 => 0xa, 323 => '2.3', 324 => '46.2', 326 => '47.2', 327 => '47.2', 331 => '1.2', 332 => '2.3', 333 => '1.2', 336 => '47.2', 337 => '47.2', 338 => '2.4' },
	'afpointinfocus' => { 458 => [0x38,0x8] },
	'afpointmode' => { 388 => 0x3 },
	'afpointposition' => { 119 => 0x2021, 370 => 0x4d },
	'afpointregistration' => { 88 => 0x7 },
	'afpoints' => { 200 => 0x10 },
	'afpointsel' => { 339 => 0xb, 340 => 0xb, 341 => 0xb, 342 => 0xb },
	'afpointselected' => { 201 => 0xd, 345 => 0x305, 409 => 0xe, 462 => 0x15, 463 => 0x14, 464 => [0x14,0x1c], 479 => 0x201e },
	'afpointselected2' => { 388 => 0x4 },
	'afpointselection' => { 89 => 0xb, 323 => '1.3', 324 => '1.3', 332 => '1.3', 336 => '1.3', 337 => '1.3' },
	'afpointselectionmethod' => { 90 => 0x50f, 91 => 0xc, 92 => 0xd, 95 => 0xd },
	'afpointsetting' => { 465 => 0x12, 466 => 0x11 },
	'afpointsinfocus' => { 82 => 0xe, 209 => 0x2, 211 => 0x30, 381 => 0xb, 409 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 89 => 0xd },
	'afpointsselected' => { 210 => 0x1c, 211 => 0x1c, 381 => 0x12a, 514 => 0x4 },
	'afpointsunknown' => { 381 => 0x18f },
	'afpointsunknown1' => { 381 => 0x0 },
	'afpointsunknown2' => { 381 => 0x2 },
	'afpointsused' => { 210 => 0x8, 211 => [0x1c,0x8], 212 => 0x8, 213 => 0xa, 214 => 0xa, 458 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpointvalues' => { 381 => 0x14 },
	'afpredictor' => { 381 => 0x4 },
	'afresponse' => { 256 => 0xad },
	'afresult' => { 350 => 0x1038 },
	'afsearch' => { 345 => 0x303 },
	'afselectedarea' => { 344 => 0x6 },
	'afselectionmode' => { 382 => 0x1 },
	'afsensoractive' => { 197 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 445 => 0x1200 },
	'afstatus_00_b4' => { 461 => 0x0 },
	'afstatus_01_c4' => { 461 => 0x2 },
	'afstatus_02_d4' => { 461 => 0x4 },
	'afstatus_03_e4' => { 461 => 0x6 },
	'afstatus_04_f4' => { 461 => 0x8 },
	'afstatus_05_g4' => { 461 => 0xa },
	'afstatus_06_h4' => { 461 => 0xc },
	'afstatus_07_b3' => { 461 => 0xe },
	'afstatus_08_c3' => { 461 => 0x10 },
	'afstatus_09_d3' => { 461 => 0x12 },
	'afstatus_10_e3' => { 461 => 0x14 },
	'afstatus_11_f3' => { 461 => 0x16 },
	'afstatus_12_g3' => { 461 => 0x18 },
	'afstatus_13_h3' => { 461 => 0x1a },
	'afstatus_14_b2' => { 461 => 0x1c },
	'afstatus_15_c2' => { 461 => 0x1e },
	'afstatus_16_d2' => { 461 => 0x20 },
	'afstatus_17_e2' => { 461 => 0x22 },
	'afstatus_18_f2' => { 461 => 0x24 },
	'afstatus_19_g2' => { 461 => 0x26 },
	'afstatus_20_h2' => { 461 => 0x28 },
	'afstatus_21_c1' => { 461 => 0x2a },
	'afstatus_22_d1' => { 461 => 0x2c },
	'afstatus_23_e1' => { 461 => 0x2e },
	'afstatus_24_f1' => { 461 => 0x30 },
	'afstatus_25_g1' => { 461 => 0x32 },
	'afstatus_26_a7_vertical' => { 461 => 0x34 },
	'afstatus_27_a6_vertical' => { 461 => 0x36 },
	'afstatus_28_a5_vertical' => { 461 => 0x38 },
	'afstatus_29_c7_vertical' => { 461 => 0x3a },
	'afstatus_30_c6_vertical' => { 461 => 0x3c },
	'afstatus_31_c5_vertical' => { 461 => 0x3e },
	'afstatus_32_e7_vertical' => { 461 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 461 => 0x42 },
	'afstatus_34_e5_vertical' => { 461 => 0x44 },
	'afstatus_35_g7_vertical' => { 461 => 0x46 },
	'afstatus_36_g6_vertical' => { 461 => 0x48 },
	'afstatus_37_g5_vertical' => { 461 => 0x4a },
	'afstatus_38_i7_vertical' => { 461 => 0x4c },
	'afstatus_39_i6_vertical' => { 461 => 0x4e },
	'afstatus_40_i5_vertical' => { 461 => 0x50 },
	'afstatus_41_a7' => { 461 => 0x52 },
	'afstatus_42_b7' => { 461 => 0x54 },
	'afstatus_43_c7' => { 461 => 0x56 },
	'afstatus_44_d7' => { 461 => 0x58 },
	'afstatus_45_e7' => { 461 => 0x5a },
	'afstatus_46_f7' => { 461 => 0x5c },
	'afstatus_47_g7' => { 461 => 0x5e },
	'afstatus_48_h7' => { 461 => 0x60 },
	'afstatus_49_i7' => { 461 => 0x62 },
	'afstatus_50_a6' => { 461 => 0x64 },
	'afstatus_51_b6' => { 461 => 0x66 },
	'afstatus_52_c6' => { 461 => 0x68 },
	'afstatus_53_d6' => { 461 => 0x6a },
	'afstatus_54_e6_center' => { 461 => 0x6c },
	'afstatus_55_f6' => { 461 => 0x6e },
	'afstatus_56_g6' => { 461 => 0x70 },
	'afstatus_57_h6' => { 461 => 0x72 },
	'afstatus_58_i6' => { 461 => 0x74 },
	'afstatus_59_a5' => { 461 => 0x76 },
	'afstatus_60_b5' => { 461 => 0x78 },
	'afstatus_61_c5' => { 461 => 0x7a },
	'afstatus_62_d5' => { 461 => 0x7c },
	'afstatus_63_e5' => { 461 => 0x7e },
	'afstatus_64_f5' => { 461 => 0x80 },
	'afstatus_65_g5' => { 461 => 0x82 },
	'afstatus_66_h5' => { 461 => 0x84 },
	'afstatus_67_i5' => { 461 => 0x86 },
	'afstatus_68_c11' => { 461 => 0x88 },
	'afstatus_69_d11' => { 461 => 0x8a },
	'afstatus_70_e11' => { 461 => 0x8c },
	'afstatus_71_f11' => { 461 => 0x8e },
	'afstatus_72_g11' => { 461 => 0x90 },
	'afstatus_73_b10' => { 461 => 0x92 },
	'afstatus_74_c10' => { 461 => 0x94 },
	'afstatus_75_d10' => { 461 => 0x96 },
	'afstatus_76_e10' => { 461 => 0x98 },
	'afstatus_77_f10' => { 461 => 0x9a },
	'afstatus_78_g10' => { 461 => 0x9c },
	'afstatus_79_h10' => { 461 => 0x9e },
	'afstatus_80_b9' => { 461 => 0xa0 },
	'afstatus_81_c9' => { 461 => 0xa2 },
	'afstatus_82_d9' => { 461 => 0xa4 },
	'afstatus_83_e9' => { 461 => 0xa6 },
	'afstatus_84_f9' => { 461 => 0xa8 },
	'afstatus_85_g9' => { 461 => 0xaa },
	'afstatus_86_h9' => { 461 => 0xac },
	'afstatus_87_b8' => { 461 => 0xae },
	'afstatus_88_c8' => { 461 => 0xb0 },
	'afstatus_89_d8' => { 461 => 0xb2 },
	'afstatus_90_e8' => { 461 => 0xb4 },
	'afstatus_91_f8' => { 461 => 0xb6 },
	'afstatus_92_g8' => { 461 => 0xb8 },
	'afstatus_93_h8' => { 461 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 461 => 0xbc },
	'afstatusactivesensor' => { 197 => 0x2, 458 => [0x4,0x3b], 462 => 0x1e, 463 => 0x1b, 464 => [0x1b,0x21] },
	'afstatusbottom' => { 197 => 0x8, 462 => 0x2a, 463 => 0x21, 464 => 0x21 },
	'afstatusbottom-left' => { 197 => 0x12, 463 => 0x2b, 464 => 0x2b },
	'afstatusbottom-right' => { 197 => 0x6, 463 => 0x1f, 464 => 0x1f },
	'afstatusbottomassist-left' => { 462 => 0x28 },
	'afstatusbottomassist-right' => { 462 => 0x2c },
	'afstatusbottomhorizontal' => { 459 => 0x10, 460 => 0x1c },
	'afstatusbottomvertical' => { 459 => 0x16, 460 => 0x26 },
	'afstatuscenter-10' => { 462 => 0x34 },
	'afstatuscenter-11' => { 462 => 0x36 },
	'afstatuscenter-12' => { 462 => 0x38 },
	'afstatuscenter-14' => { 462 => 0x3c },
	'afstatuscenter-7' => { 462 => 0x2e },
	'afstatuscenter-9' => { 462 => 0x32 },
	'afstatuscenter-horizontal' => { 462 => 0x30 },
	'afstatuscenter-vertical' => { 462 => 0x3a },
	'afstatuscenterf2-8' => { 462 => 0x4c },
	'afstatuscenterhorizontal' => { 197 => 0x2f, 459 => 0xc, 460 => 0x18, 463 => 0x2f, 464 => 0x2f },
	'afstatuscentervertical' => { 197 => 0xc, 459 => 0x14, 460 => 0x22, 463 => 0x25, 464 => 0x25 },
	'afstatusfarleft' => { 459 => 0x6, 462 => 0x26 },
	'afstatusfarlefthorizontal' => { 460 => 0x4 },
	'afstatusfarleftvertical' => { 460 => 0x12 },
	'afstatusfarright' => { 459 => 0x18, 462 => 0x44 },
	'afstatusfarrighthorizontal' => { 460 => 0x2c },
	'afstatusfarrightvertical' => { 460 => 0x34 },
	'afstatusleft' => { 197 => 0x2d, 459 => 0x2, 462 => 0x22, 463 => 0x2d, 464 => 0x2d },
	'afstatuslefthorizontal' => { 460 => 0x6 },
	'afstatusleftvertical' => { 460 => 0xe },
	'afstatuslower-left' => { 459 => 0x4, 462 => 0x24 },
	'afstatuslower-lefthorizontal' => { 460 => 0xa },
	'afstatuslower-leftvertical' => { 460 => 0x10 },
	'afstatuslower-middle' => { 459 => 0x22, 460 => 0x24 },
	'afstatuslower-right' => { 459 => 0x1e, 462 => 0x4a },
	'afstatuslower-righthorizontal' => { 460 => 0x32 },
	'afstatuslower-rightvertical' => { 460 => 0x3a },
	'afstatuslowerfarleft' => { 460 => 0x8 },
	'afstatuslowerfarright' => { 460 => 0x30 },
	'afstatusmiddlehorizontal' => { 197 => 0xa, 463 => 0x23, 464 => 0x23 },
	'afstatusnearleft' => { 459 => 0xe, 460 => 0x1a },
	'afstatusnearright' => { 459 => 0xa, 460 => 0x16 },
	'afstatusright' => { 197 => 0x31, 459 => 0x1c, 462 => 0x48, 463 => 0x31, 464 => 0x31 },
	'afstatusrighthorizontal' => { 460 => 0x2e },
	'afstatusrightvertical' => { 460 => 0x38 },
	'afstatustop' => { 197 => 0xe, 462 => 0x40, 463 => 0x27, 464 => 0x27 },
	'afstatustop-left' => { 197 => 0x10, 463 => 0x29, 464 => 0x29 },
	'afstatustop-right' => { 197 => 0x4, 463 => 0x1d, 464 => 0x1d },
	'afstatustopassist-left' => { 462 => 0x3e },
	'afstatustopassist-right' => { 462 => 0x42 },
	'afstatustophorizontal' => { 459 => 0x8, 460 => 0x14 },
	'afstatustopvertical' => { 459 => 0x12, 460 => 0x1e },
	'afstatusupper-left' => { 459 => 0x0, 462 => 0x20 },
	'afstatusupper-lefthorizontal' => { 460 => 0x2 },
	'afstatusupper-leftvertical' => { 460 => 0xc },
	'afstatusupper-middle' => { 459 => 0x20, 460 => 0x20 },
	'afstatusupper-right' => { 459 => 0x1a, 462 => 0x46 },
	'afstatusupper-righthorizontal' => { 460 => 0x2a },
	'afstatusupper-rightvertical' => { 460 => 0x36 },
	'afstatusupperfarleft' => { 460 => 0x0 },
	'afstatusupperfarright' => { 460 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'afsubjectdetection' => { 370 => 0xe9 },
	'aftargetinfo' => { 345 => 0x30a },
	'aftracking' => { 479 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 458 => 0x2 },
	'afwithshutter' => { 465 => 0x2a },
	'aggregateissuenumber' => { 554 => 'aggregateIssueNumber' },
	'aggregationtype' => { 554 => 'aggregationType' },
	'agreement' => { 557 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 155 => 0xe4e },
	'airplanemode' => { 260 => 0x9c0, 263 => 0x722, 264 => 0x782, 265 => 0x624, 266 => 0x654, 267 => 0x6bc },
	'aiservocontinuousshooting' => { 89 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 90 => 0x519 },
	'aiservoimagepriority' => { 90 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 90 => 0x51a },
	'aiservotrackingmethod' => { 90 => 0x504 },
	'aiservotrackingsensitivity' => { 89 => 0x14, 90 => 0x502 },
	'aisubjecttrackingmode' => { 345 => 0x309 },
	'album' => { 427 => ['albm',"\xa9alb"], 429 => 'album', 435 => ['albm',"\xa9alb"], 564 => 'album' },
	'albumartist' => { 196 => 'WM/AlbumArtist', 427 => 'aART', 435 => 'albr' },
	'albumcoverurl' => { 196 => 'WM/AlbumCoverURL' },
	'albumid' => { 427 => 'plID' },
	'albumtitle' => { 196 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 534 => 'AlreadyApplied', 536 => 'AlreadyApplied' },
	'alternatetitle' => { 554 => 'alternateTitle' },
	'alternatetitlea-lang' => { 554 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 554 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 554 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 217 => 0x6 },
	'alttapename' => { 564 => 'altTapeName' },
	'alttextaccessibility' => { 547 => 'AltTextAccessibility' },
	'alttimecode' => { 564 => 'altTimecode' },
	'alttimecodetimeformat' => { 564 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 564 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 564 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 438 => 0x5c, 440 => 0x6c },
	'ambientlight' => { 438 => 0x5e, 439 => 0x45, 440 => 0x6e },
	'ambienttemperature' => { 125 => 0x9400, 437 => 0x14, 438 => 0x50, 439 => 0x3a, 440 => 0x60, 441 => 0x46, 505 => 0x4, 541 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 437 => 0x13, 438 => 0x4e, 439 => 0x38, 440 => 0x5e, 441 => 0x44 },
	'analogbalance' => { 125 => 0xc627 },
	'analogcaptureiso' => { 155 => 0x89e },
	'analogisotable' => { 155 => 0x89d },
	'androidcapturefps' => { 429 => 'com.android.capture.fps' },
	'androidmake' => { 429 => 'com.android.manufacturer' },
	'androidmodel' => { 429 => 'com.android.model' },
	'androidversion' => { 429 => 'com.android.version' },
	'angleadj' => { 109 => 0x10003, 115 => 0x8b },
	'angleinforoll' => { 530 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 530 => 'AngleInfoYaw' },
	'anti-blur' => { 479 => 0xb04b },
	'antialiasstrength' => { 125 => 0xc632 },
	'antiflicker' => { 61 => 0x20 },
	'antishockwaitingtime' => { 348 => 0x2100 },
	'aperturelock' => { 324 => '38.2', 326 => '38.2', 327 => '38.2', 336 => '38.2', 337 => '38.2', 339 => 0xbc, 340 => 0xb8, 341 => 0xb8, 342 => 0xb8 },
	'aperturemode' => { 435 => 'apmd' },
	'aperturerange' => { 90 => 0x10d },
	'apertureringuse' => { 388 => '1.4' },
	'aperturesetting' => { 201 => 0x7, 465 => 0x30, 466 => 0x29, 467 => 0x1 },
	'aperturevalue' => { 99 => 0x2, 125 => 0x9202, 350 => 0x1002, 418 => 0x401, 540 => 'ApertureValue' },
	'appinfo' => { 138 => 'AppInfo' },
	'appinfoapplication' => { 138 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 138 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 138 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'apple_0x0054' => { 1 => 0x54 },
	'apple_0x005a' => { 1 => 0x5a },
	'applekeywords' => { 355 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 429 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 427 => 'apID' },
	'applestoreaccounttype' => { 427 => 'akID' },
	'applestorecatalogid' => { 427 => 'cnID' },
	'applestorecountry' => { 427 => 'sfID' },
	'applicationkeystring' => { 155 => 0x400 },
	'applicationnotes' => { 125 => 0x2bc, 375 => 0x2bc },
	'applicationrecordversion' => { 148 => 0x0 },
	'applyautomatically' => { 360 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 90 => 0x10e },
	'approved' => { 542 => 'Approved' },
	'approvedby' => { 542 => 'ApprovedBy' },
	'approximatefnumber' => { 365 => 0x313, 372 => 0x3406 },
	'approximatefocusdistance' => { 531 => 'ApproximateFocusDistance' },
	'appversion' => { 546 => 'AppVersion' },
	'aps-csizecapture' => { 498 => 0x114, 499 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 109 => 0x20914 },
	'armidentifier' => { 149 => 0x78 },
	'armversion' => { 149 => 0x7a },
	'arranger' => { 427 => "\xa9arg", 435 => "\xa9arg" },
	'arrangerkeywords' => { 435 => "\xa9ark" },
	'artdirector' => { 427 => "\xa9ard" },
	'artfilter' => { 345 => 0x529 },
	'artfiltereffect' => { 345 => 0x52f },
	'artist' => { 125 => 0x13b, 359 => 'Artist', 375 => 0x13b, 409 => 0x22e, 427 => "\xa9ART", 429 => 'artist', 435 => "\xa9ART", 560 => 'Artist', 564 => 'artist' },
	'artistid' => { 427 => 'atID' },
	'artmode' => { 119 => 0x301b },
	'artmodeparameters' => { 119 => 0x310b },
	'artwork' => { 429 => 'artwork' },
	'artworkcircadatecreated' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 548 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 548 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 349 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 349 => 0x1112, 409 => 0x80, 465 => 0x55, 466 => 0x55, 467 => 0xa, 492 => [0x192c,0x1a88], 493 => 0x192c, 494 => 0x1958, 495 => 0x192c, 496 => 0x188c },
	'assetid' => { 522 => 'AssetID' },
	'asshoticcprofile' => { 125 => 0xc68f },
	'asshotneutral' => { 125 => 0xc628 },
	'asshotpreprofilematrix' => { 125 => 0xc690 },
	'asshotprofilename' => { 125 => 0xc6f6 },
	'asshotwhitexy' => { 125 => 0xc629 },
	'assignbktbutton' => { 323 => '4.2', 324 => '16.1', 326 => '16.1', 327 => '16.1', 336 => '16.1', 337 => '16.1' },
	'assignfuncbutton' => { 90 => 0x70b },
	'assignmb-d17af-onbutton' => { 327 => '79.1' },
	'assignmb-d17funcbutton' => { 327 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 327 => '68.1' },
	'assignmb-d18af-onbutton' => { 337 => '79.1' },
	'assignmb-d18funcbutton' => { 337 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 337 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 326 => '75.1', 327 => '75.1', 337 => '75.1' },
	'assignmoviefunc2button' => { 326 => '82.1', 327 => '82.1', 337 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 326 => '75.2', 327 => '75.2', 337 => '75.2' },
	'assignmovierecordbutton' => { 324 => '43.2', 336 => '45.1', 339 => 0x9f, 340 => 0x9b, 341 => 0x9b, 342 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 326 => '45.1', 327 => '45.1', 337 => '45.1' },
	'assignmoviesubselector' => { 326 => '74.1', 327 => '74.1', 337 => '74.1' },
	'assignmoviesubselectorplusdials' => { 326 => '76.1', 327 => '76.1', 337 => '76.1' },
	'assignremotefnbutton' => { 324 => '54.1', 336 => '51.1' },
	'assistbuttonfunction' => { 88 => 0xd },
	'atcaptureusercrop' => { 155 => 0x943 },
	'attributionname' => { 532 => 'attributionName' },
	'attributionurl' => { 532 => 'attributionURL' },
	'audio' => { 370 => 0x20 },
	'audiobitrate' => { 72 => 0x6c, 548 => 'audioBitRate' },
	'audiobitratemode' => { 548 => 'audioBitRateMode' },
	'audiobitspersample' => { 548 => 'audioBitsPerSample' },
	'audiobutton' => { 341 => 0x17b, 342 => 0x193 },
	'audiobuttonplaybackmode' => { 341 => 0x1b9, 342 => 0x1d1 },
	'audiochannelcount' => { 548 => 'audioChannelCount' },
	'audiochannels' => { 72 => 0x70 },
	'audiochanneltype' => { 564 => 'audioChannelType' },
	'audiocompression' => { 90 => 0x816, 172 => 'Compression' },
	'audiocompressor' => { 564 => 'audioCompressor' },
	'audiodata' => { 139 => 'Data' },
	'audioduration' => { 148 => 0x99 },
	'audiogain' => { 426 => 'player.movie.audio.gain', 429 => 'player.movie.audio.gain' },
	'audiomimetype' => { 139 => 'Mime' },
	'audiomoddate' => { 564 => 'audioModDate' },
	'audiooutcue' => { 148 => 0x9a },
	'audiosamplerate' => { 72 => 0x6e, 564 => 'audioSampleRate' },
	'audiosampletype' => { 564 => 'audioSampleType' },
	'audiosamplingrate' => { 148 => 0x97 },
	'audiosamplingresolution' => { 148 => 0x98 },
	'audiotype' => { 148 => 0x96 },
	'author' => { 174 => 'Author', 355 => 'Author', 359 => 'Author', 425 => 'Author', 427 => ['auth',"\xa9aut"], 429 => 'author', 435 => 'auth', 528 => 'author', 550 => 'Author', 562 => 'Author' },
	'authorsposition' => { 552 => 'AuthorsPosition' },
	'authorurl' => { 196 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 90 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 399 => '0.1' },
	'autobracket' => { 455 => 0x19 },
	'autobracketing' => { 133 => 0x1100, 409 => 0x18, 445 => 0x1007 },
	'autobracketingmode' => { 335 => '12.3' },
	'autobracketingset' => { 335 => '12.1' },
	'autobracketmodem' => { 323 => '21.2', 324 => '13.3', 326 => '13.2', 327 => '13.2', 332 => '26.2', 336 => '13.3', 337 => '13.2', 339 => 0x63, 340 => 0x5f, 341 => 0x5f, 342 => 0x5f },
	'autobracketorder' => { 201 => 0x43, 323 => '21.3', 324 => '13.2', 326 => '13.1', 327 => '13.1', 332 => '26.3', 333 => '12.2', 334 => '2.2', 335 => '12.2', 336 => '13.2', 337 => '13.1', 338 => '13.2', 339 => 0x65, 340 => 0x61, 341 => 0x61, 342 => 0x61 },
	'autobracketset' => { 323 => '21.1', 324 => '13.1', 328 => '11.1', 329 => '12.1', 330 => '12.1', 332 => '26.1', 333 => '12.1', 334 => '2.1', 336 => '13.1', 338 => '13.1' },
	'autobrightness' => { 534 => 'AutoBrightness', 536 => 'AutoBrightness' },
	'autocapturecriteria' => { 216 => 0x1 },
	'autocapturecriteriamotiondirection' => { 216 => 0x5f },
	'autocapturecriteriamotionsize' => { 216 => 0x64 },
	'autocapturecriteriamotionspeed' => { 216 => 0x63 },
	'autocapturecriteriasubjectsize' => { 216 => 0x69 },
	'autocapturecriteriasubjecttype' => { 216 => 0x6a },
	'autocapturedframe' => { 216 => 0x0 },
	'autocapturedistancefar' => { 216 => 0x4a },
	'autocapturedistancenear' => { 216 => 0x4e },
	'autocapturepreset' => { 267 => 0x746 },
	'autocapturerecordingtime' => { 216 => 0x37 },
	'autocapturewaittime' => { 216 => 0x38 },
	'autocontrast' => { 534 => 'AutoContrast', 536 => 'AutoContrast' },
	'autodistortioncontrol' => { 230 => 0x4, 260 => 0x2cf, 261 => 0x143 },
	'autodynamicrange' => { 133 => 0x140b },
	'autoexposure' => { 534 => 'AutoExposure', 536 => 'AutoExposure' },
	'autoexposurebracketing' => { 82 => 0x10 },
	'autoflashisosensitivity' => { 326 => '38.5', 327 => '38.5', 337 => '38.5', 339 => 0x5f, 340 => 0x5b, 341 => 0x5b, 342 => 0x5b },
	'autofocus' => { 348 => 0x209 },
	'autofocusmoderestrictions' => { 340 => 0x107, 341 => 0x107, 342 => 0x11d },
	'autofp' => { 334 => '7.3', 338 => '31.4' },
	'autoiso' => { 82 => 0x1, 119 => 0x3008, 260 => 0x288, 262 => 0x152, 265 => 0x142, 266 => 0x156, 267 => 0x156, 325 => '1.1', 334 => '1.1' },
	'autoisomax' => { 325 => '1.2', 334 => '1.2' },
	'autoisominshutterspeed' => { 325 => '1.3', 334 => '1.3' },
	'autolateralca' => { 534 => 'AutoLateralCA', 536 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 67 => 0x2, 90 => 0x204, 109 => 0x20500, 115 => 0x6f },
	'autolightingoptimizeron' => { 109 => '0x20500.0', 115 => 0x6e },
	'autoportraitframed' => { 479 => 0x2016 },
	'autoredeye' => { 316 => 0xfe28a44f },
	'autorotate' => { 82 => 0x1b },
	'autoshadows' => { 534 => 'AutoShadows', 536 => 'AutoShadows' },
	'autotone' => { 534 => 'AutoTone', 536 => 'AutoTone' },
	'autotonedigest' => { 534 => 'AutoToneDigest', 536 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 534 => 'AutoToneDigestNoSat', 536 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 534 => 'AutoWhiteVersion', 536 => 'AutoWhiteVersion' },
	'auxiliaryimagetype' => { 529 => 'AuxiliaryImageType' },
	'auxiliarylens' => { 256 => 0x82 },
	'avaperturesetting' => { 388 => 0x13 },
	'averageblacklevel' => { 49 => 0xe7, 51 => 0xfb, 52 => 0x114, 53 => 0x146 },
	'averagelv' => { 204 => 0x38 },
	'avsettingwithoutlens' => { 90 => 0x707 },
	'azimuth' => { 182 => 'Azimuth' },
	'babyage' => { 370 => [0x8010,0x33] },
	'babyname' => { 370 => 0x66 },
	'backgroundalpha' => { 559 => 'bgalpha' },
	'balance' => { 426 => 'player.movie.audio.balance', 429 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 388 => 0x15 },
	'baseiso' => { 82 => 0x2, 103 => 0x101c, 155 => 0x903, 372 => 0x312a, 511 => 0x6 },
	'baseisodaylight' => { 155 => 0x910 },
	'baseisoflash' => { 155 => 0x913 },
	'baseisofluorescent' => { 155 => 0x912 },
	'baseisotungsten' => { 155 => 0x911 },
	'baselineexposure' => { 125 => 0xc62a },
	'baselineexposureoffset' => { 125 => 0xc7a5 },
	'baselinenoise' => { 125 => 0xc62b },
	'baselinesharpness' => { 125 => 0xc62c },
	'baserenditionishdr' => { 545 => 'BaseRenditionIsHDR' },
	'baseurl' => { 562 => 'BaseURL' },
	'bass' => { 426 => 'player.movie.audio.bass', 429 => 'player.movie.audio.bass' },
	'batterylevel' => { 370 => 0x38, 465 => 0x51, 469 => 0xc, 470 => 0x4, 471 => 0x4, 512 => 0x7, 513 => 0x5 },
	'batterylevel2' => { 513 => 0x7 },
	'batterylevelgrip1' => { 512 => 0x6 },
	'batterylevelgrip2' => { 512 => 0x8 },
	'batteryorder' => { 323 => '12.5', 332 => '13.2', 333 => '2.1', 336 => '3.1' },
	'batterystate' => { 201 => 0x60, 465 => 0x50, 471 => 0x14 },
	'batterytemperature' => { 469 => 0x1, 471 => 0x2, 512 => 0x5 },
	'batterytype' => { 69 => 0x38, 438 => 0x66, 439 => 0x4f, 440 => 0x74 },
	'batteryunknown' => { 469 => 0x2, 471 => 0x0 },
	'batteryvoltage' => { 155 => 0x408, 437 => 0x2a, 438 => 0x62, 439 => 0x4b, 440 => 0x72, 441 => 0x49, 469 => 0x8 },
	'batteryvoltage1' => { 471 => 0x6 },
	'batteryvoltage2' => { 471 => 0x8 },
	'batteryvoltageavg' => { 438 => 0x64, 439 => 0x4d },
	'bayergreensplit' => { 125 => 0xc62d },
	'bayerpattern' => { 154 => 0xf902, 205 => 0x17 },
	'beatsperminute' => { 427 => 'tmpo' },
	'beatspliceparams' => { 564 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 564 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 564 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 564 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 564 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 564 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 323 => '13.1', 324 => '5.4', 325 => '0.1', 328 => '2.1', 329 => '3.1', 330 => '3.1', 332 => '10.1', 334 => '0.1', 336 => '5.5', 338 => '4.1' },
	'beeppitch' => { 333 => '3.1' },
	'beepvolume' => { 333 => '4.5' },
	'bestqualityscale' => { 125 => 0xc65c },
	'bestshotmode' => { 119 => 0x3007 },
	'bitdepth' => { 179 => 'BitDepth', 205 => 0x11, 282 => 0x41 },
	'bitspercomponent' => { 150 => 0x87 },
	'bitspersample' => { 125 => 0x102, 375 => 0xa, 560 => 'BitsPerSample' },
	'blackacquirerows' => { 155 => 0x18ba },
	'blacklevel' => { 125 => [0x7310,0xc61a], 227 => 0x20, 256 => 0x3d, 350 => [0x401,0x1012], 418 => 0x21d, 486 => [0x7300,0x7310] },
	'blacklevel2' => { 349 => 0x600, 353 => 0x600 },
	'blacklevelblue' => { 375 => 0x1e },
	'blacklevelbottom' => { 155 => 0x3f0 },
	'blackleveldata' => { 418 => 0x223 },
	'blackleveldeltah' => { 125 => 0xc61b },
	'blackleveldeltav' => { 125 => 0xc61c },
	'blacklevelgreen' => { 375 => 0x1d },
	'blacklevelred' => { 375 => 0x1c },
	'blacklevelrepeatdim' => { 125 => 0xc619 },
	'blacklevelrough' => { 155 => 0x40e },
	'blacklevelroughafter' => { 155 => 0x416 },
	'blacklevels' => { 38 => 0x1d },
	'blackleveltop' => { 155 => 0x3ef },
	'blackpoint' => { 409 => 0x200 },
	'blacks2012' => { 534 => 'Blacks2012', 536 => 'Blacks2012' },
	'blacksadj' => { 516 => 0x9018 },
	'bleachbypasstoning' => { 409 => 0x7f },
	'blockshotafresponse' => { 326 => '1.5', 327 => '1.5', 337 => '1.5', 339 => 0x7, 340 => 0x7, 341 => 0x7, 342 => 0x7 },
	'blogtitle' => { 554 => 'blogTitle' },
	'blogurl' => { 554 => 'blogURL' },
	'bluebalance' => { 350 => 0x1018, 375 => 0x12, 409 => 0x1b },
	'bluecurvelimits' => { 114 => 0x1fe },
	'bluecurvepoints' => { 113 => 0x79, 114 => 0x1d4 },
	'bluehsl' => { 109 => 0x20915 },
	'bluehue' => { 534 => 'BlueHue', 536 => 'BlueHue' },
	'bluesaturation' => { 534 => 'BlueSaturation', 536 => 'BlueSaturation' },
	'bluetoothfirmwaredate' => { 440 => 0x3a },
	'bluetoothfirmwareversion' => { 440 => 0x34 },
	'bluratinfinity' => { 144 => 'BlurAtInfinity' },
	'blurcontrol' => { 409 => 0x82 },
	'blurwarning' => { 133 => 0x1300 },
	'bodybatteryadload' => { 385 => 0x3 },
	'bodybatteryadnoload' => { 385 => 0x2 },
	'bodybatterypercent' => { 385 => 0x3 },
	'bodybatterystate' => { 385 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 385 => 0x4 },
	'bodybatteryvoltage1' => { 385 => 0x2 },
	'bodybatteryvoltage2' => { 385 => 0x4 },
	'bodybatteryvoltage3' => { 385 => 0x6 },
	'bodybatteryvoltage4' => { 385 => 0x8 },
	'bodyfirmware' => { 446 => 0x0 },
	'bodyfirmwareversion' => { 346 => 0x104, 347 => 0x100, 350 => 0x104 },
	'bodyserialnumber' => { 446 => 0x10 },
	'bookedition' => { 554 => 'bookEdition' },
	'bootloaderversion' => { 441 => 0x26 },
	'bracketbutton' => { 264 => 0x808, 267 => 0x80c },
	'bracketbuttonplaybackmode' => { 264 => 0x810, 267 => 0x816 },
	'bracketincrement' => { 260 => 0x34a, 262 => 0x22e, 265 => 0x21a, 266 => 0x22e, 267 => 0x22e },
	'bracketmode' => { 61 => 0x3 },
	'bracketprogram' => { 260 => 0x348, 262 => 0x22c, 265 => 0x218, 266 => 0x22c, 267 => 0x22c },
	'bracketsequence' => { 119 => 0x301d },
	'bracketset' => { 260 => 0x346, 262 => 0x22a, 265 => 0x216, 266 => 0x22a, 267 => 0x22a },
	'bracketsettings' => { 370 => 0x45 },
	'bracketshotnumber' => { 61 => 0x5, 388 => 0x9, 476 => 0x2b },
	'bracketshotnumber2' => { 476 => 0x2d },
	'bracketstep' => { 198 => 0xe },
	'bracketvalue' => { 61 => 0x4 },
	'brightness' => { 125 => 0xfe53, 173 => 'Brightness', 193 => 'Brightness', 198 => 0x2c, 274 => 0x34, 275 => 0x39, 276 => 0x41, 429 => 'player.movie.visual.brightness', 437 => 0x25, 438 => 0x54, 439 => 0x3e, 440 => 0x64, 465 => 0x22, 479 => 0x2007, 534 => 'Brightness', 536 => 'Brightness' },
	'brightnessadj' => { 114 => 0x114, 309 => 0x0, 319 => 0x2d, 516 => 0x8018 },
	'brightnessvalue' => { 125 => 0x9203, 204 => [0x691,0x49c3], 350 => 0x1003, 484 => 0x1e, 488 => 0x1140, 489 => 0x1140, 490 => 0x111c, 491 => 0x1198, 492 => 0x1174, 493 => 0x102c, 494 => 0x224, 495 => 0x224, 496 => 0x219, 540 => 'BrightnessValue' },
	'buildnumber' => { 208 => 0x5500 },
	'bulbduration' => { 82 => 0x18 },
	'burstcount' => { 155 => 0x40d },
	'burstgroupid' => { 258 => 0x4 },
	'burstid' => { 140 => 'BurstID' },
	'burstmode' => { 157 => 0xa, 370 => 0x2a },
	'burstmode2' => { 157 => 0x18 },
	'burstprimary' => { 140 => 'BurstPrimary' },
	'burstshot' => { 455 => 0x34 },
	'burstspeed' => { 370 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 90 => 0x70a },
	'bwadjustment' => { 133 => 0x1049 },
	'bwfilter' => { 198 => 0x2a, 206 => 0x39 },
	'bwmagentagreen' => { 133 => 0x104b },
	'bwmode' => { 350 => 0x203 },
	'by-line' => { 148 => 0x50 },
	'by-linetitle' => { 148 => 0x55 },
	'bytecount' => { 554 => 'byteCount' },
	'c14configuration' => { 155 => 0x1964 },
	'cacheversion' => { 125 => 0xc7aa },
	'cafarea' => { 392 => 0x2 },
	'cafgridsize' => { 386 => '1.1' },
	'calibratedfocallength' => { 122 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 122 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 122 => 'CalibratedOpticalCenterY' },
	'calibration' => { 455 => [0x24,0x30] },
	'calibrationhistory' => { 155 => 0x9c9 },
	'calibrationilluminant1' => { 125 => 0xc65a },
	'calibrationilluminant2' => { 125 => 0xc65b },
	'calibrationilluminant3' => { 125 => 0xcd31 },
	'calibrationversion' => { 155 => 0x9c6 },
	'callforimage' => { 522 => 'CallForImage' },
	'camera' => { 138 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 435 => 'angl', 564 => 'cameraAngle' },
	'cameraappinfo' => { 138 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 138 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 138 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 138 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 142 => 'CameraBurstID' },
	'cameracalibration' => { 455 => 0x11f },
	'cameracalibration1' => { 125 => 0xc623 },
	'cameracalibration2' => { 125 => 0xc624 },
	'cameracalibration3' => { 125 => 0xcd32 },
	'cameracalibrationsig' => { 125 => 0xc6f3 },
	'cameracolorcalibration01' => { 39 => 0x0, 40 => 0x0 },
	'cameracolorcalibration02' => { 39 => 0x4, 40 => 0x5 },
	'cameracolorcalibration03' => { 39 => 0x8, 40 => 0xa },
	'cameracolorcalibration04' => { 39 => 0xc, 40 => 0xf },
	'cameracolorcalibration05' => { 39 => 0x10, 40 => 0x14 },
	'cameracolorcalibration06' => { 39 => 0x14, 40 => 0x19 },
	'cameracolorcalibration07' => { 39 => 0x18, 40 => 0x1e },
	'cameracolorcalibration08' => { 39 => 0x1c, 40 => 0x23 },
	'cameracolorcalibration09' => { 39 => 0x20, 40 => 0x28 },
	'cameracolorcalibration10' => { 39 => 0x24, 40 => 0x2d },
	'cameracolorcalibration11' => { 39 => 0x28, 40 => 0x32 },
	'cameracolorcalibration12' => { 39 => 0x2c, 40 => 0x37 },
	'cameracolorcalibration13' => { 39 => 0x30, 40 => 0x3c },
	'cameracolorcalibration14' => { 39 => 0x34, 40 => 0x41 },
	'cameracolorcalibration15' => { 39 => 0x38, 40 => 0x46 },
	'cameradepthmap' => { 138 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 138 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 138 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 138 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 138 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 138 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 138 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 138 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 138 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 138 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 138 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 138 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 429 => 'direction.facing' },
	'camerae-mountversion' => { 515 => 0xb },
	'cameraelevationangle' => { 125 => 0x9405, 541 => 'CameraElevationAngle' },
	'camerafilename' => { 522 => 'CameraFilename' },
	'camerafirmware' => { 125 => 0xa439, 541 => 'CameraFirmware' },
	'cameraid' => { 350 => 0x209, 435 => 'cmid', 454 => 0x209 },
	'cameraidentifier' => { 436 => 'camera.identifier' },
	'cameraimage' => { 138 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 138 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 138 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 138 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 138 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 138 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 138 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 138 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 138 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 138 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 138 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 138 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 138 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 138 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 37 => 0x10 },
	'cameralabel' => { 125 => 0xc7a1, 564 => 'cameraLabel' },
	'cameralightestimate' => { 138 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 138 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 138 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 138 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 138 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 522 => 'CameraMakeModel' },
	'cameramodel' => { 418 => 0x410, 564 => 'cameraModel' },
	'cameramodelid' => { 193 => 'CameraModelID' },
	'cameramodelrestriction' => { 534 => 'CameraModelRestriction', 536 => 'CameraModelRestriction' },
	'cameramotion' => { 429 => 'direction.motion' },
	'cameramove' => { 564 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 370 => 0x8f, 408 => 0x1, 413 => 0x1, 418 => 0x100, 471 => [0x16,0x18], 502 => 0x28, 503 => 0x24, 504 => 0x29 },
	'cameraowner' => { 158 => 0xc353 },
	'cameraparameters' => { 350 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 121 => 0x9, 435 => "\xa9gpt" },
	'camerapointcloud' => { 138 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 138 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 138 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 138 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 138 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 138 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 138 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 138 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 138 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 138 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 138 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 138 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 138 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 534 => 'CameraProfile', 536 => 'CameraProfile' },
	'cameraprofiledigest' => { 534 => 'CameraProfileDigest', 536 => 'CameraProfileDigest' },
	'cameraprofiles' => { 552 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 552 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 552 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 552 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 552 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 552 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 552 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 552 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 552 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 552 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 552 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 552 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 552 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 552 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 552 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 552 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 115 => 0xe1 },
	'camerarawcontrast' => { 115 => 0xe3 },
	'camerarawhighlightpoint' => { 115 => 0xe6 },
	'camerarawlinear' => { 115 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 115 => 0xe8 },
	'camerarawoutputshadowpoint' => { 115 => 0xe9 },
	'camerarawsaturation' => { 115 => 0xe2 },
	'camerarawshadowpoint' => { 115 => 0xe7 },
	'camerarawsharpness' => { 115 => 0xe5 },
	'cameraroll' => { 121 => 0xb, 435 => "\xa9grl" },
	'cameras' => { 138 => 'Cameras' },
	'cameraserialnumber' => { 125 => 0xc62f, 195 => 'CameraSerialNumber', 522 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 345 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 36 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 82 => 0xc, 155 => 0x406, 349 => 0x1306, 365 => 0x320, 372 => 0x3402, 409 => 0x47, 452 => 0x43, 506 => 0x5 },
	'cameratemperature4' => { 414 => 0x14 },
	'cameratemperature5' => { 414 => 0x16 },
	'cameratemperaturerangemax' => { 127 => 0x5 },
	'cameratemperaturerangemin' => { 127 => 0x6 },
	'cameratrait' => { 138 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 82 => 0x1a, 350 => 0x207 },
	'cameratype2' => { 346 => 0x100 },
	'cameravendorinfo' => { 138 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 138 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 138 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 138 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 121 => 0xa, 435 => "\xa9gyw" },
	'camreverse' => { 122 => 'CamReverse' },
	'canondr4' => { 126 => 'CanonDR4' },
	'canonexposuremode' => { 37 => 0x14 },
	'canonfiledescription' => { 103 => 0x805 },
	'canonfilelength' => { 69 => 0xe },
	'canonfirmwareversion' => { 69 => 0x7, 103 => 0x80b },
	'canonflashinfo' => { 103 => 0x1028 },
	'canonflashmode' => { 37 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 37 => 0xa },
	'canonimagetype' => { 69 => 0x6, 103 => 0x815 },
	'canonlogversion' => { 68 => 0xb },
	'canonmodelid' => { 69 => 0x10, 103 => 0x1834 },
	'canonvrd' => { 126 => 'CanonVRD' },
	'caption' => { 528 => 'caption' },
	'caption-abstract' => { 148 => 0x78 },
	'captionsauthornames' => { 539 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 539 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 552 => 'CaptionWriter' },
	'captureframerate' => { 119 => 0x4001 },
	'captureheightnormal' => { 155 => 0x1839 },
	'capturelook' => { 155 => 0xc48 },
	'capturemode' => { 436 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 146 => 'CaptureSoftware' },
	'capturewidthnormal' => { 155 => 0x1838 },
	'capturewidthtest' => { 155 => 0x1842 },
	'cardshutterlock' => { 201 => 0x49 },
	'caseautosetting' => { 2 => 0x1c },
	'casioimagesize' => { 119 => 0x9 },
	'catalogsets' => { 148 => 0xff, 521 => 'CatalogSets', 526 => 'CatalogSets' },
	'categories' => { 69 => 0x23, 528 => 'categories' },
	'category' => { 148 => 0xf, 196 => 'WM/Category', 343 => 0x30, 427 => 'catg', 552 => 'Category' },
	'cbcrgain' => { 452 => 0xa036 },
	'cbcrgaindefault' => { 452 => 0xa035 },
	'cbcrmatrix' => { 452 => 0xa034 },
	'cbcrmatrixdefault' => { 452 => 0xa033 },
	'ccdboardversion' => { 365 => 0x331 },
	'ccdscanmode' => { 350 => 0x1039 },
	'ccdsensitivity' => { 305 => 0x6 },
	'ccdversion' => { 365 => 0x330 },
	'ccvavgluminancenits' => { 544 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 544 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 544 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 544 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 544 => 'ccv_white_xy' },
	'cellglobalid' => { 533 => 'cgi' },
	'celllength' => { 125 => 0x109 },
	'cellr' => { 533 => 'r' },
	'celltowerid' => { 533 => 'cellid' },
	'cellwidth' => { 125 => 0x108 },
	'centerafarea' => { 334 => '15.1' },
	'centerfocuspoint' => { 338 => '2.2' },
	'centerpixel' => { 155 => 0x40c },
	'centerweightedareasize' => { 323 => '7.1', 324 => '8.1', 326 => '8.1', 327 => '8.1', 331 => '7.1', 332 => '5.1', 333 => '7.1', 334 => '6.3', 336 => '8.1', 337 => '8.1', 338 => '8.1', 339 => 0x21, 340 => 0x1f, 341 => 0x1f, 342 => 0x1f },
	'certificate' => { 568 => 'Certificate' },
	'cfainterpolationalgorithm' => { 155 => 0xe60 },
	'cfainterpolationmetric' => { 155 => 0xe61 },
	'cfaoffsetcols' => { 155 => 0xc71 },
	'cfaoffsetrows' => { 155 => 0xc6f },
	'cfapattern' => { 125 => 0xa302, 375 => 0x9, 540 => 'CFAPattern' },
	'cfapattern2' => { 125 => 0x828e },
	'cfapatterncolumns' => { 540 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 540 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 540 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 125 => 0x828d },
	'cfazipperfixthreshold' => { 155 => 0xe62 },
	'channel' => { 554 => 'channel' },
	'channela-lang' => { 554 => [\'channel','channelA-lang'] },
	'channelchannel' => { 554 => [\'channel','channelChannel'] },
	'channels' => { 172 => 'Channels' },
	'channelsubchannel1' => { 554 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 554 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 554 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 554 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 435 => 'chpl' },
	'checkmark' => { 109 => 0x10101, 114 => 0x26a },
	'checkmark2' => { 115 => 0x8e },
	'childfontfiles' => { 569 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 323 => '10.3', 324 => '11.2', 340 => 0x10b, 341 => 0x10b, 342 => 0x121 },
	'chromablurradius' => { 125 => 0xc631 },
	'chromanoisecolorspace' => { 155 => 0xe6d },
	'chromanoiseedgemapthresh' => { 155 => 0xe6c },
	'chromanoisehighfthresh' => { 155 => 0xe6a },
	'chromanoiselowfthresh' => { 155 => 0xe6b },
	'chromaticaberration' => { 109 => 0x20703, 115 => 0x66, 452 => 0xa051 },
	'chromaticaberrationb' => { 534 => 'ChromaticAberrationB', 536 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 109 => 0x20708, 115 => 0x6b },
	'chromaticaberrationcorr' => { 84 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 125 => 0x7034, 398 => 0x1, 516 => 0x900d },
	'chromaticaberrationcorrparams' => { 125 => 0x7035, 510 => 0x66a, 511 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 109 => '0x20703.0', 115 => 0x62 },
	'chromaticaberrationr' => { 534 => 'ChromaticAberrationR', 536 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 109 => 0x20707, 115 => 0x6a },
	'chromaticaberrationsetting' => { 85 => 0x6 },
	'chrominancenoisereduction' => { 109 => 0x20601, 115 => 0x5e, 455 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 115 => 0x60 },
	'circadatecreated' => { 548 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 534 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 534 => 'CircularGradientBasedCorrections', 536 => 'CircularGradientBasedCorrections' },
	'city' => { 148 => 0x5a, 178 => 'City', 370 => 0x6d, 552 => 'City' },
	'city2' => { 370 => 0x80 },
	'clarity' => { 37 => 0x33, 133 => 0x100f, 275 => 0x35, 276 => 0x3d, 479 => 0x2036, 534 => 'Clarity', 536 => 'Clarity' },
	'clarity2012' => { 534 => 'Clarity2012', 536 => 'Clarity2012' },
	'claritycontrol' => { 409 => 0x96 },
	'classification' => { 435 => 'clsf' },
	'classifystate' => { 148 => 0xe1 },
	'clearretouch' => { 370 => 0x7c },
	'clearretouchvalue' => { 370 => 0xa3 },
	'client' => { 564 => 'client' },
	'clientname' => { 542 => 'ClientName' },
	'clipboardaspectratio' => { 534 => 'ClipboardAspectRatio', 536 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 534 => 'ClipboardOrientation', 536 => 'ClipboardOrientation' },
	'clipfilename' => { 435 => 'clfn' },
	'clipid' => { 435 => 'clid' },
	'clmodeshootingspeed' => { 323 => '10.2', 324 => '11.3', 326 => '11.2', 327 => '11.2', 332 => '11.2', 333 => '10.2', 336 => '11.2', 337 => '11.2', 338 => '11.1', 339 => 0x3f, 340 => 0x3b, 341 => 0x3b, 342 => 0x3b },
	'cluster' => { 534 => 'Cluster', 536 => 'Cluster' },
	'cmcontrast' => { 353 => 0x2022 },
	'cmddialsreverserotation' => { 339 => 0xbe, 340 => 0xba, 341 => 0xba, 342 => 0xba },
	'cmexposurecompensation' => { 353 => 0x2000 },
	'cmhue' => { 353 => 0x2021 },
	'cmsaturation' => { 353 => 0x2020 },
	'cmsharpness' => { 353 => 0x2023 },
	'cmwhitebalance' => { 353 => 0x2001 },
	'cmwhitebalancecomp' => { 353 => 0x2002 },
	'cmwhitebalancegraypoint' => { 353 => 0x2010 },
	'codec' => { 186 => 'Codec' },
	'codedcharacterset' => { 149 => 0x5a },
	'codeversion' => { 435 => 'cver' },
	'collection' => { 359 => 'Collection' },
	'collectionname' => { 187 => [\'Collections','CollectionsCollectionName'], 435 => 'coll' },
	'collections' => { 187 => 'Collections', 528 => 'collections' },
	'collectionuri' => { 187 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 429 => 'player.movie.visual.color', 553 => 'color' },
	'coloraberrationcontrol' => { 316 => 0xc89224b },
	'coloradjustment' => { 455 => 0x14 },
	'coloradjustmentmode' => { 454 => 0x210 },
	'coloranta' => { 569 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 569 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 569 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 569 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 569 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 569 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 569 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 569 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 569 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 569 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 569 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 569 => 'Colorants' },
	'colorantswatchname' => { 569 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 569 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 569 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 569 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 173 => 'ColorBalance' },
	'colorbalanceadj' => { 316 => 0x76a43202 },
	'colorbalanceblue' => { 198 => 0x1e },
	'colorbalancegreen' => { 198 => 0x1d },
	'colorbalancered' => { 198 => 0x1c },
	'colorbalanceversion' => { 226 => 0x4, 227 => 0x4, 228 => 0x0, 229 => 0x0 },
	'colorblur' => { 115 => 0x65 },
	'colorbluron' => { 109 => 0x20704 },
	'colorbooster' => { 316 => 0x5f0e7d23 },
	'colorboostlevel' => { 310 => 0x1 },
	'colorboosttype' => { 310 => 0x0 },
	'colorchromeeffect' => { 133 => 0x1048 },
	'colorchromefxblue' => { 133 => 0x104e },
	'colorclass' => { 420 => 0xde, 421 => 'ColorClass' },
	'colorcompensationfilter' => { 201 => [0x3a,0x5f], 203 => 0x111, 479 => 0xb022 },
	'colorcompensationfiltercustom' => { 465 => 0xd, 466 => 0xc },
	'colorcompensationfilterset' => { 465 => 0x8, 466 => 0x7, 467 => 0x18, 484 => 0xf },
	'colorcontrol' => { 350 => 0x102b },
	'colorcorrection' => { 516 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 345 => 0x532 },
	'colordataversion' => { 44 => 0x0, 45 => 0x0, 46 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0, 54 => 0x0 },
	'coloreffect' => { 370 => 0x28 },
	'colorfilter' => { 118 => 0x17, 119 => 0x3017, 198 => 0x29, 206 => [0x38,0x4d,0x4f], 416 => 0x17 },
	'colorgain' => { 282 => 0x51 },
	'colorgradeblending' => { 534 => 'ColorGradeBlending', 536 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 534 => 'ColorGradeGlobalHue', 536 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 534 => 'ColorGradeGlobalLum', 536 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 534 => 'ColorGradeGlobalSat', 536 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 534 => 'ColorGradeHighlightLum', 536 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 534 => 'ColorGradeMidtoneHue', 536 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 534 => 'ColorGradeMidtoneLum', 536 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 534 => 'ColorGradeMidtoneSat', 536 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 534 => 'ColorGradeShadowLum', 536 => 'ColorGradeShadowLum' },
	'colorhue' => { 109 => 0x20900, 256 => 0x8d },
	'colorimetricreference' => { 125 => 0xc6bf },
	'colorlabel' => { 539 => 'ColorLabel' },
	'colormatrix' => { 68 => 0xa, 349 => 0x200, 350 => 0x1011, 452 => 0xa030 },
	'colormatrix1' => { 125 => 0xc621, 418 => 0x106 },
	'colormatrix2' => { 125 => 0xc622, 353 => 0x200, 418 => 0x226 },
	'colormatrix3' => { 125 => 0xcd33 },
	'colormatrixa' => { 409 => 0x203 },
	'colormatrixa2' => { 409 => 0x21c },
	'colormatrixadobergb' => { 452 => 0xa032 },
	'colormatrixb' => { 409 => 0x204 },
	'colormatrixb2' => { 409 => 0x21d },
	'colormatrixnumber' => { 350 => 0x1019 },
	'colormatrixsrgb' => { 452 => 0xa031 },
	'colormode' => { 119 => 0x3015, 133 => 0x1210, 157 => 0x66, 198 => 0x28, 201 => 0x16, 203 => 0x101, 204 => 0x36, 206 => 0x7, 256 => 0x3, 305 => 0x4, 370 => 0x32, 455 => 0x2c, 479 => 0xb029, 552 => 'ColorMode' },
	'colormoirereduction' => { 109 => 0x20670, 317 => 0x15 },
	'colormoirereductionmode' => { 317 => 0x5 },
	'colormoirereductionon' => { 109 => '0x20670.0' },
	'colornoisereduction' => { 516 => 0x8029, 534 => 'ColorNoiseReduction', 536 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 534 => 'ColorNoiseReductionDetail', 536 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 317 => 0x18 },
	'colornoisereductionsharpness' => { 317 => 0x1c },
	'colornoisereductionsmoothness' => { 534 => 'ColorNoiseReductionSmoothness', 536 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 129 => 0x2 },
	'colorprofile' => { 198 => 0x33 },
	'colorprofilesettings' => { 345 => 0x539 },
	'colorrepresentation' => { 150 => 0x3c },
	'colorsaturationadj' => { 109 => 0x20305 },
	'colorsequence' => { 150 => 0x41 },
	'colorspace' => { 55 => 0x3, 69 => 0xb4, 103 => 0x10b4, 125 => 0xa001, 152 => 0x3, 179 => 'ColorSpace', 199 => 0x2f, 200 => 0x25, 201 => 0x17, 256 => 0x1e, 345 => 0x507, 409 => 0x37, 452 => 0xa011, 455 => 0xb, 465 => 0x1b, 466 => 0x83, 467 => 0xe, 484 => 0x6, 540 => 'ColorSpace' },
	'colorspace2' => { 68 => 0x9 },
	'colorspecapproximation' => { 152 => 0x2 },
	'colorspecdata' => { 152 => 0x3 },
	'colorspecmethod' => { 152 => 0x0 },
	'colorspecprecedence' => { 152 => 0x1 },
	'colortempasshot' => { 41 => 0x4, 42 => 0x7, 43 => 0x1d, 44 => 0x59, 45 => 0x6d, 46 => 0x6d, 47 => 0x26, 48 => 0x43, 51 => 0x43, 52 => 0x43, 53 => 0x43, 54 => 0x4b },
	'colortempauto' => { 41 => 0x9, 42 => 0xf, 43 => 0x22, 44 => 0x5e, 45 => 0x72, 47 => 0x1c, 48 => 0x48, 51 => 0x48, 52 => 0x48, 53 => 0x48, 54 => 0x50 },
	'colortempcloudy' => { 41 => 0x22, 42 => 0x37, 43 => 0x31, 44 => 0xa4, 45 => 0xdb, 46 => 0x7c, 47 => 0x35, 48 => 0x5c, 51 => 0x75, 52 => 0x8e, 53 => 0x93, 54 => 0x96, 409 => 0x55 },
	'colortempcustom' => { 48 => 0x84 },
	'colortempcustom1' => { 43 => 0x45 },
	'colortempcustom2' => { 43 => 0x4a },
	'colortempdaylight' => { 41 => 0x18, 42 => 0x27, 43 => 0x27, 44 => 0x9a, 45 => 0xd1, 46 => 0x72, 47 => 0x2b, 48 => 0x52, 51 => 0x6b, 52 => 0x84, 53 => 0x89, 54 => 0x8c, 409 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 69 => 0xae, 79 => 0x9, 103 => 0x10ae, 133 => 0x1005, 155 => 0x846, 173 => 'ColorTemperature', 199 => [0x6e,0x49], 200 => 0x3f, 201 => [0x39,0x5e], 203 => 0x10b, 206 => [0x3c,0x4c,0x4e], 365 => 0x321, 409 => 0x50, 445 => 0x1308, 479 => 0xb021, 534 => 'Temperature', 536 => 'Temperature' },
	'colortemperatureadj' => { 516 => 0x8013 },
	'colortemperatureauto' => { 256 => 0x4f },
	'colortemperaturebg' => { 350 => 0x1013 },
	'colortemperaturecustom' => { 465 => 0xc, 466 => 0xb },
	'colortemperaturerg' => { 350 => 0x1014 },
	'colortemperatureset' => { 465 => 0x7, 466 => 0x6 },
	'colortemperaturesetting' => { 201 => 0x25, 467 => 0x17, 484 => 0xe },
	'colortempflash' => { 41 => 0x36, 42 => 0x57, 43 => 0x40, 44 => 0xb8, 45 => 0xef, 46 => 0x8b, 47 => 0x49, 48 => 0x70, 51 => 0x89, 52 => 0xa2, 53 => 0xa7, 54 => 0xaa, 409 => 0x5a },
	'colortempflashdata' => { 48 => 0x24a },
	'colortempfluorescent' => { 41 => 0x2c, 42 => 0x47, 43 => 0x3b, 44 => 0xae, 45 => 0xe5, 46 => 0x86, 47 => 0x3f, 48 => 0x66, 51 => 0x7f, 52 => 0x98, 53 => 0x9d, 54 => 0xa0 },
	'colortempfluorescentd' => { 409 => 0x57 },
	'colortempfluorescentn' => { 409 => 0x58 },
	'colortempfluorescentw' => { 409 => 0x59 },
	'colortempkelvin' => { 41 => 0x31, 42 => 0x4f, 44 => 0xb3, 45 => 0xea, 47 => 0x44, 48 => 0x6b, 51 => 0x84, 52 => 0x9d, 53 => 0xa2, 54 => 0xa5, 370 => 0x44, 445 => 0x1307 },
	'colortempmeasured' => { 41 => 0xe, 42 => 0x17, 44 => 0x63, 45 => 0x77, 48 => 0x4d, 51 => 0x4d, 52 => 0x4d, 53 => 0x4d, 54 => 0x55 },
	'colortemppc1' => { 47 => 0x94, 48 => 0x75 },
	'colortemppc2' => { 47 => 0x99, 48 => 0x7a },
	'colortemppc3' => { 47 => 0x9e, 48 => 0x7f },
	'colortempshade' => { 41 => 0x1d, 42 => 0x2f, 43 => 0x2c, 44 => 0x9f, 45 => 0xd6, 46 => 0x77, 47 => 0x30, 48 => 0x57, 51 => 0x70, 52 => 0x89, 53 => 0x8e, 54 => 0x91, 409 => 0x54 },
	'colortemptungsten' => { 41 => 0x27, 42 => 0x3f, 43 => 0x36, 44 => 0xa9, 45 => 0xe0, 46 => 0x81, 47 => 0x3a, 48 => 0x61, 51 => 0x7a, 52 => 0x93, 53 => 0x98, 54 => 0x9b, 409 => 0x56 },
	'colortempunknown' => { 41 => 0x13, 42 => 0x1f, 44 => 0x68, 45 => 0x7c, 47 => 0x21, 51 => 0x52, 52 => 0x52, 53 => 0x52, 54 => 0x5a },
	'colortempunknown10' => { 41 => 0x63, 42 => 0x9f, 44 => 0x95, 45 => 0xa9, 46 => 0xb8, 47 => 0x76, 51 => 0xa2, 52 => 0x7f, 53 => 0x7f, 54 => 0x87 },
	'colortempunknown11' => { 41 => 0x68, 42 => 0xa7, 44 => 0xbd, 45 => [0xae,0xb3], 46 => 0xbd, 47 => 0x7b, 51 => 0xa7, 52 => 0xa7, 53 => 0x84, 54 => 0xaf },
	'colortempunknown12' => { 41 => 0x6d, 42 => 0xaf, 44 => 0xc2, 45 => 0xb8, 46 => 0xc2, 47 => 0x80, 51 => 0xac, 52 => 0xac, 53 => 0xac, 54 => 0xb4 },
	'colortempunknown13' => { 41 => 0x72, 42 => 0xb7, 44 => 0xc7, 45 => 0xbd, 46 => 0xc7, 47 => 0x85, 51 => 0xb1, 52 => 0xb1, 53 => 0xb1, 54 => 0xb9 },
	'colortempunknown14' => { 44 => 0xcc, 45 => 0xc2, 46 => 0xcc, 47 => 0x8a, 51 => 0xb6, 52 => 0xb6, 53 => 0xb6, 54 => 0xbe },
	'colortempunknown15' => { 44 => 0xd1, 45 => 0xc7, 46 => 0xd1, 47 => 0x8f, 51 => 0xbb, 52 => 0xbb, 53 => 0xbb, 54 => 0xc3 },
	'colortempunknown16' => { 44 => 0xd6, 45 => 0xcc, 46 => 0xd6, 47 => 0xa3, 52 => 0xc0, 53 => 0xc0, 54 => 0xc8 },
	'colortempunknown17' => { 44 => 0xdb, 45 => 0xf4, 46 => 0xdb, 52 => 0xc5, 53 => 0xc5, 54 => 0xcd },
	'colortempunknown18' => { 44 => 0xe0, 45 => 0xf9, 46 => 0xe0, 52 => 0xca, 53 => 0xca, 54 => 0xd2 },
	'colortempunknown19' => { 44 => 0xe5, 45 => 0xfe, 46 => 0xe5, 52 => 0xcf, 53 => 0xcf, 54 => 0xd7 },
	'colortempunknown2' => { 41 => 0x3b, 42 => 0x5f, 44 => 0x6d, 45 => 0x81, 46 => 0x90, 47 => 0x4e, 51 => 0x57, 52 => 0x57, 53 => 0x57, 54 => 0x5f },
	'colortempunknown20' => { 44 => 0xea, 45 => 0x103, 46 => 0xea, 52 => 0xd4, 53 => 0xd4, 54 => 0xdc },
	'colortempunknown21' => { 44 => 0xef, 45 => 0x108, 46 => 0xef, 53 => 0xd9, 54 => 0xe1 },
	'colortempunknown22' => { 44 => 0xf4, 45 => 0x10d, 46 => 0xf4, 53 => 0xde, 54 => 0xe6 },
	'colortempunknown23' => { 44 => 0xf9, 45 => 0x112, 46 => 0xf9, 53 => 0xe3, 54 => 0xeb },
	'colortempunknown24' => { 44 => 0xfe, 45 => 0x117, 46 => 0xfe, 53 => 0xe8, 54 => 0xf0 },
	'colortempunknown25' => { 44 => 0x103, 45 => 0x11c, 46 => 0x103, 53 => 0xed, 54 => 0xf5 },
	'colortempunknown26' => { 44 => 0x108, 45 => 0x121, 46 => 0x108, 53 => 0xf2, 54 => 0xfa },
	'colortempunknown27' => { 44 => 0x10d, 45 => 0x126, 46 => 0x10d, 53 => 0xf7, 54 => 0xff },
	'colortempunknown28' => { 44 => 0x112, 46 => 0x112, 53 => 0xfc, 54 => 0x104 },
	'colortempunknown29' => { 44 => 0x117, 46 => 0x117, 53 => 0x101, 54 => 0x109 },
	'colortempunknown3' => { 41 => 0x40, 42 => 0x67, 44 => 0x72, 45 => 0x86, 46 => 0x95, 47 => 0x53, 51 => 0x5c, 52 => 0x5c, 53 => 0x5c, 54 => 0x64 },
	'colortempunknown30' => { 46 => 0x11c, 53 => 0x106 },
	'colortempunknown31' => { 46 => 0x121 },
	'colortempunknown32' => { 46 => 0x126 },
	'colortempunknown33' => { 46 => 0x12b },
	'colortempunknown4' => { 41 => 0x45, 42 => 0x6f, 44 => 0x77, 45 => 0x8b, 46 => 0x9a, 47 => 0x58, 51 => 0x61, 52 => 0x61, 53 => 0x61, 54 => 0x69 },
	'colortempunknown5' => { 41 => 0x4a, 42 => 0x77, 44 => 0x7c, 45 => 0x90, 46 => 0x9f, 47 => 0x5d, 51 => 0x66, 52 => 0x66, 53 => 0x66, 54 => 0x6e },
	'colortempunknown6' => { 41 => 0x4f, 42 => 0x7f, 44 => 0x81, 45 => 0x95, 46 => 0xa4, 47 => 0x62, 51 => 0x8e, 52 => 0x6b, 53 => 0x6b, 54 => 0x73 },
	'colortempunknown7' => { 41 => 0x54, 42 => 0x87, 44 => 0x86, 45 => 0x9a, 46 => 0xa9, 47 => 0x67, 51 => 0x93, 52 => 0x70, 53 => 0x70, 54 => 0x78 },
	'colortempunknown8' => { 41 => 0x59, 42 => 0x8f, 44 => 0x8b, 45 => 0x9f, 46 => 0xae, 47 => 0x6c, 51 => 0x98, 52 => 0x75, 53 => 0x75, 54 => 0x7d },
	'colortempunknown9' => { 41 => 0x5e, 42 => 0x97, 44 => 0x90, 45 => 0xa4, 46 => 0xb3, 47 => 0x71, 51 => 0x9d, 52 => 0x7a, 53 => 0x7a, 54 => 0x82 },
	'colortint' => { 369 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 37 => 0x2a, 55 => 0x2, 68 => 0x8 },
	'colortoneadj' => { 109 => 0x20304, 114 => 0x11e },
	'colortoneauto' => { 76 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 75 => 0x6c, 76 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 75 => 0x3c, 76 => 0x3c },
	'colortonemonochrome' => { 75 => 0x84, 76 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 75 => 0x54, 76 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 75 => 0x24, 76 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 75 => 0xc, 76 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 75 => 0x9c, 76 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 75 => 0xb4, 76 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 75 => 0xcc, 76 => 0xe4 },
	'columninterleavefactor' => { 125 => 0xcd43 },
	'comlenblksize' => { 155 => 0xfde8 },
	'commanddialframeadvancezoom' => { 267 => 0x804 },
	'commanddialplaybackmode' => { 340 => 0x1cb, 341 => 0x1cb, 342 => 0x1e3 },
	'commanddials' => { 334 => '5.1' },
	'commanddialsaperturesetting' => { 323 => '17.3', 324 => '18.3', 326 => '18.3', 327 => '18.3', 332 => '33.3', 333 => '17.3', 336 => '18.3', 337 => '18.3' },
	'commanddialschangemainsub' => { 323 => '17.2', 324 => '18.1', 326 => '18.1', 327 => '18.1', 332 => '33.2', 333 => '17.2', 336 => '18.1', 337 => '18.1' },
	'commanddialsmenuandplayback' => { 323 => '17.4', 324 => '18.2', 326 => '18.2', 327 => '18.2', 332 => '33.4', 333 => '17.4', 336 => '18.2', 337 => '18.2' },
	'commanddialsreverserotation' => { 323 => '17.1', 324 => '6.4', 326 => '6.2', 327 => '6.2', 328 => '16.2', 329 => '17.2', 332 => '33.1', 333 => '17.1', 336 => '6.2', 337 => '6.2', 338 => '18.1' },
	'commanddialvideoplaybackmode' => { 340 => 0x1cd, 342 => 0x1e5 },
	'commanderchannel' => { 334 => '10.2', 335 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 334 => '13.1', 335 => '31.1' },
	'commandergroupa_ttlcomp' => { 338 => '32.1' },
	'commandergroupamanualoutput' => { 334 => '13.2', 335 => '28.2' },
	'commandergroupamode' => { 334 => '11.2', 335 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 334 => '14.1', 335 => '32.1' },
	'commandergroupb_ttlcomp' => { 338 => '33.1' },
	'commandergroupbmanualoutput' => { 334 => '14.2', 335 => '29.2' },
	'commandergroupbmode' => { 334 => '11.3', 335 => '29.1' },
	'commanderinternalflash' => { 334 => '11.1', 335 => '27.1' },
	'commanderinternalmanualoutput' => { 334 => '12.2', 335 => '27.2' },
	'commanderinternalttlchannel' => { 332 => '18.2' },
	'commanderinternalttlcomp' => { 334 => '12.1', 335 => '30.2', 338 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 332 => '20.1', 333 => '26.1' },
	'commanderinternalttlcompgroupa' => { 332 => '21.1', 333 => '27.1' },
	'commanderinternalttlcompgroupb' => { 332 => '22.1', 333 => '28.1' },
	'comment' => { 0 => 0x2, 126 => 'Comment', 174 => 'Comment', 359 => 'Comment', 427 => "\xa9cmt", 429 => 'comment', 435 => "\xa9cmt" },
	'compass' => { 448 => 0x4 },
	'compatiblebrands' => { 429 => 'compatible_brands' },
	'compatibleversion' => { 534 => 'CompatibleVersion', 536 => 'CompatibleVersion' },
	'compilation' => { 427 => 'cpil' },
	'compimageimagespersequence' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 541 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 554 => 'complianceProfile' },
	'componentsconfiguration' => { 125 => 0x9101, 179 => 'Components', 540 => 'ComponentsConfiguration' },
	'componentversion' => { 103 => 0x80c },
	'composer' => { 196 => 'WM/Composer', 427 => ["\xa9com","\xa9wrt"], 435 => ["\xa9com","\xa9wrt"], 564 => 'composer' },
	'composerid' => { 427 => 'cmID' },
	'composerkeywords' => { 435 => "\xa9cok" },
	'compositeimage' => { 125 => 0xa460, 541 => 'CompositeImage' },
	'compositeimagecount' => { 125 => 0xa461, 541 => 'CompositeImageCount' },
	'compositeimagecount1' => { 133 => 0x1151 },
	'compositeimagecount2' => { 133 => 0x1152 },
	'compositeimageexposuretimes' => { 125 => 0xa462, 541 => 'CompositeImageExposureTimes' },
	'compositeimagemode' => { 133 => 0x1150 },
	'composition' => { 522 => 'Composition' },
	'compositionadjust' => { 407 => '0.1' },
	'compositionadjustrotation' => { 407 => 0x7 },
	'compositionadjustx' => { 407 => 0x5 },
	'compositionadjusty' => { 407 => 0x6 },
	'compressedbitsperpixel' => { 125 => 0x9102, 540 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 203 => 0x40, 350 => 0x40 },
	'compression' => { 125 => 0x103, 375 => 0xb, 560 => 'Compression' },
	'compressionfactor' => { 345 => 0x50d },
	'compressionformat' => { 68 => 0x4 },
	'compressionratio' => { 179 => 'Compression', 350 => 0x1034 },
	'compressorversion' => { 435 => 'CNCV' },
	'condadobvfactor' => { 155 => 0xf3e },
	'condadodaybvthresh' => { 155 => 0xf3c },
	'condadodayoffsets' => { 155 => 0xf42 },
	'condadofluoffsets' => { 155 => 0xf44 },
	'condadofluthresh' => { 155 => 0xf41 },
	'condadoillfactor' => { 155 => 0xf3f },
	'condadoneurange' => { 155 => 0xf3d },
	'condadotunoffsets' => { 155 => 0xf43 },
	'condadotunthresh' => { 155 => 0xf40 },
	'conductor' => { 196 => 'WM/Conductor', 427 => "\xa9con" },
	'confidence' => { 143 => 'Confidence' },
	'confidencelevel' => { 530 => 'ConfidenceLevel' },
	'confidencemime' => { 143 => 'ConfidenceMime' },
	'constrainedcropheight' => { 114 => 0x266, 420 => 0xd6 },
	'constrainedcropwidth' => { 114 => 0x262, 420 => 0xd5 },
	'contact' => { 148 => 0x76 },
	'contactinfo' => { 534 => 'ContactInfo', 536 => 'ContactInfo', 553 => 'contactInfo' },
	'container' => { 138 => 'Container' },
	'containerdirectory' => { 138 => [\'Container','ContainerDirectory'], 141 => 'Directory' },
	'containerdirectoryitem' => { 138 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 138 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 138 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 138 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 138 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 548 => 'ContainerFormat' },
	'containerformatidentifier' => { 548 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 548 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 427 => "\xa9day", 435 => ['@day',"\xa9day"] },
	'contentdistributor' => { 196 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 435 => 'cdis' },
	'contentid' => { 435 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 429 => 'content.identifier' },
	'contentlocationcode' => { 148 => 0x1a },
	'contentlocationname' => { 148 => 0x1b },
	'contenttype' => { 554 => 'contentType' },
	'continuousbracketing' => { 201 => 0x20 },
	'continuousdrive' => { 37 => 0x5 },
	'continuousmodedisplay' => { 339 => 0x55, 340 => 0x51, 341 => 0x51, 342 => 0x51 },
	'continuousmodeliveview' => { 337 => '77.2' },
	'continuousshootingspeed' => { 90 => 0x610 },
	'continuousshotlimit' => { 90 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 37 => 0xd, 118 => 0xc, 119 => [0x3012,0x20], 125 => [0xa408,0xfe54], 133 => [0x1004,0x1006], 173 => 'Contrast', 193 => 'Contrast', 198 => 0x20, 199 => 0x31, 200 => 0x27, 201 => 0x19, 206 => 0x2, 274 => 0x33, 275 => 0x37, 276 => 0x3f, 350 => 0x1029, 370 => 0x39, 372 => 0x300a, 409 => 0x20, 416 => 0xc, 429 => 'player.movie.visual.contrast', 437 => 0x24, 438 => 0x52, 439 => 0x3c, 440 => 0x62, 445 => 0x1012, 455 => 0xd, 465 => 0x1d, 466 => 0x1a, 479 => 0x2004, 534 => 'Contrast', 536 => 'Contrast', 540 => 'Contrast' },
	'contrast2012' => { 534 => 'Contrast2012', 536 => 'Contrast2012' },
	'contrastadj' => { 109 => 0x20303, 114 => 0x115, 319 => 0x2c, 516 => 0x8017 },
	'contrastauto' => { 76 => 0x90 },
	'contrastcurve' => { 256 => 0x8c },
	'contrastdetectafarea' => { 409 => 0x231 },
	'contrastdetectafinfocus' => { 210 => 0x1c, 211 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 75 => 0x60, 76 => 0x60 },
	'contrasthighlight' => { 409 => 0x6d },
	'contrasthighlightshadowadj' => { 409 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 75 => 0x30, 76 => 0x30 },
	'contrastmode' => { 370 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 75 => 0x78, 76 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 75 => 0x48, 76 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 75 => 0x18, 76 => 0x18 },
	'contrastsetting' => { 345 => 0x505, 353 => 0x1012, 467 => 0x10, 484 => 0x8 },
	'contrastshadow' => { 409 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 75 => 0x0, 76 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 75 => 0x90, 76 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 75 => 0xa8, 76 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 75 => 0xc0, 76 => 0xd8 },
	'contributedmedia' => { 564 => 'contributedMedia' },
	'contributedmediaduration' => { 564 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 564 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 564 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 564 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 564 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 564 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 564 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 564 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 564 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 564 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 537 => 'contributor', 548 => 'Contributor' },
	'contributoridentifier' => { 548 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 548 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 548 => [\'Contributor','ContributorRole'] },
	'contributors' => { 174 => 'Contributors' },
	'controldialset' => { 201 => 0x46 },
	'controlledvocabularyterm' => { 548 => 'CVterm' },
	'controllerboardversion' => { 365 => 0x332 },
	'controlmode' => { 82 => 0x12 },
	'controlringresponse' => { 339 => 0x1cf, 340 => 0x1d5, 341 => 0x1d5, 342 => 0x1ed },
	'controlringrotation' => { 90 => 0x712 },
	'conversionlens' => { 346 => 0x403, 370 => 0x35 },
	'converter' => { 125 => 0xfe4d, 305 => 0xb, 534 => 'Converter', 536 => 'Converter' },
	'converttograyscale' => { 534 => 'ConvertToGrayscale', 536 => 'ConvertToGrayscale' },
	'cookingequipment' => { 556 => 'cookingEquipment' },
	'cookingmethod' => { 556 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 125 => 0x8298, 174 => 'Copyright', 359 => 'Copyright', 375 => 0x8298, 409 => 0x22f, 425 => 'Copyright', 427 => ['cprt',"\xa9cpy"], 429 => 'copyright', 435 => ['cprt',"\xa9cpy"], 534 => 'Copyright', 536 => 'Copyright', 550 => 'Copyright', 557 => 'copyright', 560 => 'Copyright', 564 => 'copyright' },
	'copyrightflag' => { 423 => 0x40a },
	'copyrightnotice' => { 148 => 0x74 },
	'copyrightowner' => { 356 => 'CopyrightOwner' },
	'copyrightownerid' => { 356 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 356 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 356 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 356 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 356 => 'CopyrightStatus' },
	'copyrightyear' => { 548 => 'CopyrightYear', 554 => 'copyrightYear' },
	'coringfilter' => { 349 => 0x310, 350 => 0x102d, 353 => 0x310 },
	'coringvalues' => { 349 => 0x311, 353 => 0x311 },
	'corporateentity' => { 554 => 'corporateEntity' },
	'correctionalreadyapplied' => { 360 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 369 => 0x35b },
	'country' => { 178 => 'Country', 370 => 0x69, 552 => 'Country' },
	'country-primarylocationcode' => { 148 => 0x64 },
	'country-primarylocationname' => { 148 => 0x65 },
	'countrycode' => { 255 => 0x5, 421 => 'CountryCode', 547 => 'CountryCode' },
	'course' => { 556 => 'course' },
	'coverage' => { 537 => 'coverage' },
	'coverart' => { 427 => 'covr' },
	'coverdate' => { 554 => 'coverDate' },
	'coverdisplaydate' => { 554 => 'coverDisplayDate' },
	'coveruri' => { 435 => 'cvru' },
	'cpufirmwareversion' => { 409 => 0x28 },
	'crc32' => { 538 => 'crc32' },
	'createdate' => { 125 => 0x9004, 174 => 'CreateDate', 355 => 'CreationDate', 359 => 'create-date', 425 => 'CreationDate', 432 => 0x1, 562 => 'CreateDate' },
	'creationdate' => { 429 => 'creationdate', 550 => 'CreationDate', 554 => 'creationDate' },
	'creationtime' => { 359 => 'Creation Time', 429 => 'creation_time' },
	'creativestyle' => { 465 => 0x1a, 466 => 0x18, 476 => 0x41, 479 => 0xb020, 511 => 0x4a },
	'creativestylesetting' => { 467 => 0xf, 484 => 0x7 },
	'creativestylewaschanged' => { 516 => 0x8001 },
	'creator' => { 355 => 'Creator', 425 => 'Creator', 537 => 'creator', 548 => 'Creator', 550 => 'Creator' },
	'creatoraddress' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 195 => 'CreatorAppId' },
	'creatorcity' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 547 => 'CreatorContactInfo' },
	'creatorcountry' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 548 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 421 => 'CreatorIdentity' },
	'creatorname' => { 548 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 195 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 548 => [\'Creator','CreatorRole'] },
	'creatortool' => { 562 => 'CreatorTool' },
	'creatorworkemail' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 547 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 148 => 0x6e, 552 => 'Credit' },
	'creditline' => { 557 => 'creditLine' },
	'creditlinereq' => { 567 => 'CreditLineReq' },
	'creditlinerequired' => { 356 => 'CreditLineRequired' },
	'cropactive' => { 107 => 0x0, 114 => 0x244 },
	'cropangle' => { 107 => 0x8, 534 => 'CropAngle', 536 => 'CropAngle' },
	'croparea' => { 256 => 0x45, 516 => 0x9011 },
	'cropaspectratio' => { 109 => 0x30101, 114 => 0x260 },
	'cropaspectratiocustom' => { 109 => 0x30102 },
	'cropbottom' => { 129 => 0x9, 311 => 0x36, 375 => 0x31, 420 => 0xdc, 534 => 'CropBottom', 536 => 'CropBottom' },
	'cropbottommargin' => { 57 => 0x3 },
	'cropcircleactive' => { 115 => 0xd6 },
	'cropcircleradius' => { 115 => 0xd9 },
	'cropcirclex' => { 115 => 0xd7 },
	'cropcircley' => { 115 => 0xd8 },
	'cropconstraintowarp' => { 534 => 'CropConstrainToWarp', 536 => 'CropConstrainToWarp' },
	'cropflag' => { 133 => 0x1051 },
	'croph' => { 527 => 'CropH' },
	'cropheight' => { 107 => 0x6, 114 => 0x24c, 349 => 0x615, 353 => 0x615, 534 => 'CropHeight', 536 => 'CropHeight' },
	'crophispeed' => { 256 => 0x1b },
	'cropleft' => { 114 => 0x246, 129 => 0x6, 311 => 0x1e, 349 => 0x612, 353 => 0x612, 375 => 0x30, 420 => 0xd9, 534 => 'CropLeft', 536 => 'CropLeft' },
	'cropleftmargin' => { 57 => 0x0 },
	'cropmode' => { 133 => 0x104d, 445 => 0x1018 },
	'croporiginalheight' => { 107 => 0xb },
	'croporiginalwidth' => { 107 => 0xa },
	'cropoutputheight' => { 311 => 0xce },
	'cropoutputheightinches' => { 311 => 0x96 },
	'cropoutputpixels' => { 311 => 0xd6 },
	'cropoutputresolution' => { 311 => 0xb6 },
	'cropoutputscale' => { 311 => 0xbe },
	'cropoutputwidth' => { 311 => 0xc6 },
	'cropoutputwidthinches' => { 311 => 0x8e },
	'croppedareaimageheightpixels' => { 146 => 'CroppedAreaImageHeightPixels', 147 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 146 => 'CroppedAreaImageWidthPixels', 147 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 146 => 'CroppedAreaLeftPixels', 147 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 146 => 'CroppedAreaTopPixels', 147 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 445 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 445 => 0x1603 },
	'cropping' => { 516 => 0x9010 },
	'cropright' => { 129 => 0x8, 311 => 0x2e, 375 => 0x32, 420 => 0xdb, 534 => 'CropRight', 536 => 'CropRight' },
	'croprightmargin' => { 57 => 0x1 },
	'croprotatedoriginalheight' => { 107 => 0x2 },
	'croprotatedoriginalwidth' => { 107 => 0x1 },
	'croprotation' => { 107 => 0x7, 129 => 0xb },
	'cropscaledresolution' => { 311 => 0x9e },
	'cropsize' => { 133 => 0x1053 },
	'cropsourceresolution' => { 311 => 0xae },
	'croptop' => { 114 => 0x248, 129 => 0x7, 311 => 0x26, 349 => 0x613, 353 => 0x613, 375 => 0x2f, 420 => 0xda, 534 => 'CropTop', 536 => 'CropTop' },
	'croptopleft' => { 133 => 0x1052 },
	'croptopmargin' => { 57 => 0x2 },
	'cropunit' => { 534 => 'CropUnit', 536 => 'CropUnit' },
	'cropunits' => { 534 => 'CropUnits', 536 => 'CropUnits' },
	'cropw' => { 527 => 'CropW' },
	'cropwidth' => { 107 => 0x5, 114 => 0x24a, 349 => 0x614, 353 => 0x614, 534 => 'CropWidth', 536 => 'CropWidth' },
	'cropx' => { 107 => 0x3, 527 => 'CropX' },
	'cropy' => { 107 => 0x4, 527 => 'CropY' },
	'crossprocess' => { 409 => 0x7b },
	'crossprocessparams' => { 409 => 0x235 },
	'cuisine' => { 556 => 'cuisine' },
	'currenticcprofile' => { 125 => 0xc691 },
	'currentpreprofilematrix' => { 125 => 0xc692 },
	'currentversion' => { 516 => 0xd000 },
	'curve0x' => { 527 => 'Curve0x' },
	'curve0y' => { 527 => 'Curve0y' },
	'curve1x' => { 527 => 'Curve1x' },
	'curve1y' => { 527 => 'Curve1y' },
	'curve2x' => { 527 => 'Curve2x' },
	'curve2y' => { 527 => 'Curve2y' },
	'curve3x' => { 527 => 'Curve3x' },
	'curve3y' => { 527 => 'Curve3y' },
	'curve4x' => { 527 => 'Curve4x' },
	'curve4y' => { 527 => 'Curve4y' },
	'curves' => { 316 => 0x76a43201 },
	'custom1' => { 356 => 'Custom1' },
	'custom10' => { 356 => 'Custom10' },
	'custom2' => { 356 => 'Custom2' },
	'custom3' => { 356 => 'Custom3' },
	'custom4' => { 356 => 'Custom4' },
	'custom5' => { 356 => 'Custom5' },
	'custom6' => { 356 => 'Custom6' },
	'custom7' => { 356 => 'Custom7' },
	'custom8' => { 356 => 'Custom8' },
	'custom9' => { 356 => 'Custom9' },
	'customcolortone' => { 115 => 0x4c },
	'customcontrast' => { 115 => 0x4e },
	'customcontrols' => { 90 => 0x70c },
	'customdefaultunsharpfineness' => { 115 => 0xbe },
	'customdefaultunsharpstrength' => { 115 => 0xbc },
	'customdefaultunsharpthreshold' => { 115 => 0xc0 },
	'customilluminant' => { 155 => 0x405 },
	'customizedials' => { 90 => 0x715 },
	'customlinear' => { 115 => 0x4f },
	'customoutputhighlightpoint' => { 115 => 0x53 },
	'customoutputshadowpoint' => { 115 => 0x54 },
	'custompicturestyle' => { 109 => 0x10021 },
	'custompicturestyledata' => { 109 => 0xf0500 },
	'custompicturestylefilename' => { 69 => 0x4010 },
	'customrawhighlight' => { 115 => 0x7c },
	'customrawhighlightpoint' => { 115 => 0x51 },
	'customrawshadow' => { 115 => 0x85 },
	'customrawshadowpoint' => { 115 => 0x52 },
	'customrendered' => { 125 => 0xa401, 208 => 0x6420, 540 => 'CustomRendered' },
	'customsaturation' => { 115 => 0x4d, 345 => 0x503 },
	'customsettingsalldefault' => { 323 => '0.2', 332 => '0.2' },
	'customsettingsbank' => { 323 => '0.1', 324 => '0.1', 326 => '0.1', 327 => '0.1', 332 => '0.1', 336 => '0.2', 337 => '0.2', 340 => 0x1, 341 => 0x1, 342 => 0x1 },
	'customsharpness' => { 115 => 0x50 },
	'customunsharpmaskfineness' => { 115 => 0xb8 },
	'customunsharpmaskstrength' => { 115 => 0xb6 },
	'customunsharpmaskthreshold' => { 115 => 0xba },
	'customwb_rblevels' => { 484 => 0x1a },
	'customwb_rgblevels' => { 466 => 0x8, 467 => 0x19 },
	'customwbbluelevel' => { 201 => 0x36 },
	'customwberror' => { 201 => 0x37 },
	'customwbgreenlevel' => { 201 => 0x35 },
	'customwbredlevel' => { 201 => 0x34 },
	'customwbsetting' => { 201 => 0x26 },
	'cx' => { 435 => '_cx_' },
	'cy' => { 435 => '_cy_' },
	'd-lightinghq' => { 316 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 312 => 0x2 },
	'd-lightinghqhighlight' => { 312 => 0x1 },
	'd-lightinghqselected' => { 316 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 312 => 0x0 },
	'd-lightinghs' => { 316 => 0xce5554aa },
	'd-lightinghsadjustment' => { 313 => 0x0 },
	'd-lightinghscolorboost' => { 313 => 0x1 },
	'd-rangeoptimizerhighlight' => { 516 => 0x8024 },
	'd-rangeoptimizermode' => { 516 => 0x8022 },
	'd-rangeoptimizershadow' => { 516 => 0x802d },
	'd-rangeoptimizervalue' => { 516 => 0x8023 },
	'darkblacksegrows' => { 155 => 0x18d8 },
	'darkfocusenvironment' => { 370 => 0x8003 },
	'darkframecountfactor' => { 155 => 0xc85 },
	'darkframelongexposure' => { 155 => 0xc84 },
	'darkframeshortexposure' => { 155 => 0xc83 },
	'darkpedestal' => { 155 => 0xc7f },
	'datacompressionmethod' => { 150 => 0x6e },
	'dataimprint' => { 198 => 0x34 },
	'datamining' => { 356 => 'DataMining' },
	'dataonscreen' => { 548 => 'DataOnScreen' },
	'dataonscreenregion' => { 548 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 548 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 548 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 548 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 548 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 548 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 548 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 548 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 409 => 0x3d },
	'date' => { 409 => 0x6, 537 => 'date' },
	'dateacquired' => { 195 => 'DateAcquired', 196 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 148 => 0x37, 552 => 'DateCreated' },
	'datedisplayformat' => { 308 => 0x3 },
	'dateidentified' => { 124 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 328 => '4.2' },
	'daterecieved' => { 554 => 'dateRecieved' },
	'datesent' => { 149 => 0x46 },
	'datestampmode' => { 69 => 0x1c, 256 => 0x9d },
	'datetime' => { 528 => 'datetime', 560 => 'DateTime' },
	'datetimedigitized' => { 540 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 106 => 0x0, 125 => 0x9003, 171 => 0x14, 174 => 'OriginalDate', 430 => 'IDIT', 435 => 'date', 437 => 0xb, 438 => 0x3e, 439 => 0x2f, 440 => 0x4e, 441 => 0x3b, 540 => 'DateTimeOriginal' },
	'datetimestamp' => { 157 => 0x64 },
	'datetimeutc' => { 345 => 0x908 },
	'daylightsavings' => { 83 => 0x3, 308 => 0x2 },
	'dayofweek' => { 438 => 0x4a, 439 => 0x36, 440 => 0x5a, 441 => 0x42 },
	'dccontinent' => { 124 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 124 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 124 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 124 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 124 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 124 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 124 => 'Event' },
	'dcfootprintspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 124 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 124 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 124 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 124 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 124 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 124 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 124 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 124 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 124 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 124 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 124 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 124 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 124 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 182 => 'Declination' },
	'decposition' => { 198 => 0x32 },
	'defaultautogray' => { 534 => 'DefaultAutoGray', 536 => 'DefaultAutoGray' },
	'defaultautotone' => { 534 => 'DefaultAutoTone', 536 => 'DefaultAutoTone' },
	'defaultblackrender' => { 125 => 0xc7a6 },
	'defaultcroporigin' => { 125 => 0xc61f },
	'defaultcropsize' => { 125 => 0xc620 },
	'defaulteraseoption' => { 90 => 0x813 },
	'defaultscale' => { 125 => 0xc61e },
	'defaultsspecifictoiso' => { 534 => 'DefaultsSpecificToISO', 536 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 534 => 'DefaultsSpecificToSerial', 536 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 125 => 0xc7b5 },
	'defectisocode' => { 155 => 0x90f },
	'defringe' => { 534 => 'Defringe', 536 => 'Defringe' },
	'defringegreenamount' => { 534 => 'DefringeGreenAmount', 536 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 534 => 'DefringeGreenHueHi', 536 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 534 => 'DefringeGreenHueLo', 536 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 534 => 'DefringePurpleAmount', 536 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 534 => 'DefringePurpleHueHi', 536 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 534 => 'DefringePurpleHueLo', 536 => 'DefringePurpleHueLo' },
	'dehaze' => { 534 => 'Dehaze', 536 => 'Dehaze' },
	'deletedimagecount' => { 256 => 0xa6, 287 => 0x6e },
	'deprecatedon' => { 532 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 534 => 'DepthBasedCorrections', 536 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 534 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 125 => 0xc7eb },
	'depthformat' => { 125 => 0xc7e9 },
	'depthimage' => { 143 => 'Data' },
	'depthmapinfo' => { 534 => 'DepthMapInfo', 536 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 536 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 536 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 536 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 536 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 536 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 536 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 536 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 536 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 534 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 536 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 534 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 536 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 125 => 0xc7ed },
	'depthnear' => { 125 => 0xc7ea },
	'depthunits' => { 125 => 0xc7ec },
	'derivedfrom' => { 565 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 565 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 565 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 565 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 565 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 565 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 565 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 565 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 565 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 565 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 565 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 565 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 565 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 565 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 565 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 565 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 565 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 565 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 565 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 565 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 565 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 565 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 565 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 565 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 196 => 'Description', 359 => 'Description', 427 => ['desc','dscp',"\xa9des"], 429 => 'description', 435 => 'dscp', 534 => 'Description', 536 => 'Description', 537 => 'description', 562 => 'Description' },
	'destination' => { 149 => 0x5 },
	'destinationcity' => { 409 => 0x24, 415 => 0x3 },
	'destinationcitycode' => { 416 => 0x1001 },
	'destinationdst' => { 409 => 0x26, 415 => '0.3' },
	'developmentdynamicrange' => { 133 => 0x1403 },
	'deviantmatrixcustom' => { 155 => 0x7de },
	'deviantmatrixdaylight' => { 155 => 0x7da },
	'deviantmatrixflash' => { 155 => 0x7dd },
	'deviantmatrixfluorescent' => { 155 => 0x7dc },
	'deviantmatrixtungsten' => { 155 => 0x7db },
	'deviantwhitecustom' => { 155 => 0x842 },
	'deviantwhitedaylight' => { 155 => 0x83e },
	'deviantwhiteflash' => { 155 => 0x841 },
	'deviantwhitefluorescent' => { 155 => 0x840 },
	'deviantwhitetungsten' => { 155 => 0x83f },
	'device' => { 554 => 'device' },
	'devicesettingdescription' => { 540 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 540 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 540 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 540 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 452 => 0x2 },
	'dewarpdata' => { 122 => 'DewarpData' },
	'dewarpflag' => { 122 => 'DewarpFlag' },
	'dialdirectiontvav' => { 90 => 0x706 },
	'dietaryneeds' => { 556 => 'dietaryNeeds' },
	'diffractioncompensation' => { 245 => 0x20e, 260 => 0x2ce, 261 => 0x142, 262 => 0x1b2, 265 => 0x1a2, 266 => 0x1b6, 267 => 0x1b6 },
	'diffractioncorrection' => { 370 => 0xbc, 398 => 0x3 },
	'diffractioncorrectionon' => { 109 => 0x2070b },
	'digitalcreationdate' => { 148 => 0x3e },
	'digitalcreationtime' => { 148 => 0x3f },
	'digitaldeehighlightadj' => { 282 => 0x202 },
	'digitaldeeshadowadj' => { 282 => 0x200 },
	'digitaldeethreshold' => { 282 => 0x201 },
	'digitalfilter' => { 455 => 0x59 },
	'digitalfilter01' => { 395 => 0x5 },
	'digitalfilter02' => { 395 => 0x16 },
	'digitalfilter03' => { 395 => 0x27 },
	'digitalfilter04' => { 395 => 0x38 },
	'digitalfilter05' => { 395 => 0x49 },
	'digitalfilter06' => { 395 => 0x5a },
	'digitalfilter07' => { 395 => 0x6b },
	'digitalfilter08' => { 395 => 0x7c },
	'digitalfilter09' => { 395 => 0x8d },
	'digitalfilter10' => { 395 => 0x9e },
	'digitalfilter11' => { 395 => 0xaf },
	'digitalfilter12' => { 395 => 0xc0 },
	'digitalfilter13' => { 395 => 0xd1 },
	'digitalfilter14' => { 395 => 0xe2 },
	'digitalfilter15' => { 395 => 0xf3 },
	'digitalfilter16' => { 395 => 0x104 },
	'digitalfilter17' => { 395 => 0x115 },
	'digitalfilter18' => { 395 => 0x126 },
	'digitalfilter19' => { 395 => 0x137 },
	'digitalfilter20' => { 395 => 0x148 },
	'digitalgain' => { 79 => 0xb },
	'digitalgem' => { 240 => 0x0 },
	'digitalice' => { 282 => 0x100 },
	'digitalimageguid' => { 548 => 'DigImageGUID' },
	'digitallensoptimizer' => { 67 => 0xa },
	'digitallensoptimizersetting' => { 85 => 0x9 },
	'digitalroc' => { 279 => 0x0 },
	'digitalsourcefiletype' => { 548 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 548 => 'DigitalSourceType' },
	'digitalzoom' => { 37 => 0xc, 118 => 0xa, 133 => 0x1044, 157 => 0x68, 168 => 0x22, 169 => 0x1e, 173 => 'DigitalZoom', 198 => 0xc, 256 => 0x86, 305 => 0xa, 350 => 0x204, 409 => 0x1e, 416 => 0xa, 454 => 0x204, 502 => 0x12, 503 => 0x12 },
	'digitalzoomon' => { 454 => 0x21b },
	'digitalzoomratio' => { 125 => 0xa404, 490 => 0x200, 492 => 0x21c, 540 => 'DigitalZoomRatio' },
	'director' => { 196 => 'WM/Director', 427 => "\xa9dir", 429 => 'director', 435 => "\xa9dir", 564 => 'director' },
	'directorphotography' => { 564 => 'directorPhotography' },
	'directory' => { 126 => 'Directory' },
	'directorycreatedate' => { 438 => 0x14, 440 => 0x14 },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 141 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 141 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 141 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 141 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 141 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 141 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 141 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 233 => 0x3, 438 => 0x12, 439 => 0x93, 440 => 0x12 },
	'disableautocreation' => { 140 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 140 => 'DisableSuggestedAction' },
	'disclaimer' => { 359 => 'Disclaimer' },
	'discnumber' => { 564 => 'discNumber' },
	'dishtype' => { 556 => 'dishType' },
	'disknumber' => { 427 => 'disk' },
	'dispbutton' => { 267 => 0x7d4, 340 => 0x2ab },
	'displayallafpoints' => { 90 => 0x514 },
	'displayaperture' => { 37 => 0x23 },
	'displayedunitsx' => { 424 => 0x2 },
	'displayedunitsy' => { 424 => 0x6 },
	'displayname' => { 429 => 'displayname', 553 => 'displayName' },
	'distance1' => { 157 => 0x28 },
	'distance2' => { 157 => 0x2c },
	'distance3' => { 157 => 0x30 },
	'distance4' => { 157 => 0x34 },
	'distortion' => { 452 => 0xa050 },
	'distortioncompensation' => { 516 => 0x8040 },
	'distortioncontrol' => { 287 => 0x10 },
	'distortioncorrection' => { 84 => 0x3, 109 => 0x20705, 115 => 0x67, 125 => 0x7036, 231 => 0x4, 345 => 0x50b, 374 => '7.1', 398 => 0x0, 510 => 0x601, 511 => 0x5b },
	'distortioncorrection2' => { 349 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 531 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 109 => '0x20705.0', 115 => 0x63 },
	'distortioncorrectionsetting' => { 85 => 0x7, 479 => 0x2013 },
	'distortioncorrectionvalue' => { 84 => 0x9 },
	'distortioncorrectionversion' => { 231 => 0x0 },
	'distortioncorrparams' => { 125 => 0x7037, 489 => 0x1a23, 492 => 0x1870, 494 => 0x189c, 495 => 0x18cc, 496 => 0x17d0, 510 => 0x6ca, 511 => 0x64 },
	'distortioncorrparamsnumber' => { 492 => 0x1899, 494 => 0x18c5, 495 => 0x18f5, 496 => 0x17f9 },
	'distortioncorrparamspresent' => { 492 => 0x1898, 494 => 0x18c4, 495 => 0x18f4, 496 => 0x17f8, 498 => 0x10b, 499 => 0x10b, 510 => 0x600, 511 => 0x5a },
	'distortioneffect' => { 109 => 0x20709 },
	'distortionn' => { 374 => 0xc },
	'distortionparam02' => { 374 => 0x2 },
	'distortionparam04' => { 374 => 0x4 },
	'distortionparam08' => { 374 => 0x8 },
	'distortionparam09' => { 374 => 0x9 },
	'distortionparam11' => { 374 => 0xb },
	'distortionscale' => { 374 => 0x5 },
	'distributor' => { 554 => 'distributor' },
	'distributorproductid' => { 553 => 'distributorProductID' },
	'dloon' => { 109 => '0x20706.0', 115 => 0xdc },
	'dlosetting' => { 109 => 0x20706, 115 => 0xdd },
	'dlosettingapplied' => { 108 => 0x4 },
	'dloshootingdistance' => { 115 => 0xde },
	'dloversion' => { 108 => 0x5 },
	'dmcomment' => { 564 => 'comment' },
	'dmdithermatrix' => { 155 => 0xc7a },
	'dmdithermatrixheight' => { 155 => 0xc7c },
	'dmdithermatrixwidth' => { 155 => 0xc7b },
	'dngadobedata' => { 125 => 0xc634 },
	'dngbackwardversion' => { 125 => 0xc613 },
	'dngignoresidecars' => { 534 => 'DNGIgnoreSidecars', 536 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 125 => 0xc630 },
	'dngprivatedata' => { 125 => 0xc634 },
	'dngversion' => { 125 => 0xc612 },
	'document' => { 359 => 'Document' },
	'documentancestors' => { 552 => 'DocumentAncestors' },
	'documenthistory' => { 148 => 0xe7 },
	'documentid' => { 565 => 'DocumentID' },
	'documentname' => { 125 => 0x10d },
	'documentnotes' => { 148 => 0xe6 },
	'doi' => { 554 => 'doi' },
	'dopesheet' => { 548 => 'Dopesheet' },
	'dopesheetlink' => { 548 => 'DopesheetLink' },
	'dopesheetlinklink' => { 548 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 548 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 155 => 0xc82 },
	'dpp' => { 528 => 'dpp' },
	'dprawbokehshift' => { 109 => 0x20b20 },
	'dprawbokehshiftarea' => { 109 => 0x20b21 },
	'dprawghostingreductionarea' => { 109 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 109 => 0x20b10 },
	'dprawmicroadjuststrength' => { 109 => 0x20b12 },
	'dr4cameramodel' => { 110 => 0x3 },
	'drangepriority' => { 133 => 0x1443 },
	'drangepriorityauto' => { 133 => 0x1444 },
	'drangepriorityfixed' => { 133 => 0x1445 },
	'drivemode' => { 119 => 0x3103, 131 => '0.1', 198 => 0x6, 201 => 0x1e, 204 => 0xe, 208 => 0x64d0, 345 => 0x600, 409 => 0x34, 445 => 0x1002, 455 => 0x3, 465 => 0x4, 466 => 0x7e, 467 => 0x34 },
	'drivemode2' => { 201 => 0xa, 388 => 0x7, 476 => 0xe, 484 => 0x1 },
	'drivemodesetting' => { 467 => 0x4 },
	'drivespeed' => { 131 => '0.2' },
	'dspfirmwareversion' => { 409 => 0x27 },
	'dualpixelraw' => { 67 => 0xb },
	'duration' => { 72 => 0x6a, 172 => 'Duration', 186 => 'Duration', 556 => 'duration', 564 => 'duration' },
	'durationscale' => { 564 => [\'duration','durationScale'] },
	'durationvalue' => { 564 => [\'duration','durationValue'] },
	'dustremovaldata' => { 69 => 0x97 },
	'dxcropalert' => { 262 => 0x250, 265 => 0x23c, 266 => 0x250, 267 => 0x250 },
	'dynamicafarea' => { 323 => '1.4', 332 => '1.4' },
	'dynamicafareasize' => { 260 => 0x370, 262 => 0x254, 265 => 0x240, 266 => 0x254, 267 => 0x254 },
	'dynamicareaafassist' => { 339 => 0x18, 340 => 0x18, 341 => 0x18, 342 => 0x18 },
	'dynamicareaafdisplay' => { 324 => '46.1', 326 => '47.1', 327 => '47.1', 336 => '47.1', 337 => '47.1' },
	'dynamicrange' => { 133 => 0x1400 },
	'dynamicrangeboost' => { 370 => 0xee },
	'dynamicrangeexpansion' => { 409 => 0x69, 445 => 0x100e },
	'dynamicrangemax' => { 114 => 0x7c },
	'dynamicrangemin' => { 114 => 0x7a },
	'dynamicrangeoptimizer' => { 201 => 0x15, 479 => [0xb025,0xb04f], 488 => 0x1144, 489 => [0x1144,0x324], 490 => [0x1120,0x300], 491 => [0x119c,0x37c], 492 => [0x1178,0x328], 493 => [0x1030,0x50], 494 => [0x228,0x50], 495 => [0x228,0x50], 496 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 476 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 465 => 0x19, 466 => 0x17, 467 => 0xd, 476 => 0x79, 484 => 0x5 },
	'dynamicrangeoptimizermode' => { 204 => 0x15, 465 => 0x18, 466 => 0x16, 476 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 201 => 0x27, 467 => 0xc, 484 => 0x4 },
	'dynamicrangesetting' => { 133 => 0x1402 },
	'e-dialinprogram' => { 388 => '1.3' },
	'earliestageorloweststage' => { 124 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 138 => 'EarthPos' },
	'earthposaltitude' => { 138 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 138 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 138 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 138 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 138 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 138 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 138 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 138 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 338 => '6.1' },
	'easyexposurecompensation' => { 323 => '6.4', 324 => '6.5', 326 => '6.3', 327 => '6.3', 331 => '5.1', 332 => '4.4', 333 => '5.2', 336 => '6.3', 337 => '6.3', 339 => 0x1f, 340 => 0x1d, 341 => 0x1d, 342 => 0x1d },
	'easymode' => { 37 => 0xb },
	'edgemapslope' => { 155 => 0x930 },
	'edgemapx1' => { 155 => 0x931 },
	'edgemapx2' => { 155 => 0x932 },
	'edgemapx3' => { 155 => 0x934 },
	'edgemapx4' => { 155 => 0x935 },
	'edgenoisereduction' => { 317 => 0x4, 516 => 0x8028 },
	'edit1' => { 435 => "\xa9ed1" },
	'edit2' => { 435 => "\xa9ed2" },
	'edit3' => { 435 => "\xa9ed3" },
	'edit4' => { 435 => "\xa9ed4" },
	'edit5' => { 435 => "\xa9ed5" },
	'edit6' => { 435 => "\xa9ed6" },
	'edit7' => { 435 => "\xa9ed7" },
	'edit8' => { 435 => "\xa9ed8" },
	'edit9' => { 435 => "\xa9ed9" },
	'edition' => { 554 => 'edition' },
	'editorialupdate' => { 148 => 0x8 },
	'editstatus' => { 148 => 0x7, 421 => 'EditStatus', 528 => 'EditStatus' },
	'editversionname' => { 316 => 0x3d136244 },
	'effectivelv' => { 409 => 0x2d },
	'effectivemaxaperture' => { 249 => 0x12, 250 => 0x13, 254 => 0x14 },
	'eissn' => { 554 => 'eIssn' },
	'electricalblackcolumns' => { 155 => 0x1810 },
	'electronicfront-curtainshutter' => { 326 => '5.2', 327 => '5.2', 336 => '5.3', 337 => '5.2' },
	'electronicfrontcurtainshutter' => { 479 => 0x201a },
	'elevation' => { 182 => 'Elevation' },
	'email' => { 174 => 'EMail' },
	'embargodate' => { 557 => 'embargoDate' },
	'embdencrightsexpr' => { 548 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 548 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 548 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 548 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 552 => 'EmbeddedXMPDigest' },
	'emissivity' => { 127 => 0x3 },
	'emptyslotrelease' => { 260 => 0x98c, 263 => 0x723, 264 => 0x783, 265 => 0x625, 266 => 0x655, 267 => 0x6bd },
	'enablechromanoisereduction' => { 155 => 0xe6e },
	'enablesharpening' => { 155 => 0x92e },
	'encodedby' => { 196 => 'WM/EncodedBy', 427 => "\xa9enc" },
	'encodedwith' => { 429 => 'Encoded_With' },
	'encoder' => { 427 => "\xa9too", 429 => 'encoder', 435 => "\xa9too" },
	'encoderid' => { 435 => "\xa9enc" },
	'encodingtime' => { 196 => 'WM/EncodingTime' },
	'encryptionkey' => { 452 => 0xa020 },
	'endingpage' => { 554 => 'endingPage' },
	'enduser' => { 356 => 'EndUser' },
	'enduserid' => { 356 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 356 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 260 => 0x992, 263 => 0x746, 264 => 0x7a6, 265 => 0x648, 266 => 0x678, 267 => 0x6e0 },
	'engineer' => { 564 => 'engineer' },
	'enhancedarktones' => { 309 => 0x8 },
	'enhancedenoisealreadyapplied' => { 531 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 531 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 531 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 531 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 531 => 'EnhanceDetailsVersion' },
	'enhancement' => { 118 => 0x16, 119 => 0x3016 },
	'enhanceparams' => { 125 => 0xc7ee },
	'enhancer' => { 349 => 0x300 },
	'enhancervalues' => { 349 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 531 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 531 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 531 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 149 => 0x28 },
	'envelopepriority' => { 149 => 0x3c },
	'enveloperecordversion' => { 149 => 0x0 },
	'episode' => { 548 => 'Episode' },
	'episodeglobaluniqueid' => { 427 => 'egid' },
	'episodeidentifier' => { 548 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 548 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 548 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 350 => 0x20c },
	'epsonimagewidth' => { 350 => 0x20b },
	'epsonsoftware' => { 350 => 0x20d },
	'equipmentinstitution' => { 519 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 519 => 'EquipmentManufacturer' },
	'equipmentversion' => { 346 => 0x0 },
	'ettlii' => { 90 => 0x304, 91 => 0xd, 92 => 0xe, 93 => 0x7, 94 => 0x7, 95 => 0xe },
	'event' => { 521 => 'Event', 526 => 'Event', 548 => 'Event', 554 => 'event' },
	'eventalias' => { 553 => 'eventAlias' },
	'eventdate' => { 124 => [\'Event','EventEventDate'] },
	'eventday' => { 124 => [\'Event','EventDay'] },
	'eventearliestdate' => { 124 => [\'Event','EventEarliestDate'] },
	'eventend' => { 553 => 'eventEnd' },
	'eventenddayofyear' => { 124 => [\'Event','EventEndDayOfYear'] },
	'eventeventtype' => { 124 => [\'Event','EventEventType'] },
	'eventfieldnotes' => { 124 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 124 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 124 => [\'Event','EventHabitat'] },
	'eventid' => { 124 => [\'Event','EventEventID'], 548 => 'EventId' },
	'eventlatestdate' => { 124 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 124 => [\'Event','EventMonth'] },
	'eventnumber' => { 437 => 0x9, 438 => 0x3a, 439 => 0x2b, 440 => 0x4a, 441 => 0x37 },
	'eventparenteventid' => { 124 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 124 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 124 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 124 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 124 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 124 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 553 => 'eventStart' },
	'eventstartdayofyear' => { 124 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 553 => 'eventSubtype' },
	'eventtime' => { 124 => [\'Event','EventEventTime'] },
	'eventtype' => { 553 => 'eventType' },
	'eventverbatimeventdate' => { 124 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 124 => [\'Event','EventYear'] },
	'evfgrid' => { 339 => 0x15f, 340 => 0x165, 341 => 0x165, 342 => 0x17d },
	'evfimageframe' => { 339 => 0x15e, 340 => 0x164, 341 => 0x164, 342 => 0x17c },
	'evfreleaseindicator' => { 340 => 0x24f, 341 => 0x24f, 342 => 0x267 },
	'evfwarmdisplaybrightness' => { 340 => 0x24d, 341 => 0x24d, 342 => 0x265 },
	'evfwarmdisplaymode' => { 340 => 0x24b, 341 => 0x24b, 342 => 0x263 },
	'evsteps' => { 388 => '1.2', 390 => 0x0 },
	'evstepsize' => { 328 => '5.1', 329 => '6.1', 330 => '6.1', 334 => '0.7' },
	'exclusivecoverage' => { 522 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 557 => 'exclusivityEndDate' },
	'excursiontolerance' => { 150 => 0x82 },
	'executiveproducer' => { 427 => "\xa9xpd" },
	'exif' => { 126 => 'EXIF' },
	'exifbyteorder' => { 126 => 'ExifByteOrder' },
	'exifcamerainfo' => { 148 => 0xe8 },
	'exifimageheight' => { 125 => 0xa003, 540 => 'PixelYDimension' },
	'exifimagewidth' => { 125 => 0xa002, 540 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 126 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 125 => 0x9000, 540 => 'ExifVersion' },
	'exitpupilposition' => { 249 => 0x4, 250 => 0x4, 254 => 0x4 },
	'expirationdate' => { 148 => 0x25, 557 => 'expirationDate' },
	'expirationtime' => { 148 => 0x26 },
	'exposure' => { 125 => 0xfe51, 534 => 'Exposure', 536 => 'Exposure' },
	'exposure2012' => { 534 => 'Exposure2012', 536 => 'Exposure2012' },
	'exposureadj' => { 314 => 0x0 },
	'exposureadj2' => { 314 => 0x12 },
	'exposureadjust' => { 455 => 0xc },
	'exposurebracketingindicatorlast' => { 201 => 0x52 },
	'exposurebracketshotnumber' => { 204 => 0x2d, 476 => 0x2f },
	'exposurebracketstepsize' => { 388 => 0x8 },
	'exposurebracketvalue' => { 256 => 0x19 },
	'exposurecompautocancel' => { 90 => 0x113 },
	'exposurecompensation' => { 82 => 0x6, 99 => 0x0, 125 => 0x9204, 157 => 0x24, 173 => 'ExposureComp', 193 => 'ExposureCompensation', 198 => 0xd, 199 => 0x53, 200 => 0x1e, 204 => 0x49c0, 350 => 0x1006, 409 => 0x16, 418 => 0x402, 452 => 0xa013, 455 => [0xc,0x35,0x47,0x4d], 488 => 0x114c, 489 => 0x114c, 490 => 0x1128, 492 => 0x1180, 493 => 0x1038, 494 => 0x230, 495 => 0x230, 496 => 0x223, 540 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 484 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 267 => 0x794 },
	'exposurecompensationmode' => { 201 => 0x47, 204 => 0x2a },
	'exposurecompensationset' => { 465 => 0x3, 466 => 0x3, 467 => 0x3, 484 => 0x1e },
	'exposurecompensationsetting' => { 201 => 0x1 },
	'exposurecompstepsize' => { 323 => '6.3', 324 => '7.3', 326 => '7.3', 327 => '7.3', 332 => '4.3', 336 => '7.3', 337 => '7.3' },
	'exposurecontrolstep' => { 331 => '6.1', 333 => '6.1' },
	'exposurecontrolstepsize' => { 323 => '6.2', 324 => '7.1', 326 => '7.1', 327 => '7.1', 332 => '4.2', 336 => '7.1', 337 => '7.1', 338 => '7.1', 339 => 0x1d, 340 => 0x1b, 341 => 0x1b, 342 => 0x1b },
	'exposurecount' => { 133 => 0x1032 },
	'exposuredelay' => { 267 => 0x800, 340 => 0x2f1 },
	'exposuredelaymode' => { 323 => '10.1', 324 => '11.1', 326 => '11.1', 327 => '11.1', 328 => '9.1', 329 => '10.1', 330 => '10.1', 332 => '10.4', 333 => '10.1', 334 => '6.4', 336 => '11.1', 337 => '11.1', 338 => '11.2' },
	'exposuredifference' => { 256 => 0xe },
	'exposuregaincustom' => { 155 => 0x89c },
	'exposuregaindaylight' => { 155 => 0x898 },
	'exposuregainflash' => { 155 => 0x89b },
	'exposuregainfluorescent' => { 155 => 0x89a },
	'exposuregaintungsten' => { 155 => 0x899 },
	'exposureindex' => { 125 => 0xa215, 540 => 'ExposureIndex' },
	'exposureindicator' => { 201 => 0x50 },
	'exposurelevelincrements' => { 88 => 0x6, 89 => 0x6, 90 => 0x101, 91 => 0x5, 92 => 0x6, 93 => 0x5, 94 => 0x5, 95 => 0x6, 96 => 0x4, 465 => 0x58, 466 => 0x58 },
	'exposurelockused' => { 146 => 'ExposureLockUsed' },
	'exposuremode' => { 125 => 0xa402, 173 => 'ExposureMode', 198 => 0x1, 199 => 0xa, 200 => 0x0, 201 => 0x0, 204 => 0x34, 345 => 0x200, 367 => 0x40d, 455 => 0x8, 479 => 0xb041, 540 => 'ExposureMode' },
	'exposuremodeinmanual' => { 90 => 0x10b },
	'exposureprogram' => { 125 => 0x8822, 445 => 0x1001, 458 => [0x17e,0x43], 465 => 0x3c, 466 => 0x3c, 467 => 0x5, 471 => 0x14, 476 => 0x3f, 484 => 0x2, 488 => 0x1175, 489 => 0x1179, 490 => 0x1155, 491 => 0x11d1, 492 => 0x11ad, 493 => 0x1065, 494 => 0x25d, 495 => 0x25d, 496 => 0x24c, 507 => 0xb, 508 => 0xc, 509 => 0xb, 511 => 0x48, 540 => 'ExposureProgram' },
	'exposureshift' => { 345 => 0x203 },
	'exposurestandardadjustment' => { 479 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 82 => 0x16, 125 => 0x829a, 154 => 0xfd05, 157 => 0x20, 159 => 0xfa24, 161 => 0xf104, 164 => 0x12, 166 => 0x38, 168 => 0x14, 169 => 0x10, 171 => 0x10, 173 => 'ExposureTime', 198 => 0x9, 199 => 0x35, 200 => 0x48, 201 => 0x8, 204 => 0x49b8, 409 => 0x12, 452 => 0xa018, 455 => [0x32,0x4a], 465 => 0x0, 466 => 0x0, 484 => [0x21,0x23,0x27], 511 => 0x10, 540 => 'ExposureTime' },
	'exposuretime2' => { 455 => [0x33,0x4b] },
	'exposuretuning' => { 256 => 0x1c },
	'exposurevalue' => { 155 => 0x3 },
	'exposurewarning' => { 133 => 0x1302 },
	'exrauto' => { 133 => 0x1033 },
	'exrmode' => { 133 => 0x1034 },
	'extdescraccessibility' => { 547 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 262 => 0x120, 265 => 0x114, 266 => 0x124, 267 => 0x124 },
	'extendedshutterspeeds' => { 339 => 0xf2, 340 => 0x102, 341 => 0x102, 342 => 0x118 },
	'extendedwbdetect' => { 345 => 0x902 },
	'extender' => { 346 => 0x301 },
	'extenderfirmwareversion' => { 346 => 0x304 },
	'extendermagnification' => { 175 => 'Magnification' },
	'extendermake' => { 175 => 'Make' },
	'extendermodel' => { 175 => 'Model', 346 => 0x303 },
	'extenderserialnumber' => { 175 => 'SerialNumber', 346 => 0x302 },
	'extenderstatus' => { 406 => 0x3 },
	'externalflash' => { 348 => 0x1201 },
	'externalflashae1' => { 350 => 0x101f },
	'externalflashae1_0' => { 350 => 0x101b },
	'externalflashae2' => { 350 => 0x1020 },
	'externalflashae2_0' => { 350 => 0x101c },
	'externalflashbounce' => { 348 => 0x1204, 350 => 0x1026, 396 => 0x1a },
	'externalflashcompensation' => { 236 => 0x1b },
	'externalflashexposurecomp' => { 256 => 0x17, 396 => 0x19 },
	'externalflashfirmware' => { 234 => 0x6, 235 => 0x6, 236 => 0x6, 237 => 0x6, 238 => 0x6, 239 => 0x6 },
	'externalflashflags' => { 234 => 0x8, 235 => 0x8, 236 => 0x8, 237 => 0x8, 239 => 0x8 },
	'externalflashguidenumber' => { 348 => 0x1203, 396 => '24.1' },
	'externalflashgvalue' => { 350 => 0x1025 },
	'externalflashmode' => { 350 => 0x1028, 396 => 0x2 },
	'externalflashreadystate' => { 238 => '9.1' },
	'externalflashstatus' => { 238 => '8.2' },
	'externalflashzoom' => { 348 => 0x1205, 350 => 0x1027 },
	'externalflashzoomoverride' => { 238 => '8.1' },
	'externalmetadatalink' => { 548 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 365 => 0x311, 368 => 0x311, 369 => 0x311, 372 => 0x3408 },
	'extrainfoversion' => { 469 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 201 => 0x40 },
	'fac100per' => { 155 => 0xe94 },
	'fac170per' => { 155 => 0xe93 },
	'fac18per' => { 155 => 0xe92 },
	'face10aarea' => { 392 => 0xbe },
	'face10aeye1' => { 392 => 0xc2 },
	'face10aeye2' => { 392 => 0xc6 },
	'face10barea' => { 392 => 0x186 },
	'face10beye1' => { 392 => 0x18a },
	'face10beye2' => { 392 => 0x18e },
	'face10position' => { 116 => 0x3f4, 117 => 0x1ec, 232 => 0x28, 393 => 0x12 },
	'face10size' => { 394 => 0x12 },
	'face11position' => { 232 => 0x2c, 393 => 0x14 },
	'face11size' => { 394 => 0x14 },
	'face12position' => { 232 => 0x30, 393 => 0x16 },
	'face12size' => { 394 => 0x16 },
	'face13position' => { 393 => 0x18 },
	'face13size' => { 394 => 0x18 },
	'face14position' => { 393 => 0x1a },
	'face14size' => { 394 => 0x1a },
	'face15position' => { 393 => 0x1c },
	'face15size' => { 394 => 0x1c },
	'face16position' => { 393 => 0x1e },
	'face16size' => { 394 => 0x1e },
	'face17position' => { 393 => 0x20 },
	'face17size' => { 394 => 0x20 },
	'face18position' => { 393 => 0x22 },
	'face18size' => { 394 => 0x22 },
	'face19position' => { 393 => 0x24 },
	'face19size' => { 394 => 0x24 },
	'face1aarea' => { 392 => 0xa },
	'face1aeye1' => { 392 => 0xe },
	'face1aeye2' => { 392 => 0x12 },
	'face1barea' => { 392 => 0xd2 },
	'face1beye1' => { 392 => 0xd6 },
	'face1beye2' => { 392 => 0xda },
	'face1position' => { 58 => 0x8, 116 => 0xd, 117 => 0x18, 232 => 0x4, 362 => 0x1, 393 => 0x0, 442 => 0xbc, 472 => 0x1, 473 => 0x0, 474 => 0x0, 475 => 0x5b },
	'face1size' => { 394 => 0x0 },
	'face20position' => { 393 => 0x26 },
	'face20size' => { 394 => 0x26 },
	'face21position' => { 393 => 0x28 },
	'face21size' => { 394 => 0x28 },
	'face22position' => { 393 => 0x2a },
	'face22size' => { 394 => 0x2a },
	'face23position' => { 393 => 0x2c },
	'face23size' => { 394 => 0x2c },
	'face24position' => { 393 => 0x2e },
	'face24size' => { 394 => 0x2e },
	'face25position' => { 393 => 0x30 },
	'face25size' => { 394 => 0x30 },
	'face26position' => { 393 => 0x32 },
	'face26size' => { 394 => 0x32 },
	'face27position' => { 393 => 0x34 },
	'face27size' => { 394 => 0x34 },
	'face28position' => { 393 => 0x36 },
	'face28size' => { 394 => 0x36 },
	'face29position' => { 393 => 0x38 },
	'face29size' => { 394 => 0x38 },
	'face2aarea' => { 392 => 0x1e },
	'face2aeye1' => { 392 => 0x22 },
	'face2aeye2' => { 392 => 0x26 },
	'face2barea' => { 392 => 0xe6 },
	'face2beye1' => { 392 => 0xea },
	'face2beye2' => { 392 => 0xee },
	'face2position' => { 58 => 0xa, 116 => 0x7c, 117 => 0x4c, 232 => 0x8, 362 => 0x5, 393 => 0x2, 442 => 0xc8, 472 => 0x6, 473 => 0x20, 474 => 0x25, 475 => 0x65 },
	'face2size' => { 394 => 0x2 },
	'face30position' => { 393 => 0x3a },
	'face30size' => { 394 => 0x3a },
	'face31position' => { 393 => 0x3c },
	'face31size' => { 394 => 0x3c },
	'face32position' => { 393 => 0x3e },
	'face32size' => { 394 => 0x3e },
	'face3aarea' => { 392 => 0x32 },
	'face3aeye1' => { 392 => 0x36 },
	'face3aeye2' => { 392 => 0x3a },
	'face3barea' => { 392 => 0xfa },
	'face3beye1' => { 392 => 0xfe },
	'face3beye2' => { 392 => 0x102 },
	'face3position' => { 58 => 0xc, 116 => 0xeb, 117 => 0x80, 232 => 0xc, 362 => 0x9, 393 => 0x4, 442 => 0xd4, 472 => 0xb, 473 => 0x40, 474 => 0x4a, 475 => 0x6f },
	'face3size' => { 394 => 0x4 },
	'face4aarea' => { 392 => 0x46 },
	'face4aeye1' => { 392 => 0x4a },
	'face4aeye2' => { 392 => 0x4e },
	'face4barea' => { 392 => 0x10e },
	'face4beye1' => { 392 => 0x112 },
	'face4beye2' => { 392 => 0x116 },
	'face4position' => { 58 => 0xe, 116 => 0x15a, 117 => 0xb4, 232 => 0x10, 362 => 0xd, 393 => 0x6, 442 => 0xe0, 472 => 0x10, 473 => 0x60, 474 => 0x6f, 475 => 0x79 },
	'face4size' => { 394 => 0x6 },
	'face5aarea' => { 392 => 0x5a },
	'face5aeye1' => { 392 => 0x5e },
	'face5aeye2' => { 392 => 0x62 },
	'face5barea' => { 392 => 0x122 },
	'face5beye1' => { 392 => 0x126 },
	'face5beye2' => { 392 => 0x12a },
	'face5position' => { 58 => 0x10, 116 => 0x1c9, 117 => 0xe8, 232 => 0x14, 362 => 0x11, 393 => 0x8, 442 => 0xec, 472 => 0x15, 473 => 0x80, 474 => 0x94 },
	'face5size' => { 394 => 0x8 },
	'face6aarea' => { 392 => 0x6e },
	'face6aeye1' => { 392 => 0x72 },
	'face6aeye2' => { 392 => 0x76 },
	'face6barea' => { 392 => 0x136 },
	'face6beye1' => { 392 => 0x13a },
	'face6beye2' => { 392 => 0x13e },
	'face6position' => { 58 => 0x12, 116 => 0x238, 117 => 0x11c, 232 => 0x18, 393 => 0xa, 442 => 0xf8, 472 => 0x1a, 473 => 0xa0, 474 => 0xb9 },
	'face6size' => { 394 => 0xa },
	'face7aarea' => { 392 => 0x82 },
	'face7aeye1' => { 392 => 0x86 },
	'face7aeye2' => { 392 => 0x8a },
	'face7barea' => { 392 => 0x14a },
	'face7beye1' => { 392 => 0x14e },
	'face7beye2' => { 392 => 0x152 },
	'face7position' => { 58 => 0x14, 116 => 0x2a7, 117 => 0x150, 232 => 0x1c, 393 => 0xc, 442 => 0x104, 472 => 0x1f, 473 => 0xc0, 474 => 0xde },
	'face7size' => { 394 => 0xc },
	'face8aarea' => { 392 => 0x96 },
	'face8aeye1' => { 392 => 0x9a },
	'face8aeye2' => { 392 => 0x9e },
	'face8barea' => { 392 => 0x15e },
	'face8beye1' => { 392 => 0x162 },
	'face8beye2' => { 392 => 0x166 },
	'face8position' => { 58 => 0x16, 116 => 0x316, 117 => 0x184, 232 => 0x20, 393 => 0xe, 442 => 0x110, 472 => 0x24, 473 => 0xe0, 474 => 0x103 },
	'face8size' => { 394 => 0xe },
	'face9aarea' => { 392 => 0xaa },
	'face9aeye1' => { 392 => 0xae },
	'face9aeye2' => { 392 => 0xb2 },
	'face9barea' => { 392 => 0x172 },
	'face9beye1' => { 392 => 0x176 },
	'face9beye2' => { 392 => 0x17a },
	'face9position' => { 58 => 0x18, 116 => 0x385, 117 => 0x1b8, 232 => 0x24, 393 => 0x10 },
	'face9size' => { 394 => 0x10 },
	'facebalanceorigi' => { 527 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 527 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 527 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 527 => 'FaceBalanceWarmth' },
	'facedetect' => { 409 => 0x76, 452 => 0x100 },
	'facedetectarea' => { 349 => 0x1201 },
	'facedetectframecrop' => { 349 => 0x1207 },
	'facedetectframesize' => { 58 => 0x3, 116 => 0x1, 117 => 0x4, 232 => 0x1, 349 => 0x1203, 409 => 0x77, 442 => 0xb6 },
	'facedetection' => { 467 => 0x30, 484 => 0x19 },
	'faceelementpositions' => { 133 => 0x4203 },
	'faceelementselected' => { 133 => 0x4005 },
	'faceelementtypes' => { 133 => 0x4201 },
	'faceid' => { 530 => 'FaceID' },
	'faceimagesize' => { 392 => 0x0 },
	'faceinfok3iii' => { 392 => '0.1' },
	'faceinfounknown' => { 119 => 0x2089 },
	'facename' => { 452 => 0x123 },
	'faceorientation' => { 117 => 0x8 },
	'faceposition' => { 391 => 0x2, 453 => 0x4 },
	'facepositions' => { 133 => 0x4103 },
	'facerecognition' => { 452 => 0x120 },
	'facesdetected' => { 58 => 0x2, 59 => 0x2, 60 => 0x3, 116 => 0x0, 117 => 0x2, 119 => 0x211c, 133 => 0x4100, 232 => 0x3, 349 => 0x1200, 370 => 0x3f, 391 => 0x0, 442 => 0xb5, 453 => 0x0, 472 => 0x0, 475 => 0x3, 487 => 0x30 },
	'facesdetecteda' => { 392 => 0x6 },
	'facesdetectedb' => { 392 => 0x8 },
	'facesrecognized' => { 363 => 0x0 },
	'facewidth' => { 59 => 0x1 },
	'fade' => { 455 => 0x138, 479 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 115 => 0x38 },
	'faithfuloutputshadowpoint' => { 115 => 0x39 },
	'faithfulrawcolortone' => { 115 => 0x31 },
	'faithfulrawcontrast' => { 115 => 0x33 },
	'faithfulrawhighlight' => { 115 => 0x79 },
	'faithfulrawhighlightpoint' => { 115 => 0x36 },
	'faithfulrawlinear' => { 115 => 0x34 },
	'faithfulrawsaturation' => { 115 => 0x32 },
	'faithfulrawshadow' => { 115 => 0x82 },
	'faithfulrawshadowpoint' => { 115 => 0x37 },
	'faithfulrawsharpness' => { 115 => 0x35 },
	'faithfulunsharpmaskfineness' => { 115 => 0xac },
	'faithfulunsharpmaskstrength' => { 115 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 115 => 0xae },
	'far' => { 143 => 'Far' },
	'fastresetlinetime' => { 155 => 0x1860 },
	'feedidentifier' => { 548 => 'FeedIdentifier' },
	'femicroadjustment' => { 90 => 0x111 },
	'ffid' => { 538 => 'ffid' },
	'field' => { 553 => 'field' },
	'fieldcount' => { 350 => 0x103f },
	'fieldofview' => { 435 => "FOV\x00" },
	'fifoenonepixeldelay' => { 155 => 0x1901 },
	'filecreatedate' => { 126 => 'FileCreateDate' },
	'filedatarate' => { 564 => 'fileDataRate' },
	'fileformat' => { 101 => 0x0, 149 => 0x14, 455 => [0x22,0x26], 479 => 0xb000 },
	'filegroupid' => { 126 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 371 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 126 => 'FileModifyDate' },
	'filename' => { 126 => 'FileName' },
	'filenameasdelivered' => { 356 => 'FileNameAsDelivered' },
	'filenumber' => { 61 => 0x1, 69 => 0x8, 103 => 0x1817, 120 => 'Canon-FileNumber', 233 => 0x4, 438 => 0x10, 439 => 0x95, 440 => 0x10 },
	'filenumbermemory' => { 198 => 0x1a },
	'filenumbersequence' => { 323 => '12.2', 328 => '3.1', 329 => '4.1', 330 => '4.1', 332 => '11.1', 333 => '4.3', 338 => '5.2', 339 => 0x4e, 340 => 0x48, 341 => 0x48, 342 => 0x48 },
	'filepermissions' => { 126 => 'FilePermissions' },
	'filesource' => { 125 => 0xa300, 133 => 0x8000, 540 => 'FileSource' },
	'fileuserid' => { 126 => 'FileUserID' },
	'fileversion' => { 149 => 0x16 },
	'fillflashautoreduction' => { 88 => 0xe, 89 => 0xe, 96 => 0xa },
	'filllight' => { 534 => 'FillLight', 536 => 'FillLight' },
	'fillorder' => { 125 => 0x10a },
	'filmgraineffect' => { 345 => 0x538 },
	'filmmode' => { 133 => 0x1401, 367 => 0x412, 370 => 0x42 },
	'filmtype' => { 282 => 0x2 },
	'filtereffect' => { 61 => 0xe, 274 => 0x37, 275 => 0x3f, 276 => 0x47, 370 => 0xa1 },
	'filtereffectauto' => { 76 => 0xa0 },
	'filtereffectfaithful' => { 75 => 0x70, 76 => 0x70 },
	'filtereffectlandscape' => { 75 => 0x40, 76 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 75 => 0x88, 76 => 0x88 },
	'filtereffectneutral' => { 75 => 0x58, 76 => 0x58 },
	'filtereffectportrait' => { 75 => 0x28, 76 => 0x28 },
	'filtereffectstandard' => { 75 => 0x10, 76 => 0x10 },
	'filtereffectuserdef1' => { 75 => 0xa0, 76 => 0xb8 },
	'filtereffectuserdef2' => { 75 => 0xb8, 76 => 0xd0 },
	'filtereffectuserdef3' => { 75 => 0xd0, 76 => 0xe8 },
	'finderdisplayduringexposure' => { 89 => 0x1 },
	'finesharpness' => { 409 => 0x70 },
	'finetuneoptcenterweighted' => { 323 => '7.2', 324 => '9.1', 326 => '9.1', 327 => '9.1', 331 => '8.1', 336 => '9.1', 337 => '9.1', 338 => '9.1', 339 => 0x25, 340 => 0x23, 341 => 0x23, 342 => 0x23 },
	'finetuneopthighlightweighted' => { 326 => '46.1', 327 => '46.1', 336 => '46.1', 337 => '46.1', 339 => 0x29, 340 => 0x27, 341 => 0x27, 342 => 0x27 },
	'finetuneoptmatrixmetering' => { 323 => '8.1', 324 => '8.2', 326 => '8.2', 327 => '8.2', 331 => '7.2', 332 => '6.1', 336 => '8.2', 337 => '8.2', 338 => '8.2', 339 => 0x23, 340 => 0x21, 341 => 0x21, 342 => 0x21 },
	'finetuneoptspotmetering' => { 323 => '8.2', 324 => '9.2', 326 => '9.2', 327 => '9.2', 331 => '8.2', 332 => '6.2', 336 => '9.2', 337 => '9.2', 338 => '9.2', 339 => 0x27, 340 => 0x25, 341 => 0x25, 342 => 0x25 },
	'finishexposure' => { 155 => 0xdbd },
	'finishfiletype' => { 155 => 0xdb8 },
	'finishlook' => { 155 => 0xdbc },
	'finishnoise' => { 155 => 0xdba },
	'finishresolution' => { 155 => 0xdb9 },
	'finishsharpening' => { 155 => 0xdbb },
	'firmware' => { 350 => 0x405, 455 => [0x8c,0x17,0x3b], 531 => 'Firmware' },
	'firmware2' => { 455 => 0x57 },
	'firmwaredate' => { 118 => 0x15, 119 => 0x2001, 437 => 0x4, 438 => 0x30, 440 => 0x30 },
	'firmwareid' => { 205 => 0x0 },
	'firmwarename' => { 452 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 69 => 0x1e, 443 => 0x0 },
	'firmwarerevision2' => { 443 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 155 => [0x415,0xce5], 171 => 0x57, 173 => 'FirmwareVersion', 368 => 0x320, 370 => 0x2, 372 => 0x3109, 409 => 0x230, 435 => ['CNFV','FIRM','info'], 438 => 0x2a, 439 => 0x1a, 440 => 0x2a, 441 => 0x18, 445 => 0x2 },
	'firmwareversions' => { 418 => 0x301 },
	'firstframeactioninafc' => { 381 => 0x21f },
	'firstphotodate' => { 146 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 356 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 148 => 0x16, 528 => 'FixtureIdentifier' },
	'flash' => { 120 => 'XMP-Flash', 125 => 0x9209, 169 => 0x22, 199 => 0x1f, 200 => 0x15, 438 => 0x5a, 439 => 0x44, 440 => 0x6a, 540 => 'Flash' },
	'flashaction' => { 465 => 0x3e, 466 => 0x3e, 479 => 0x2017, 484 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 465 => 0x4c, 466 => 0x4c, 484 => 0x77 },
	'flashactionexternal' => { 484 => [0x78,0x7c] },
	'flashactivity' => { 37 => 0x1c },
	'flashbatterylevel' => { 48 => 0x249 },
	'flashbias' => { 370 => 0x24 },
	'flashbits' => { 37 => 0x1d },
	'flashburstpriority' => { 339 => 0x101, 340 => 0x111, 341 => 0x111, 342 => 0x129 },
	'flashbuttonfunction' => { 90 => 0x70e },
	'flashchargelevel' => { 350 => 0x1010 },
	'flashcolorfilter' => { 236 => 0x10, 237 => 0x10, 239 => 0x10 },
	'flashcommandermode' => { 234 => '9.1', 235 => '9.1', 236 => '9.1', 237 => '9.1', 239 => '9.1' },
	'flashcompensation' => { 155 => 0x3f3, 234 => 0xa, 235 => 0xa, 236 => 0xa, 237 => 0x27, 238 => 0xa, 239 => 0xa, 531 => 'FlashCompensation' },
	'flashcontrol' => { 465 => 0x23, 466 => 0x1f, 467 => 0x21 },
	'flashcontrolbuilt-in' => { 332 => '16.1', 333 => '23.1', 335 => '23.1', 336 => '24.1' },
	'flashcontrolmode' => { 234 => '9.2', 235 => '9.2', 236 => '9.2', 237 => '9.2', 239 => '9.2', 245 => 0x214, 260 => 0x2d4, 261 => 0x148, 262 => 0x1b8, 265 => 0x1a8, 266 => 0x1bc, 267 => 0x1bc, 345 => 0x404 },
	'flashcurtain' => { 370 => 0x48 },
	'flashdefault' => { 201 => 0x42 },
	'flashdevice' => { 350 => 0x1005 },
	'flashdistance' => { 119 => 0x2034 },
	'flashenergy' => { 125 => 0xa20b, 540 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 256 => 0x18 },
	'flashexposurecomp' => { 82 => 0xf, 133 => 0x1011, 176 => 'ExposureComp', 198 => 0x23, 203 => 0x104, 204 => 0x49c1, 256 => 0x12, 345 => 0x401, 350 => 0x1023, 409 => 0x4d, 445 => 0x100b, 455 => [0x3a,0x56], 479 => 0x104 },
	'flashexposurecomp2' => { 303 => 0x4d2 },
	'flashexposurecomp3' => { 236 => 0x1d },
	'flashexposurecomp4' => { 236 => 0x27 },
	'flashexposurecomparea' => { 324 => '38.4', 326 => '38.4', 327 => '38.4', 336 => '38.4', 337 => '38.4', 339 => 0x5d, 340 => 0x59, 341 => 0x59, 342 => 0x59 },
	'flashexposurecompset' => { 201 => 0x10, 378 => 0xe, 465 => 0x14, 466 => 0x12, 467 => 0x23, 484 => 0x1f },
	'flashexposurecompset2' => { 484 => [0x26,0x2c] },
	'flashexposureindicator' => { 201 => 0x54 },
	'flashexposureindicatorlast' => { 201 => 0x56 },
	'flashexposureindicatornext' => { 201 => 0x55 },
	'flashexposurelock' => { 61 => 0x19 },
	'flashfired' => { 157 => 0x5d, 176 => 'Fired', 198 => 0x14, 302 => '590.3', 540 => [\'Flash','FlashFired'] },
	'flashfiring' => { 90 => 0x306, 91 => 0x6, 92 => 0x7, 95 => 0x7 },
	'flashfirmwareversion' => { 346 => 0x1002 },
	'flashfocallength' => { 234 => 0xb, 235 => 0xc, 236 => 0xc, 237 => 0xc, 238 => 0xc, 239 => 0x26 },
	'flashfunction' => { 204 => 0x31, 540 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 234 => 0xe, 235 => 0xf, 236 => 0xf, 237 => 0xf, 238 => 0xf, 239 => 0xf, 245 => 0x21a, 260 => 0x2da, 261 => 0x14e, 265 => 0x1ae, 266 => 0x1c2, 267 => 0x1c2 },
	'flashgroupacompensation' => { 234 => 0x11, 235 => 0x12, 236 => 0x13, 237 => 0x28, 238 => 0x28, 239 => 0x28 },
	'flashgroupacontrolmode' => { 234 => 0xf, 235 => '16.1', 236 => '17.1', 237 => '17.1', 238 => '17.1', 239 => '17.1' },
	'flashgroupaoutput' => { 234 => 0x11, 235 => 0x12, 236 => 0x13, 237 => 0x28, 238 => 0x28, 239 => 0x28 },
	'flashgroupbcompensation' => { 234 => 0x12, 235 => 0x13, 236 => 0x14, 237 => 0x29, 238 => 0x29, 239 => 0x29 },
	'flashgroupbcontrolmode' => { 234 => 0x10, 235 => '17.1', 236 => '18.1', 237 => '18.1', 238 => '18.1', 239 => '18.1' },
	'flashgroupboutput' => { 234 => 0x12, 235 => 0x13, 236 => 0x14, 237 => 0x29, 238 => 0x29, 239 => 0x29 },
	'flashgroupccompensation' => { 235 => 0x14, 236 => 0x15, 237 => 0x2a, 238 => 0x2a, 239 => 0x2a },
	'flashgroupccontrolmode' => { 235 => '17.2', 236 => '18.2', 237 => '18.2', 238 => '18.2', 239 => '18.2' },
	'flashgroupcoutput' => { 235 => 0x14, 236 => 0x15, 237 => 0x2a, 238 => 0x2a, 239 => 0x2a },
	'flashguidenumber' => { 82 => 0xd, 100 => 0x0, 176 => 'GuideNumber' },
	'flashilluminationpattern' => { 239 => 0x25 },
	'flashintensity' => { 118 => [0x19,0x5], 345 => 0x405 },
	'flashlevel' => { 325 => 0x9, 479 => 0xb048 },
	'flashmake' => { 176 => 'Make' },
	'flashmanufacturer' => { 195 => 'FlashManufacturer' },
	'flashmastercompensation' => { 245 => 0x22e, 260 => 0x2ee, 261 => 0x162, 265 => 0x1aa, 266 => 0x1be, 267 => 0x1be },
	'flashmastercontrolmode' => { 245 => 0x22c, 260 => 0x2ec, 261 => 0x160 },
	'flashmasteroutput' => { 245 => 0x232, 260 => 0x2f2, 261 => 0x166 },
	'flashmetering' => { 198 => 0x3f, 201 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 409 => 0x20a },
	'flashmode' => { 118 => 0x4, 155 => 0x3f2, 157 => 0x5c, 168 => 0x27, 176 => 'Mode', 198 => 0x2, 199 => 0x20, 200 => 0x16, 201 => 0xf, 256 => 0x87, 345 => 0x400, 350 => 0x1004, 409 => 0xc, 416 => 0x4, 444 => 0x20, 445 => 0x100a, 454 => 0x225, 465 => 0x13, 466 => 0x7f, 467 => 0x20, 484 => 0x10, 488 => 0x1138, 489 => 0x1138, 490 => 0x1114, 491 => 0x1190, 492 => 0x116c, 493 => 0x1024, 494 => 0x21c, 495 => 0x21c, 496 => 0x211, 540 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 267 => 0x80e },
	'flashmodebuttonplaybackmode' => { 267 => 0x818 },
	'flashmodel' => { 176 => 'Model', 195 => 'FlashModel', 346 => 0x1001 },
	'flashoptions' => { 388 => 0x2 },
	'flashoptions2' => { 388 => 0x10 },
	'flashoutput' => { 48 => 0x248, 82 => 0x21, 234 => 0xa, 235 => 0xa, 236 => 0xa, 237 => 0x27, 239 => 0x21, 245 => 0x21e, 260 => 0x2de, 261 => 0x152, 265 => 0x1b2, 266 => 0x1c6, 267 => 0x1c6 },
	'flashpixversion' => { 125 => 0xa000, 540 => 'FlashpixVersion' },
	'flashredeyemode' => { 540 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 245 => 0x228, 260 => 0x2e8, 261 => 0x15c, 265 => 0x1bc, 345 => 0x403 },
	'flashreturn' => { 540 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 176 => 'SerialNumber', 346 => 0x1003 },
	'flashsetting' => { 256 => 0x8 },
	'flashshutterspeed' => { 323 => '20.2', 324 => '23.2', 326 => '23.2', 327 => '23.2', 332 => '15.2', 333 => '22.2', 334 => '7.2', 335 => '22.2', 336 => '23.2', 337 => '23.2', 338 => '23.1', 339 => 0x5b, 340 => 0x57, 341 => 0x57, 342 => 0x57 },
	'flashsource' => { 234 => 0x4, 235 => 0x4, 236 => 0x4, 237 => 0x4, 238 => 0x4, 239 => 0x4 },
	'flashstatus' => { 396 => 0x0, 484 => [0x82,0x86], 498 => 0x31, 499 => 0x39, 500 => 0x39 },
	'flashstatusbuilt-in' => { 467 => [0x87,0x287] },
	'flashstatusexternal' => { 467 => [0x88,0x288] },
	'flashsyncspeed' => { 323 => '20.1', 324 => '23.1', 326 => '23.1', 327 => '23.1', 332 => '15.1', 333 => '22.1', 335 => '22.1', 336 => '23.1', 337 => '23.1', 339 => 0x57, 340 => 0x53, 341 => 0x53, 342 => 0x53 },
	'flashsyncspeedav' => { 88 => 0x3, 90 => 0x10f, 91 => 0x2, 92 => 0x3, 93 => 0x2, 94 => 0x2, 95 => 0x3, 96 => 0x6 },
	'flashthreshold' => { 100 => 0x1 },
	'flashtype' => { 176 => 'Type', 201 => 0x59, 256 => 0x9, 346 => 0x1000 },
	'flashwarning' => { 333 => '30.1', 334 => '7.1', 338 => '31.1', 370 => 0x62 },
	'flashwirelessoption' => { 245 => 0x234, 260 => 0x2e6, 261 => 0x15a, 265 => 0x1c8 },
	'flexiblespotposition' => { 479 => 0x201d },
	'flickadvancedirection' => { 340 => 0x25f, 341 => 0x25f, 342 => 0x277 },
	'flickerreduce' => { 454 => 0x218 },
	'flickerreduction' => { 133 => 0x1446, 286 => 0x7 },
	'flickerreductionindicator' => { 281 => 0x532 },
	'flickerreductionshooting' => { 260 => 0x2d0, 262 => 0x1b4, 265 => 0x1a4, 266 => 0x1b8, 267 => 0x1b8 },
	'flightpitchdegree' => { 122 => 'FlightPitchDegree' },
	'flightrolldegree' => { 122 => 'FlightRollDegree' },
	'flightxspeed' => { 122 => 'FlightXSpeed' },
	'flightyawdegree' => { 122 => 'FlightYawDegree' },
	'flightyspeed' => { 122 => 'FlightYSpeed' },
	'flightzspeed' => { 122 => 'FlightZSpeed' },
	'fliphorizontal' => { 316 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 82 => 0x15, 125 => 0x829d, 154 => 0xfd04, 157 => 0x1e, 159 => 0xfa23, 161 => 0xf103, 164 => 0x13, 166 => 0x3c, 168 => 0x1c, 169 => 0x18, 171 => 0xc, 180 => 'FNumber', 198 => 0xa, 199 => 0x36, 200 => 0x47, 201 => 0x9, 204 => 0x49c7, 254 => 0x38, 369 => 0x35a, 409 => 0x13, 452 => 0xa019, 455 => [0x31,0x49], 465 => 0x1, 466 => 0x1, 484 => [0x20,0x22,0x26], 540 => 'FNumber' },
	'focaldistance' => { 144 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 63 => 0x1, 66 => 0x7, 119 => 0x1d, 125 => 0x920a, 164 => 0x1d, 180 => 'FocalLength', 198 => 0x12, 249 => 0xa, 250 => 0xb, 254 => [0xc,0x3c], 364 => 0x1, 409 => 0x1d, 418 => 0x403, 445 => 0x1500, 464 => 0xe, 492 => 0x1278, 493 => 0x1134, 494 => 0x32c, 495 => 0x32c, 496 => 0x30a, 540 => 'FocalLength' },
	'focallength2' => { 484 => [0x23,0x25,0x29] },
	'focallength35mm' => { 360 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 125 => 0xa405, 436 => 'camera.focal_length.35mm_equivalent', 452 => 0xa01a, 540 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 464 => 0x10 },
	'focalplaneafpointarea' => { 497 => 0x2 },
	'focalplaneafpointlocation1' => { 497 => 0x6 },
	'focalplaneafpointlocation10' => { 497 => 0x2a },
	'focalplaneafpointlocation11' => { 497 => 0x2e },
	'focalplaneafpointlocation12' => { 497 => 0x32 },
	'focalplaneafpointlocation13' => { 497 => 0x36 },
	'focalplaneafpointlocation14' => { 497 => 0x3a },
	'focalplaneafpointlocation15' => { 497 => 0x3e },
	'focalplaneafpointlocation2' => { 497 => 0xa },
	'focalplaneafpointlocation3' => { 497 => 0xe },
	'focalplaneafpointlocation4' => { 497 => 0x12 },
	'focalplaneafpointlocation5' => { 497 => 0x16 },
	'focalplaneafpointlocation6' => { 497 => 0x1a },
	'focalplaneafpointlocation7' => { 497 => 0x1e },
	'focalplaneafpointlocation8' => { 497 => 0x22 },
	'focalplaneafpointlocation9' => { 497 => 0x26 },
	'focalplaneafpointsused' => { 497 => 0x1 },
	'focalplanediagonal' => { 346 => 0x103, 350 => 0x205 },
	'focalplaneresolutionunit' => { 125 => 0xa210, 540 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 125 => 0xa20e, 540 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 63 => 0x2 },
	'focalplanexunknown' => { 63 => 0x2 },
	'focalplaneyresolution' => { 125 => 0xa20f, 540 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 63 => 0x3 },
	'focalplaneyunknown' => { 63 => 0x3 },
	'focalpointx' => { 144 => 'FocalPointX' },
	'focalpointy' => { 144 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 63 => 0x0 },
	'focalunits' => { 37 => 0x19 },
	'focus' => { 305 => 0x8 },
	'focusarea' => { 198 => 0x31 },
	'focusareaselection' => { 334 => '15.2' },
	'focusbracket' => { 370 => 0xbd },
	'focusbracketing' => { 37 => 0x32 },
	'focusbracketstepsize' => { 345 => 0x308 },
	'focuscontinuous' => { 37 => 0x20 },
	'focusdisplayaiservoandmf' => { 90 => 0x515 },
	'focusdistance' => { 180 => 'FocusDistance', 198 => 0x13, 204 => 0x49bb, 249 => 0x9, 250 => 0xa, 254 => [0xb,0x4e], 348 => 0x305, 364 => 0x0, 368 => 0x304, 369 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 61 => 0x15, 82 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 254 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 61 => 0x14, 82 => 0x13 },
	'focusholdbutton' => { 201 => 0x44 },
	'focusinfoversion' => { 348 => 0x0 },
	'focusingscreen' => { 89 => 0x0, 90 => 0x80b, 95 => 0x0 },
	'focuslocation' => { 479 => 0x2027 },
	'focuslocation2' => { 479 => 0x204a },
	'focuslocked' => { 197 => 0x14 },
	'focusmode' => { 37 => 0x7, 118 => 0x3, 119 => [0x3003,0xd], 133 => 0x1021, 155 => 0x3f5, 157 => 0x38, 173 => 'FocusMode', 198 => 0x30, 200 => 0xe, 201 => 0xc, 256 => 0x7, 345 => 0x301, 350 => 0x100b, 370 => 0x7, 409 => 0xd, 416 => 0x3, 445 => 0x1006, 458 => [0xb,0x5], 464 => [0x15,0x1d], 465 => 0x4d, 466 => 0x4d, 479 => [0xb042,0xb04e,0x201b], 484 => 0x13, 505 => 0x16 },
	'focusmode2' => { 132 => '0.1', 388 => '3.1', 484 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 325 => '10.1', 462 => 0x14, 463 => 0x15, 465 => 0x10, 466 => 0xf, 467 => 0x6 },
	'focusmodeswitch' => { 201 => 0x58, 465 => 0x2e },
	'focuspeakingdisplay' => { 339 => 0x22f, 340 => 0x235, 341 => 0x235, 342 => 0x24d },
	'focuspeakinghighlightcolor' => { 339 => 0x53, 340 => 0x4b, 341 => 0x4b, 342 => 0x4b },
	'focuspeakinglevel' => { 339 => 0x51, 340 => 0x49, 341 => 0x49, 342 => 0x49 },
	'focuspixel' => { 133 => 0x1023 },
	'focuspointlock' => { 340 => 0x1d3, 341 => 0x1d3, 342 => 0x1eb },
	'focuspointpersistence' => { 339 => 0xf5, 340 => 0x105, 341 => 0x105, 342 => 0x11b },
	'focuspointwrap' => { 323 => '2.2', 324 => '2.2', 326 => '2.1', 327 => '2.1', 331 => '1.1', 332 => '2.2', 333 => '1.1', 336 => '2.2', 337 => '2.1', 338 => '2.5', 339 => 0x16, 340 => 0x16, 341 => 0x16, 342 => 0x16 },
	'focusposition' => { 1 => 0x2f, 249 => 0x8, 250 => 0x8, 409 => 0x10, 476 => 0x9bb },
	'focusposition2' => { 484 => [0x29,0x2b,0x2f], 505 => 0x2d, 508 => 0x20 },
	'focuspositionhorizontal' => { 213 => 0x2f, 214 => 0x43 },
	'focuspositionvertical' => { 213 => 0x31, 214 => 0x45 },
	'focusprocess' => { 345 => 0x302 },
	'focusrange' => { 37 => 0x12, 350 => 0x100a },
	'focusrangeindex' => { 399 => '3.1' },
	'focusresult' => { 214 => 0x4a },
	'focusringrotation' => { 90 => 0x713 },
	'focussetting' => { 455 => 0x6 },
	'focusshiftautoreset' => { 266 => 0x6da, 267 => 0x748 },
	'focusshiftexposurelock' => { 245 => 0x1b4, 260 => 0x224, 261 => 0xe8, 262 => 0x100, 265 => 0xf4, 266 => 0x104, 267 => 0x104 },
	'focusshiftinterval' => { 245 => 0x1b0, 260 => 0x220, 261 => 0xe4, 262 => 0xfc, 265 => 0xf0, 266 => 0x100, 267 => 0x100 },
	'focusshiftnumbershots' => { 245 => 0x1a8, 260 => 0x218, 261 => 0xdc, 262 => 0xf4, 265 => 0xe8, 266 => 0xf8, 267 => 0xf8 },
	'focusshiftshooting' => { 284 => 0x20 },
	'focusshiftstepwidth' => { 245 => 0x1ac, 260 => 0x21c, 261 => 0xe0, 262 => 0xf8, 265 => 0xec, 266 => 0xfc, 267 => 0xfc },
	'focusstatus' => { 464 => 0x19, 465 => 0x53, 466 => 0x53 },
	'focusstepcount' => { 348 => 0x301, 350 => 0x100e },
	'focusstepinfinity' => { 348 => 0x303, 350 => 0x103b },
	'focusstepnear' => { 348 => 0x304, 350 => 0x103c },
	'focusstepsfrominfinity' => { 254 => 0x58 },
	'focustrackinglockon' => { 323 => ['1.5','4.1'], 324 => '1.4', 331 => '0.4', 332 => '3.1', 333 => '0.4', 336 => '1.4' },
	'focuswarning' => { 133 => 0x1301 },
	'foldername' => { 198 => 0x27 },
	'foldernumber' => { 465 => 0x9a, 467 => [0x402,0x114,0x316] },
	'fontcomposite' => { 569 => [\'Fonts','FontsComposite'] },
	'fontface' => { 569 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 569 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 569 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 569 => [\'Fonts','FontsFontName'] },
	'fonts' => { 569 => 'Fonts' },
	'fonttype' => { 569 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 569 => [\'Fonts','FontsVersionString'] },
	'for' => { 425 => 'For' },
	'forcewrite' => { 126 => 'ForceWrite' },
	'format' => { 143 => 'Format', 435 => "\xa9fmt", 537 => 'format', 562 => 'Format' },
	'forwardlock' => { 559 => 'forwardlock' },
	'forwardmatrix1' => { 125 => 0xc714 },
	'forwardmatrix2' => { 125 => 0xc715 },
	'forwardmatrix3' => { 125 => 0xcd34 },
	'fossilspecimen' => { 124 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 124 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 72 => [0x2,0x4] },
	'frameheight' => { 133 => 0x3822 },
	'framenum' => { 420 => 0xd7 },
	'framenumber' => { 133 => 0x8003, 204 => 0x3c, 409 => 0x29 },
	'framerate' => { 72 => [0x1,0x6], 125 => 0xc764, 133 => 0x3820 },
	'framereadouttime' => { 436 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 133 => 0x3821 },
	'framing' => { 553 => 'framing' },
	'freebytes' => { 103 => 0x1 },
	'freememorycardimages' => { 199 => [0x37,0x54], 200 => [0x2d,0x4a], 201 => 0x32 },
	'fujiflashmode' => { 133 => 0x1010 },
	'fujimodel' => { 133 => 0x1447 },
	'fujimodel2' => { 133 => 0x1448 },
	'fullframerateplaybackintent' => { 429 => 'full-frame-rate-playback-intent' },
	'fullhdhighspeedrec' => { 133 => 0x3824 },
	'fullimagesize' => { 479 => 0xb02b },
	'fullpanoheightpixels' => { 146 => 'FullPanoHeightPixels', 147 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 146 => 'FullPanoWidthPixels', 147 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 445 => 0x100d },
	'fullsizeimage' => { 179 => 'data' },
	'fullsizeimagename' => { 179 => '1Name' },
	'fullsizeimagetype' => { 179 => '0Type' },
	'func1button' => { 326 => '14.1', 327 => '14.1', 337 => '14.1', 339 => 0x67, 340 => 0x63, 341 => 0x63, 342 => 0x63 },
	'func1buttonplaybackmode' => { 339 => 0x19f, 340 => 0x1a5, 341 => 0x1a5, 342 => 0x1bd },
	'func1buttonplusdials' => { 326 => '42.1', 327 => '42.1', 337 => '42.1' },
	'func2button' => { 326 => '80.1', 327 => '80.1', 337 => '80.1', 339 => 0x77, 340 => 0x73, 341 => 0x73, 342 => 0x73 },
	'func2buttonplaybackmode' => { 339 => 0x1a1, 340 => 0x1a7, 341 => 0x1a7, 342 => 0x1bf },
	'func2buttonplusdials' => { 326 => '81.1' },
	'func3button' => { 326 => '83.1', 340 => 0x119, 341 => 0x119, 342 => 0x131 },
	'func3buttonplaybackmode' => { 341 => 0x1a9, 342 => 0x1c1 },
	'func4button' => { 341 => 0x175, 342 => 0x18d },
	'func4buttonplaybackmode' => { 341 => 0x1af, 342 => 0x1c7 },
	'funcbutton' => { 323 => ['14.1','15.1'], 324 => '14.1', 332 => '28.1', 333 => '13.1', 336 => '14.1', 338 => '14.1' },
	'funcbuttonplusdials' => { 323 => ['14.2','15.2'], 324 => '14.2', 332 => '31.1', 336 => '42.1' },
	'functionbutton' => { 330 => '13.1', 334 => '5.2' },
	'gainbase' => { 349 => 0x610 },
	'gaincontrol' => { 125 => 0xa407, 540 => 'GainControl' },
	'gainmapmax' => { 545 => 'GainMapMax' },
	'gainmapmin' => { 545 => 'GainMapMin' },
	'gamma' => { 125 => 0xa500, 155 => 0x8fe, 357 => 'gAMA', 375 => 0x11c, 541 => 'Gamma', 545 => 'Gamma' },
	'gammablackpoint' => { 111 => 0xc },
	'gammacolortone' => { 111 => 0x3 },
	'gammacompensatedvalue' => { 150 => 0x91 },
	'gammacontrast' => { 111 => 0x2 },
	'gammacurveoutputrange' => { 111 => 0xf },
	'gammahighlight' => { 111 => 0xa },
	'gammalinear' => { 109 => 0x20200 },
	'gammamidpoint' => { 111 => 0xe },
	'gammasaturation' => { 111 => 0x4 },
	'gammashadow' => { 111 => 0x9 },
	'gammasharpnessstrength' => { 111 => 0x8 },
	'gammaunsharpmaskfineness' => { 111 => 0x6 },
	'gammaunsharpmaskstrength' => { 111 => 0x5 },
	'gammaunsharpmaskthreshold' => { 111 => 0x7 },
	'gammawhitepoint' => { 111 => 0xd },
	'garminsettings' => { 435 => 'pmcc' },
	'garminsoftware' => { 435 => 'uuid' },
	'gdalmetadata' => { 125 => 0xa480 },
	'gdalnodata' => { 125 => 0xa481 },
	'geimagesize' => { 133 => 0x1304 },
	'gemake' => { 135 => 0x300 },
	'gemodel' => { 135 => 0x207 },
	'genre' => { 427 => ['gnre',"\xa9gen"], 429 => 'genre', 435 => ['gnre',"\xa9gen"], 548 => 'Genre', 554 => 'genre', 564 => 'genre' },
	'genrecvid' => { 548 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 548 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 548 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 548 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 427 => 'geID' },
	'geography' => { 555 => 'geography' },
	'geolocate' => { 126 => 'Geolocate' },
	'geologicalcontext' => { 124 => 'GeologicalContext' },
	'geologicalcontextbed' => { 124 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 124 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 124 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 124 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 124 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 126 => 'Geosync' },
	'geotag' => { 126 => 'Geotag' },
	'geotiffasciiparams' => { 125 => 0x87b1 },
	'geotiffdirectory' => { 125 => 0x87af },
	'geotiffdoubleparams' => { 125 => 0x87b0 },
	'geotime' => { 126 => 'Geotime' },
	'giftftppriority' => { 522 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 122 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 122 => 'GimbalReverse' },
	'gimbalrolldegree' => { 122 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 122 => 'GimbalYawDegree' },
	'globalaltitude' => { 423 => 0x419 },
	'globalangle' => { 423 => 0x40d },
	'gndfiltertype' => { 349 => 0x2110 },
	'good' => { 564 => 'good' },
	'googlehostheader' => { 427 => 'gshh' },
	'googlepingmessage' => { 427 => 'gspm' },
	'googlepingurl' => { 427 => 'gspu' },
	'googleplusuploadcode' => { 125 => 0x9009 },
	'googlesourcedata' => { 427 => 'gssd' },
	'googlestarttime' => { 427 => 'gsst' },
	'googletrackduration' => { 427 => 'gstd' },
	'goprotype' => { 435 => 'GoPr' },
	'gpsaltitude' => { 137 => 0x6, 177 => 'Altitude', 540 => 'GPSAltitude' },
	'gpsaltituderef' => { 137 => 0x5, 540 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 137 => 0x1c, 540 => 'GPSAreaInformation' },
	'gpscoordinates' => { 427 => "\xa9xyz", 429 => 'location.ISO6709', 435 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 137 => 0x1d },
	'gpsdatetime' => { 177 => 'DateTime', 540 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 137 => 0x18, 177 => 'Bearing', 540 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 137 => 0x17, 540 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 137 => 0x1a, 177 => 'Distance', 540 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 137 => 0x19, 540 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 137 => 0x14, 540 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 137 => 0x13 },
	'gpsdestlongitude' => { 137 => 0x16, 540 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 137 => 0x15 },
	'gpsdifferential' => { 137 => 0x1e, 177 => 'Differential', 540 => 'GPSDifferential' },
	'gpsdop' => { 137 => 0xb, 540 => 'GPSDOP' },
	'gpshpositioningerror' => { 137 => 0x1f, 540 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 137 => 0x11, 540 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 137 => 0x10, 540 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 120 => 'GPS-GPSLatitude', 122 => 'GpsLatitude', 137 => 0x2, 177 => 'Latitude', 540 => 'GPSLatitude' },
	'gpslatituderef' => { 137 => 0x1 },
	'gpslongitude' => { 120 => 'GPS-GPSLongitude', 122 => 'GpsLongitude', 137 => 0x4, 177 => 'Longitude', 540 => 'GPSLongitude' },
	'gpslongituderef' => { 137 => 0x3 },
	'gpslongtitude' => { 122 => 'GpsLongtitude' },
	'gpsmapdatum' => { 137 => 0x12, 177 => 'Datum', 540 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 137 => 0xa, 177 => 'MeasureMode', 540 => 'GPSMeasureMode' },
	'gpsposition' => { 120 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 137 => 0x1b, 540 => 'GPSProcessingMethod' },
	'gpssatellites' => { 137 => 0x8, 177 => 'Satellites', 540 => 'GPSSatellites' },
	'gpsspeed' => { 137 => 0xd, 177 => 'Speed', 540 => 'GPSSpeed' },
	'gpsspeedref' => { 137 => 0xc, 540 => 'GPSSpeedRef' },
	'gpsstatus' => { 137 => 0x9, 540 => 'GPSStatus' },
	'gpsstring' => { 155 => 0x402 },
	'gpstimestamp' => { 137 => 0x7 },
	'gpstrack' => { 137 => 0xf, 177 => 'Heading', 540 => 'GPSTrack' },
	'gpstrackref' => { 137 => 0xe, 540 => 'GPSTrackRef' },
	'gpsversionid' => { 137 => 0x0, 540 => 'GPSVersionID' },
	'gradation' => { 345 => 0x50f },
	'gradientbasedcorractive' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 534 => 'GradientBasedCorrections', 536 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 534 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 534 => 'GrainAmount', 536 => 'GrainAmount' },
	'graineffectroughness' => { 133 => 0x1047 },
	'graineffectsize' => { 133 => 0x104c },
	'grainfrequency' => { 534 => 'GrainFrequency', 536 => 'GrainFrequency' },
	'grainseed' => { 534 => 'GrainSeed', 536 => 'GrainSeed' },
	'grainsize' => { 534 => 'GrainSize', 536 => 'GrainSize' },
	'graymixeraqua' => { 534 => 'GrayMixerAqua', 536 => 'GrayMixerAqua' },
	'graymixerblue' => { 534 => 'GrayMixerBlue', 536 => 'GrayMixerBlue' },
	'graymixergreen' => { 534 => 'GrayMixerGreen', 536 => 'GrayMixerGreen' },
	'graymixermagenta' => { 534 => 'GrayMixerMagenta', 536 => 'GrayMixerMagenta' },
	'graymixerorange' => { 534 => 'GrayMixerOrange', 536 => 'GrayMixerOrange' },
	'graymixerpurple' => { 534 => 'GrayMixerPurple', 536 => 'GrayMixerPurple' },
	'graymixerred' => { 534 => 'GrayMixerRed', 536 => 'GrayMixerRed' },
	'graymixeryellow' => { 534 => 'GrayMixerYellow', 536 => 'GrayMixerYellow' },
	'graypoint' => { 516 => 0x8021 },
	'grayresponseunit' => { 125 => 0x122 },
	'greencurvelimits' => { 114 => 0x1c4 },
	'greencurvepoints' => { 113 => 0x53, 114 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 109 => 0x20913 },
	'greenhue' => { 534 => 'GreenHue', 536 => 'GreenHue' },
	'greensaturation' => { 534 => 'GreenSaturation', 536 => 'GreenSaturation' },
	'griddisplay' => { 323 => '13.3', 324 => '4.3', 326 => '4.2', 327 => '4.2', 328 => '2.2', 332 => '10.5', 333 => '3.4', 334 => '6.1', 336 => '4.4', 337 => '4.2', 338 => '4.2' },
	'gripbatteryadload' => { 385 => 0x5 },
	'gripbatteryadnoload' => { 385 => 0x4 },
	'gripbatterypercent' => { 385 => 0x11 },
	'gripbatterystate' => { 385 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 385 => 0x12 },
	'group' => { 534 => 'Group', 536 => 'Group' },
	'groupareaafillumination' => { 324 => '46.4', 327 => '47.4', 336 => '47.4' },
	'grouping' => { 427 => ['grup',"\xa9grp"], 435 => "\xa9grp" },
	'guid' => { 427 => 'GUID' },
	'h2resetblackpixels' => { 155 => 0x18a6 },
	'h3resetblackcolumns' => { 155 => 0x18ce },
	'h3resetblackpixels' => { 155 => 0x18b0 },
	'halftonehints' => { 125 => 0x141 },
	'hardlink' => { 126 => 'HardLink' },
	'hasalternative' => { 554 => 'hasAlternative' },
	'hascorrection' => { 554 => 'hasCorrection' },
	'hascorrectiona-lang' => { 554 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 554 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 554 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 534 => 'HasCrop', 536 => 'HasCrop' },
	'hasextendedxmp' => { 566 => 'HasExtendedXMP' },
	'hassettings' => { 534 => 'HasSettings', 536 => 'HasSettings' },
	'hastranslation' => { 554 => 'hasTranslation' },
	'hasvisibleoverprint' => { 569 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 569 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 261 => 0x35a },
	'hdmioutputresolution' => { 263 => 0x710, 264 => 0x770, 265 => 0x610, 266 => 0x640, 267 => 0x6a8 },
	'hdmiviewassist' => { 341 => 0x20f, 342 => 0x227 },
	'hdr' => { 64 => 0x1, 241 => 0x4, 242 => 0x4, 260 => 0x354, 262 => 0x23a, 267 => 0x23a, 370 => 0x9e, 409 => 0x85, 479 => 0x200a },
	'hdr-pq' => { 37 => 0x34 },
	'hdrcapacitymax' => { 545 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 545 => 'HDRCapacityMin' },
	'hdreditmode' => { 534 => 'HDREditMode', 536 => 'HDREditMode' },
	'hdreffect' => { 64 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrgainmapversion' => { 523 => 'HDRGainMapVersion' },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 241 => 0x5, 242 => 0x5, 260 => 0x360, 262 => 0x246, 267 => 0x246, 467 => 0x2e, 484 => 0x17 },
	'hdrlevel2' => { 241 => 0x7 },
	'hdrplusmakernote' => { 140 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 140 => 'hdrp_makernote' },
	'hdrsetting' => { 467 => 0x2d, 484 => 0x16, 488 => 0x1148, 489 => 0x1148, 490 => 0x1124, 491 => 0x11a0, 492 => 0x117c, 493 => 0x1034, 494 => 0x22c, 495 => 0x22c, 496 => 0x21f },
	'hdrsmoothing' => { 241 => 0x6 },
	'hdvideo' => { 427 => 'hdvd' },
	'headline' => { 148 => 0x69, 548 => 'Headline', 552 => 'Headline' },
	'hiddendatalength' => { 477 => 0x1 },
	'hiddendataoffset' => { 477 => 0x0 },
	'hierarchicalkeywords' => { 188 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 188 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 188 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 188 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 188 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 188 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 188 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 525 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 260 => 0x16c, 262 => 0x48, 266 => 0x48, 267 => 0x48 },
	'highfrequencyflickerreduction' => { 260 => 0x386, 262 => 0x27c, 266 => 0x27c, 267 => 0x27c },
	'highisomultiplierblue' => { 375 => 0x1a },
	'highisomultipliergreen' => { 375 => 0x19 },
	'highisomultiplierred' => { 375 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 67 => 0x5, 90 => 0x202, 256 => 0xb1, 409 => 0x71, 465 => 0x2c, 466 => 0x26, 467 => 0x26, 479 => 0x2009, 484 => 0x12, 511 => 0x42 },
	'highisonoisereduction2' => { 479 => 0xb050 },
	'highlight' => { 455 => 0xf },
	'highlight2012' => { 534 => 'Highlight2012', 536 => 'Highlight2012' },
	'highlightadj' => { 109 => 0x2030c },
	'highlightcolordistortreduct' => { 516 => 0x8026 },
	'highlightlinearitylimit' => { 452 => 0xa025 },
	'highlightprotection' => { 315 => 0x6 },
	'highlightrecovery' => { 534 => 'HighlightRecovery', 536 => 'HighlightRecovery' },
	'highlights' => { 479 => 0x2033, 527 => 'Highlights' },
	'highlights2012' => { 534 => 'Highlights2012', 536 => 'Highlights2012' },
	'highlightsadj' => { 516 => 0x9019 },
	'highlightshadow' => { 370 => 0xad },
	'highlighttone' => { 133 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 67 => 0x3, 90 => 0x203 },
	'highlightwarning' => { 370 => 0x8002 },
	'highlowkeyadj' => { 409 => 0x6c },
	'highspeedsync' => { 201 => 0x5, 339 => 0x59, 340 => 0x55, 341 => 0x55, 342 => 0x55, 465 => 0x2, 466 => 0x2 },
	'hintversion' => { 435 => 'hinv' },
	'histogramxml' => { 316 => 0x83a1a25 },
	'history' => { 552 => 'History', 565 => 'History' },
	'historyaction' => { 565 => [\'History','HistoryAction'] },
	'historychanged' => { 565 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 565 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 565 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 565 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 565 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 155 => 0xc88 },
	'holefilldeltathreshold' => { 155 => 0xc7e },
	'hometowncity' => { 119 => 0x3006, 409 => 0x23, 415 => 0x2 },
	'hometowncitycode' => { 416 => 0x1000 },
	'hometowndst' => { 409 => 0x25, 415 => '0.2' },
	'hostcomputer' => { 125 => 0x13c },
	'hostsoftwarerendering' => { 155 => 0xce7 },
	'hue' => { 206 => 0x3b, 275 => 0x3d, 276 => 0x45, 409 => 0x67 },
	'hueadj' => { 319 => 0x2f, 516 => 0x8019 },
	'hueadjust' => { 445 => 0x1016 },
	'hueadjustment' => { 199 => 0x4a, 200 => 0x40, 256 => 0x92, 274 => 0x36 },
	'hueadjustmentaqua' => { 534 => 'HueAdjustmentAqua', 536 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 534 => 'HueAdjustmentBlue', 536 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 534 => 'HueAdjustmentGreen', 536 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 534 => 'HueAdjustmentMagenta', 536 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 534 => 'HueAdjustmentOrange', 536 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 534 => 'HueAdjustmentPurple', 536 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 534 => 'HueAdjustmentRed', 536 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 534 => 'HueAdjustmentYellow', 536 => 'HueAdjustmentYellow' },
	'huesetting' => { 353 => 0x1011 },
	'humanobservation' => { 124 => 'HumanObservation' },
	'humanobservationday' => { 124 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 124 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 124 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 124 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 124 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 124 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 124 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationeventtype' => { 124 => [\'HumanObservation','HumanObservationEventType'] },
	'humanobservationfieldnotes' => { 124 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 124 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 124 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 124 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 124 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 124 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 124 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 124 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 124 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 124 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 124 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 124 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 124 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 125 => 0x9401, 541 => 'Humidity' },
	'icc_profile' => { 126 => 'ICC_Profile', 136 => 'ICCRGBG1/012' },
	'iccprofilename' => { 552 => 'ICCProfile' },
	'iconuri' => { 435 => 'icnu' },
	'idccreativestyle' => { 516 => 0x8000 },
	'idcpreviewlength' => { 516 => 0x202 },
	'idcpreviewstart' => { 516 => 0x201 },
	'identification' => { 124 => 'Identification' },
	'identificationid' => { 124 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 124 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 124 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 124 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 124 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 124 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 124 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 537 => 'identifier', 562 => 'Identifier' },
	'ifcameramodel' => { 155 => 0x9c8 },
	'illuminantdata1' => { 125 => 0xcd35 },
	'illuminantdata2' => { 125 => 0xcd36 },
	'illuminantdata3' => { 125 => 0xcd37 },
	'illumination' => { 334 => '0.5', 441 => 0x48 },
	'imageabsolutex' => { 155 => 0x3fe },
	'imageabsolutey' => { 155 => 0x3ff },
	'imageadjustment' => { 256 => 0x80, 305 => 0x5 },
	'imagealterationconstraints' => { 356 => 'ImageAlterationConstraints' },
	'imagearea' => { 246 => 0x2b, 283 => 0x2b, 291 => 0x10, 294 => 0x10 },
	'imageareaoffset' => { 409 => 0x38 },
	'imageauthentication' => { 256 => 0x20 },
	'imageboundary' => { 256 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 133 => 0x1438, 256 => 0xa5, 482 => 0x11b },
	'imagecreator' => { 356 => 'ImageCreator' },
	'imagecreatorid' => { 356 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 356 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 356 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 155 => 0x41f },
	'imagecropy' => { 155 => 0x420 },
	'imagedata' => { 145 => 'Data' },
	'imagedatasize' => { 256 => 0xa2 },
	'imagedescription' => { 125 => 0x10e, 560 => 'ImageDescription' },
	'imageduplicationconstraints' => { 356 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 316 => 0xfe443a45 },
	'imageeditcount' => { 409 => 0x41 },
	'imageediting' => { 409 => 0x32 },
	'imageeditingsoftware' => { 125 => 0xa43b, 541 => 'ImageEditingSoftware' },
	'imageeditor' => { 125 => 0xa438, 541 => 'ImageEditor' },
	'imageeffects' => { 445 => 0x1010 },
	'imagefileconstraints' => { 356 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 356 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 356 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 133 => 0x1436 },
	'imageheight' => { 125 => 0x101, 143 => 'ImageHeight', 205 => 0xc, 418 => 0x10d, 560 => 'ImageLength' },
	'imagehistory' => { 125 => 0x9213, 539 => 'ImageHistory' },
	'imageidnumber' => { 365 => 0x340 },
	'imagemimetype' => { 145 => 'Mime' },
	'imagenumber' => { 125 => 0x9211, 173 => 'ImageNumber', 199 => 0xae, 200 => 0x5e, 418 => 0x113, 465 => 0x9b, 467 => [0x400,'276.1',0x314], 531 => 'ImageNumber' },
	'imagenumber2' => { 200 => 0x62 },
	'imageoptimization' => { 256 => 0xa9 },
	'imageorientation' => { 148 => 0x83 },
	'imageprocessing' => { 256 => 0x1a },
	'imageprocessingfiledatecreated' => { 155 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 155 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 349 => 0x0 },
	'imagequality' => { 173 => 'ImageQuality', 293 => '723.2', 294 => '732.2', 302 => '708.1', 370 => 0x1 },
	'imagequality2' => { 345 => 0x603 },
	'imagerank' => { 522 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 155 => 0x600 },
	'imagerboardversion' => { 155 => 0x439 },
	'imagercols' => { 155 => 0x17d4 },
	'imageref' => { 546 => 'ImageRef' },
	'imageregion' => { 548 => 'ImageRegion' },
	'imageregionboundary' => { 548 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 548 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 548 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 548 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 548 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 548 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 548 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 548 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 548 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 548 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 155 => 0x944 },
	'imageresolutionjpg' => { 155 => 0x945 },
	'imagereview' => { 325 => '0.4', 334 => '0.4' },
	'imagereviewmonitorofftime' => { 324 => '21.1', 326 => '21.1', 327 => '21.1', 331 => '20.1', 336 => '21.1', 337 => '21.1', 339 => 0x3b, 340 => 0x39, 341 => 0x39, 342 => 0x39 },
	'imagereviewtime' => { 323 => '25.1', 325 => '2.1', 328 => '19.1', 329 => '20.1', 330 => '20.1', 332 => '9.2', 333 => '20.1', 338 => '21.2' },
	'imagerfiledatecreated' => { 155 => 0x9c5 },
	'imagerfileproductionlevel' => { 155 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 155 => 0x9c7 },
	'imagerotated' => { 168 => 0x2a },
	'imagerpowerondelaymsec' => { 155 => 0x5fd },
	'imagerrows' => { 155 => 0x17de },
	'imagesegmentlines' => { 155 => 0x184d },
	'imagesegmentstartline' => { 155 => 0x184c },
	'imagesequenceinfo' => { 125 => 0xcd44 },
	'imagesize' => { 179 => 'ImageSize' },
	'imagesizeraw' => { 256 => 0x3e },
	'imagesizerestriction' => { 557 => 'imageSizeRestriction' },
	'imagesourcedata' => { 125 => 0x935c },
	'imagespace' => { 155 => 0x909 },
	'imagestabilization' => { 37 => 0x22, 119 => 0x3020, 133 => 0x1422, 173 => 'ImageStabilization', 199 => 0xbd, 200 => 0x71, 201 => 0x57, 202 => 0x0, 203 => [0x18,0x107,0x113], 204 => 0x49c2, 256 => 0xac, 345 => 0x604, 348 => 0x1600, 370 => 0x1a, 470 => 0x12, 471 => 0x11, 479 => 0xb026 },
	'imagestabilization2' => { 469 => 0xa },
	'imagestabilizationsetting' => { 204 => 0x14, 465 => 0x3d, 466 => 0x3d, 476 => 0x14 },
	'imagestats' => { 125 => 0xcd46 },
	'imagestyle' => { 465 => 0x2d, 466 => 0x27 },
	'imagesupplier' => { 356 => 'ImageSupplier' },
	'imagesupplierid' => { 356 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 356 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 356 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 127 => 0x1 },
	'imagetemperaturemin' => { 127 => 0x2 },
	'imagetitle' => { 125 => 0xa436, 541 => 'ImageTitle' },
	'imagetone' => { 409 => 0x4f },
	'imagetype' => { 148 => 0x82, 356 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 69 => 0x28, 125 => 0xa420, 539 => 'ImageUniqueID', 540 => 'ImageUniqueID', 541 => 'ImageUniqueID' },
	'imagewidth' => { 125 => 0x100, 143 => 'ImageWidth', 205 => 0xe, 418 => 0x10c, 560 => 'ImageWidth' },
	'inclinationangle' => { 516 => 0x900f },
	'inclinationcorrection' => { 516 => 0x900e },
	'incrementaltemperature' => { 534 => 'IncrementalTemperature', 536 => 'IncrementalTemperature' },
	'incrementaltint' => { 534 => 'IncrementalTint', 536 => 'IncrementalTint' },
	'industry' => { 554 => 'industry', 555 => 'industry' },
	'infobuttonwhenshooting' => { 90 => 0x409 },
	'information' => { 429 => 'information', 435 => "\xa9inf" },
	'infourl' => { 435 => 'infu' },
	'infraredilluminator' => { 437 => 0x28 },
	'ingredientexclusion' => { 556 => 'ingredientExclusion' },
	'ingredients' => { 565 => 'Ingredients' },
	'ingredientsalternatepaths' => { 565 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 565 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 565 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 565 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 565 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 565 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 565 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 565 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 565 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 565 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 565 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 565 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 565 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 565 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 565 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 565 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 565 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 565 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 565 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 565 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 565 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 565 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 565 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 90 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 146 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 146 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 196 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 146 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 146 => 'InitialViewHeadingDegrees', 147 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 146 => 'InitialViewPitchDegrees', 147 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 146 => 'InitialViewRollDegrees', 147 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 323 => '4.4' },
	'initialzoomsetting' => { 323 => '9.3', 332 => '27.3' },
	'inkset' => { 125 => 0x14c },
	'inputprofile' => { 155 => 0x1389 },
	'instanceid' => { 565 => 'InstanceID' },
	'instantplaybacksetup' => { 201 => 0x3e },
	'instantplaybacktime' => { 201 => 0x3d },
	'instructions' => { 552 => 'Instructions' },
	'instrument' => { 564 => 'instrument' },
	'integrationtime' => { 155 => 0x423 },
	'intellectualgenre' => { 547 => 'IntellectualGenre' },
	'intelligentauto' => { 479 => 0xb052, 507 => 0xd, 508 => 0xe, 509 => 0xd },
	'intelligentcontrast' => { 56 => 0x4 },
	'intelligentd-range' => { 370 => 0x79 },
	'intelligentexposure' => { 370 => 0x5d },
	'intelligentresolution' => { 370 => 0x70 },
	'interchangecolorspace' => { 150 => 0x40 },
	'intergraphmatrix' => { 125 => 0x8480 },
	'internalflash' => { 198 => 0x2b, 323 => '23.1', 325 => '8.1', 328 => '22.1', 330 => '23.1', 334 => '8.1', 338 => '24.1', 348 => 0x1208 },
	'internalflashae1' => { 350 => 0x1021 },
	'internalflashae1_0' => { 350 => 0x101d },
	'internalflashae2' => { 350 => 0x1022 },
	'internalflashae2_0' => { 350 => 0x101e },
	'internalflashmode' => { 396 => 0x1 },
	'internalflashstrength' => { 396 => 0x3 },
	'internalflashtable' => { 350 => 0x1024 },
	'internallensserialnumber' => { 452 => 0xa005 },
	'internalndfilter' => { 370 => 0x9d },
	'internalserialnumber' => { 69 => 0x96, 81 => 0x9, 133 => 0x10, 204 => 0x49dc, 343 => 0x18, 346 => 0x102, 367 => 0x500, 370 => 0x25, 387 => 0x4, 445 => 0x5, 498 => [0x7c,0xf0], 499 => 0x88, 500 => [0x88,0x8a], 501 => 0x38 },
	'interopindex' => { 125 => 0x1, 541 => 'InteroperabilityIndex' },
	'interopversion' => { 125 => 0x2 },
	'interval' => { 281 => 0x20 },
	'intervaldurationhours' => { 260 => 0x1dc, 261 => 0xa0, 262 => 0xb8 },
	'intervaldurationminutes' => { 260 => 0x1e0, 261 => 0xa4, 262 => 0xbc },
	'intervaldurationseconds' => { 260 => 0x1e4, 261 => 0xa8, 262 => 0xc0 },
	'intervalexposuresmoothing' => { 245 => 0x184, 260 => 0x1f4, 261 => 0xb8, 262 => 0xd0 },
	'intervalframe' => { 281 => 0x24 },
	'intervallength' => { 198 => 0x10 },
	'intervalmode' => { 198 => 0x26 },
	'intervalnumber' => { 198 => 0x11 },
	'intervalpriority' => { 245 => 0x186, 260 => 0x1f6, 261 => 0xba, 262 => 0xd2 },
	'intervals' => { 245 => 0x17c, 260 => 0x1ec, 261 => 0xb0, 262 => 0xc8, 265 => 0xbc, 266 => 0xcc, 267 => 0xcc },
	'intervalshooting' => { 246 => 0x24, 283 => 0x24, 284 => 0x28, 409 => 0x92 },
	'introtime' => { 564 => 'introTime' },
	'introtimescale' => { 564 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 564 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 155 => 0xdae },
	'ipfcameramodel' => { 155 => 0xe4d },
	'iptc' => { 126 => 'IPTC' },
	'iptc-naa' => { 125 => 0x83bb, 375 => 0x83bb },
	'iptcbitspersample' => { 150 => 0x56 },
	'iptcdigest' => { 423 => 0x425 },
	'iptcimageheight' => { 150 => 0x1e },
	'iptcimagerotation' => { 150 => 0x66 },
	'iptcimagewidth' => { 150 => 0x14 },
	'iptclastedited' => { 548 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 150 => 0xa },
	'iptcpixelheight' => { 150 => 0x32 },
	'iptcpixelwidth' => { 150 => 0x28 },
	'isalternativeof' => { 554 => 'isAlternativeOf' },
	'isbn' => { 554 => 'isbn' },
	'iscorrectionof' => { 554 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 115 => 0x3 },
	'ismergedhdr' => { 531 => 'IsMergedHDR' },
	'ismergedpanorama' => { 531 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 118 => 0x14, 119 => [0x3014,0x14], 125 => 0x8827, 154 => 0xfd06, 155 => 0x1784, 157 => 0x60, 159 => [0xfa2e,0xfa46], 160 => [0x27,0x28], 161 => 0xf105, 164 => 0x14, 166 => 0x4e, 168 => 0x1e, 169 => 0x1a, 171 => 0x34, 173 => 'ISO', 198 => 0x8, 204 => 0x49ba, 244 => 0x0, 256 => 0x2, 370 => 0xd1, 375 => [0x17,0x37], 409 => [0x8b,0x14], 416 => 0x14, 418 => 0x105, 452 => 0xa014, 455 => 0x86, 476 => 0x6f, 484 => [0x1f,0x21,0x25], 540 => 'ISOSpeedRatings' },
	'iso2' => { 244 => 0x6, 288 => 0x265, 289 => 0x25c, 290 => 0x265, 291 => 0x221, 292 => 0x25d, 293 => 0x256, 294 => 0x25d, 297 => 0x2b5, 300 => 0x265, 304 => 0x2b5 },
	'isoauto' => { 388 => '14.4' },
	'isoautoflashlimit' => { 262 => 0x156, 265 => 0x146, 266 => 0x15a, 267 => 0x15a },
	'isoautohilimit' => { 243 => 0x5, 260 => 0x28a, 262 => 0x154, 265 => 0x144, 266 => 0x158, 267 => 0x158, 286 => 0x5, 296 => 0x18eb },
	'isoautomax' => { 478 => 0x4 },
	'isoautomin' => { 478 => 0x2 },
	'isoautominspeed' => { 409 => 0x7a },
	'isoautosettings' => { 345 => 0x821 },
	'isoautoshuttertime' => { 243 => 0x4, 262 => 0x15e, 265 => 0x14e, 266 => 0x162, 267 => 0x162, 286 => 0x4, 296 => 0x18ea },
	'isobutton' => { 267 => 0x796 },
	'isocalibrationgain' => { 155 => 0x89f },
	'isodisplay' => { 326 => '4.1', 327 => '4.1', 328 => '2.3', 329 => '3.3', 330 => '3.3', 333 => '3.3', 336 => '4.3', 337 => '4.1', 338 => '4.3' },
	'isoexpansion' => { 90 => 0x103, 91 => 0x7, 92 => 0x8, 95 => 0x8, 244 => 0x4 },
	'isoexpansion2' => { 244 => 0xa },
	'isofloor' => { 388 => 0x6 },
	'isoselected' => { 369 => 0x359 },
	'isoselection' => { 256 => 0xf },
	'isosensitivitystep' => { 331 => '6.2', 333 => '6.2' },
	'isosetting' => { 157 => 0x5e, 169 => 0x14, 173 => 'ISOSetting', 198 => 0x24, 199 => 0x26, 200 => 0x1c, 201 => 0x13, 206 => 0x6, 256 => 0x13, 388 => '17.3', 444 => 0x27, 465 => 0x16, 466 => 0x14, 467 => 0x2, 476 => 0x6d, 478 => 0x0 },
	'isospeed' => { 125 => 0x8833, 541 => 'ISOSpeed' },
	'isospeedexpansion' => { 89 => 0x3 },
	'isospeedincrements' => { 90 => 0x102 },
	'isospeedlatitudeyyy' => { 125 => 0x8834, 541 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 125 => 0x8835, 541 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 90 => 0x103 },
	'isostepsize' => { 323 => '6.1', 324 => '7.2', 326 => '7.2', 327 => '7.2', 332 => '4.1', 336 => '7.2', 337 => '7.2', 339 => 0x14d, 340 => 0x15d, 341 => 0x15d, 342 => 0x175 },
	'isovalue' => { 350 => 0x1001 },
	'isrc' => { 427 => 'xid ' },
	'isrccode' => { 435 => "\xa9isr" },
	'issn' => { 554 => 'issn' },
	'issueidentifier' => { 554 => 'issueIdentifier' },
	'issuename' => { 554 => 'issueName' },
	'issueteaser' => { 554 => 'issueTeaser' },
	'issuetype' => { 554 => 'issueType' },
	'istranslationof' => { 554 => 'isTranslationOf' },
	'itemsubtype' => { 195 => 'ItemSubType' },
	'itunesu' => { 427 => 'itnu' },
	'jobid' => { 148 => 0xb8 },
	'jobname' => { 542 => 'JobName' },
	'jobref' => { 563 => 'JobRef' },
	'jobrefid' => { 563 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 563 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 563 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 542 => 'JobStatus' },
	'jpeg-heifswitch' => { 479 => 0x2039 },
	'jpeghandling' => { 534 => 'JPEGHandling', 536 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 370 => 0x43, 372 => 0x3034, 479 => 0xb047 },
	'jpegsize' => { 372 => 0x303a },
	'jpgcompression' => { 247 => 0x24, 256 => 0x44, 291 => '671.1' },
	'jpgfromraw' => { 103 => 0x2007, 120 => 'Exif-JpgFromRaw', 375 => 0x2e },
	'jpgfromrawlength' => { 125 => [0x117,0x202] },
	'jpgfromrawstart' => { 125 => [0x111,0x201] },
	'jpgrecordedpixels' => { 388 => '14.1' },
	'jurisdiction' => { 532 => 'jurisdiction' },
	'jxldecodespeed' => { 125 => 0xcd4b },
	'jxldistance' => { 125 => 0xcd49 },
	'jxleffort' => { 125 => 0xcd4a },
	'keepexposure' => { 340 => 0x237, 341 => 0x237, 342 => 0x24f },
	'kelvinwb_01' => { 397 => 0x5 },
	'kelvinwb_02' => { 397 => 0x9 },
	'kelvinwb_03' => { 397 => 0xd },
	'kelvinwb_04' => { 397 => 0x11 },
	'kelvinwb_05' => { 397 => 0x15 },
	'kelvinwb_06' => { 397 => 0x19 },
	'kelvinwb_07' => { 397 => 0x1d },
	'kelvinwb_08' => { 397 => 0x21 },
	'kelvinwb_09' => { 397 => 0x25 },
	'kelvinwb_10' => { 397 => 0x29 },
	'kelvinwb_11' => { 397 => 0x2d },
	'kelvinwb_12' => { 397 => 0x31 },
	'kelvinwb_13' => { 397 => 0x35 },
	'kelvinwb_14' => { 397 => 0x39 },
	'kelvinwb_15' => { 397 => 0x3d },
	'kelvinwb_16' => { 397 => 0x41 },
	'kelvinwb_daylight' => { 397 => 0x1 },
	'kerneldenominators' => { 155 => 0x933 },
	'key' => { 564 => 'key' },
	'keystonecompensation' => { 349 => 0x1900 },
	'keystonedirection' => { 349 => 0x1901 },
	'keystonevalue' => { 349 => 0x1906 },
	'keyword' => { 427 => 'keyw', 554 => 'keyword' },
	'keywordinfo' => { 188 => 'Keywords' },
	'keywords' => { 148 => 0x19, 174 => 'Keywords', 355 => 'Keywords', 425 => 'Keywords', 429 => 'keywords', 528 => 'keywords', 550 => 'Keywords', 562 => 'Keywords' },
	'killdate' => { 554 => 'killDate' },
	'killdatea-platform' => { 554 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 554 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 154 => 0xf908, 157 => 0xe, 159 => [0xfa1e,0xfa52], 165 => 0x70 },
	'kodakimagewidth' => { 154 => 0xf907, 157 => 0xc, 159 => [0xfa1d,0xfa51], 165 => 0x6c },
	'kodakinfotype' => { 154 => 0xfa00 },
	'kodaklook' => { 155 => 0xe4c },
	'kodaklookprofile' => { 155 => 0x138a },
	'kodakmaker' => { 165 => 0x8 },
	'kodakmodel' => { 157 => 0x0, 165 => 0x28 },
	'kodaktag' => { 155 => 0x3ea },
	'kodakversion' => { 155 => 0x0 },
	'label' => { 359 => 'Label', 562 => 'Label' },
	'labelname1' => { 546 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 546 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 370 => 0x6f },
	'landscapeoutputhighlightpoint' => { 115 => 0x26 },
	'landscapeoutputshadowpoint' => { 115 => 0x27 },
	'landscaperawcolortone' => { 115 => 0x1f },
	'landscaperawcontrast' => { 115 => 0x21 },
	'landscaperawhighlight' => { 115 => 0x77 },
	'landscaperawhighlightpoint' => { 115 => 0x24 },
	'landscaperawlinear' => { 115 => 0x22 },
	'landscaperawsaturation' => { 115 => 0x20 },
	'landscaperawshadow' => { 115 => 0x80 },
	'landscaperawshadowpoint' => { 115 => 0x25 },
	'landscaperawsharpness' => { 115 => 0x23 },
	'landscapeunsharpmaskfineness' => { 115 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 115 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 115 => 0xa2 },
	'language' => { 260 => 0x8fc, 263 => 0x6a2, 264 => 0x6a2, 265 => 0x592, 266 => 0x5c2, 267 => 0x5da, 537 => 'language' },
	'languageidentifier' => { 148 => 0x87 },
	'largestvalidinteriorrectheight' => { 146 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 146 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 146 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 146 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 198 => 0x1b },
	'lastkeywordiptc' => { 195 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 195 => 'LastKeywordXMP' },
	'lastphotodate' => { 146 => 'LastPhotoDate' },
	'lasturl' => { 565 => 'LastURL' },
	'lateralchromaticaberration' => { 479 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 531 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 124 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 124 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 124 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 122 => 'Latitude' },
	'lc1' => { 399 => 0x2 },
	'lc10' => { 399 => 0xb },
	'lc11' => { 399 => 0xc },
	'lc12' => { 399 => 0xd },
	'lc14' => { 399 => 0xf },
	'lc15' => { 399 => 0x10 },
	'lc3' => { 399 => 0x4 },
	'lc4' => { 399 => 0x5 },
	'lc5' => { 399 => 0x6 },
	'lc6' => { 399 => 0x7 },
	'lc7' => { 399 => 0x8 },
	'lc8' => { 399 => 0x9 },
	'lcddisplayatpoweron' => { 90 => 0x811, 94 => 0xa },
	'lcddisplayreturntoshoot' => { 95 => 0x12 },
	'lcdillumination' => { 323 => '17.5', 324 => '5.2', 326 => '5.1', 327 => '5.1', 332 => '10.3', 333 => '4.2', 336 => '5.2', 337 => '5.1', 338 => '5.4', 339 => 0xf1, 340 => 0x101, 341 => 0x101, 342 => 0x117 },
	'lcdilluminationduringbulb' => { 90 => 0x408 },
	'lcdmatrix' => { 155 => 0xe74 },
	'lcdmatrixchickfix' => { 155 => 0xe75 },
	'lcdmatrixmarvin' => { 155 => 0xe76 },
	'lcdpanels' => { 89 => 0x8 },
	'lcheditor' => { 316 => 0x8ae85e },
	'legacyiptcdigest' => { 552 => 'LegacyIPTCDigest' },
	'legalcode' => { 532 => 'legalcode' },
	'lens' => { 125 => 0xfdea, 256 => 0x84, 531 => 'Lens' },
	'lensafstopbutton' => { 88 => 0x11, 89 => 0x13, 90 => 0x506, 91 => 0x10, 92 => 0x12, 95 => 0x13, 96 => 0x9 },
	'lensaperturerange' => { 455 => [0x30,0x48] },
	'lensblur' => { 534 => 'LensBlur', 536 => 'LensBlur' },
	'lensbluractive' => { 534 => [\'LensBlur','LensBlurActive'], 536 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 534 => [\'LensBlur','LensBlurBlurAmount'], 536 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 534 => [\'LensBlur','LensBlurBokehAspect'], 536 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 534 => [\'LensBlur','LensBlurBokehRotation'], 536 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 534 => [\'LensBlur','LensBlurBokehShape'], 536 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 534 => [\'LensBlur','LensBlurBokehShapeDetail'], 536 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 534 => [\'LensBlur','LensBlurCatEyeAmount'], 536 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 534 => [\'LensBlur','LensBlurCatEyeScale'], 536 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 534 => [\'LensBlur','LensBlurFocalRange'], 536 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 534 => [\'LensBlur','LensBlurFocalRangeSource'], 536 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 534 => [\'LensBlur','LensBlurHighlightsBoost'], 536 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 534 => [\'LensBlur','LensBlurHighlightsThreshold'], 536 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 534 => [\'LensBlur','LensBlurSampledArea'], 536 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 534 => [\'LensBlur','LensBlurSampledRange'], 536 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 534 => [\'LensBlur','LensBlurSphericalAberration'], 536 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 534 => [\'LensBlur','LensBlurSubjectRange'], 536 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 534 => [\'LensBlur','LensBlurVersion'], 536 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 339 => 0xb1, 340 => 0xad, 341 => 0xad, 342 => 0xad },
	'lenscorrectionsettings' => { 539 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 531 => 'LensDistortInfo' },
	'lensdistortionparams' => { 350 => 0x206 },
	'lensdriveend' => { 254 => 0x56 },
	'lensdrivenoaf' => { 90 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 467 => 0x3f0, 515 => 0xd },
	'lensfirmware' => { 446 => 0x20, 452 => 0xa004 },
	'lensfirmwareversion' => { 254 => 0x34, 346 => 0x204, 370 => 0x60, 467 => 0x3f3, 515 => 0x14 },
	'lensfocallength' => { 109 => 0xf0512, 399 => 0x9 },
	'lensfocalrange' => { 455 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 324 => '55.1', 326 => '52.1', 327 => '52.1', 336 => '52.1', 337 => '52.1' },
	'lensformat' => { 492 => 0x1891, 494 => 0x18bd, 495 => 0x18ed, 496 => 0x17f1, 498 => 0x106, 499 => 0x106, 510 => 0x603, 511 => 0x5d },
	'lensfstops' => { 248 => 0x7, 249 => 0xc, 250 => 0xd, 254 => 0xe, 256 => 0x8b, 399 => '0.3' },
	'lensfunc1button' => { 339 => 0xa3, 340 => 0x9f, 341 => 0x9f, 342 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 264 => 0x80a, 267 => 0x810 },
	'lensfunc2button' => { 339 => 0xab, 340 => 0xa7, 341 => 0xa7, 342 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 264 => 0x80c, 267 => 0x812 },
	'lensid' => { 254 => 0x30, 531 => 'LensID' },
	'lensidnumber' => { 248 => 0x6, 249 => 0xb, 250 => 0xc, 254 => 0xd },
	'lensinfo' => { 125 => 0xa432, 405 => 0x2a, 531 => 'LensInfo', 541 => 'LensSpecification' },
	'lenskind' => { 399 => 0x1 },
	'lensmake' => { 125 => 0xa433, 180 => 'Make', 541 => 'LensMake' },
	'lensmanualdistortionamount' => { 534 => 'LensManualDistortionAmount', 536 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 195 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 455 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 69 => 0x95, 125 => 0xa434, 180 => 'Model', 195 => 'LensModel', 251 => 0x18a, 252 => 0x18b, 253 => 0x2ac, 346 => 0x203, 405 => 0xc, 418 => 0x412, 436 => 'camera.lens_model', 541 => 'LensModel' },
	'lensmodulationoptimizer' => { 133 => 0x1045 },
	'lensmount' => { 467 => 0x99, 492 => 0x1892, 494 => 0x18be, 495 => 0x18ee, 496 => 0x17f2, 498 => 0x105, 499 => 0x105, 510 => 0x604, 511 => 0x5e },
	'lensmount2' => { 515 => 0x8 },
	'lensmounttype' => { 254 => 0x5f },
	'lenspositionabsolute' => { 254 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 534 => 'LensProfileChromaticAberrationScale', 536 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 534 => 'LensProfileDigest', 536 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 534 => 'LensProfileDistortionScale', 536 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 534 => 'LensProfileEnable', 536 => 'LensProfileEnable' },
	'lensprofilefilename' => { 534 => 'LensProfileFilename', 536 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 534 => 'LensProfileIsEmbedded', 536 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 534 => 'LensProfileMatchKeyCameraModelName', 536 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 534 => 'LensProfileMatchKeyExifMake', 536 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 534 => 'LensProfileMatchKeyExifModel', 536 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 534 => 'LensProfileMatchKeyIsRaw', 536 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 534 => 'LensProfileMatchKeyLensID', 536 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 534 => 'LensProfileMatchKeyLensInfo', 536 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 534 => 'LensProfileMatchKeyLensName', 536 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 534 => 'LensProfileMatchKeySensorFormatFactor', 536 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 369 => 0x370, 534 => 'LensProfileName', 536 => 'LensProfileName' },
	'lensprofilesetup' => { 534 => 'LensProfileSetup', 536 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 534 => 'LensProfileVignettingScale', 536 => 'LensProfileVignettingScale' },
	'lensproperties' => { 346 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 35 => 0x16b, 65 => 0x0, 125 => 0xa435, 180 => 'SerialNumber', 346 => 0x202, 368 => 0x321, 370 => 0x52, 435 => 'LENS', 446 => 0x30, 531 => 'LensSerialNumber', 541 => 'LensSerialNumber' },
	'lensshutterlock' => { 201 => 0x4a },
	'lensspec' => { 462 => 0x0, 463 => 0x0, 464 => 0x0, 479 => 0xb02a },
	'lensspecfeatures' => { 498 => [0x115,0x116], 499 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 350 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 37 => 0x16, 203 => 0x10c, 204 => 0x49bd, 256 => 0x83, 346 => 0x201, 361 => 0x16, 365 => 0x310, 367 => 0x303, 368 => 0x303, 370 => 0x51, 372 => 0x3405, 400 => 0x0, 401 => 0x0, 402 => 0x1, 403 => 0x1, 404 => 0x1, 406 => 0x0, 452 => 0xa003, 455 => 0x27, 479 => 0xb027, 492 => 0x1896, 494 => 0x18c2, 495 => 0x18f2, 496 => 0x17f6, 498 => 0x109, 499 => 0x109, 510 => 0x608, 511 => 0x62 },
	'lenstype2' => { 467 => 0x3f7, 492 => 0x1893, 494 => 0x18bf, 495 => 0x18ef, 496 => 0x17f3, 498 => 0x107, 499 => 0x107, 510 => 0x605, 511 => 0x60 },
	'lenstype3' => { 515 => 0x9 },
	'lenstypemake' => { 370 => 0xc4 },
	'lenstypemodel' => { 370 => [0xc5,0xe4] },
	'lenszoomposition' => { 507 => 0x19, 508 => 0x1e, 511 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 378 => 0x15 },
	'levelmeter' => { 435 => ['Lvlm','lvlm'] },
	'levelorientation' => { 407 => 0x0 },
	'license' => { 532 => 'license' },
	'licensee' => { 356 => 'Licensee' },
	'licenseeid' => { 356 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 356 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 356 => 'LicenseeImageNotes' },
	'licenseename' => { 356 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 356 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 356 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 356 => 'LicenseeTransactionID' },
	'licenseid' => { 356 => 'LicenseID' },
	'licensestartdate' => { 356 => 'LicenseStartDate' },
	'licensetransactiondate' => { 356 => 'LicenseTransactionDate' },
	'licensetype' => { 538 => 'licensetype' },
	'licensor' => { 356 => 'Licensor' },
	'licensorcity' => { 356 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 356 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 356 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 356 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 356 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 356 => 'LicensorImageID' },
	'licensorname' => { 356 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 356 => 'LicensorNotes' },
	'licensorpostalcode' => { 356 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 356 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 356 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 356 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 356 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 356 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 356 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 356 => 'LicensorTransactionID' },
	'licensorurl' => { 356 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 350 => 0x1009 },
	'lightingmode' => { 119 => 0x302a },
	'lightreading' => { 409 => 0x15 },
	'lightsource' => { 125 => 0x9208, 256 => 0x90, 353 => 0x1000, 540 => 'LightSource' },
	'lightsourcespecial' => { 454 => 0x21d },
	'lightswitch' => { 336 => '0.1', 338 => '0.1' },
	'lightvaluecenter' => { 350 => 0x103d },
	'lightvalueperiphery' => { 350 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 339 => 0x143, 340 => 0x153, 341 => 0x153, 342 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 339 => 0x141, 340 => 0x151, 341 => 0x151, 342 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 339 => 0x140, 340 => 0x150, 341 => 0x150, 342 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 339 => 0x13f, 340 => 0x14f, 341 => 0x14f, 342 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 339 => 0x11, 340 => 0x11, 341 => 0x11, 342 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 339 => 0x14, 340 => 0x14, 341 => 0x14, 342 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 339 => 0x13, 340 => 0x13, 341 => 0x13, 342 => 0x13 },
	'limitafareamodeselauto' => { 339 => 0x15, 340 => 0x15, 341 => 0x15, 342 => 0x15 },
	'limitafareamodeselection' => { 324 => '51.1', 326 => '49.1', 327 => '49.1', 336 => '49.1', 337 => '49.1' },
	'limitreleasemodeselc120' => { 341 => '269.4', 342 => '293.4' },
	'limitreleasemodeselc30' => { 341 => '269.3', 342 => '293.3' },
	'limitreleasemodeselch' => { 341 => '269.2', 342 => '293.2' },
	'limitreleasemodeselcl' => { 341 => '269.1', 342 => '293.1' },
	'limitreleasemodeselself' => { 341 => '269.5', 342 => '293.5' },
	'limitselectableimagearea16to9' => { 339 => 0x4d, 340 => 0x47, 341 => 0x47, 342 => 0x47 },
	'limitselectableimagearea1to1' => { 339 => 0x4c, 340 => 0x46, 341 => 0x46, 342 => 0x46 },
	'limitselectableimageareadx' => { 339 => 0x4b, 340 => 0x45, 341 => 0x45, 342 => 0x45 },
	'linearitylimitblue' => { 375 => 0x10 },
	'linearitylimitgreen' => { 375 => 0xf },
	'linearitylimitred' => { 375 => 0xe },
	'linearityuppermargin' => { 44 => 0x32c, 45 => 0x282, 46 => 0x296, 49 => [0x2ba,0x2d1,0x2d5], 51 => 0x1e5, 52 => [0x1fe,0x2de], 53 => [0x232,0x310], 54 => 0x31e },
	'linearizationtable' => { 125 => 0xc618 },
	'linearresponselimit' => { 125 => 0xc62e },
	'link' => { 554 => 'link' },
	'linkaetoafpoint' => { 388 => '14.2' },
	'linkedencodedrightsexpr' => { 548 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 548 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 548 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 548 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 260 => 0x3ec },
	'linlogcoring' => { 155 => 0x904 },
	'lithostratigraphicterms' => { 124 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 429 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 429 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 429 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 381 => 0x1fa, 390 => 0x3 },
	'liveviewaf' => { 328 => '32.1', 338 => '34.1' },
	'liveviewafareamode' => { 333 => '34.1' },
	'liveviewafmethod' => { 484 => 0x20 },
	'liveviewafmode' => { 333 => '34.2' },
	'liveviewafsetting' => { 467 => 0x36 },
	'liveviewbuttonoptions' => { 324 => '50.2', 326 => '48.2', 327 => '48.2', 336 => '48.2', 337 => '48.2' },
	'liveviewexposuresimulation' => { 90 => 0x810 },
	'liveviewfocusmode' => { 467 => [0x8b,0x28b] },
	'liveviewmetering' => { 467 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 324 => '21.2', 326 => '21.2', 327 => '21.2', 329 => '20.2', 330 => '20.2', 331 => '20.2', 333 => '20.2', 336 => '21.2', 337 => '21.2' },
	'liveviewshooting' => { 61 => 0x13 },
	'livingspecimen' => { 124 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 124 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 148 => 0x79 },
	'localizedcameramodel' => { 125 => 0xc615 },
	'locallocationname' => { 452 => 0x30 },
	'location' => { 255 => 0x9, 370 => 0x67, 526 => 'Location', 547 => 'Location', 553 => 'location', 554 => 'location' },
	'locationaccuracyhorizontal' => { 429 => 'location.accuracy.horizontal' },
	'locationareacode' => { 533 => 'lac' },
	'locationbody' => { 429 => 'location.body' },
	'locationcreated' => { 548 => 'LocationCreated' },
	'locationcreatedcity' => { 548 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 548 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 548 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 548 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 548 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 548 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 548 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 548 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 548 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 548 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 548 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 548 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 548 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 429 => 'location.date' },
	'locationinformation' => { 435 => 'loci' },
	'locationinfoversion' => { 255 => 0x0 },
	'locationname' => { 429 => 'location.name', 452 => 0x31 },
	'locationnote' => { 429 => 'location.note' },
	'locationrole' => { 429 => 'location.role' },
	'locationshown' => { 548 => 'LocationShown' },
	'locationshowncity' => { 548 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 548 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 548 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 548 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 548 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 548 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 548 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 548 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 548 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 548 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 548 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 548 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 548 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 90 => 0x709 },
	'logcomment' => { 564 => 'logComment' },
	'logscale' => { 155 => 0x902 },
	'longdescription' => { 427 => 'ldes' },
	'longexposurenoisereduction' => { 67 => 0x4, 90 => 0x201, 91 => 0x1, 92 => 0x2, 93 => 0x1, 94 => 0x1, 95 => 0x2, 96 => 0x1, 370 => 0x49, 465 => 0x2b, 466 => 0x25, 467 => 0x25, 479 => 0x2008, 484 => 0x11, 511 => 0x44 },
	'longexposurenoisereduction2' => { 61 => 0x8 },
	'longexposurenrused' => { 370 => 0xbe },
	'longitude' => { 122 => 'Longitude' },
	'look' => { 534 => 'Look', 536 => 'Look' },
	'lookamount' => { 534 => [\'Look','LookAmount'], 536 => [\'Look','LookAmount'] },
	'lookcluster' => { 534 => [\'Look','LookCluster'], 536 => [\'Look','LookCluster'] },
	'lookcopyright' => { 534 => [\'Look','LookCopyright'], 536 => [\'Look','LookCopyright'] },
	'lookgroup' => { 534 => [\'Look','LookGroup'], 536 => [\'Look','LookGroup'] },
	'lookname' => { 534 => 'LookName', 536 => 'LookName' },
	'lookparameters' => { 534 => [\'Look','LookParameters'], 536 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 534 => [\'Look','LookParametersCameraProfile'], 536 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 534 => [\'Look','LookParametersClarity2012'], 536 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 534 => [\'Look','LookParametersConvertToGrayscale'], 536 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 534 => [\'Look','LookParametersHighlights2012'], 536 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 534 => [\'Look','LookParametersLookTable'], 536 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 534 => [\'Look','LookParametersProcessVersion'], 536 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 534 => [\'Look','LookParametersShadows2012'], 536 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 534 => [\'Look','LookParametersToneCurvePV2012'], 536 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 534 => [\'Look','LookParametersToneCurvePV2012Blue'], 536 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 534 => [\'Look','LookParametersToneCurvePV2012Green'], 536 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 534 => [\'Look','LookParametersToneCurvePV2012Red'], 536 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 534 => [\'Look','LookParametersVersion'], 536 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 534 => [\'Look','LookSupportsAmount'], 536 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 534 => [\'Look','LookSupportsMonochrome'], 536 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 534 => [\'Look','LookSupportsOutputReferred'], 536 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 534 => [\'Look','LookUUID'], 536 => [\'Look','LookUUID'] },
	'loop' => { 564 => 'loop' },
	'loopstyle' => { 435 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 534 => 'LuminanceAdjustmentAqua', 536 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 534 => 'LuminanceAdjustmentBlue', 536 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 534 => 'LuminanceAdjustmentGreen', 536 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 534 => 'LuminanceAdjustmentMagenta', 536 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 534 => 'LuminanceAdjustmentOrange', 536 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 534 => 'LuminanceAdjustmentPurple', 536 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 534 => 'LuminanceAdjustmentRed', 536 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 534 => 'LuminanceAdjustmentYellow', 536 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 114 => 0x150 },
	'luminancecurvepoints' => { 114 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 109 => 0x20600, 115 => 0x5f, 455 => 0x1b },
	'luminancenoisereductioncontrast' => { 534 => 'LuminanceNoiseReductionContrast', 536 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 534 => 'LuminanceNoiseReductionDetail', 536 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 115 => 0x6d },
	'luminancesmoothing' => { 534 => 'LuminanceSmoothing', 536 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 90 => [0x40b,0x40c] },
	'lyrics' => { 427 => "\xa9lyr", 435 => "\xa9lyr", 564 => 'lyrics' },
	'lyricsuri' => { 435 => 'lrcu' },
	'm16cversion' => { 365 => 0x333 },
	'macatom' => { 535 => 'macAtom' },
	'macatomapplicationcode' => { 535 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 535 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 535 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 124 => 'MachineObservation' },
	'machineobservationday' => { 124 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 124 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 124 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 124 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 124 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 124 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 124 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationeventtype' => { 124 => [\'MachineObservation','MachineObservationEventType'] },
	'machineobservationfieldnotes' => { 124 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 124 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 124 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 124 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 124 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 124 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 124 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 124 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 124 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 124 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 124 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 124 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 124 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 133 => 0x1020, 135 => 0x202, 168 => 0x2b, 350 => 0x202, 444 => 0x21, 454 => 0x202, 479 => 0xb040 },
	'macroled' => { 348 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 61 => 0x10 },
	'macromode' => { 37 => 0x1, 198 => 0xb, 345 => 0x300, 370 => 0x1c, 445 => 0x1009 },
	'magentahsl' => { 109 => 0x20917 },
	'magicfilter' => { 345 => 0x52c },
	'magnifiedview' => { 92 => 0x11, 94 => 0x9 },
	'mainboardversion' => { 155 => 0x438 },
	'maindialexposurecomp' => { 334 => '0.6' },
	'mainingredient' => { 556 => 'mainIngredient' },
	'majorbrand' => { 429 => 'major_brand' },
	'majorversion' => { 524 => 'MajorVersion' },
	'make' => { 104 => 0x0, 121 => 0x1, 125 => 0x10f, 173 => 'Make', 359 => 'Make', 375 => 0x10f, 429 => 'make', 435 => ['@mak',"\xa9mak"], 553 => 'make', 560 => 'Make' },
	'makernote' => { 540 => 'MakerNote' },
	'makernoteapple' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecanon' => { 87 => 'CMT3', 123 => 'MakN', 125 => 0x927c },
	'makernotecasio' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecasio2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedji' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedjiinfo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteflir' => { 123 => 'MakN', 125 => 0x927c },
	'makernotefujifilm' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotegoogle' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehasselblad' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteisl' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvc' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvctext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak10' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak11' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak12' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak7' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8c' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak9' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodakunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekyocera' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica10' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica3' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica4' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica5' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica7' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica8' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica9' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotemotorola' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenintendo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteoffset' => { 454 => 0xff },
	'makernoteolympus' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax6' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentaxunknown' => { 435 => 'PXMN' },
	'makernotephaseone' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyxhyperfire' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyxhyperfire2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyxhyperfire4k' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyxmicrofire' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyxultrafire' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohpentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohtext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesafety' => { 125 => 0xc635 },
	'makernotesamsung1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyo' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyoc4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyopatch' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesigma' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonyericsson' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonysrf' => { 123 => 'MakN', 125 => 0x927c },
	'makernotetype' => { 445 => 0x1 },
	'makernoteunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknownbinary' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknowntext' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 203 => 0x0, 256 => 0x1, 350 => 0x0, 370 => 0x8000, 449 => 0x0, 452 => 0x1, 455 => [0x1d,0x1f], 468 => 0x2000 },
	'makerurl' => { 435 => "\xa9mal" },
	'managedfrom' => { 565 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 565 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 565 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 565 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 565 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 565 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 565 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 565 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 565 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 565 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 565 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 565 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 565 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 565 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 565 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 565 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 565 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 565 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 565 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 565 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 565 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 565 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 565 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 565 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 565 => 'Manager' },
	'managervariant' => { 565 => 'ManagerVariant' },
	'manageto' => { 565 => 'ManageTo' },
	'manageui' => { 565 => 'ManageUI' },
	'manifest' => { 565 => 'Manifest' },
	'manifestlinkform' => { 565 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 565 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 565 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 565 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 565 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 565 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 565 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 565 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 565 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 565 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 565 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 565 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 565 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 565 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 565 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 565 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 565 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 565 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 565 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 565 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 565 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 565 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 565 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 565 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 565 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 565 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 565 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 565 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 345 => 0x900, 370 => 0x86 },
	'manometerreading' => { 345 => 0x901 },
	'manualafpointselectpattern' => { 90 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 348 => 0x1209 },
	'manualflashoutput' => { 37 => 0x29, 325 => '8.2', 328 => '22.2', 329 => '23.1', 330 => '23.2', 332 => '16.2', 333 => '23.2', 334 => '8.2', 335 => '23.2', 338 => '24.2', 445 => 0x100c },
	'manualflashstrength' => { 345 => 0x406 },
	'manualfocusdistance' => { 256 => 0x85, 350 => 0x100c, 454 => 0x223 },
	'manualfocuspointillumination' => { 339 => 0x17, 340 => 0x17, 341 => 0x17, 342 => 0x17 },
	'manualfocusringinafmode' => { 339 => 0x1b, 340 => 0x1a, 341 => 0x1a, 342 => 0x1a },
	'manualtv' => { 89 => 0x5, 90 => 0x705 },
	'manufacturedate' => { 208 => 0x6705, 387 => 0x1 },
	'manufacturedate1' => { 447 => 0x4 },
	'manufacturedate2' => { 447 => 0x5 },
	'manufacturer' => { 143 => 'Manufacturer', 553 => 'manufacturer' },
	'mariahchromablursize' => { 155 => 0xf0d },
	'mariahmaphithreshold' => { 155 => 0xf0c },
	'mariahmaplothreshold' => { 155 => 0xf0b },
	'mariahsigmathreshold' => { 155 => 0xf0e },
	'mariahtexturethreshold' => { 155 => 0xf0a },
	'marked' => { 550 => 'Marked', 568 => 'Marked' },
	'markers' => { 564 => 'markers' },
	'markerscomment' => { 564 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 564 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 564 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 564 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 564 => [\'markers','markersCuePointType'] },
	'markersduration' => { 564 => [\'markers','markersDuration'] },
	'markerslocation' => { 564 => [\'markers','markersLocation'] },
	'markersname' => { 564 => [\'markers','markersName'] },
	'markersprobability' => { 564 => [\'markers','markersProbability'] },
	'markersspeaker' => { 564 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 564 => [\'markers','markersStartTime'] },
	'markerstarget' => { 564 => [\'markers','markersTarget'] },
	'markerstype' => { 564 => [\'markers','markersType'] },
	'maskedareas' => { 125 => 0xc68e },
	'maskgroupbasedcorractive' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 534 => 'MaskGroupBasedCorrections', 536 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 534 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 148 => 0xb9 },
	'mastergain' => { 282 => 0x50 },
	'materialsample' => { 124 => 'MaterialSample' },
	'materialsampleid' => { 124 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 324 => '50.1', 326 => '48.1', 327 => '48.1', 336 => '48.1', 337 => '48.1', 340 => 0x233, 341 => 0x233, 342 => 0x24b },
	'matrixselectk' => { 155 => 0x91b },
	'matrixselectthreshold' => { 155 => 0x91a },
	'matrixselectthreshold1' => { 155 => 0x91e },
	'matrixselectthreshold2' => { 155 => 0x91f },
	'matrixstructure' => { 434 => 0xa },
	'maxaperture' => { 37 => 0x1a, 155 => 0x3f9, 161 => 0x6103, 180 => 'MaxAperture', 198 => 0x17, 204 => 0x49c5, 254 => 0x36, 346 => 0x20a, 399 => '14.1' },
	'maxapertureatmaxfocal' => { 133 => 0x1407, 180 => 'MaxApertureAtMaxFocal', 248 => 0xb, 249 => 0x10, 250 => 0x11, 254 => 0x12, 346 => 0x206 },
	'maxapertureatminfocal' => { 133 => 0x1406, 248 => 0xa, 249 => 0xf, 250 => 0x10, 254 => 0x11, 346 => 0x205 },
	'maxaperturevalue' => { 125 => 0x9205, 418 => 0x414, 540 => 'MaxApertureValue' },
	'maxavailheight' => { 548 => 'MaxAvailHeight' },
	'maxavailwidth' => { 548 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 323 => 0xb, 324 => 0xc, 326 => '12.1', 327 => '12.1', 332 => 0xc, 333 => 0xb, 336 => '12.1', 337 => '12.1', 339 => 0x41, 340 => 0x3d, 341 => 0x3d, 342 => 0x3d },
	'maxfaces' => { 349 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 37 => 0x17, 133 => 0x1405, 180 => 'MaxFocalLength', 248 => 0x9, 249 => 0xe, 250 => 0xf, 254 => 0x10, 346 => 0x208, 492 => 0x127c, 493 => 0x1138, 494 => 0x330, 495 => 0x330, 496 => 0x30e },
	'maxfocallength2' => { 66 => 0x9 },
	'maximumaperturelv' => { 264 => 0x89e },
	'maximumdensityrange' => { 150 => 0x8c },
	'maxnumafpoints' => { 382 => 0x2 },
	'maxpagesize' => { 569 => 'MaxPageSize' },
	'maxpagesizeh' => { 569 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 569 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 569 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 155 => 0xc7d },
	'maxsamplevalue' => { 125 => 0x119 },
	'maxstorage' => { 559 => 'maxstorage' },
	'mb-d10batteries' => { 323 => '12.6' },
	'mb-d10batterytype' => { 332 => '13.3' },
	'mb-d11batterytype' => { 333 => '2.3' },
	'mb-d12batterytype' => { 336 => '3.2' },
	'mb-d80batteries' => { 334 => '6.5' },
	'mb-d80batterytype' => { 338 => '3.2' },
	'mcuversion' => { 248 => 0xc, 249 => 0x11, 250 => 0x12, 254 => 0x13 },
	'md5digest' => { 181 => 'zmd5' },
	'mditemfindercomment' => { 190 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 190 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 190 => 'MDItemFSLabel' },
	'mditemusertags' => { 190 => 'MDItemUserTags' },
	'meal' => { 556 => 'meal' },
	'measuredev' => { 28 => 0x9, 82 => 0x3, 103 => 0x1814, 173 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 82 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 204 => 0x690, 365 => 0x312, 368 => 0x312, 369 => 0x312, 372 => 0x3407 },
	'measuredrggb' => { 70 => 0x1 },
	'measuredrggbdata' => { 48 => 0x287 },
	'measurementaccuracy' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 124 => 'MeasurementOrFact' },
	'measurementremarks' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 143 => 'MeasureType' },
	'mechanicalshuttercount' => { 256 => 0x37 },
	'mediaclassprimaryid' => { 196 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 196 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 356 => 'MediaConstraints' },
	'mediacreatedate' => { 431 => 0x1 },
	'mediaeventiddate' => { 522 => 'MediaEventIdDate' },
	'mediamodifydate' => { 431 => 0x2 },
	'mediasummarycode' => { 356 => 'MediaSummaryCode' },
	'mediatype' => { 427 => 'stik' },
	'mediauid' => { 435 => 'MUID' },
	'memoaudioquality' => { 90 => 0x812 },
	'memorycardconfiguration' => { 471 => 0x16 },
	'memorycardnumber' => { 233 => 0x2 },
	'menubuttondisplayposition' => { 88 => 0xb, 91 => 0xa, 92 => 0xb, 95 => 0xb },
	'menubuttonreturn' => { 96 => 0xb },
	'menumonitorofftime' => { 323 => '26.1', 324 => '22.1', 326 => '22.1', 327 => '22.1', 331 => '21.1', 332 => '8.2', 333 => '21.1', 336 => '22.1', 337 => '22.1', 338 => '22.1', 339 => 0x39, 340 => 0x35, 341 => 0x35, 342 => 0x35 },
	'mergedimages' => { 370 => 0x76 },
	'metadataauthority' => { 548 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 548 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 548 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 562 => 'MetadataDate' },
	'metadataeditingsoftware' => { 125 => 0xa43c, 541 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 548 => 'metadataLastEdited' },
	'metadatalasteditor' => { 548 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 548 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 548 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 564 => 'metadataModDate' },
	'metaversion' => { 487 => 0x34 },
	'meterinfo1row1' => { 480 => 0x0, 481 => 0x0 },
	'meterinfo1row2' => { 480 => 0x6c, 481 => 0x5a },
	'meterinfo1row3' => { 480 => 0xd8, 481 => 0xb4 },
	'meterinfo1row4' => { 480 => 0x144, 481 => 0x10e },
	'meterinfo1row5' => { 480 => 0x1b0, 481 => 0x168 },
	'meterinfo1row6' => { 480 => 0x21c, 481 => 0x1c2 },
	'meterinfo1row7' => { 480 => 0x288, 481 => 0x21c },
	'meterinfo2row1' => { 480 => 0x2f4, 481 => 0x276 },
	'meterinfo2row2' => { 480 => 0x378, 481 => 0x2e4 },
	'meterinfo2row3' => { 480 => 0x3fc, 481 => 0x352 },
	'meterinfo2row4' => { 480 => 0x480, 481 => 0x3c0 },
	'meterinfo2row5' => { 480 => 0x504, 481 => 0x42e },
	'meterinfo2row6' => { 480 => 0x588, 481 => 0x49c },
	'meterinfo2row7' => { 480 => 0x60c, 481 => 0x50a },
	'meterinfo2row8' => { 480 => 0x690, 481 => 0x578 },
	'meterinfo2row9' => { 480 => 0x714, 481 => 0x5e6 },
	'metering' => { 325 => '6.1' },
	'meteringmode' => { 37 => 0x11, 125 => 0x9207, 157 => 0x1c, 198 => 0x7, 199 => 0x25, 201 => 0x12, 345 => 0x202, 409 => 0x17, 455 => 0x9, 465 => 0x15, 466 => 0x13, 467 => 0x7, 484 => 0x3, 488 => 0x1174, 489 => 0x1178, 490 => 0x1154, 491 => 0x11d0, 492 => 0x11ac, 493 => 0x1064, 494 => 0x25c, 495 => 0x25c, 496 => 0x24b, 540 => 'MeteringMode' },
	'meteringmode2' => { 388 => '2.1', 479 => 0x202c },
	'meteringmode3' => { 388 => '16.1' },
	'meteringoffscaleindicator' => { 201 => 0x53 },
	'meteringtime' => { 323 => '22.2', 325 => '3.2', 328 => '17.1', 329 => '18.1', 332 => '7.3', 333 => '18.1', 334 => '3.2', 338 => '19.1' },
	'micro1version' => { 441 => 0x1f },
	'micro2version' => { 441 => 0x2d },
	'microphoneattenuator' => { 262 => 0x34e, 265 => 0x2d2, 266 => 0x2fa, 267 => 0x2fa },
	'microphonefrequencyresponse' => { 262 => 0x350, 265 => 0x2d4, 266 => 0x2fc, 267 => 0x2fc },
	'microphonejackpower' => { 262 => 0x376, 265 => 0x2fa, 266 => 0x322, 267 => 0x322 },
	'microphonesensitivity' => { 262 => 0x34c, 265 => 0x2d0, 266 => 0x2f8, 267 => 0x2f8 },
	'microvideo' => { 140 => 'MicroVideo' },
	'microvideooffset' => { 140 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 140 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 140 => 'MicroVideoVersion' },
	'midrangesharpness' => { 276 => 0x3b },
	'mieversion' => { 181 => '0Vers' },
	'mime' => { 143 => 'Mime' },
	'minaperture' => { 37 => 0x1b, 155 => 0x3f8, 180 => 'MinAperture', 399 => '0.2' },
	'minaperturevalue' => { 418 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 37 => 0x18, 133 => 0x1404, 180 => 'MinFocalLength', 248 => 0x8, 249 => 0xd, 250 => 0xe, 254 => 0xf, 346 => 0x207, 492 => 0x127a, 493 => 0x1136, 494 => 0x32e, 495 => 0x32e, 496 => 0x30c },
	'minfocallength2' => { 66 => 0x8 },
	'minfocusdistance' => { 399 => 0x3 },
	'minimumiso' => { 370 => 0xe8 },
	'minintegrationrows' => { 155 => 0x1874 },
	'minoltadate' => { 198 => 0x15 },
	'minoltaimagesize' => { 198 => 0x4, 199 => 0xc, 200 => 0x2, 203 => 0x103 },
	'minoltamodelid' => { 198 => 0x25 },
	'minoltaquality' => { 198 => 0x5, 199 => 0xd, 200 => 0x3, 203 => [0x102,0x103] },
	'minoltatime' => { 198 => 0x16 },
	'minormodelagedisclosure' => { 356 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 429 => 'minor_version', 524 => 'MinorVersion' },
	'minsamplevalue' => { 125 => 0x118 },
	'mirrorlockup' => { 88 => 0xc, 89 => 0xc, 90 => 0x60f, 91 => 0xb, 92 => 0xc, 93 => 0x6, 94 => 0x6, 95 => 0xc, 96 => 0x3 },
	'mobilecountrycode' => { 533 => 'mcc' },
	'mobilenetworkcode' => { 533 => 'mnc' },
	'moddate' => { 359 => 'modify-date', 550 => 'ModDate' },
	'modedialposition' => { 471 => 0x14 },
	'model' => { 104 => 0x6, 125 => 0x110, 143 => 'Model', 173 => 'Model', 359 => 'Model', 375 => 0x110, 409 => 0x23f, 429 => 'model', 435 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 455 => 0x84, 553 => 'model', 560 => 'Model' },
	'modelage' => { 548 => 'ModelAge' },
	'modelid' => { 343 => 0x0 },
	'modelingflash' => { 323 => '21.4', 324 => '31.1', 326 => '31.1', 327 => '31.1', 332 => '26.4', 333 => '30.2', 334 => '7.4', 335 => '30.1', 336 => '31.1', 337 => '31.1', 338 => '31.3', 339 => 0x61, 340 => 0x5d, 341 => 0x5d, 342 => 0x5d },
	'modelreleaseid' => { 356 => 'ModelReleaseID' },
	'modelreleasestatus' => { 356 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 502 => 0x52, 503 => 0x46, 504 => 0x53 },
	'modeltiepoint' => { 125 => 0x8482 },
	'modeltransform' => { 125 => 0x85d8 },
	'modelyear' => { 553 => 'modelYear' },
	'modificationdate' => { 554 => 'modificationDate' },
	'modifiedcolortemp' => { 71 => 0x9 },
	'modifieddigitalgain' => { 71 => 0xb },
	'modifiedparamflag' => { 62 => 0x1 },
	'modifiedpicturestyle' => { 71 => 0xa },
	'modifiedsaturation' => { 345 => 0x504 },
	'modifiedsensorbluelevel' => { 71 => 0x5 },
	'modifiedsensorredlevel' => { 71 => 0x4 },
	'modifiedsharpness' => { 71 => 0x2 },
	'modifiedsharpnessfreq' => { 71 => 0x3 },
	'modifiedtonecurve' => { 71 => 0x1 },
	'modifiedwhitebalance' => { 71 => 0x8 },
	'modifiedwhitebalanceblue' => { 71 => 0x7 },
	'modifiedwhitebalancered' => { 71 => 0x6 },
	'modifydate' => { 125 => 0x132, 174 => 'ModifyDate', 355 => 'ModDate', 357 => 'tIME', 425 => 'ModDate', 432 => 0x2, 562 => 'ModifyDate' },
	'moirefilter' => { 125 => 0xfe58, 534 => 'MoireFilter', 536 => 'MoireFilter' },
	'monitorbrightness' => { 260 => 0x904, 263 => 0x69a, 264 => 0x6aa, 265 => 0x59a, 266 => 0x5ca, 267 => 0x5e2 },
	'monitordisplayoff' => { 201 => 0x4c },
	'monitormatrix' => { 155 => 0x8fc },
	'monitorofftime' => { 323 => '18.2', 325 => '3.1', 334 => '3.1' },
	'monochromecolor' => { 345 => 0x53b },
	'monochromecontrast' => { 115 => 0x3c },
	'monochromefiltereffect' => { 109 => 0x20307, 115 => 0x3a, 370 => 0xac, 409 => 0x73 },
	'monochromegraineffect' => { 370 => 0xd2 },
	'monochromelinear' => { 115 => 0x3d },
	'monochromeoutputhighlightpoint' => { 115 => 0x41 },
	'monochromeoutputshadowpoint' => { 115 => 0x42 },
	'monochromeprofilesettings' => { 345 => 0x537 },
	'monochromerawhighlight' => { 115 => 0x7a },
	'monochromerawhighlightpoint' => { 115 => 0x3f },
	'monochromerawshadow' => { 115 => 0x83 },
	'monochromerawshadowpoint' => { 115 => 0x40 },
	'monochromesharpness' => { 115 => 0x3e },
	'monochrometoning' => { 409 => 0x74 },
	'monochrometoningeffect' => { 109 => 0x20306, 115 => 0x3b },
	'monochromeunsharpmaskfineness' => { 115 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 115 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 115 => 0xb4 },
	'monochromevignetting' => { 345 => 0x53a },
	'monthdaycreated' => { 157 => 0x12, 166 => 0xe },
	'mood' => { 196 => 'WM/Mood' },
	'moonphase' => { 437 => 0x12, 438 => 0x4c, 439 => 0x37, 440 => 0x5c, 441 => 0x43 },
	'morepermissions' => { 532 => 'morePermissions' },
	'motionphoto' => { 140 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 140 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 140 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 430 => 'mpvd' },
	'motionsensitivity' => { 437 => 0x29, 438 => 0x60, 439 => 0x49, 440 => 0x70 },
	'movementcount' => { 427 => "\xa9mvc" },
	'movementname' => { 427 => "\xa9mvn" },
	'movementnumber' => { 427 => "\xa9mvi" },
	'movieactived-lighting' => { 261 => 0x238, 262 => 0x334, 265 => 0x2b8, 266 => 0x2e0, 267 => 0x2e0 },
	'movieaelockbuttonassignment' => { 336 => '40.1' },
	'movieaf-onbutton' => { 339 => 0xd3, 340 => 0xcb, 341 => 0xcb, 342 => 0xcb },
	'movieafareamode' => { 262 => 0x342, 265 => 0x2c6, 266 => 0x2ee, 267 => 0x2ee, 341 => 0x203 },
	'movieafspeed' => { 339 => 0xe5, 340 => 0xdd, 341 => 0xdd, 342 => 0xdd },
	'movieafspeedapply' => { 339 => 0xe7, 340 => 0xdf, 341 => 0xdf, 342 => 0xdf },
	'movieaftrackingsensitivity' => { 339 => 0xe9, 340 => 0xe1, 341 => 0xe1, 342 => 0xe1 },
	'movieaperturelock' => { 340 => 0x259, 341 => 0x259, 342 => 0x271 },
	'movieautodistortioncontrol' => { 261 => 0x242 },
	'moviediffractioncompensation' => { 261 => 0x241 },
	'moviedxcropalert' => { 262 => 0x377, 265 => 0x2fb, 266 => 0x323, 267 => 0x323 },
	'movieelectronicvr' => { 262 => 0x348, 265 => 0x2cc, 266 => 0x2f4, 267 => 0x2f4 },
	'movieevfgrid' => { 340 => 0x21d, 341 => 0x21d, 342 => 0x235 },
	'movieflickerreduction' => { 262 => 0x33c, 265 => 0x2c0, 266 => 0x2e8, 267 => 0x2e8 },
	'moviefocusmode' => { 261 => 0x248, 262 => 0x340, 265 => 0x2c4, 266 => 0x2ec, 267 => 0x2ec },
	'moviefocuspointlock' => { 340 => 0x226, 341 => 0x226, 342 => 0x23e },
	'movieframerate' => { 260 => 0x48c, 261 => 0x1f8, 262 => 0x374, 265 => 0x2f4, 266 => 0x31c, 267 => 0x31c },
	'movieframesize' => { 260 => 0x48a, 261 => 0x1f6, 262 => 0x372, 265 => 0x2f2, 266 => 0x31a, 267 => 0x31a },
	'moviefunc1button' => { 326 => '41.1', 327 => '41.1', 337 => '41.1', 339 => 0xc7, 340 => 0xc3, 341 => 0xc3, 342 => 0xc3 },
	'moviefunc2button' => { 339 => 0xcd, 340 => 0xc7, 341 => 0xc7, 342 => 0xc7 },
	'moviefunc3button' => { 341 => 0x127, 342 => 0x13f },
	'moviefunctionbutton' => { 324 => '41.1', 336 => '41.1' },
	'moviefunctionbuttonplusdials' => { 324 => '52.1' },
	'moviehighisonoisereduction' => { 261 => 0x23c, 262 => 0x336, 265 => 0x2ba, 266 => 0x2e2, 267 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 340 => 0x215, 341 => 0x215, 342 => 0x22d },
	'moviehighreszoom' => { 262 => 0x380, 266 => 0x32c, 267 => 0x32c },
	'movieimagearea' => { 262 => 0x2da, 265 => 0x25c, 266 => 0x286, 267 => 0x286 },
	'movieisoautocontrolmanualmode' => { 262 => 0x2e8, 265 => 0x26a, 266 => 0x294, 267 => 0x294 },
	'movieisoautohilimit' => { 262 => 0x2e6, 265 => 0x268, 266 => 0x292, 267 => 0x292 },
	'movieisoautomanualmode' => { 261 => 0x204, 262 => 0x2ea, 265 => 0x26c, 266 => 0x296, 267 => 0x296 },
	'movielenscontrolring' => { 339 => 0xdf, 340 => 0xd7, 341 => 0xd7, 342 => 0xd7 },
	'moviemeteringmode' => { 262 => 0x33e, 265 => 0x2c2, 266 => 0x2ea, 267 => 0x2ea },
	'moviemidtonedisplayrange' => { 340 => 0x219, 341 => 0x219, 342 => 0x231 },
	'moviemidtonedisplayvalue' => { 340 => 0x217, 341 => 0x217, 342 => 0x22f },
	'moviemultiselector' => { 339 => 0xe1, 340 => 0xd9, 341 => 0xcf, 342 => 0xcf },
	'moviepreviewbutton' => { 324 => '41.2', 326 => '41.2', 327 => '41.2', 336 => '41.2', 337 => '41.2' },
	'moviepreviewbuttonplusdials' => { 324 => '52.2' },
	'movierecordbuttonplaybackmode' => { 339 => 0x1af, 340 => 0x1b5, 341 => 0x1b5, 342 => 0x1cd },
	'movieshutterbutton' => { 324 => '38.3', 326 => '38.3', 327 => '38.3', 336 => '38.3', 337 => '38.3' },
	'movieshutterspeedlock' => { 340 => 0x225, 341 => 0x225, 342 => 0x23d },
	'movieslowmotion' => { 260 => 0x416, 261 => 0x1fa },
	'moviesoundrecording' => { 262 => 0x34a, 265 => 0x2ce, 266 => 0x2f6, 267 => 0x2f6 },
	'moviesubjectdetection' => { 262 => 0x378, 265 => 0x2fc, 266 => 0x324, 267 => 0x324 },
	'moviesubselectorassignment' => { 324 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 324 => '53.1' },
	'movietonemap' => { 265 => 0x2ec, 266 => 0x314, 267 => 0x314 },
	'movietype' => { 245 => 0x2ca, 260 => 0x41a, 261 => 0x1fe, 262 => 0x2e4, 265 => 0x266, 266 => 0x290, 267 => 0x290 },
	'movievibrationreduction' => { 261 => 0x24e },
	'movievibrationreductionsameasphoto' => { 261 => 0x24f },
	'movievignettecontrol' => { 261 => 0x23e, 262 => 0x1b0, 265 => 0x1a0, 266 => 0x1b4, 267 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 261 => 0x240 },
	'movievrmode' => { 262 => 0x344, 265 => 0x2c8, 266 => 0x2f0, 267 => 0x2f0 },
	'moviezebrapattern' => { 340 => 0x213, 341 => 0x213, 342 => 0x22b },
	'multiburstimageheight' => { 479 => 0x1002 },
	'multiburstimagewidth' => { 479 => 0x1001 },
	'multiburstmode' => { 479 => 0x1000 },
	'multicontrollerwhilemetering' => { 90 => 0x517 },
	'multiexposure' => { 73 => 0x1, 370 => 0xb4 },
	'multiexposureautogain' => { 269 => 0x3 },
	'multiexposurecontrol' => { 73 => 0x2 },
	'multiexposuremode' => { 269 => 0x1, 270 => 0x1 },
	'multiexposureoverlaymode' => { 270 => 0x3 },
	'multiexposureshots' => { 73 => 0x3, 260 => 0x1be, 262 => 0x9a, 265 => 0x8e, 266 => 0x9c, 267 => 0x9c, 269 => 0x2, 270 => 0x2 },
	'multiframenoisereduction' => { 467 => 0x35, 479 => 0x200b, 484 => 0x15 },
	'multiframenreffect' => { 479 => 0x2023 },
	'multifunctionlock' => { 90 => 0x70f },
	'multipleexposure' => { 133 => 0x1037 },
	'multipleexposuremode' => { 260 => 0x1bc, 262 => 0x98, 265 => 0x8c, 266 => 0x9a, 267 => 0x9a, 349 => 0x101c },
	'multipleexposureset' => { 388 => '10.1' },
	'multisample' => { 282 => 0x40 },
	'multiselector' => { 323 => '9.4', 324 => '10.3', 326 => '10.3', 327 => '10.3', 332 => '27.4', 336 => '10.3', 337 => '10.3' },
	'multiselectorliveview' => { 323 => '4.3', 326 => '37.1', 327 => '37.1', 336 => '37.1', 337 => '37.1' },
	'multiselectorliveviewmode' => { 296 => 0x18c2 },
	'multiselectorplaybackmode' => { 323 => ['13.5','9.2'], 324 => '10.2', 327 => '10.2', 332 => '27.2', 336 => '10.2', 337 => '10.2', 339 => 0xb7, 340 => 0xb3, 341 => 0xb3, 342 => 0xb3 },
	'multiselectorshootmode' => { 323 => '9.1', 324 => '10.1', 326 => '10.1', 327 => '10.1', 332 => '27.1', 336 => '10.1', 337 => '10.1', 339 => 0xb3, 340 => 0xaf, 341 => 0xaf, 342 => 0xaf },
	'multishot' => { 375 => 0x121 },
	'mute' => { 426 => 'player.movie.audio.mute', 429 => 'player.movie.audio.mute' },
	'mycolormode' => { 74 => 0x2 },
	'name' => { 435 => 'name', 534 => 'Name', 536 => 'Name' },
	'narrator' => { 427 => "\xa9nrt" },
	'nationalcatalognumber' => { 554 => 'nationalCatalogNumber' },
	'nativedigest' => { 540 => 'NativeDigest', 560 => 'NativeDigest' },
	'nativeformat' => { 529 => 'NativeFormat' },
	'ndfilter' => { 82 => 0x1c, 345 => 0x204, 445 => 0x1019 },
	'near' => { 143 => 'Near' },
	'nefbitdepth' => { 256 => 0xe22 },
	'nefcompression' => { 256 => 0x93, 257 => 0xa },
	'neflinearizationtable' => { 256 => 0x96 },
	'negativecachelargepreviewsize' => { 534 => 'NegativeCacheLargePreviewSize', 536 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 534 => 'NegativeCacheMaximumSize', 536 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 534 => 'NegativeCachePath', 536 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 531 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 409 => 0x88 },
	'neutraloutputhighlightpoint' => { 115 => 0x2f },
	'neutraloutputshadowpoint' => { 115 => 0x30 },
	'neutralrawcolortone' => { 115 => 0x28 },
	'neutralrawcontrast' => { 115 => 0x2a },
	'neutralrawhighlight' => { 115 => 0x78 },
	'neutralrawhighlightpoint' => { 115 => 0x2d },
	'neutralrawlinear' => { 115 => 0x2b },
	'neutralrawsaturation' => { 115 => 0x29 },
	'neutralrawshadow' => { 115 => 0x81 },
	'neutralrawshadowpoint' => { 115 => 0x2e },
	'neutralrawsharpness' => { 115 => 0x2c },
	'neutralunsharpmaskfineness' => { 115 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 115 => 0xa8 },
	'neutraunsharpmaskstrength' => { 115 => 0xa4 },
	'newlensdata' => { 254 => 0x2f },
	'newrawimagedigest' => { 125 => 0xc7a7 },
	'newsphotoversion' => { 150 => 0x0 },
	'nickname' => { 562 => 'Nickname' },
	'nikoncapturedata' => { 256 => 0xe01 },
	'nikoncaptureeditversions' => { 256 => 0xe13 },
	'nikoncaptureoffsets' => { 256 => 0xe0e },
	'nikoncaptureoutput' => { 256 => 0xe1e },
	'nikoncaptureversion' => { 256 => 0xe09 },
	'nikoniccprofile' => { 256 => 0xe1d },
	'nikonimagesize' => { 293 => '723.1', 294 => '732.1', 302 => 0x2c4 },
	'nikonmeteringmode' => { 219 => 0x17, 260 => 0x2d2, 261 => 0x146, 273 => 0x214 },
	'nikonsettings' => { 256 => 0x4e },
	'noisefilter' => { 345 => 0x527 },
	'noiseprofile' => { 125 => 0xc761 },
	'noisereduction' => { 133 => [0x100b,0x100e], 199 => 0xb0, 200 => 0x60, 201 => 0x3f, 256 => 0x95, 316 => 0x753dcbc0, 317 => 0x17, 345 => 0x50a, 350 => 0x103a, 370 => 0x2d, 409 => 0x49, 445 => 0x100f, 447 => 0x2a },
	'noisereduction2' => { 349 => 0x1010 },
	'noisereductionapplied' => { 125 => 0xc6f7 },
	'noisereductionintensity' => { 317 => 0x9 },
	'noisereductionmethod' => { 317 => 0x11 },
	'noisereductionmode' => { 516 => 0x801e },
	'noisereductionparametersatcapture' => { 155 => 0xe73 },
	'noisereductionparameterscamera' => { 155 => 0xe72 },
	'noisereductionparametershost3mp' => { 155 => 0xe71 },
	'noisereductionparametershost6mp' => { 155 => 0xe70 },
	'noisereductionparametershostrgb' => { 155 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 155 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 155 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 155 => 0xe63 },
	'noisereductionparams' => { 375 => 0x1b },
	'noisereductionsharpness' => { 317 => 0xd },
	'noisereductionstrength' => { 370 => 0xd6 },
	'noisereductionvalue' => { 516 => 0x8027 },
	'nomemorycard' => { 323 => '22.1', 324 => '4.2', 325 => '0.3', 328 => '2.4', 329 => '3.2', 330 => '3.2', 332 => '33.7', 333 => '3.2', 334 => '0.3', 336 => '4.2', 338 => '4.5' },
	'nominalmaxaperture' => { 399 => 0xa },
	'nominalminaperture' => { 399 => '10.1' },
	'noncpulens10focallength' => { 263 => 0x6c6, 264 => 0x6d6, 267 => 0x620 },
	'noncpulens10maxaperture' => { 263 => 0x6ee, 264 => 0x738, 267 => 0x670 },
	'noncpulens11focallength' => { 263 => 0x6c8, 264 => 0x6d8, 267 => 0x624 },
	'noncpulens11maxaperture' => { 263 => 0x6f0, 264 => 0x73c, 267 => 0x674 },
	'noncpulens12focallength' => { 263 => 0x6ca, 264 => 0x6da, 267 => 0x628 },
	'noncpulens12maxaperture' => { 263 => 0x6f2, 264 => 0x740, 267 => 0x678 },
	'noncpulens13focallength' => { 263 => 0x6cc, 264 => 0x6dc, 267 => 0x62c },
	'noncpulens13maxaperture' => { 263 => 0x6f4, 264 => 0x744, 267 => 0x67c },
	'noncpulens14focallength' => { 263 => 0x6ce, 264 => 0x6de, 267 => 0x630 },
	'noncpulens14maxaperture' => { 263 => 0x6f6, 264 => 0x748, 267 => 0x680 },
	'noncpulens15focallength' => { 263 => 0x6d0, 264 => 0x6e0, 267 => 0x634 },
	'noncpulens15maxaperture' => { 263 => 0x6f8, 264 => 0x74c, 267 => 0x684 },
	'noncpulens16focallength' => { 263 => 0x6d2, 264 => 0x6e2, 267 => 0x638 },
	'noncpulens16maxaperture' => { 263 => 0x6fa, 264 => 0x750, 267 => 0x688 },
	'noncpulens17focallength' => { 263 => 0x6d4, 264 => 0x6e4, 267 => 0x63c },
	'noncpulens17maxaperture' => { 263 => 0x6fc, 264 => 0x754, 267 => 0x68c },
	'noncpulens18focallength' => { 263 => 0x6d6, 264 => 0x6e6, 267 => 0x640 },
	'noncpulens18maxaperture' => { 263 => 0x6fe, 264 => 0x758, 267 => 0x690 },
	'noncpulens19focallength' => { 263 => 0x6d8, 264 => 0x6e8, 267 => 0x644 },
	'noncpulens19maxaperture' => { 263 => 0x700, 264 => 0x75c, 267 => 0x694 },
	'noncpulens1focallength' => { 263 => 0x6b4, 264 => 0x6c4, 267 => 0x5fc },
	'noncpulens1maxaperture' => { 263 => 0x6dc, 264 => 0x714, 267 => 0x64c },
	'noncpulens20focallength' => { 263 => 0x6da, 264 => 0x6ea, 267 => 0x648 },
	'noncpulens20maxaperture' => { 263 => 0x702, 264 => 0x760, 267 => 0x698 },
	'noncpulens2focallength' => { 263 => 0x6b6, 264 => 0x6c6, 267 => 0x600 },
	'noncpulens2maxaperture' => { 263 => 0x6de, 264 => 0x718, 267 => 0x650 },
	'noncpulens3focallength' => { 263 => 0x6b8, 264 => 0x6c8, 267 => 0x604 },
	'noncpulens3maxaperture' => { 263 => 0x6e0, 264 => 0x71c, 267 => 0x654 },
	'noncpulens4focallength' => { 263 => 0x6ba, 264 => 0x6ca, 267 => 0x608 },
	'noncpulens4maxaperture' => { 263 => 0x6e2, 264 => 0x720, 267 => 0x658 },
	'noncpulens5focallength' => { 263 => 0x6bc, 264 => 0x6cc, 267 => 0x60c },
	'noncpulens5maxaperture' => { 263 => 0x6e4, 264 => 0x724, 267 => 0x65c },
	'noncpulens6focallength' => { 263 => 0x6be, 264 => 0x6ce, 267 => 0x610 },
	'noncpulens6maxaperture' => { 263 => 0x6e6, 264 => 0x728, 267 => 0x660 },
	'noncpulens7focallength' => { 263 => 0x6c0, 264 => 0x6d0, 267 => 0x614 },
	'noncpulens7maxaperture' => { 263 => 0x6e8, 264 => 0x72c, 267 => 0x664 },
	'noncpulens8focallength' => { 263 => 0x6c2, 264 => 0x6d2, 267 => 0x618 },
	'noncpulens8maxaperture' => { 263 => 0x6ea, 264 => 0x730, 267 => 0x668 },
	'noncpulens9focallength' => { 263 => 0x6c4, 264 => 0x6d4, 267 => 0x61c },
	'noncpulens9maxaperture' => { 263 => 0x6ec, 264 => 0x734, 267 => 0x66c },
	'normalizedcropcorners' => { 360 => 'NormalizedCropCorners' },
	'normallinetime' => { 155 => 0x186a },
	'normalwhitelevel' => { 44 => 0x32a, 45 => 0x280, 46 => 0x294, 49 => [0x2b8,0x2cf,0x2d3], 50 => 0x569, 51 => 0x1e3, 52 => [0x1fc,0x2dc], 53 => [0x230,0x30e], 54 => 0x31c },
	'notes' => { 518 => 'Notes', 528 => 'notes' },
	'npages' => { 569 => 'NPages' },
	'nullrecord' => { 103 => 0x0 },
	'numafpoints' => { 382 => 0x3, 383 => 0x2 },
	'number' => { 554 => 'number' },
	'numberofbeats' => { 564 => 'numberOfBeats' },
	'numberoffocuspoints' => { 326 => '1.3', 327 => '1.3', 330 => '0.2', 331 => '0.3', 333 => '0.3' },
	'numcafpoints' => { 386 => 0x1 },
	'numfaceelements' => { 133 => 0x4200 },
	'numfacepositions' => { 362 => 0x0 },
	'numindexentries' => { 150 => 0x54 },
	'numwbentries' => { 376 => 0x0, 377 => 0x0 },
	'object' => { 554 => 'object' },
	'objectattributereference' => { 148 => 0x4 },
	'objectcycle' => { 148 => 0x4b, 528 => 'ObjectCycle' },
	'objectdescription' => { 553 => 'objectDescription' },
	'objectdistance' => { 118 => 0x6, 119 => 0x2022 },
	'objectname' => { 148 => 0x5 },
	'objectpreviewdata' => { 148 => 0xca },
	'objectpreviewfileformat' => { 148 => 0xc8 },
	'objectpreviewfileversion' => { 148 => 0xc9 },
	'objectsubtype' => { 553 => 'objectSubtype' },
	'objecttype' => { 553 => 'objectType' },
	'objecttypereference' => { 148 => 0x3 },
	'occurrence' => { 124 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 124 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 124 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 124 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 124 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 124 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 124 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecaste' => { 124 => [\'Occurrence','OccurrenceCaste'] },
	'occurrencecatalognumber' => { 124 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 124 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 124 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 124 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 124 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 124 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 124 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 124 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 124 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 124 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 124 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 124 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 124 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 124 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 124 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 124 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 124 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 124 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 124 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 124 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 124 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 124 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 124 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'occurrencevitality' => { 124 => [\'Occurrence','OccurrenceVitality'] },
	'oecfcolumns' => { 540 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 540 => [\'OECF','OECFNames'] },
	'oecfrows' => { 540 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 540 => [\'OECF','OECFValues'] },
	'offsaledate' => { 554 => 'offSaleDate' },
	'offsaledatea-platform' => { 554 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 554 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 155 => 0x190a },
	'offsethdr' => { 545 => 'OffsetHDR' },
	'offsetschema' => { 125 => 0xea1d },
	'offsetsdr' => { 545 => 'OffsetSDR' },
	'offsettime' => { 125 => 0x9010 },
	'offsettimedigitized' => { 125 => 0x9012 },
	'offsettimeoriginal' => { 125 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 333 => '15.1', 338 => '16.1' },
	'oldsubfiletype' => { 125 => 0xff },
	'olympusimageheight' => { 350 => 0x102f },
	'olympusimagewidth' => { 350 => 0x102e },
	'omenatcapturestrength' => { 155 => 0xa60 },
	'omenautostrength' => { 155 => 0xa5f },
	'omenearlystrength' => { 155 => 0xa5e },
	'omenfocallengthlimit' => { 155 => 0xa62 },
	'omeninitialipfstrength' => { 155 => 0xa5d },
	'omensurfaceindex' => { 155 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 350 => 0x302 },
	'onsaledate' => { 554 => 'onSaleDate' },
	'onsaledatea-platform' => { 554 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 554 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 554 => 'onSaleDay' },
	'onsaledaya-platform' => { 554 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 554 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 125 => 0xc740 },
	'opcodelist2' => { 125 => 0xc741 },
	'opcodelist3' => { 125 => 0xc74e },
	'opticalzoom' => { 159 => 0xfa3d, 161 => [0x6006,0xf006], 162 => 0x1000, 163 => 0xf, 166 => 0x1e, 168 => 0x20, 169 => 0x1c, 180 => 'OpticalZoom' },
	'opticalzoomcode' => { 82 => 0xa },
	'opticalzoommode' => { 370 => 0x34 },
	'opticalzoomon' => { 454 => 0x219 },
	'optionenddate' => { 557 => 'optionEndDate' },
	'opto-electricconvfactor' => { 540 => 'OECF' },
	'orangehsl' => { 109 => 0x20911 },
	'ordernumber' => { 133 => 0x8002 },
	'organisationinimagecode' => { 548 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 548 => 'OrganisationInImageName' },
	'organism' => { 124 => 'Organism' },
	'organismassociatedoccurrences' => { 124 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 124 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 124 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 124 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 124 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 124 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 124 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 554 => 'organization' },
	'orientation' => { 125 => 0x112, 375 => 0x112, 553 => 'orientation', 560 => 'Orientation' },
	'orientation2' => { 484 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 90 => 0x516 },
	'originalalbumtitle' => { 196 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 196 => 'WM/OriginalArtist', 427 => "\xa9ope" },
	'originalbestqualitysize' => { 125 => 0xc792 },
	'originalcreatedatetime' => { 522 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 120 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 69 => 0x83 },
	'originaldefaultcropsize' => { 125 => 0xc793 },
	'originaldefaultfinalsize' => { 125 => 0xc791 },
	'originaldirectory' => { 367 => 0x408 },
	'originaldocumentid' => { 565 => 'OriginalDocumentID' },
	'originalfilename' => { 103 => 0x816, 155 => 0x3e9, 167 => 0x20, 367 => 0x407, 522 => 'OriginalFilename' },
	'originalfilepath' => { 435 => 'fsid' },
	'originalimagehash' => { 520 => 'OriginalImageHash' },
	'originalimagehashtype' => { 520 => 'OriginalImageHashType' },
	'originalimageheight' => { 84 => 0xc, 129 => 0x1 },
	'originalimagemd5' => { 520 => 'OriginalImageMD5' },
	'originalimagesize' => { 179 => 'OriginalImageSize' },
	'originalimagewidth' => { 84 => 0xb, 129 => 0x0 },
	'originallyricist' => { 196 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 125 => 0xc68c },
	'originalrawfiledigest' => { 125 => 0xc71d },
	'originalrawfilename' => { 125 => 0xc68b },
	'originaltransmissionreference' => { 148 => 0x67 },
	'originatingprogram' => { 148 => 0x41, 528 => 'OriginatingProgram' },
	'originplatform' => { 554 => 'originPlatform' },
	'os' => { 538 => 'os' },
	'otherconditions' => { 356 => 'OtherConditions' },
	'otherconstraints' => { 356 => 'OtherConstraints' },
	'otherimage' => { 120 => 'Exif-OtherImage' },
	'otherimageinfo' => { 356 => 'OtherImageInfo' },
	'otherimagelength' => { 125 => 0x202 },
	'otherimagestart' => { 125 => 0x201 },
	'otherlicensedocuments' => { 356 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 356 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 356 => 'OtherLicenseRequirements' },
	'outcue' => { 564 => 'outCue' },
	'outcuescale' => { 564 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 564 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 220 => 0x3 },
	'outputimagewidth' => { 220 => 0x2 },
	'outputlut' => { 370 => 0xa7 },
	'outputprofile' => { 155 => 0x138b },
	'outputresolution' => { 220 => 0x4 },
	'overclockcols' => { 155 => 0x189c },
	'overclockrows' => { 155 => 0x18c4 },
	'overridelookvignette' => { 534 => 'OverrideLookVignette', 536 => 'OverrideLookVignette' },
	'owner' => { 427 => 'ownr', 568 => 'Owner' },
	'ownerid' => { 148 => 0xbc },
	'ownername' => { 15 => 0x10f, 69 => 0x9, 103 => 0x810, 125 => [0xa430,0xfde8], 173 => 'OwnerName', 531 => 'OwnerName', 541 => 'CameraOwnerName' },
	'padding' => { 125 => 0xea1c },
	'pagecount' => { 554 => 'pageCount' },
	'pageimage' => { 562 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 562 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 562 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 562 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 562 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 562 => 'PageInfo' },
	'pagename' => { 125 => 0x11d },
	'pagenumber' => { 125 => 0x129 },
	'pageprogressiondirection' => { 554 => 'pageProgressionDirection' },
	'pagerange' => { 554 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 534 => 'PaintBasedCorrections', 536 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 534 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 373 => 0x0 },
	'panasonicexifversion' => { 370 => 0x26 },
	'panasonicimageheight' => { 370 => 0x4c },
	'panasonicimagewidth' => { 370 => 0x4b },
	'panasonicrawversion' => { 375 => 0x1 },
	'panasonictitle' => { 125 => 0xc6d2 },
	'panasonictitle2' => { 125 => 0xc6d3 },
	'panoramaangle' => { 133 => 0x1153 },
	'panoramacropbottom' => { 485 => 0x7 },
	'panoramacropleft' => { 485 => 0x4 },
	'panoramacropright' => { 485 => 0x6 },
	'panoramacroptop' => { 485 => 0x5 },
	'panoramadirection' => { 77 => 0x5, 133 => 0x1154, 485 => 0x3 },
	'panoramaframeheight' => { 485 => 0x9 },
	'panoramaframenumber' => { 77 => 0x2 },
	'panoramaframewidth' => { 485 => 0x8 },
	'panoramafullheight' => { 485 => 0x2 },
	'panoramafullwidth' => { 485 => 0x1 },
	'panoramamode' => { 157 => 0x3c, 345 => 0x601 },
	'panoramasize3d' => { 467 => 0x38 },
	'panoramasourceheight' => { 485 => 0xb },
	'panoramasourcewidth' => { 485 => 0xa },
	'panoramicstitchcameramotion' => { 193 => 'PanoramicStitchCameraMotion', 194 => 0x1 },
	'panoramicstitchmaptype' => { 193 => 'PanoramicStitchMapType', 194 => 0x2 },
	'panoramicstitchphi0' => { 193 => 'PanoramicStitchPhi0', 194 => 0x5 },
	'panoramicstitchphi1' => { 193 => 'PanoramicStitchPhi1', 194 => 0x6 },
	'panoramicstitchtheta0' => { 193 => 'PanoramicStitchTheta0', 194 => 0x3 },
	'panoramicstitchtheta1' => { 193 => 'PanoramicStitchTheta1', 194 => 0x4 },
	'panoramicstitchversion' => { 194 => 0x0 },
	'pantry' => { 565 => 'Pantry' },
	'pantryinstanceid' => { 565 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 133 => 0xb211, 343 => 0x28 },
	'parameters' => { 359 => 'parameters' },
	'parametricdarks' => { 534 => 'ParametricDarks', 536 => 'ParametricDarks' },
	'parametrichighlights' => { 534 => 'ParametricHighlights', 536 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 534 => 'ParametricHighlightSplit', 536 => 'ParametricHighlightSplit' },
	'parametriclights' => { 534 => 'ParametricLights', 536 => 'ParametricLights' },
	'parametricmidtonesplit' => { 534 => 'ParametricMidtoneSplit', 536 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 534 => 'ParametricShadows', 536 => 'ParametricShadows' },
	'parametricshadowsplit' => { 534 => 'ParametricShadowSplit', 536 => 'ParametricShadowSplit' },
	'parentalrating' => { 196 => 'WM/ParentalRating' },
	'parentid' => { 548 => 'parentId' },
	'parentmeasurementid' => { 124 => [\'MeasurementOrFact','MeasurementOrFactParentMeasurementID'] },
	'parentmediaeventid' => { 522 => 'ParentMediaEventID' },
	'parentmeid' => { 522 => 'ParentMEID' },
	'parentproductid' => { 427 => '@ppi' },
	'parentreference1' => { 546 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 546 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 427 => '@PST' },
	'parenttitle' => { 427 => '@pti' },
	'partialactivecols1' => { 155 => 0x17e8 },
	'partialactivecols2' => { 155 => 0x17f2 },
	'partialactiverows1' => { 155 => 0x17fc },
	'partialactiverows2' => { 155 => 0x1806 },
	'partofcompilation' => { 564 => 'partOfCompilation' },
	'patientbirthdate' => { 519 => 'PatientDOB' },
	'patientid' => { 519 => 'PatientID' },
	'patientname' => { 519 => 'PatientName' },
	'patientsex' => { 519 => 'PatientSex' },
	'patternareaheight' => { 155 => 0x963 },
	'patternareawidth' => { 155 => 0x962 },
	'patterncorrectionfactorscale' => { 155 => 0x969 },
	'patterncropcols1' => { 155 => 0x96c },
	'patterncropcols2' => { 155 => 0x96d },
	'patterncroprows1' => { 155 => 0x96a },
	'patterncroprows2' => { 155 => 0x96b },
	'patternimagerheight' => { 155 => 0x961 },
	'patternimagerwidth' => { 155 => 0x960 },
	'patternx' => { 155 => 0x966 },
	'patterny' => { 155 => 0x967 },
	'pdfversion' => { 550 => 'PDFVersion' },
	'pentaximagesize' => { 409 => 0x9 },
	'pentaxmodelid' => { 387 => 0x0, 409 => 0x5 },
	'pentaxmodeltype' => { 409 => 0x1 },
	'pentaxversion' => { 409 => 0x0 },
	'people' => { 521 => 'People', 526 => 'People' },
	'perchannelblacklevel' => { 44 => 0x157, 45 => 0x16b, 46 => 0x17f, 48 => 0xc4, 49 => [0x2b4,0x2cb,0x2cf], 50 => [0x108,0x14d], 51 => 0x1df, 52 => [0x1f8,0x2d8], 53 => [0x22c,0x30a], 54 => 0x149 },
	'performer' => { 427 => 'perf', 435 => 'perf' },
	'performerkeywords' => { 435 => "\xa9prk" },
	'performers' => { 435 => "\xa9prf" },
	'performerurl' => { 435 => "\xa9prl" },
	'period' => { 196 => 'WM/Period' },
	'peripheralillumcentralradius' => { 516 => 0x8030 },
	'peripheralillumcentralvalue' => { 516 => 0x8031 },
	'peripheralillumination' => { 109 => 0x20702, 115 => 0x68 },
	'peripheralilluminationcorr' => { 67 => 0x1, 398 => 0x2 },
	'peripheralilluminationon' => { 109 => '0x20702.0', 115 => 0x64 },
	'peripheralillumperiphvalue' => { 516 => 0x8032 },
	'peripherallighting' => { 84 => 0x2, 133 => 0x3804 },
	'peripherallightingsetting' => { 85 => 0x5 },
	'peripherallightingvalue' => { 84 => 0x6 },
	'permissions' => { 557 => 'permissions' },
	'permits' => { 532 => 'permits' },
	'person' => { 554 => 'person' },
	'personality' => { 522 => 'Personality' },
	'personheard' => { 548 => 'PersonHeard' },
	'personheardidentifier' => { 548 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 548 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 548 => 'PersonInImage' },
	'personinimagecharacteristic' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 548 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 548 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 534 => 'PerspectiveAspect', 536 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 534 => 'PerspectiveHorizontal', 536 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 534 => 'PerspectiveRotate', 536 => 'PerspectiveRotate' },
	'perspectivescale' => { 534 => 'PerspectiveScale', 536 => 'PerspectiveScale' },
	'perspectiveupright' => { 534 => 'PerspectiveUpright', 536 => 'PerspectiveUpright' },
	'perspectivevertical' => { 534 => 'PerspectiveVertical', 536 => 'PerspectiveVertical' },
	'perspectivex' => { 534 => 'PerspectiveX', 536 => 'PerspectiveX' },
	'perspectivey' => { 534 => 'PerspectiveY', 536 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 98 => 0x1 },
	'pf10retainprogramshift' => { 98 => 0xb },
	'pf13drivepriority' => { 98 => 0xe },
	'pf14disablefocussearch' => { 98 => 0xf },
	'pf15disableafassistbeam' => { 98 => 0x10 },
	'pf16autofocuspointshoot' => { 98 => 0x11 },
	'pf17disableafpointsel' => { 98 => 0x12 },
	'pf18enableautoafpointsel' => { 98 => 0x13 },
	'pf19continuousshootspeed' => { 98 => 0x14 },
	'pf19shootingspeedhigh' => { 97 => 0xa },
	'pf19shootingspeedlow' => { 97 => 0x9 },
	'pf1disableshootingmodes' => { 98 => 0x2 },
	'pf1value' => { 97 => 0x1 },
	'pf20limitcontinousshots' => { 98 => 0x15 },
	'pf20maxcontinousshots' => { 97 => 0xb },
	'pf21enablequietoperation' => { 98 => 0x16 },
	'pf23felocktime' => { 97 => 0xd },
	'pf23postreleasetime' => { 97 => 0xe },
	'pf23settimerlengths' => { 98 => 0x18 },
	'pf23shutterbuttontime' => { 97 => 0xc },
	'pf24lightlcdduringbulb' => { 98 => 0x19 },
	'pf25aemode' => { 97 => 0xf },
	'pf25afmode' => { 97 => 0x12 },
	'pf25afpointsel' => { 97 => 0x13 },
	'pf25colormatrix' => { 97 => 0x17 },
	'pf25defaultclearsettings' => { 98 => 0x1a },
	'pf25drivemode' => { 97 => 0x11 },
	'pf25imagesize' => { 97 => 0x14 },
	'pf25meteringmode' => { 97 => 0x10 },
	'pf25parameters' => { 97 => 0x16 },
	'pf25wbmode' => { 97 => 0x15 },
	'pf26shortenreleaselag' => { 98 => 0x1b },
	'pf27reversedialrotation' => { 98 => 0x1c },
	'pf27value' => { 97 => 0x18 },
	'pf28noquickdialexpcomp' => { 98 => 0x1d },
	'pf29quickdialswitchoff' => { 98 => 0x1e },
	'pf2disablemeteringmodes' => { 98 => 0x3 },
	'pf2value' => { 97 => 0x2 },
	'pf30enlargementmode' => { 98 => 0x1f },
	'pf31originaldecisiondata' => { 98 => 0x20 },
	'pf3manualexposuremetering' => { 98 => 0x4 },
	'pf3value' => { 97 => 0x3 },
	'pf4exposuretimelimits' => { 98 => 0x5 },
	'pf4exposuretimemax' => { 97 => 0x5 },
	'pf4exposuretimemin' => { 97 => 0x4 },
	'pf5aperturelimits' => { 98 => 0x6 },
	'pf5aperturemax' => { 97 => 0x7 },
	'pf5aperturemin' => { 97 => 0x6 },
	'pf6presetshootingmodes' => { 98 => 0x7 },
	'pf7bracketcontinuousshoot' => { 98 => 0x8 },
	'pf8bracketshots' => { 97 => 0x8 },
	'pf8setbracketshots' => { 98 => 0x9 },
	'pf9changebracketsequence' => { 98 => 0xa },
	'phasedetectaf' => { 212 => 0x6 },
	'phonenumber' => { 174 => 'Phone' },
	'photoeffect' => { 37 => 0x28 },
	'photoeffecthistoryxml' => { 316 => 0xe9651831 },
	'photoeffects' => { 316 => 0xab5eca5e },
	'photoeffectsblue' => { 318 => 0x8 },
	'photoeffectsgreen' => { 318 => 0x6 },
	'photoeffectsred' => { 318 => 0x4 },
	'photoeffectstype' => { 318 => 0x0 },
	'photographer' => { 125 => 0xa437, 541 => 'Photographer' },
	'photographicsensitivity' => { 541 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 323 => '17.6', 332 => '33.6' },
	'photometricinterpretation' => { 125 => 0x106, 560 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 262 => 0x11e, 265 => 0x112, 266 => 0x122, 267 => 0x122, 268 => 0x24, 286 => 0x0 },
	'photoshootingmenubankimagearea' => { 259 => 0x6dd, 262 => 0x144, 265 => 0x134, 266 => 0x148, 267 => 0x148, 286 => '7.1' },
	'photoshopbgrthumbnail' => { 423 => 0x409 },
	'photoshopquality' => { 422 => 0x0 },
	'photoshopthumbnail' => { 423 => 0x40c },
	'photostyle' => { 370 => 0x89 },
	'picasawebgphotoid' => { 539 => 'picasawebGPhotoId' },
	'pick' => { 564 => 'pick' },
	'picklabel' => { 539 => 'PickLabel' },
	'pictinfo' => { 454 => 0x208 },
	'picturecontrol' => { 316 => 0xe2173c47 },
	'picturecontrolactive' => { 319 => 0x0 },
	'picturecontroladjust' => { 274 => 0x30, 275 => 0x30, 276 => 0x36 },
	'picturecontrolbase' => { 274 => 0x18, 275 => 0x18, 276 => 0x1c },
	'picturecontroldata' => { 256 => [0xbd,0x23] },
	'picturecontrolmode' => { 319 => 0x13 },
	'picturecontrolname' => { 274 => 0x4, 275 => 0x4, 276 => 0x8 },
	'picturecontrolquickadjust' => { 274 => 0x31, 275 => 0x31, 276 => 0x37 },
	'pictureeffect' => { 479 => 0x200e },
	'pictureeffect2' => { 488 => 0x1163, 489 => 0x1167, 490 => 0x1143, 491 => 0x11bf, 492 => 0x119b, 493 => 0x1053, 494 => 0x24b, 495 => 0x24b, 496 => 0x23c, 511 => 0x46 },
	'picturefinish' => { 199 => 0x71 },
	'picturemode' => { 133 => 0x1031, 345 => 0x520, 409 => [0xb,0x33], 455 => 0x3d },
	'picturemode2' => { 388 => 0x0 },
	'picturemodebwfilter' => { 345 => 0x525 },
	'picturemodecontrast' => { 345 => 0x523 },
	'picturemodeeffect' => { 345 => 0x52d },
	'picturemodehue' => { 345 => 0x522 },
	'picturemodesaturation' => { 345 => 0x521 },
	'picturemodesharpness' => { 345 => 0x524 },
	'picturemodestrength' => { 455 => 0x113 },
	'picturemodetone' => { 345 => 0x526 },
	'pictureprofile' => { 488 => [0x115e,0x115f], 489 => [0x1162,0x1163], 490 => [0x113e,0x113f], 491 => [0x11ba,0x11bb], 492 => [0x1196,0x1197], 493 => [0x104e,0x104f], 494 => [0x246,0x247], 495 => [0x246,0x247], 496 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 79 => 0xa, 109 => 0x20301, 115 => 0x2 },
	'picturestylepc' => { 69 => 0x4009 },
	'picturestyleuserdef' => { 69 => 0x4008 },
	'picturewizard' => { 452 => 0x21 },
	'picturewizardcolor' => { 451 => 0x1 },
	'picturewizardcontrast' => { 451 => 0x4 },
	'picturewizardmode' => { 451 => 0x0 },
	'picturewizardsaturation' => { 451 => 0x2 },
	'picturewizardsharpness' => { 451 => 0x3 },
	'pipelineversion' => { 193 => 'PipelineVersion' },
	'pitch' => { 121 => 0x6, 324 => '4.1', 336 => '4.1', 435 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 66 => 0x5, 272 => 0x4, 345 => 0x904, 360 => 'PitchAngle', 370 => 0x91, 407 => 0x2, 408 => 0x5, 450 => 0x1 },
	'pitchshift' => { 426 => 'player.movie.audio.pitchshift', 429 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 428 => 'pasp' },
	'pixelclockfrequency' => { 155 => 0x40b },
	'pixelcorrectionoffset' => { 155 => 0x972 },
	'pixelcorrectionscale' => { 155 => 0x971 },
	'pixelscale' => { 125 => 0x830e },
	'pixelshiftdelay' => { 260 => 0x38c, 264 => 0x802 },
	'pixelshiftinfo' => { 479 => 0x202f },
	'pixelshiftinterval' => { 260 => 0x38e },
	'pixelshiftnumbershots' => { 260 => 0x38a, 264 => 0x800 },
	'pixelshiftoffset' => { 133 => 0x1106 },
	'pixelshiftresolution' => { 410 => 0x0 },
	'pixelshiftshooting' => { 260 => 0x388, 264 => 0x7fe },
	'pixelshiftshots' => { 133 => 0x1105 },
	'pixelsperunitx' => { 358 => 0x0 },
	'pixelsperunity' => { 358 => 0x4 },
	'pixelunits' => { 358 => 0x8 },
	'planarconfiguration' => { 125 => 0x11c, 560 => 'PlanarConfiguration' },
	'plane' => { 138 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 138 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 138 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 138 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 138 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 138 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 138 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 138 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 138 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 138 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 138 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 138 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 138 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 138 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 138 => 'Planes' },
	'planningref' => { 548 => 'PlanningRef' },
	'planningrefidentifier' => { 548 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 548 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 548 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 569 => 'PlateNames' },
	'platform' => { 554 => 'platform' },
	'playallframes' => { 435 => 'AllF' },
	'playbackbutton' => { 264 => 0x804, 267 => 0x808 },
	'playbackbuttonplaybackmode' => { 264 => 0x80e, 267 => 0x814 },
	'playbackflickdown' => { 339 => 0x149, 340 => 0x159, 341 => 0x159, 342 => 0x171 },
	'playbackflickup' => { 339 => 0x145, 340 => 0x155, 341 => 0x155, 342 => 0x16d },
	'playbackmenustime' => { 328 => '20.1', 329 => '21.1', 330 => '21.1' },
	'playbackmonitorofftime' => { 323 => '25.2', 324 => '36.1', 326 => '36.1', 327 => '36.1', 331 => '35.1', 332 => '8.1', 333 => '35.1', 336 => '36.1', 337 => '36.1', 338 => '21.1', 339 => 0x37, 340 => 0x33, 341 => 0x33, 342 => 0x33 },
	'playbackzoom' => { 324 => '37.1' },
	'playdisplay' => { 201 => 0x4e },
	'playerversion' => { 429 => 'player.version' },
	'playgap' => { 427 => 'pgap' },
	'playmode' => { 435 => 'SDLN' },
	'playselection' => { 435 => 'SelO' },
	'plusversion' => { 356 => 'Version' },
	'pmversion' => { 421 => 'PMVersion' },
	'pngwarning' => { 359 => 'Warning' },
	'podcast' => { 427 => 'pcst' },
	'podcasturl' => { 427 => 'purl' },
	'poilevel' => { 255 => 0x8 },
	'portraitimpressionbalance' => { 260 => 0x378, 262 => 0x26e, 277 => 0xa0 },
	'portraitnote' => { 140 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 115 => 0x1d },
	'portraitoutputshadowpoint' => { 115 => 0x1e },
	'portraitrawcolortone' => { 115 => 0x16 },
	'portraitrawcontrast' => { 115 => 0x18 },
	'portraitrawhighlight' => { 115 => 0x76 },
	'portraitrawhighlightpoint' => { 115 => 0x1b },
	'portraitrawlinear' => { 115 => 0x19 },
	'portraitrawsaturation' => { 115 => 0x17 },
	'portraitrawshadow' => { 115 => 0x7f },
	'portraitrawshadowpoint' => { 115 => 0x1c },
	'portraitrawsharpness' => { 115 => 0x1a },
	'portraitrefiner' => { 119 => 0x302b },
	'portraitrequest' => { 140 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 115 => 0x9a },
	'portraitunsharpmaskstrength' => { 115 => 0x98 },
	'portraitunsharpmaskthreshold' => { 115 => 0x9c },
	'portraitversion' => { 140 => 'PortraitVersion' },
	'pose' => { 138 => 'Pose' },
	'poseheadingdegrees' => { 146 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 146 => 'PosePitchDegrees' },
	'posepositionx' => { 138 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 138 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 138 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 146 => 'PoseRollDegrees' },
	'poserotationw' => { 138 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 138 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 138 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 138 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 138 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 553 => 'positionDescriptor' },
	'postalcode' => { 178 => 'PostalCode' },
	'postcropvignetteamount' => { 534 => 'PostCropVignetteAmount', 536 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 534 => 'PostCropVignetteFeather', 536 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 534 => 'PostCropVignetteHighlightContrast', 536 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 534 => 'PostCropVignetteMidpoint', 536 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 534 => 'PostCropVignetteRoundness', 536 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 534 => 'PostCropVignetteStyle', 536 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 370 => 0xbf },
	'postreleaseburstlength' => { 266 => 0x714, 267 => 0x784, 340 => 0x289 },
	'potentialface1position' => { 475 => 0xb },
	'potentialface2position' => { 475 => 0x15 },
	'potentialface3position' => { 475 => 0x1f },
	'potentialface4position' => { 475 => 0x29 },
	'potentialface5position' => { 475 => 0x33 },
	'potentialface6position' => { 475 => 0x3d },
	'potentialface7position' => { 475 => 0x47 },
	'potentialface8position' => { 475 => 0x51 },
	'poweravailable' => { 385 => '0.2' },
	'powersource' => { 385 => '0.1' },
	'poweruptime' => { 256 => 0xb6 },
	'preaf' => { 132 => '0.2' },
	'precaptureframes' => { 350 => 0x300 },
	'predictor' => { 125 => 0x13d },
	'preflashreturnstrength' => { 294 => 0x28a },
	'prefs' => { 148 => 0xdd, 421 => 'Prefs' },
	'prereadfastresetcount' => { 155 => 0x187e },
	'prereleaseburstlength' => { 266 => 0x712, 267 => 0x782, 340 => 0x287 },
	'preservedfilename' => { 565 => 'PreservedFileName' },
	'preservedspecimen' => { 124 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 124 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 534 => 'PresetType', 536 => 'PresetType' },
	'presetwhitebalance' => { 201 => 0x24, 516 => 0x8002 },
	'presetwhitebalanceadj' => { 516 => 0x8014 },
	'pressure' => { 125 => 0x9402, 541 => 'Pressure' },
	'previewapplicationname' => { 125 => 0xc716 },
	'previewapplicationversion' => { 125 => 0xc717 },
	'previewbutton' => { 323 => ['14.1','15.1'], 324 => '15.1', 326 => '15.1', 327 => '15.1', 332 => '29.1', 333 => '14.1', 336 => '15.1', 337 => '15.1' },
	'previewbuttonplusdials' => { 323 => ['14.2','15.2'], 324 => '15.2', 326 => '43.1', 327 => '43.1', 332 => '31.2', 336 => '43.1', 337 => '43.1' },
	'previewcolorspace' => { 125 => 0xc71a },
	'previewcropbottom' => { 420 => 0xef },
	'previewcropleft' => { 420 => 0xec },
	'previewcropright' => { 420 => 0xee },
	'previewcroptop' => { 420 => 0xed },
	'previewdate' => { 433 => 0x0 },
	'previewdatetime' => { 125 => 0xc71b },
	'previewimage' => { 119 => 0x2000, 120 => 'Exif-PreviewImage', 126 => 'PreviewImage', 128 => 0x4, 183 => 'data', 203 => 0x81, 350 => 0x280, 368 => 0x300, 427 => 'snal', 435 => ['SIGM','mcvr'], 479 => 0x2001 },
	'previewimageborders' => { 409 => 0x3e },
	'previewimageheight' => { 78 => 0x4, 159 => 0xfa58 },
	'previewimagelength' => { 78 => 0x2, 119 => 0x3, 125 => [0x117,0x202], 203 => 0x89, 278 => 0x202, 345 => 0x102, 350 => 0x1037, 409 => 0x3, 444 => 0x1e, 449 => 0x3, 455 => [0x1b,0x1d], 468 => 0x202 },
	'previewimagename' => { 183 => '1Name' },
	'previewimagesize' => { 119 => 0x2, 164 => 0x2, 183 => 'ImageSize', 409 => 0x2, 455 => [0x1c,0x1e], 479 => 0xb02c, 516 => 0x9012 },
	'previewimagestart' => { 78 => 0x5, 119 => 0x4, 125 => [0x111,0x201], 203 => 0x88, 278 => 0x201, 345 => 0x101, 350 => 0x1036, 409 => 0x4, 444 => 0x1c, 449 => 0x2, 455 => [0x1a,0x1c], 468 => 0x201 },
	'previewimagetype' => { 183 => '0Type' },
	'previewimagevalid' => { 345 => 0x100, 350 => 0x1035 },
	'previewimagewidth' => { 78 => 0x3, 159 => 0xfa57 },
	'previewquality' => { 78 => 0x1 },
	'previewsettingsdigest' => { 125 => 0xc719 },
	'previewsettingsname' => { 125 => 0xc718 },
	'primaryafpoint' => { 210 => 0x7, 211 => 0x44, 212 => 0x7, 213 => 0x38 },
	'primarychromaticities' => { 125 => 0x13f, 560 => 'PrimaryChromaticities' },
	'primaryftp' => { 522 => 'PrimaryFTP' },
	'primaryslot' => { 268 => 0x25, 286 => 0x2 },
	'printim' => { 125 => 0xc4a5 },
	'prioritysetinawb' => { 479 => 0x202b },
	'prioritysetupshutterrelease' => { 201 => 0x1d, 465 => 0x28 },
	'privatertkinfo' => { 525 => 'privateRTKInfo' },
	'processbordercolsleft' => { 155 => 0xc61 },
	'processbordercolsright' => { 155 => 0xc62 },
	'processborderrowsbottom' => { 155 => 0xc64 },
	'processborderrowstop' => { 155 => 0xc63 },
	'processingsoftware' => { 125 => 0xb },
	'processversion' => { 534 => 'ProcessVersion', 536 => 'ProcessVersion' },
	'producer' => { 196 => 'WM/Producer', 355 => 'Producer', 427 => "\xa9prd", 429 => 'producer', 435 => "\xa9prd", 550 => 'Producer' },
	'producerkeywords' => { 435 => "\xa9pdk" },
	'productcode' => { 554 => 'productCode' },
	'productid' => { 149 => 0x32, 427 => 'prID', 553 => 'productID' },
	'productidtype' => { 553 => 'productIDType' },
	'productinimage' => { 548 => 'ProductInImage' },
	'productinimagedescription' => { 548 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 548 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 548 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 548 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 387 => 0x2 },
	'productorserviceconstraints' => { 356 => 'ProductOrServiceConstraints' },
	'productversion' => { 427 => 'VERS' },
	'profession' => { 554 => 'profession' },
	'profile' => { 138 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 125 => 0xc6f4 },
	'profilecameraindices' => { 138 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 125 => 0xc6fe },
	'profiledynamicrange' => { 125 => 0xcd47 },
	'profileembedpolicy' => { 125 => 0xc6fd },
	'profilegaintablemap' => { 125 => 0xcd2d },
	'profilegaintablemap2' => { 125 => 0xcd40 },
	'profilegroupname' => { 125 => 0xcd48 },
	'profilehuesatmapdata1' => { 125 => 0xc6fa },
	'profilehuesatmapdata2' => { 125 => 0xc6fb },
	'profilehuesatmapdata3' => { 125 => 0xcd39 },
	'profilehuesatmapdims' => { 125 => 0xc6f9 },
	'profilehuesatmapencoding' => { 125 => 0xc7a3 },
	'profilelooktabledata' => { 125 => 0xc726 },
	'profilelooktabledims' => { 125 => 0xc725 },
	'profilelooktableencoding' => { 125 => 0xc7a4 },
	'profilename' => { 125 => 0xc6f8, 357 => 'iCCP-name' },
	'profiles' => { 138 => 'Profiles' },
	'profiletonecurve' => { 125 => 0xc6fc },
	'profiletype' => { 138 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 370 => 0x3c },
	'programline' => { 388 => '1.1' },
	'programmode' => { 206 => 0x5 },
	'programshift' => { 256 => 0xd },
	'programversion' => { 148 => 0x46 },
	'prohibits' => { 532 => 'prohibits' },
	'projectiontype' => { 146 => 'ProjectionType', 147 => 'ProjectionType' },
	'projectname' => { 564 => 'projectName' },
	'projectref' => { 564 => 'projectRef' },
	'projectrefpath' => { 564 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 564 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 196 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 356 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 356 => 'PropertyReleaseStatus' },
	'provider' => { 196 => 'WM/Provider' },
	'province-state' => { 148 => 0x5f },
	'publicationdate' => { 554 => 'publicationDate' },
	'publicationdatea-platform' => { 554 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 554 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 554 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 554 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 554 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 548 => 'PublicationEvent' },
	'publicationeventdate' => { 548 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 548 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 548 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 554 => 'publicationName' },
	'publisher' => { 196 => 'WM/Publisher', 427 => "\xa9pub", 429 => 'publisher', 537 => 'publisher' },
	'publishingfrequency' => { 554 => 'publishingFrequency' },
	'pulldown' => { 564 => 'pullDown' },
	'purchasedate' => { 427 => 'purd' },
	'purplehsl' => { 109 => 0x20916 },
	'pxshiftperiphedgenr' => { 516 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 516 => 0x9014 },
	'quality' => { 0 => 0x1, 37 => 0x3, 118 => 0x2, 119 => 0x3002, 133 => 0x1000, 157 => 0x9, 256 => 0x4, 305 => 0x3, 350 => 0x201, 365 => 0x300, 409 => 0x8, 416 => 0x2, 455 => 0x16, 465 => 0x56, 466 => 0x56, 467 => 0xb, 479 => [0x102,0x202e] },
	'quality2' => { 488 => 0x1170, 489 => 0x1174, 490 => 0x1150, 492 => 0x11a8, 493 => 0x1060, 494 => 0x258, 495 => 0x258, 496 => 0x247, 502 => 0x29, 503 => 0x25, 504 => 0x2a },
	'qualitybutton' => { 341 => 0x17d, 342 => 0x195 },
	'qualitybuttonplaybackmode' => { 341 => 0x1bf, 342 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 119 => 0x8 },
	'quantizationmethod' => { 150 => 0x78 },
	'quickadjust' => { 319 => 0x2a },
	'quickcontroldialinmeter' => { 90 => 0x703 },
	'quickfix' => { 316 => 0x416391c6 },
	'quickshot' => { 454 => 0x213 },
	'quiettime' => { 155 => 0x188a },
	'radialdistortioncoefficient1' => { 231 => 0x14 },
	'radialdistortioncoefficient2' => { 231 => 0x1c },
	'radialdistortioncoefficient3' => { 231 => 0x24 },
	'rads' => { 435 => 'rads' },
	'rangefinder' => { 328 => '4.1', 329 => '5.1', 330 => '5.1' },
	'rangemask' => { 534 => 'RangeMaskMapInfo', 536 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 534 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 534 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 534 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 534 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 534 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 534 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 148 => 0x7d },
	'rating' => { 109 => 0x10100, 125 => 0x4746, 133 => 0x1431, 420 => 0xdf, 427 => 'rtng', 435 => 'rtng', 479 => 0x2002, 528 => 'rating', 538 => 'rating', 548 => 'Rating', 554 => 'rating', 562 => 'Rating' },
	'ratingpercent' => { 125 => 0x4749, 195 => 'Rating', 427 => 'rate', 562 => 'RatingPercent' },
	'ratingregion' => { 548 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 548 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 548 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 548 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 548 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 548 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 548 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 548 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 548 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 548 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 548 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 548 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 548 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 548 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 548 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 548 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 548 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 548 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 548 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 88 => 0x8, 203 => 0x109, 388 => 0xd },
	'rawbrightnessadj' => { 109 => 0x20001, 114 => 0x38 },
	'rawburstimagecount' => { 80 => 0x2 },
	'rawburstimagenum' => { 80 => 0x1 },
	'rawcoloradj' => { 114 => 0x2e },
	'rawcropbottom' => { 420 => 0xd4 },
	'rawcropleft' => { 420 => 0xd1 },
	'rawcropright' => { 420 => 0xd3 },
	'rawcroptop' => { 420 => 0xd2 },
	'rawcustomsaturation' => { 114 => 0x30 },
	'rawcustomtone' => { 114 => 0x34 },
	'rawdata' => { 452 => 0xa048 },
	'rawdatabyteorder' => { 452 => 0x40 },
	'rawdatacfapattern' => { 452 => 0x50 },
	'rawdatauniqueid' => { 125 => 0xc65d },
	'rawdepth' => { 205 => 0x10 },
	'rawdevartfilter' => { 352 => 0x121 },
	'rawdevautogradation' => { 352 => 0x119 },
	'rawdevcolorspace' => { 351 => 0x108, 352 => 0x109 },
	'rawdevcontrastvalue' => { 351 => 0x106, 352 => 0x105 },
	'rawdeveditstatus' => { 351 => 0x10b },
	'rawdevelopingsoftware' => { 125 => 0xa43a, 541 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 409 => 0x62 },
	'rawdevengine' => { 351 => 0x109, 352 => 0x10b },
	'rawdevexposurebiasvalue' => { 351 => 0x100, 352 => 0x100 },
	'rawdevgradation' => { 352 => 0x112 },
	'rawdevgraypoint' => { 351 => 0x103, 352 => 0x104 },
	'rawdevmemorycoloremphasis' => { 351 => 0x105, 352 => 0x108 },
	'rawdevnoisereduction' => { 351 => 0x10a, 352 => 0x10a },
	'rawdevpicturemode' => { 352 => 0x10c },
	'rawdevpm_bwfilter' => { 352 => 0x110 },
	'rawdevpmcontrast' => { 352 => 0x10e },
	'rawdevpmnoisefilter' => { 352 => 0x120 },
	'rawdevpmpicturetone' => { 352 => 0x111 },
	'rawdevpmsaturation' => { 352 => 0x10d },
	'rawdevpmsharpness' => { 352 => 0x10f },
	'rawdevsaturation3' => { 352 => 0x113 },
	'rawdevsaturationemphasis' => { 351 => 0x104, 352 => 0x107 },
	'rawdevsettings' => { 351 => 0x10c },
	'rawdevsharpnessvalue' => { 351 => 0x107, 352 => 0x106 },
	'rawdevversion' => { 351 => 0x0, 352 => 0x0 },
	'rawdevwbfineadjustment' => { 351 => 0x102, 352 => 0x103 },
	'rawdevwhitebalance' => { 352 => 0x101 },
	'rawdevwhitebalancevalue' => { 351 => 0x101, 352 => 0x102 },
	'rawfile' => { 125 => 0xfe4c },
	'rawfilename' => { 534 => 'RawFileName', 536 => 'RawFileName' },
	'rawfiletype' => { 479 => 0x2029 },
	'rawformat' => { 375 => 0x2d, 418 => 0x10e },
	'rawimagecenter' => { 256 => 0x99 },
	'rawimagedigest' => { 125 => 0xc71c },
	'rawimagesize' => { 409 => 0x39 },
	'rawinfoversion' => { 353 => 0x0 },
	'rawjpgheight' => { 105 => 0x4 },
	'rawjpgquality' => { 61 => 0x6, 105 => 0x1 },
	'rawjpgsize' => { 61 => 0x7, 105 => 0x2 },
	'rawjpgwidth' => { 105 => 0x3 },
	'rawmeasuredrggb' => { 47 => 0x26a, 49 => 0x280, 51 => 0x194, 52 => [0x1ad,0x26b] },
	'rawrppused' => { 528 => 'rawrppused' },
	'rawtopreviewgain' => { 125 => 0xc7a8 },
	'readouttypeactual' => { 155 => 0x1903 },
	'readouttyperequested' => { 155 => 0x1902 },
	'reardisplay' => { 323 => '12.3', 324 => '6.2' },
	'recdevice' => { 548 => 'RecDevice' },
	'recdeviceattlensdescription' => { 548 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 548 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 548 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 548 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 548 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 556 => 'recipeEndingPage' },
	'recipepagerange' => { 556 => 'recipePageRange' },
	'recipesource' => { 556 => 'recipeSource' },
	'recipestartingpage' => { 556 => 'recipeStartingPage' },
	'recipetitle' => { 556 => 'recipeTitle' },
	'recognizedface1age' => { 363 => 0x20 },
	'recognizedface1name' => { 363 => 0x4 },
	'recognizedface1position' => { 363 => 0x18 },
	'recognizedface2age' => { 363 => 0x50 },
	'recognizedface2name' => { 363 => 0x34 },
	'recognizedface2position' => { 363 => 0x48 },
	'recognizedface3age' => { 363 => 0x80 },
	'recognizedface3name' => { 363 => 0x64 },
	'recognizedface3position' => { 363 => 0x78 },
	'recognizedfaceflags' => { 370 => 0x63 },
	'recommendedexposureindex' => { 125 => 0x8832, 541 => 'RecommendedExposureIndex' },
	'record' => { 124 => 'Record' },
	'recordbasisofrecord' => { 124 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 124 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 124 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 124 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 124 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 124 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 201 => 0x4d },
	'recorddynamicproperties' => { 124 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 103 => 0x1804 },
	'recordinformationwithheld' => { 124 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 435 => "\xa9phg" },
	'recordingformat' => { 445 => 0x1000 },
	'recordingmode' => { 118 => 0x1, 416 => 0x1 },
	'recordinstitutioncode' => { 124 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 124 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 435 => "\xa9lab" },
	'recordlabelurl' => { 435 => "\xa9lal" },
	'recordlocationdata' => { 265 => 0x660, 266 => 0x690, 267 => 0x6f8 },
	'recordmode' => { 37 => 0x9, 119 => 0x3000 },
	'recordownerinstitutioncode' => { 124 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 454 => 0x217 },
	'redbalance' => { 350 => 0x1017, 375 => 0x11, 409 => 0x1c },
	'redcurvelimits' => { 114 => 0x18a },
	'redcurvepoints' => { 113 => 0x2d, 114 => 0x160 },
	'redeyecorrection' => { 320 => 0x0 },
	'redeyeinfo' => { 534 => 'RedEyeInfo', 536 => 'RedEyeInfo' },
	'redeyereduction' => { 201 => 0x41, 465 => 0x6a, 467 => 0x28 },
	'redeyeremoval' => { 370 => 0xb9 },
	'redhsl' => { 109 => 0x20910 },
	'redhue' => { 534 => 'RedHue', 536 => 'RedHue' },
	'redsaturation' => { 534 => 'RedSaturation', 536 => 'RedSaturation' },
	'reductionmatrix1' => { 125 => 0xc625 },
	'reductionmatrix2' => { 125 => 0xc626 },
	'reductionmatrix3' => { 125 => 0xcd3a },
	'reelname' => { 125 => 0xc789, 435 => 'reel' },
	'reference1' => { 546 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 546 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 125 => 0x214, 560 => 'ReferenceBlackWhite' },
	'referencedate' => { 148 => 0x2f },
	'referencenumber' => { 148 => 0x32 },
	'references' => { 174 => 'References' },
	'referenceservice' => { 148 => 0x2d },
	'regionappliedtodimensions' => { 189 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 189 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 189 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 189 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 189 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 189 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 189 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 189 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 189 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 189 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 189 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 189 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 356 => 'RegionConstraints' },
	'regiondescription' => { 189 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 189 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 189 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 189 => 'Regions' },
	'regioninfoacdsee' => { 517 => 'Regions' },
	'regioninfodateregionsvalid' => { 192 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 192 => 'RegionInfo' },
	'regioninforegions' => { 192 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 189 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 189 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 192 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 192 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 192 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 192 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 192 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 189 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 189 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 189 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 548 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 548 => 'RegistryId' },
	'registryitemid' => { 548 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 548 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 172 => 'data' },
	'relatedaudiofilename' => { 172 => '1Name' },
	'relatedaudiofiletype' => { 172 => '0Type' },
	'relatedimagefileformat' => { 125 => 0x1000 },
	'relatedimageheight' => { 125 => 0x1002 },
	'relatedimagewidth' => { 125 => 0x1001 },
	'relatedresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 125 => 0xa004, 540 => 'RelatedSoundFile' },
	'relatedvideofile' => { 186 => 'data' },
	'relatedvideofilename' => { 186 => '1Name' },
	'relatedvideofiletype' => { 186 => '0Type' },
	'relation' => { 537 => 'relation' },
	'relationshipaccordingto' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 122 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 564 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 564 => 'relativeTimestamp' },
	'relativetimestampscale' => { 564 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 564 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 323 => '17.8', 324 => '18.5', 326 => '18.4', 327 => '18.4', 332 => '33.8', 333 => '17.6', 336 => '18.5', 337 => '18.4' },
	'releasedate' => { 148 => 0x1e, 427 => 'rldt', 528 => 'ReleaseDate', 564 => 'releaseDate' },
	'releasemode' => { 119 => 0x3001, 261 => 0x5c, 296 => 0x184d, 479 => 0xb049 },
	'releasemode2' => { 488 => 0x112c, 489 => [0x112c,0x8], 490 => [0x1108,0x8], 491 => [0x1184,0x8], 492 => [0x1160,0x8], 493 => [0x4,0x1018], 494 => [0x4,0x210], 495 => [0x4,0x210], 496 => [0x4,0x208], 498 => [0x67,0x3f], 499 => [0x6b,0x6d,0x73,0x4b], 500 => [0x6b,0x4b], 501 => 0x1f, 502 => 0x10, 503 => 0x10, 504 => 0x9, 511 => 0x34 },
	'releasemode3' => { 488 => 0x1128, 489 => 0x1128, 490 => 0x1104, 491 => 0x1180, 492 => 0x115c, 493 => 0x1014, 494 => 0x20c, 495 => 0x20c, 496 => 0x204 },
	'releasemodebutton' => { 264 => 0x8a0 },
	'releasemodebuttonplaybackmode' => { 264 => 0x8a8 },
	'releaseready' => { 548 => 'ReleaseReady' },
	'releasesetting' => { 103 => 0x1016 },
	'releasetime' => { 148 => 0x23, 528 => 'ReleaseTime' },
	'remoteonduration' => { 325 => '3.4', 328 => '17.2', 329 => '18.2', 330 => '18.2', 331 => '18.2', 333 => '18.2', 334 => '4.3', 338 => '19.2' },
	'renditionclass' => { 565 => 'RenditionClass' },
	'renditionof' => { 565 => 'RenditionOf' },
	'renditionofalternatepaths' => { 565 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 565 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 565 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 565 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 565 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 565 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 565 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 565 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 565 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 565 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 565 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 565 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 565 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 565 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 565 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 565 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 565 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 565 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 565 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 565 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 565 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 565 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 565 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 565 => 'RenditionParams' },
	'repeatingflashcount' => { 234 => 0xd, 235 => 0xe, 236 => 0xe, 237 => 0xe, 238 => 0xe, 239 => 0xe, 332 => '17.2', 333 => '24.2', 334 => '9.2', 335 => '24.2', 338 => '25.2' },
	'repeatingflashcountbuilt-in' => { 303 => 0x4db },
	'repeatingflashcountexternal' => { 303 => 0x4c3 },
	'repeatingflashoutput' => { 332 => '17.1', 333 => '24.1', 334 => '9.1', 335 => '24.1', 338 => '25.1' },
	'repeatingflashoutputexternal' => { 303 => 0x4c0 },
	'repeatingflashrate' => { 234 => 0xc, 235 => 0xd, 236 => 0xd, 237 => 0xd, 238 => 0xd, 239 => 0xd, 332 => '18.1', 333 => '25.1', 334 => '10.1', 335 => '25.1', 338 => '26.1' },
	'repeatingflashratebuilt-in' => { 303 => 0x4da },
	'repeatingflashrateexternal' => { 303 => 0x4c2 },
	'requirements' => { 435 => "\xa9req" },
	'requires' => { 532 => 'requires' },
	'resampleparams' => { 564 => 'resampleParams' },
	'resampleparamsquality' => { 564 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 155 => 0xe50 },
	'resamplingkerneldenominators067' => { 155 => 0xe4f },
	'resamplingkerneldenominators100' => { 155 => 0xe51 },
	'resaved' => { 454 => 0x21e },
	'resetblacksegrows' => { 155 => 0x181a },
	'resolution' => { 179 => 'Resolution' },
	'resolutionmode' => { 455 => [0x87,0x4] },
	'resolutionunit' => { 125 => 0x128, 151 => 0x2, 560 => 'ResolutionUnit' },
	'resourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 124 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 90 => 0x612 },
	'restrictions' => { 557 => 'restrictions' },
	'retouchareafeather' => { 534 => [\'RetouchAreas','RetouchAreasFeather'], 536 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 534 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 536 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 534 => [\'RetouchAreas','RetouchAreasMasksAngle'], 536 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 534 => [\'RetouchAreas','RetouchAreasMasksBottom'], 536 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 534 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 536 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 534 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 536 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 534 => [\'RetouchAreas','RetouchAreasMasksDabs'], 536 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 534 => [\'RetouchAreas','RetouchAreasMasksFeather'], 536 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 534 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 536 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 534 => [\'RetouchAreas','RetouchAreasMasksFlow'], 536 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 534 => [\'RetouchAreas','RetouchAreasMasksFullX'], 536 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 534 => [\'RetouchAreas','RetouchAreasMasksFullY'], 536 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 534 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 536 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 534 => [\'RetouchAreas','RetouchAreasMasksLeft'], 536 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasks'], 536 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 534 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 536 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 534 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 536 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 534 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 536 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 534 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 536 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 534 => [\'RetouchAreas','RetouchAreasMasksRadius'], 536 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 534 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 534 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 536 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 534 => [\'RetouchAreas','RetouchAreasMasksRight'], 536 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 534 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 536 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 534 => [\'RetouchAreas','RetouchAreasMasks'], 536 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 534 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 536 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 534 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 536 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 534 => [\'RetouchAreas','RetouchAreasMasksTop'], 536 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 534 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 536 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 534 => [\'RetouchAreas','RetouchAreasMasksVersion'], 536 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 534 => [\'RetouchAreas','RetouchAreasMasksWhat'], 536 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 534 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 536 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 534 => [\'RetouchAreas','RetouchAreasMasksX'], 536 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 534 => [\'RetouchAreas','RetouchAreasMasksY'], 536 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 534 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 536 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 534 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 536 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 534 => [\'RetouchAreas','RetouchAreasMethod'], 536 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 534 => [\'RetouchAreas','RetouchAreasOffsetY'], 536 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 534 => [\'RetouchAreas','RetouchAreasOpacity'], 536 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 534 => 'RetouchAreas', 536 => 'RetouchAreas' },
	'retouchareaseed' => { 534 => [\'RetouchAreas','RetouchAreasSeed'], 536 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 534 => [\'RetouchAreas','RetouchAreasSourceState'], 536 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 534 => [\'RetouchAreas','RetouchAreasSourceX'], 536 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 534 => [\'RetouchAreas','RetouchAreasSpotType'], 536 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 256 => 0x9e },
	'retouchinfo' => { 534 => 'RetouchInfo', 536 => 'RetouchInfo' },
	'retouchnefprocessing' => { 280 => 0x5 },
	'retractlensonpoweroff' => { 90 => 0x814 },
	'reuse' => { 356 => 'Reuse' },
	'reuseallowed' => { 567 => 'ReuseAllowed' },
	'reuseprohibited' => { 557 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 330 => '5.2' },
	'reversefocusring' => { 340 => 0x163, 341 => 0x163, 342 => 0x17b },
	'reverseindicators' => { 323 => '12.1', 324 => '6.1', 326 => '6.1', 327 => '6.1', 328 => '4.3', 329 => '5.2', 330 => '5.4', 332 => '33.5', 333 => '5.1', 336 => '6.1', 337 => '6.1', 338 => '6.2', 339 => 0xc5, 340 => 0xc1, 341 => 0xc1, 342 => 0xc1 },
	'reverseshutterspeedaperture' => { 330 => '5.3' },
	'revision' => { 538 => 'revision' },
	'rflensmffocusringsensitivity' => { 90 => 0x714 },
	'rflenstype' => { 61 => 0x3d },
	'rgbcurvelimits' => { 114 => 0x238 },
	'rgbcurvepoints' => { 113 => 0x7, 114 => 0x20e },
	'rgbtables' => { 125 => 0xcd3f },
	'richtextcomment' => { 543 => 'RichTextComment' },
	'ricohdate' => { 444 => 0x6 },
	'ricohimageheight' => { 444 => 0x2 },
	'ricohimagewidth' => { 444 => 0x0 },
	'rightalbedo' => { 524 => 'RightAlbedo' },
	'rightascension' => { 182 => 'RightAscension' },
	'rights' => { 537 => 'rights' },
	'rightsagent' => { 557 => 'rightsAgent' },
	'rightsowner' => { 557 => 'rightsOwner' },
	'roll' => { 121 => 0x8, 435 => ['roll',"\xa9frl"] },
	'rollangle' => { 66 => 0x4, 133 => 0x144d, 272 => 0x0, 345 => 0x903, 360 => 'RollAngle', 370 => 0x90, 407 => 0x1, 408 => 0x3, 450 => 0x2 },
	'romoperationmode' => { 103 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 102 => 0x3, 109 => 0x10002, 114 => 0x26e, 120 => 'QuickTime-Rotation', 129 => 0x4, 182 => 'Rotation', 199 => [0x65,0x50], 200 => 0x46, 201 => 0x5a, 204 => 0x10, 281 => 0x1a, 296 => 0x3693, 302 => '590.1', 316 => 0x76a43207, 370 => 0x30, 388 => '17.2', 420 => 0xd8, 428 => 'irot', 465 => 0x3f, 466 => 0x3f, 476 => 0x10 },
	'routedto' => { 542 => 'RoutedTo' },
	'routing' => { 425 => 'Routing' },
	'routingdestinations' => { 522 => 'RoutingDestinations' },
	'routingexclusions' => { 522 => 'RoutingExclusions' },
	'routingnotes' => { 542 => 'RoutingNotes' },
	'rowsperstrip' => { 125 => 0x116 },
	'rpp' => { 528 => 'rpp' },
	'rtkflag' => { 122 => 'RtkFlag' },
	'rtkstdhgt' => { 122 => 'RtkStdHgt' },
	'rtkstdlat' => { 122 => 'RtkStdLat' },
	'rtkstdlon' => { 122 => 'RtkStdLon' },
	'safetyshift' => { 90 => 0x108 },
	'safetyshiftinavortv' => { 88 => 0x10, 89 => 0x10, 91 => 0xf, 92 => 0x10, 95 => 0x10 },
	'sameexposurefornewaperture' => { 90 => 0x112 },
	'samplebits' => { 172 => 'SampleBits' },
	'samplepagerange' => { 554 => 'samplePageRange' },
	'samplerate' => { 172 => 'SampleRate' },
	'samplesperpixel' => { 125 => 0x115, 375 => 0x8, 560 => 'SamplesPerPixel' },
	'samplestructure' => { 150 => 0x5a },
	'samsungmodelid' => { 452 => 0x3 },
	'sanyoquality' => { 454 => 0x201 },
	'sanyothumbnail' => { 454 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 37 => 0xe, 55 => 0x1, 68 => 0x7, 118 => 0xd, 119 => [0x3013,0x1f], 125 => [0xa409,0xfe55], 133 => 0x1003, 173 => 'Saturation', 198 => 0x1f, 199 => 0x32, 200 => 0x28, 201 => 0x1a, 206 => 0x1, 256 => 0xaa, 274 => 0x35, 275 => 0x3b, 276 => 0x43, 370 => 0x40, 372 => 0x300d, 409 => 0x1f, 416 => 0xd, 437 => 0x27, 438 => 0x58, 439 => 0x42, 440 => 0x68, 444 => 0x28, 445 => 0x1013, 455 => 0x10, 465 => 0x1e, 466 => 0x1b, 479 => 0x2005, 534 => 'Saturation', 536 => 'Saturation', 540 => 'Saturation' },
	'saturationadj' => { 109 => 0x20901, 114 => 0x116, 256 => 0x94, 315 => 0x1, 319 => 0x2e, 516 => 0x8016 },
	'saturationadjustmentaqua' => { 534 => 'SaturationAdjustmentAqua', 536 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 534 => 'SaturationAdjustmentBlue', 536 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 534 => 'SaturationAdjustmentGreen', 536 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 534 => 'SaturationAdjustmentMagenta', 536 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 534 => 'SaturationAdjustmentOrange', 536 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 534 => 'SaturationAdjustmentPurple', 536 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 534 => 'SaturationAdjustmentRed', 536 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 534 => 'SaturationAdjustmentYellow', 536 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 76 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 75 => 0x68, 76 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 75 => 0x38, 76 => 0x38 },
	'saturationmonochrome' => { 75 => 0x80, 76 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 75 => 0x50, 76 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 75 => 0x20, 76 => 0x20 },
	'saturationsetting' => { 353 => 0x1010, 467 => 0x11, 484 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 75 => 0x8, 76 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 75 => 0x98, 76 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 75 => 0xb0, 76 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 75 => 0xc8, 76 => 0xe0 },
	'savefocusposition' => { 260 => 0x9b0 },
	'saveid' => { 565 => 'SaveID' },
	'sbaanalysiscomplete' => { 155 => 0xc35 },
	'sbablack' => { 155 => 0xc25 },
	'sbagmoffset' => { 155 => 0xc4a },
	'sbagray' => { 155 => 0xc26 },
	'sbagreenmagentabal' => { 155 => 0xc33 },
	'sbahighgray' => { 155 => 0xc46 },
	'sbailloffset' => { 155 => 0xc49 },
	'sbailluminantbal' => { 155 => 0xc34 },
	'sbalowgray' => { 155 => 0xc47 },
	'sbaneutralbal' => { 155 => 0xc32 },
	'sbawhite' => { 155 => 0xc27 },
	'scaletype' => { 564 => 'scaleType' },
	'scalingfactorheight' => { 360 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 282 => 0x60 },
	'scanningdirection' => { 150 => 0x64 },
	'scene' => { 435 => 'scen', 547 => 'Scene', 564 => 'scene' },
	'scenearea' => { 348 => 0x211, 350 => 0x1031 },
	'sceneassist' => { 256 => 0x9c },
	'scenecapturetype' => { 125 => 0xa406, 540 => 'SceneCaptureType' },
	'scenedetect' => { 348 => 0x210, 350 => 0x1030 },
	'scenedetectdata' => { 348 => 0x212, 350 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 159 => 0xfa02, 203 => 0x100, 256 => 0x8f, 345 => 0x509, 350 => 0x403, 370 => 0x8001, 379 => 0xf, 479 => 0xb023 },
	'scenemodeused' => { 161 => [0x6002,0xf002] },
	'scenerecognition' => { 133 => 0x1425 },
	'scenereferred' => { 544 => 'scene_referred' },
	'sceneselect' => { 454 => 0x21f },
	'scenetype' => { 125 => 0xa301, 540 => 'SceneType' },
	'screentips' => { 323 => '12.7', 324 => '5.3', 332 => '13.1', 333 => '4.4', 336 => '5.4', 338 => '5.1' },
	'scriptversion' => { 155 => 0x1770 },
	'sdcardid' => { 440 => 0x18 },
	'sdrblend' => { 534 => 'SDRBlend', 536 => 'SDRBlend' },
	'sdrbrightness' => { 534 => 'SDRBrightness', 536 => 'SDRBrightness' },
	'sdrcontrast' => { 534 => 'SDRContrast', 536 => 'SDRContrast' },
	'sdrhighlights' => { 534 => 'SDRHighlights', 536 => 'SDRHighlights' },
	'sdrshadows' => { 534 => 'SDRShadows', 536 => 'SDRShadows' },
	'sdrwhites' => { 534 => 'SDRWhites', 536 => 'SDRWhites' },
	'seal' => { 125 => 0xcea1 },
	'season' => { 548 => 'Season', 553 => 'season' },
	'seasonidentifier' => { 548 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 548 => [\'Season','SeasonName'] },
	'seasonnumber' => { 548 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 522 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 260 => 0x35a, 262 => 0x240, 265 => 0x22c, 266 => 0x240, 267 => 0x240, 285 => 0x13c, 296 => 0x1d0 },
	'section' => { 554 => 'section' },
	'securityclassification' => { 125 => 0x9212 },
	'selectableafpoint' => { 90 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 90 => 0x512 },
	'selfdata' => { 122 => 'SelfData' },
	'selftimer' => { 37 => 0x2, 370 => 0x2e, 454 => 0x214, 488 => 0x1134, 489 => 0x1134, 490 => 0x1110, 491 => 0x118c, 492 => 0x1168, 493 => 0x1020, 494 => 0x218, 495 => 0x218, 496 => 0x210 },
	'selftimer2' => { 82 => 0x1d },
	'selftimerinterval' => { 333 => '19.2' },
	'selftimermode' => { 125 => 0x882b },
	'selftimershotcount' => { 324 => '20.2', 326 => '20.3', 327 => '20.3', 328 => '18.2', 329 => '19.2', 330 => '19.2', 331 => '19.3', 333 => '19.3', 336 => '20.3', 337 => '20.3', 338 => '20.2', 339 => 0x31, 340 => 0x2d, 341 => 0x2d, 342 => 0x2d },
	'selftimershotinterval' => { 324 => '20.3', 326 => '20.2', 327 => '20.2', 331 => '19.2', 336 => '20.2', 337 => '20.2', 339 => 0x35, 340 => 0x31, 341 => 0x31, 342 => 0x31 },
	'selftimertime' => { 103 => 0x1806, 201 => 0x1f, 323 => '18.1', 324 => '20.1', 325 => '3.3', 326 => '20.1', 327 => '20.1', 328 => '18.1', 329 => '19.1', 330 => '19.1', 331 => '19.1', 332 => '7.2', 333 => '19.1', 334 => '3.3', 336 => '20.1', 337 => '20.1', 338 => '20.1', 339 => 0x2d, 340 => 0x2b, 341 => 0x2b, 342 => 0x2b },
	'sellingagency' => { 554 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 125 => 0x8546 },
	'sensingmethod' => { 125 => 0xa217, 540 => 'SensingMethod' },
	'sensitivityadjust' => { 409 => 0x40 },
	'sensitivitysteps' => { 388 => ['14.3','17.4'], 390 => 0x1 },
	'sensitivitytype' => { 125 => 0x8830, 541 => 'SensitivityType' },
	'sensor' => { 208 => 0x665e },
	'sensorarea' => { 350 => 0x400 },
	'sensorareas' => { 452 => 0xa010 },
	'sensorbitdepth' => { 372 => 0x312d },
	'sensorbluelevel' => { 79 => 0x5 },
	'sensorcalibration' => { 349 => 0x805 },
	'sensorcleaning' => { 96 => 0xd },
	'sensorfullheight' => { 154 => 0xf904 },
	'sensorfullwidth' => { 154 => 0xf903 },
	'sensorheight' => { 154 => 0xf901, 159 => 0xfa21, 205 => 0x8, 372 => 0x312c, 418 => 0x109, 445 => 0x1602 },
	'sensorimageheight' => { 155 => 0x3ee },
	'sensorimagewidth' => { 155 => 0x3ed },
	'sensorleftborder' => { 155 => 0x3eb },
	'sensorleftmargin' => { 418 => 0x10a },
	'sensorpixelsize' => { 256 => 0x9a },
	'sensorredlevel' => { 79 => 0x4 },
	'sensorserialnumber' => { 155 => 0x9ce },
	'sensorshield' => { 263 => 0x76b, 264 => 0x7cb, 265 => 0x66d, 266 => 0x69d, 267 => 0x705 },
	'sensorsize' => { 173 => 'SensorSize', 409 => 0x35 },
	'sensortemperature' => { 348 => 0x1500, 350 => 0x1007, 414 => [0xc,0x2a], 418 => 0x210, 455 => [0x39,0x55] },
	'sensortemperature2' => { 414 => 0xe, 418 => 0x211 },
	'sensortopborder' => { 155 => 0x3ec },
	'sensortopmargin' => { 418 => 0x10b },
	'sensortype' => { 370 => 0xca },
	'sensorwidth' => { 154 => 0xf900, 159 => 0xfa20, 205 => 0xa, 372 => 0x312b, 418 => 0x108, 445 => 0x1601 },
	'sequence' => { 437 => 0x7, 438 => 0x36, 439 => 0x29, 440 => 0x46, 441 => 0x35 },
	'sequencefilenumber' => { 489 => 0x4, 490 => 0x4, 491 => 0x4, 492 => 0x4, 502 => 0xc, 503 => 0xc, 504 => 0x1a },
	'sequenceimagenumber' => { 489 => 0x0, 490 => 0x0, 491 => 0x0, 492 => 0x0, 502 => 0x8, 503 => 0x8, 504 => 0x12, 511 => 0x24 },
	'sequencelength' => { 502 => 0x22, 503 => 0x1e, 504 => [0x16,0x1e] },
	'sequencename' => { 553 => 'sequenceName' },
	'sequencenumber' => { 82 => 0x9, 119 => 0x301c, 133 => 0x1101, 157 => 0x1d, 303 => 0x51c, 370 => 0x2b, 467 => [0x10c,0x30c], 479 => 0xb04a, 553 => 'sequenceNumber' },
	'sequenceshotinterval' => { 454 => 0x224 },
	'sequencetotalnumber' => { 553 => 'sequenceTotalNumber' },
	'sequentialshot' => { 454 => 0x20e },
	'serialnumber' => { 69 => 0xc, 103 => 0x180b, 125 => [0xa431,0xfde9], 154 => 0xfa04, 156 => 0xfa00, 158 => 0xc354, 159 => 0xfa19, 170 => 0x0, 173 => 'SerialNumber', 208 => 0x5501, 256 => [0xa0,0x1d], 346 => 0x101, 350 => [0x404,0x101a], 365 => 0x303, 367 => 0x305, 372 => 0x3103, 409 => 0x229, 418 => 0x102, 419 => 0x407, 435 => ['SNum','slno'], 437 => 0x15, 438 => 0x7e, 439 => 0x84, 440 => 0x8c, 441 => 0x4b, 445 => 0x5, 452 => 0xa002, 455 => 0x2, 479 => 0x2031, 531 => 'SerialNumber', 541 => 'BodySerialNumber' },
	'serialnumberformat' => { 69 => 0x15, 103 => 0x183b },
	'serialnumberhash' => { 435 => 'CAME' },
	'series' => { 548 => 'Series' },
	'seriesdatetime' => { 519 => 'SeriesDateTime' },
	'seriesdescription' => { 519 => 'SeriesDescription' },
	'seriesidentifier' => { 548 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 519 => 'SeriesModality' },
	'seriesname' => { 548 => [\'Series','SeriesName'] },
	'seriesnumber' => { 519 => 'SeriesNumber', 554 => 'seriesNumber' },
	'seriestitle' => { 554 => 'seriesTitle' },
	'serviceidentifier' => { 149 => 0x1e },
	'servingsize' => { 556 => 'servingSize' },
	'servoafcharacteristics' => { 2 => 0x1b },
	'setbuttoncrosskeysfunc' => { 93 => 0x0, 94 => 0x0 },
	'setbuttonwhenshooting' => { 88 => 0x1, 90 => 0x704, 96 => 0xc },
	'setclockfromlocationdata' => { 265 => 0x61d, 266 => 0x64d, 267 => 0x6b5 },
	'setfunctionwhenshooting' => { 91 => 0x0, 92 => 0x1, 95 => 0x1 },
	'setting' => { 553 => 'setting' },
	'shadingcompensation' => { 345 => 0x50c, 370 => 0x8a },
	'shadingcompensation2' => { 349 => 0x1012 },
	'shadow' => { 455 => 0xe },
	'shadowadj' => { 109 => 0x2030b },
	'shadowcorrection' => { 409 => 0x79 },
	'shadowprotection' => { 315 => 0x0 },
	'shadows' => { 125 => 0xfe52, 479 => 0x2032, 527 => 'Shadows', 534 => 'Shadows', 536 => 'Shadows' },
	'shadows2012' => { 534 => 'Shadows2012', 536 => 'Shadows2012' },
	'shadowsadj' => { 516 => 0x901a },
	'shadowscale' => { 125 => 0xc633 },
	'shadowtint' => { 534 => 'ShadowTint', 536 => 'ShadowTint' },
	'shadowtone' => { 133 => 0x1040 },
	'shakereduction' => { 411 => 0x1, 412 => 0x1 },
	'shareduserrating' => { 196 => 'WM/SharedUserRating' },
	'sharpendetail' => { 534 => 'SharpenDetail', 536 => 'SharpenDetail' },
	'sharpenedgemasking' => { 534 => 'SharpenEdgeMasking', 536 => 'SharpenEdgeMasking' },
	'sharpening' => { 372 => 0x300b },
	'sharpeningadj' => { 319 => 0x2b },
	'sharpeningkernel' => { 155 => 0x92f },
	'sharpenradius' => { 534 => 'SharpenRadius', 536 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 37 => 0xf, 68 => 0x6, 79 => 0x2, 118 => 0xb, 119 => [0x3011,0x21], 125 => [0xa40a,0xfe56], 133 => 0x1001, 157 => 0x6b, 166 => 0x37, 173 => 'Sharpness', 198 => 0x21, 199 => 0x30, 200 => 0x26, 201 => 0x18, 206 => 0x3, 256 => 0x6, 274 => 0x32, 275 => 0x33, 276 => 0x39, 350 => 0x100f, 370 => 0x41, 409 => 0x21, 416 => 0xb, 437 => 0x26, 438 => 0x56, 439 => 0x40, 440 => 0x66, 444 => 0x22, 445 => [0x1003,0x1014], 455 => 0x11, 465 => 0x1c, 466 => 0x19, 479 => 0x2006, 511 => 0x52, 534 => 'Sharpness', 536 => 'Sharpness', 540 => 'Sharpness' },
	'sharpnessadj' => { 109 => 0x20310, 114 => 0x25a, 516 => 0x801a },
	'sharpnessadjon' => { 109 => '0x20310.0' },
	'sharpnessauto' => { 76 => 0x94 },
	'sharpnessfactor' => { 350 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 75 => 0x64, 76 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 79 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 75 => 0x34, 76 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 75 => 0x7c, 76 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 75 => 0x4c, 76 => 0x4c },
	'sharpnessovershoot' => { 516 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 75 => 0x1c, 76 => 0x1c },
	'sharpnessrange' => { 479 => 0x2035 },
	'sharpnesssetting' => { 345 => 0x506, 353 => 0x1013, 467 => 0x12, 484 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 75 => 0x4, 76 => 0x4 },
	'sharpnessstrength' => { 109 => 0x20311 },
	'sharpnessthreshold' => { 516 => 0x801d },
	'sharpnessundershoot' => { 516 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 75 => 0x94, 76 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 75 => 0xac, 76 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 75 => 0xc4, 76 => 0xdc },
	'shiftcols' => { 155 => 0xc70 },
	'shootid' => { 553 => 'shootID' },
	'shootingdistance' => { 109 => 0x20701 },
	'shootinginfodisplay' => { 323 => '13.2', 324 => '5.1', 332 => '10.2', 333 => '4.1', 336 => '5.1', 338 => '5.3' },
	'shootinginfomonitorofftime' => { 323 => '26.2', 324 => '22.2', 326 => '22.2', 327 => '22.2', 331 => '21.2', 332 => '9.1', 333 => '21.2', 336 => '22.2', 337 => '22.2', 338 => '22.2', 339 => 0x3d, 340 => 0x37, 341 => 0x37, 342 => 0x37 },
	'shootingmode' => { 173 => 'ShootingMode', 256 => 0x89, 370 => 0x1f },
	'shootingmodesetting' => { 325 => '5.1' },
	'shortdescription' => { 538 => 'shortdescription' },
	'shortdocumentid' => { 148 => 0xba },
	'shortname' => { 534 => 'ShortName', 536 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 90 => 0x80d },
	'shorttitle' => { 427 => '@sti' },
	'shotdate' => { 564 => 'shotDate' },
	'shotday' => { 564 => 'shotDay' },
	'shotlocation' => { 564 => 'shotLocation' },
	'shotlogdata' => { 140 => 'shot_log_data' },
	'shotname' => { 435 => 'shot', 564 => 'shotName' },
	'shotnumber' => { 414 => 0xa, 564 => 'shotNumber' },
	'shotnumbersincepowerup' => { 483 => 0x44e, 502 => 0x1a, 503 => 0x16, 504 => 0xa },
	'shotnumbersincepowerup2' => { 467 => 0x200 },
	'shotsize' => { 564 => 'shotSize' },
	'shotsperinterval' => { 245 => 0x180, 260 => 0x1f0, 261 => 0xb4, 262 => 0xcc, 265 => 0xc0, 266 => 0xd0, 267 => 0xd0 },
	'showmovement' => { 427 => 'shwm' },
	'shownevent' => { 548 => 'EventExt' },
	'showneventidentifier' => { 548 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 548 => [\'EventExt','EventExtName'] },
	'shutter' => { 498 => 0x20, 499 => 0x26, 500 => 0x26 },
	'shutter-aelock' => { 88 => 0x4, 90 => 0x701, 91 => 0x3, 92 => 0x4, 93 => 0x3, 94 => 0x3, 95 => 0x4, 96 => 0x2 },
	'shutteraelbutton' => { 89 => 0x4 },
	'shutterbuttonafonbutton' => { 90 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 34 => 0xd29, 61 => 0x1, 256 => 0xa7, 287 => [0x6a,0x157,0x24d], 288 => 0x286, 289 => 0x279, 290 => 0x284, 291 => 0x242, 292 => 0x280, 293 => 0x276, 294 => [0x27d,0x27f], 295 => 0x246, 297 => 0x2d6, 298 => 0x321, 299 => 0xbd8, 300 => 0x287, 301 => 0x320, 302 => 0x24a, 303 => 0x5fb, 304 => 0x2d5, 409 => 0x5d, 476 => 0x846, 482 => [0x125,0x14a], 498 => 0x32, 499 => 0x3a, 500 => 0x3a, 501 => 0xa },
	'shuttercount2' => { 498 => 0x4c, 499 => [0x50,0x52,0x58], 500 => 0x50 },
	'shuttercount3' => { 498 => [0x1a0,0x1aa,0x1bd], 499 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 88 => 0xf, 89 => 0xf, 90 => 0x305, 91 => 0xe, 92 => 0xf, 93 => 0x8, 94 => 0x8, 95 => 0xf, 96 => 0x8 },
	'shuttermode' => { 61 => 0x17, 157 => 0x1b, 256 => 0x34 },
	'shutterreleasebuttonae-l' => { 323 => '17.7', 324 => '18.4', 326 => '78.4', 327 => '78.4', 328 => '16.1', 329 => '17.1', 330 => '17.1', 331 => '17.1', 332 => '7.1', 333 => '17.5', 336 => '18.4', 337 => '78.4', 338 => '18.2', 339 => 0x2b, 340 => 0x29, 341 => 0x29, 342 => 0x29 },
	'shutterreleasemethod' => { 103 => 0x1010 },
	'shutterreleasenocfcard' => { 88 => 0x2, 89 => 0x2, 96 => 0xf },
	'shutterreleasetiming' => { 103 => 0x1011 },
	'shutterreleasewithoutlens' => { 90 => 0x711 },
	'shutterspeedlock' => { 324 => '38.1', 326 => '38.1', 327 => '38.1', 336 => '38.1', 337 => '38.1', 339 => 0xbb, 340 => 0xb7, 341 => 0xb7, 342 => 0xb7 },
	'shutterspeedrange' => { 90 => 0x10c },
	'shutterspeedsetting' => { 201 => 0x6, 465 => 0x2f, 466 => 0x28, 467 => 0x0 },
	'shutterspeedvalue' => { 99 => 0x1, 125 => 0x9201, 350 => 0x1000, 418 => 0x400, 540 => 'ShutterSpeedValue' },
	'shuttertype' => { 133 => 0x1050, 370 => 0x9f, 409 => 0x87, 504 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 552 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 155 => 0xe0d },
	'sigmascalingfactorcamera' => { 155 => 0xe0c },
	'sigmascalingfactorlowres' => { 155 => 0xe0b },
	'sigmasizetable' => { 155 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 256 => 0xbf, 260 => 0x9b7 },
	'similarityindex' => { 148 => 0xe4 },
	'singleframebracketing' => { 201 => 0x21 },
	'skilllevel' => { 556 => 'skillLevel' },
	'skintonecorrection' => { 409 => 0x95 },
	'skiplinetime' => { 155 => 0x184e },
	'slaveflashmeteringsegments' => { 409 => 0x20b },
	'slideshowname' => { 553 => 'slideshowName' },
	'slideshownumber' => { 553 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 553 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 260 => 0x364, 262 => 0x24a, 267 => 0x24a },
	'slowshutter' => { 82 => 0x8 },
	'slowsync' => { 133 => 0x1030 },
	'smartalbumcolor' => { 452 => 0x20 },
	'smartrange' => { 452 => 0xa012 },
	'smileshutter' => { 467 => 0x31 },
	'smileshuttermode' => { 467 => 0x27 },
	'smoothness' => { 125 => 0xfe57, 534 => 'Smoothness', 536 => 'Smoothness' },
	'snapshot' => { 548 => 'SnapshotLink' },
	'snapshotformat' => { 548 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 548 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 548 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 548 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 548 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 528 => 'Snapshots' },
	'snapshotusedvideoframe' => { 548 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 548 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 548 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 548 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 548 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 479 => 0x200f },
	'software' => { 125 => 0x131, 143 => 'Software', 174 => 'Software', 359 => 'Software', 418 => 0x203, 429 => 'software', 455 => 0x18, 560 => 'Software' },
	'softwareversion' => { 435 => ['@swr',"\xa9swr"], 454 => 0x207 },
	'soloist' => { 427 => "\xa9sol" },
	'songwriter' => { 435 => "\xa9swf" },
	'songwriterkeywords' => { 435 => "\xa9swk" },
	'sonycropsize' => { 125 => 0x74c8 },
	'sonycroptopleft' => { 125 => 0x74c7 },
	'sonydatetime' => { 487 => 0x6, 489 => 0x1b6, 490 => 0x210, 491 => 0x1fe, 492 => 0x22c },
	'sonydatetime2' => { 498 => 0x51 },
	'sonyexposuretime' => { 498 => 0x3a, 499 => 0x46, 500 => [0x66,0x46], 501 => 0x1a },
	'sonyexposuretime2' => { 511 => 0xe },
	'sonyfnumber' => { 498 => 0x3c, 499 => 0x48, 500 => [0x68,0x48], 501 => 0x1c, 511 => 0x14 },
	'sonyimageheight' => { 487 => 0x1a, 502 => 0x44, 503 => 0x3f },
	'sonyimageheightmax' => { 511 => 0x40 },
	'sonyimagesize' => { 201 => 0x3b, 465 => 0x54, 466 => 0x54, 467 => 0x9 },
	'sonyimagewidth' => { 487 => 0x1c },
	'sonyimagewidthmax' => { 511 => 0x3e },
	'sonyiso' => { 489 => 0x1218, 490 => 0x11f4, 491 => 0x1270, 492 => [0x1254,0x1258,0x1280], 493 => 0x113c, 494 => 0x344, 495 => 0x346, 496 => 0x320, 511 => 0x4 },
	'sonymaxaperture' => { 498 => 0x0, 499 => 0x0 },
	'sonymaxaperturevalue' => { 511 => 0x16 },
	'sonyminaperture' => { 498 => 0x1, 499 => 0x1 },
	'sonymodelid' => { 479 => 0xb001 },
	'sonyquality' => { 201 => 0x3c },
	'sonyrawimagesize' => { 125 => 0x7038 },
	'sonytimeminsec' => { 499 => 0x61 },
	'sortalbum' => { 427 => 'soal' },
	'sortalbumartist' => { 427 => 'soaa' },
	'sortartist' => { 427 => 'soar' },
	'sortcomposer' => { 427 => 'soco' },
	'sortname' => { 427 => 'sonm', 534 => 'SortName', 536 => 'SortName' },
	'sortshow' => { 427 => 'sosn' },
	'soundengineer' => { 427 => "\xa9sne" },
	'source' => { 148 => 0x73, 359 => 'Source', 537 => 'source', 538 => 'source', 552 => 'Source' },
	'sourcecount' => { 147 => 'SourceCount' },
	'sourcecredits' => { 435 => "\xa9src" },
	'sourcedirectoryindex' => { 395 => 0x0 },
	'sourcefileindex' => { 395 => 0x2 },
	'sourcemodified' => { 355 => 'SourceModified', 551 => 'SourceModified' },
	'sourcephotoscount' => { 146 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 155 => 0x1390 },
	'spatialfrequencyresponse' => { 540 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 540 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 540 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 540 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 540 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 564 => 'speakerPlacement' },
	'specialeffectlevel' => { 119 => 0x3030 },
	'specialeffectmode' => { 119 => 0x2076 },
	'specialeffectsetting' => { 119 => 0x3031 },
	'specialinstructions' => { 148 => 0x28 },
	'specialmode' => { 350 => 0x200, 454 => 0x200 },
	'specialoccasion' => { 556 => 'specialOccasion' },
	'specialtypeid' => { 140 => 'SpecialTypeID' },
	'spectralsensitivity' => { 125 => 0x8824, 540 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 44 => 0x32b, 45 => 0x281, 46 => 0x295, 49 => [0x2b9,0x2d0,0x2d4], 50 => [0x56a,0x296], 51 => 0x1e4, 52 => [0x1fd,0x2dd], 53 => [0x231,0x30f], 54 => 0x31d },
	'speedx' => { 121 => 0x3, 435 => "\xa9xsp" },
	'speedy' => { 121 => 0x4, 435 => "\xa9ysp" },
	'speedz' => { 121 => 0x5, 435 => "\xa9zsp" },
	'spherical' => { 147 => 'Spherical' },
	'sphericalvideoxml' => { 126 => 'SphericalVideoXML' },
	'splitcolumn' => { 418 => 0x222 },
	'splittoningbalance' => { 534 => 'SplitToningBalance', 536 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 534 => 'SplitToningHighlightHue', 536 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 534 => 'SplitToningHighlightSaturation', 536 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 534 => 'SplitToningShadowHue', 536 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 534 => 'SplitToningShadowSaturation', 536 => 'SplitToningShadowSaturation' },
	'sport' => { 554 => 'sport' },
	'sportevents' => { 2 => 0x1e },
	'spotfocuspointx' => { 198 => 0x2d },
	'spotfocuspointy' => { 198 => 0x2e },
	'spotmeteringmode' => { 37 => 0x27 },
	'spotmeterlinktoafpoint' => { 90 => 0x107 },
	'sractive' => { 388 => '17.1' },
	'srawquality' => { 37 => 0x2e },
	'srfocallength' => { 411 => 0x3 },
	'srgbrendering' => { 357 => 'sRGB' },
	'srhalfpresstime' => { 411 => 0x2 },
	'srresult' => { 411 => 0x0, 412 => 0x0 },
	'stackedimage' => { 345 => 0x804 },
	'standardmatrixcustom' => { 155 => 0x7d4 },
	'standardmatrixdaylight' => { 155 => 0x7d0 },
	'standardmatrixflash' => { 155 => 0x7d3 },
	'standardmatrixfluorescent' => { 155 => 0x7d2 },
	'standardmatrixtungsten' => { 155 => 0x7d1 },
	'standardoutputhighlightpoint' => { 115 => 0x14 },
	'standardoutputsensitivity' => { 125 => 0x8831, 541 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 115 => 0x15 },
	'standardrawcolortone' => { 115 => 0xd },
	'standardrawcontrast' => { 115 => 0xf },
	'standardrawhighlight' => { 115 => 0x75 },
	'standardrawhighlightpoint' => { 115 => 0x12 },
	'standardrawlinear' => { 115 => 0x10 },
	'standardrawsaturation' => { 115 => 0xe },
	'standardrawshadow' => { 115 => 0x7e },
	'standardrawshadowpoint' => { 115 => 0x13 },
	'standardrawsharpness' => { 115 => 0x11 },
	'standardunsharpmaskfineness' => { 115 => 0x94 },
	'standardunsharpmaskstrength' => { 115 => 0x92 },
	'standardunsharpmaskthreshold' => { 115 => 0x96 },
	'standardwhitecustom' => { 155 => 0x838 },
	'standardwhitedaylight' => { 155 => 0x834 },
	'standardwhiteflash' => { 155 => 0x837 },
	'standardwhitefluorescent' => { 155 => 0x836 },
	'standardwhitetungsten' => { 155 => 0x835 },
	'standbytimer' => { 324 => '19.1', 326 => '19.1', 327 => '19.1', 330 => '18.1', 331 => '18.1', 336 => '19.1', 337 => '19.1' },
	'starlightview' => { 340 => 0x249, 341 => 0x249, 342 => 0x261 },
	'startingpage' => { 554 => 'startingPage' },
	'startmovieshooting' => { 90 => 0x70d },
	'starttimecode' => { 435 => "\xa9TIM", 564 => 'startTimecode' },
	'starttimecodetimeformat' => { 564 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 564 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 564 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 435 => "\xa9TSZ", 564 => 'startTimeSampleSize' },
	'starttimescale' => { 435 => "\xa9TSC", 564 => 'startTimeScale' },
	'state' => { 178 => 'State', 370 => 0x6b, 552 => 'State' },
	'status' => { 521 => 'Status', 526 => 'Status' },
	'stepcropshooting' => { 479 => 0x205c },
	'stereomode' => { 147 => 'StereoMode' },
	'stitched' => { 147 => 'Stitched' },
	'stitchingsoftware' => { 146 => 'StitchingSoftware', 147 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 488 => 0x113e, 489 => 0x113e, 490 => 0x111a, 491 => 0x1196, 492 => 0x1172, 493 => 0x102a, 494 => 0x222, 495 => 0x222, 496 => 0x217, 511 => 0xa },
	'storagemethod' => { 205 => 0x12 },
	'storebyorientation' => { 324 => '46.3', 326 => '47.3', 327 => '47.3', 336 => '47.3', 337 => '47.3', 339 => 0xd, 340 => 0xd, 341 => 0xd, 342 => 0xd },
	'storedescription' => { 427 => 'sdes' },
	'storedformat' => { 529 => 'StoredFormat' },
	'storylineidentifier' => { 548 => 'StorylineIdentifier' },
	'straightenangle' => { 316 => 0x2fc08431 },
	'streamready' => { 548 => 'StreamReady' },
	'streamtype' => { 193 => 'StreamType' },
	'stretchmode' => { 564 => 'stretchMode' },
	'studydatetime' => { 519 => 'StudyDateTime' },
	'studydescription' => { 519 => 'StudyDescription' },
	'studyid' => { 519 => 'StudyID' },
	'studyphysician' => { 519 => 'StudyPhysician' },
	'styleperiod' => { 548 => 'StylePeriod' },
	'sub-location' => { 148 => 0x5c },
	'subcommanddialframeadvancezoom' => { 267 => 0x806 },
	'subcommanddialplaybackmode' => { 340 => 0x1cf, 341 => 0x1cf, 342 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 340 => 0x1d1, 342 => 0x1e9 },
	'subfiledata' => { 181 => 'data' },
	'subfiledirectory' => { 181 => '1Directory' },
	'subfilemimetype' => { 181 => '2MIME' },
	'subfilename' => { 181 => '1Name' },
	'subfileresource' => { 181 => 'rsrc' },
	'subfiletype' => { 125 => 0xfe, 181 => '0Type' },
	'subject' => { 355 => 'Subject', 425 => 'Subject', 537 => 'subject', 550 => 'Subject', 565 => 'subject' },
	'subjectarea' => { 125 => 0x9214, 540 => 'SubjectArea' },
	'subjectcode' => { 547 => 'SubjectCode' },
	'subjectdetectarea' => { 354 => 0x2 },
	'subjectdetectdetail' => { 354 => 0x6 },
	'subjectdetectframesize' => { 354 => 0x0 },
	'subjectdetectinfo' => { 345 => 0x30b },
	'subjectdetection' => { 260 => 0x36e, 262 => 0x252, 265 => 0x23e, 266 => 0x252, 267 => 0x252 },
	'subjectdetectionareamf' => { 260 => 0x3ea },
	'subjectdetectstatus' => { 354 => 0xa },
	'subjectdistance' => { 125 => 0x9206, 157 => 0x3e, 540 => 'SubjectDistance' },
	'subjectdistancerange' => { 125 => 0xa40c, 540 => 'SubjectDistanceRange' },
	'subjectlocation' => { 125 => 0xa214, 540 => 'SubjectLocation' },
	'subjectmotion' => { 326 => '78.2', 327 => '78.2', 337 => '78.2', 340 => 0x103, 341 => 0x103, 342 => 0x119 },
	'subjectprogram' => { 198 => 0x22 },
	'subjectrecognition' => { 381 => 0x960 },
	'subjectreference' => { 148 => 0xc },
	'subjectswitching' => { 2 => 0x15 },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 546 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 546 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 120 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 120 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 120 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 125 => 0x9290 },
	'subsectimedigitized' => { 125 => 0x9292 },
	'subsectimeoriginal' => { 125 => 0x9291 },
	'subsection1' => { 554 => 'subsection1' },
	'subsection2' => { 554 => 'subsection2' },
	'subsection3' => { 554 => 'subsection3' },
	'subsection4' => { 554 => 'subsection4' },
	'subselector' => { 324 => '49.1', 326 => '71.1', 327 => '71.1', 337 => '71.1', 339 => 0x93, 340 => 0x8f, 341 => 0x8f, 342 => 0x8f },
	'subselectorassignment' => { 324 => '48.1' },
	'subselectorcenter' => { 326 => '72.1', 327 => '72.1', 337 => '72.1' },
	'subselectorplusdials' => { 324 => '49.2', 326 => '73.1', 327 => '73.1', 337 => '73.1' },
	'subtitle' => { 196 => 'WM/SubTitle', 427 => "\xa9st3", 435 => "\xa9snm", 554 => 'subtitle' },
	'subtitlekeywords' => { 435 => "\xa9snk" },
	'subversionfilename' => { 546 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 546 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 546 => 'SubVersions' },
	'superimposeddisplay' => { 88 => 0xa, 90 => 0x510, 91 => 0x9, 92 => 0xa, 95 => 0xa, 96 => 0xe },
	'supermacro' => { 69 => 0x1a },
	'supplementalcategories' => { 148 => 0x14, 552 => 'SupplementalCategories' },
	'supplementaltype' => { 150 => 0x37 },
	'supplementdisplayid' => { 554 => 'supplementDisplayID' },
	'supplementstartingpage' => { 554 => 'supplementStartingPage' },
	'supplementtitle' => { 554 => 'supplementTitle' },
	'supplychainsource' => { 548 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 548 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 548 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 534 => 'SupportsAmount', 536 => 'SupportsAmount' },
	'supportscolor' => { 534 => 'SupportsColor', 536 => 'SupportsColor' },
	'supportshighdynamicrange' => { 534 => 'SupportsHighDynamicRange', 536 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 534 => 'SupportsMonochrome', 536 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 534 => 'SupportsNormalDynamicRange', 536 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 534 => 'SupportsOutputReferred', 536 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 534 => 'SupportsSceneReferred', 536 => 'SupportsSceneReferred' },
	'svisosetting' => { 388 => 0x14 },
	'swatchcoloranta' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 569 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 569 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 569 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 569 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 569 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 370 => 0x93, 467 => 0x33 },
	'sweeppanoramafieldofview' => { 370 => 0x94 },
	'sweeppanoramasize' => { 467 => 0x32 },
	'switchtoregisteredafpoint' => { 89 => 0x12, 90 => 0x50a },
	'symlink' => { 126 => 'SymLink' },
	'syncreleasemode' => { 326 => '77.1', 327 => '77.1', 337 => '77.1', 339 => 0x45, 340 => 0x41, 341 => 0x41, 342 => 0x41 },
	'system' => { 418 => 0x204 },
	'tagged' => { 420 => 0xdd, 421 => 'Tagged', 528 => 'tagged' },
	'tagslist' => { 539 => 'TagsList' },
	'tagstructure' => { 546 => 'TagStructure' },
	'takenumber' => { 564 => 'takeNumber' },
	'tapename' => { 564 => 'tapeName' },
	'targetaperture' => { 82 => 0x4 },
	'targetaspectratio' => { 360 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 101 => 0x1 },
	'targetdistancesetting' => { 103 => 0x1807 },
	'targetexposuretime' => { 82 => 0x5 },
	'targetimagetype' => { 103 => 0x100a },
	'targetprinter' => { 125 => 0x151 },
	'taxon' => { 124 => 'Taxon' },
	'taxonacceptednameusage' => { 124 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 124 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 124 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 124 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 124 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 124 => [\'Taxon','TaxonFamily'] },
	'taxongenericname' => { 124 => [\'Taxon','TaxonGenericName'] },
	'taxongenus' => { 124 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 124 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 124 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfragenericepithet' => { 124 => [\'Taxon','TaxonInfragenericEpithet'] },
	'taxoninfraspecificepithet' => { 124 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 124 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 124 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 124 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 124 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 124 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 124 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 124 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 124 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 124 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 124 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 124 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 124 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 124 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 124 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 124 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 124 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 124 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 124 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 124 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 124 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubfamily' => { 124 => [\'Taxon','TaxonSubFamily'] },
	'taxonsubgenus' => { 124 => [\'Taxon','TaxonSubgenus'] },
	'taxonsubtribe' => { 124 => [\'Taxon','TaxonSubTribe'] },
	'taxonsuperfamily' => { 124 => [\'Taxon','TaxonSuperFamily'] },
	'taxontaxonomicstatus' => { 124 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxontribe' => { 124 => [\'Taxon','TaxonTribe'] },
	'taxonverbatimtaxonrank' => { 124 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 124 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 155 => 0x196f },
	'tda1edgepolarity' => { 155 => 0x1971 },
	'tda1gain' => { 155 => 0x1970 },
	'tda1offset' => { 155 => 0x196e },
	'tda2bandwidth' => { 155 => 0x1979 },
	'tda2edgepolarity' => { 155 => 0x197b },
	'tda2gain' => { 155 => 0x197a },
	'tda2offset' => { 155 => 0x1978 },
	'tda3bandwidth' => { 155 => 0x1983 },
	'tda3edgepolarity' => { 155 => 0x1985 },
	'tda3gain' => { 155 => 0x1984 },
	'tda3offset' => { 155 => 0x1982 },
	'tda4bandwidth' => { 155 => 0x198d },
	'tda4edgepolarity' => { 155 => 0x198f },
	'tda4gain' => { 155 => 0x198e },
	'tda4offset' => { 155 => 0x198c },
	'teaser' => { 554 => 'teaser' },
	'teleconverter' => { 203 => 0x105, 479 => 0x105 },
	'tempampgainx100' => { 155 => 0x1914 },
	'tempo' => { 564 => 'tempo' },
	'temporalcoverage' => { 548 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 548 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 548 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 356 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 356 => 'TermsAndConditionsURL' },
	'testname' => { 126 => 'TestName' },
	'textencoding' => { 255 => 0x4 },
	'textlayername' => { 552 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 552 => 'TextLayers' },
	'textlayertext' => { 552 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 370 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 534 => 'Texture', 536 => 'Texture' },
	'three-dtrackingfacedetection' => { 326 => '1.4', 327 => '1.4', 337 => '1.4' },
	'three-dtrackingwatcharea' => { 326 => '78.1', 327 => '78.1', 337 => '78.1' },
	'thresholding' => { 125 => 0x107 },
	'thumbnailfilename' => { 103 => 0x817 },
	'thumbnailformat' => { 562 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 159 => 0xfa55, 562 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 103 => 0x2008, 120 => 'Exif-ThumbnailImage', 128 => 0x3, 184 => 'data', 350 => 0x100, 427 => 'tnal', 435 => 'thmb', 562 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 184 => '1Name' },
	'thumbnailimagesize' => { 184 => 'ImageSize' },
	'thumbnailimagetype' => { 184 => '0Type' },
	'thumbnailimagevalidarea' => { 69 => 0x13 },
	'thumbnaillength' => { 125 => 0x202 },
	'thumbnailoffset' => { 125 => 0x201 },
	'thumbnailpng' => { 435 => 'thmb' },
	'thumbnails' => { 562 => 'Thumbnails' },
	'thumbnailwidth' => { 159 => 0xfa54, 562 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 554 => 'ticker' },
	'tiffhandling' => { 534 => 'TIFFHandling', 536 => 'TIFFHandling' },
	'tiffmeteringimage' => { 204 => 0x104c, 476 => 0x1110 },
	'tilelength' => { 125 => 0x143 },
	'tilewidth' => { 125 => 0x142 },
	'time' => { 155 => 0x401, 409 => 0x7 },
	'timecodes' => { 125 => 0xc763 },
	'timecreated' => { 148 => 0x3c, 157 => 0x14, 166 => 0x10, 421 => 'TimeCreated' },
	'timelapseshotnumber' => { 373 => 0x10 },
	'timeperiod' => { 554 => 'timePeriod' },
	'timerfunctionbutton' => { 325 => '5.2', 328 => '12.1', 329 => '13.1' },
	'timerlength' => { 90 => 0x80c },
	'timerrecording' => { 370 => 0x96 },
	'timescaleparams' => { 564 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 564 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 564 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 564 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 149 => 0x50 },
	'timeshot' => { 522 => 'TimeShot' },
	'timesignature' => { 564 => 'timeSignature' },
	'timesincepoweron' => { 370 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 147 => 'Timestamp', 343 => 0x8, 359 => 'TimeStamp', 370 => 0xaf, 530 => 'Timestamp', 546 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 83 => 0x1, 260 => 0x8fe, 263 => 0x694, 264 => 0x6a4, 265 => 0x594, 266 => 0x5c4, 267 => 0x5dc, 308 => 0x0, 448 => 0xa },
	'timezonecity' => { 83 => 0x2 },
	'timezonecode' => { 106 => 0x1 },
	'timezoneinfo' => { 106 => 0x2 },
	'timezoneoffset' => { 125 => 0x882a },
	'tint' => { 429 => 'player.movie.visual.tint', 534 => 'Tint', 536 => 'Tint' },
	'title' => { 174 => 'Title', 355 => 'Title', 359 => 'Title', 370 => 0x65, 425 => 'Title', 427 => ['titl',"\xa9nam"], 429 => 'title', 435 => ['titl',"\xa9nam"], 537 => 'title', 550 => 'Title', 562 => 'Title' },
	'togglestyleamount' => { 534 => 'ToggleStyleAmount', 536 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 534 => 'ToggleStyleDigest', 536 => 'ToggleStyleDigest' },
	'tonecomp' => { 256 => 0x81 },
	'tonecurve' => { 79 => 0x1, 409 => 0x402, 534 => 'ToneCurve', 536 => 'ToneCurve' },
	'tonecurveactive' => { 114 => 0x110 },
	'tonecurveadobergb' => { 452 => 0xa043 },
	'tonecurveadobergbdefault' => { 452 => 0xa041 },
	'tonecurveblue' => { 534 => 'ToneCurveBlue', 536 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 516 => 0x9003 },
	'tonecurvebluey' => { 516 => 0x9007 },
	'tonecurvebrightness' => { 109 => 0x20410 },
	'tonecurvebrightnessx' => { 516 => 0x9000 },
	'tonecurvebrightnessy' => { 516 => 0x9004 },
	'tonecurvecolorspace' => { 113 => 0x0 },
	'tonecurvecontrast' => { 109 => 0x20411 },
	'tonecurvegreen' => { 534 => 'ToneCurveGreen', 536 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 516 => 0x9002 },
	'tonecurvegreeny' => { 516 => 0x9006 },
	'tonecurveinputrange' => { 113 => 0x3 },
	'tonecurveinterpolation' => { 114 => 0x159 },
	'tonecurvemode' => { 114 => 0x113 },
	'tonecurvename' => { 534 => 'ToneCurveName', 536 => 'ToneCurveName' },
	'tonecurvename2012' => { 534 => 'ToneCurveName2012', 536 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 109 => '0x20400.1' },
	'tonecurveoutputrange' => { 113 => 0x5 },
	'tonecurveprofilename' => { 155 => 0x1391 },
	'tonecurveproperty' => { 114 => 0x3c },
	'tonecurvepv2012' => { 534 => 'ToneCurvePV2012', 536 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 534 => 'ToneCurvePV2012Blue', 536 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 534 => 'ToneCurvePV2012Green', 536 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 534 => 'ToneCurvePV2012Red', 536 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 534 => 'ToneCurveRed', 536 => 'ToneCurveRed' },
	'tonecurveredx' => { 516 => 0x9001 },
	'tonecurveredy' => { 516 => 0x9005 },
	'tonecurves' => { 409 => 0x403 },
	'tonecurveshape' => { 113 => 0x1 },
	'tonecurvesrgb' => { 452 => 0xa042 },
	'tonecurvesrgbdefault' => { 452 => 0xa040 },
	'tonecurvex' => { 113 => 0xa },
	'tonecurvey' => { 113 => 0xb },
	'tonelevel' => { 345 => 0x52e },
	'tonemap' => { 260 => 0x374, 262 => 0x26a },
	'tonemapstrength' => { 534 => 'ToneMapStrength', 536 => 'ToneMapStrength' },
	'toningeffect' => { 61 => 0xf, 256 => 0xb3, 274 => 0x38, 275 => 0x40, 276 => 0x48, 445 => 0x1015 },
	'toningeffectauto' => { 76 => 0xa4 },
	'toningeffectfaithful' => { 75 => 0x74, 76 => 0x74 },
	'toningeffectlandscape' => { 75 => 0x44, 76 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 75 => 0x8c, 76 => 0x8c },
	'toningeffectneutral' => { 75 => 0x5c, 76 => 0x5c },
	'toningeffectportrait' => { 75 => 0x2c, 76 => 0x2c },
	'toningeffectstandard' => { 75 => 0x14, 76 => 0x14 },
	'toningeffectuserdef1' => { 75 => 0xa4, 76 => 0xbc },
	'toningeffectuserdef2' => { 75 => 0xbc, 76 => 0xd4 },
	'toningeffectuserdef3' => { 75 => 0xd4, 76 => 0xec },
	'toningsaturation' => { 274 => 0x39, 275 => 0x41, 276 => 0x49 },
	'totalzoom' => { 157 => 0x62 },
	'touchae' => { 370 => 0xab },
	'touchfn' => { 339 => 0x154 },
	'touchfnareatall' => { 339 => 0x15b },
	'touchfnareawide' => { 339 => 0x159 },
	'touchfnrole' => { 339 => 0x155 },
	'track' => { 427 => "\xa9trk", 435 => "\xa9trk" },
	'trackcreatedate' => { 434 => 0x1 },
	'trackmodifydate' => { 434 => 0x2 },
	'trackname' => { 435 => 'tnam' },
	'tracknumber' => { 427 => 'trkn', 564 => 'trackNumber' },
	'tracks' => { 564 => 'Tracks' },
	'tracksframerate' => { 564 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 564 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 564 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 564 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 564 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 564 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 564 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 564 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 564 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 564 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 564 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 564 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 564 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 564 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 564 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 564 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 564 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 435 => 'kgtt' },
	'trailer' => { 126 => 'Trailer' },
	'trailersignature' => { 181 => 'zmie' },
	'transcript' => { 548 => 'Transcript' },
	'transcriptlink' => { 548 => 'TranscriptLink' },
	'transcriptlinklink' => { 548 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 548 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 125 => 0x12d, 560 => 'TransferFunction' },
	'transfertimenormal' => { 155 => 0x1888 },
	'transfertimetest' => { 155 => 0x1889 },
	'transform' => { 370 => [0x8012,0x59] },
	'transformation' => { 549 => 'Transformation' },
	'transmissionreference' => { 552 => 'TransmissionReference' },
	'trapped' => { 355 => 'Trapped', 550 => 'Trapped' },
	'trashbuttonfunction' => { 90 => 0x710 },
	'travelday' => { 370 => 0x36 },
	'treble' => { 426 => 'player.movie.audio.treble', 429 => 'player.movie.audio.treble' },
	'triggermode' => { 437 => 0x6, 438 => 0x34, 439 => 0x28, 440 => 0x44, 441 => 0x34 },
	'tstop' => { 125 => 0xc772 },
	'ttl_da_adown' => { 396 => 0x5 },
	'ttl_da_aup' => { 396 => 0x4 },
	'ttl_da_bdown' => { 396 => 0x7 },
	'ttl_da_bup' => { 396 => 0x6 },
	'tungstenawb' => { 384 => 0x1 },
	'tvepisode' => { 427 => 'tves' },
	'tvepisodeid' => { 427 => 'tven' },
	'tvexposuretimesetting' => { 388 => 0x12 },
	'tvnetworkname' => { 427 => 'tvnn' },
	'tvseason' => { 427 => 'tvsn' },
	'tvshow' => { 427 => 'tvsh' },
	'type' => { 142 => 'Type', 537 => 'type', 559 => 'type' },
	'typestatus' => { 124 => [\'Identification','IdentificationTypeStatus'] },
	'uibfirmwareversion' => { 439 => 0x21 },
	'uniquecameramodel' => { 125 => 0xc614 },
	'uniquedocumentid' => { 148 => 0xbb },
	'uniquematrixauto' => { 155 => 0x7e9 },
	'uniquematrixcustom' => { 155 => 0x7e8 },
	'uniquematrixdaylight' => { 155 => 0x7e4 },
	'uniquematrixflash' => { 155 => 0x7e7 },
	'uniquematrixfluorescent' => { 155 => 0x7e6 },
	'uniquematrixtungsten' => { 155 => 0x7e5 },
	'uniqueobjectname' => { 149 => 0x64 },
	'units' => { 143 => 'Units' },
	'unknown_aacr' => { 427 => 'AACR' },
	'unknown_cdek' => { 427 => 'CDEK' },
	'unknown_cdet' => { 427 => 'CDET' },
	'unknownblock' => { 409 => 0x405 },
	'unknownblock1' => { 349 => 0x635 },
	'unknownblock2' => { 349 => 0x636 },
	'unknownblock3' => { 349 => 0x1103 },
	'unknownblock4' => { 349 => 0x1104 },
	'unknowncontrast' => { 115 => 0x45 },
	'unknowndate' => { 418 => 0x212 },
	'unknownev' => { 155 => 0x1 },
	'unknownlinear' => { 115 => 0x46 },
	'unknownnumber' => { 103 => 0x180b },
	'unknownoutputhighlightpoint' => { 115 => 0x4a },
	'unknownoutputshadowpoint' => { 115 => 0x4b },
	'unknownrawhighlight' => { 115 => 0x7b },
	'unknownrawhighlightpoint' => { 115 => 0x48 },
	'unknownrawshadow' => { 115 => 0x84 },
	'unknownrawshadowpoint' => { 115 => 0x49 },
	'unknownsharpness' => { 115 => 0x47 },
	'unknowntags' => { 435 => 'TAGS' },
	'unknowntemperature' => { 127 => 0x4 },
	'unknownthumbnail' => { 435 => 'thmb' },
	'unsharp1color' => { 321 => 0x13 },
	'unsharp1halowidth' => { 321 => 0x19 },
	'unsharp1intensity' => { 321 => 0x17 },
	'unsharp1threshold' => { 321 => 0x1b },
	'unsharp2color' => { 321 => 0x2e },
	'unsharp2halowidth' => { 321 => 0x34 },
	'unsharp2intensity' => { 321 => 0x32 },
	'unsharp2threshold' => { 321 => 0x36 },
	'unsharp3color' => { 321 => 0x49 },
	'unsharp3halowidth' => { 321 => 0x4f },
	'unsharp3intensity' => { 321 => 0x4d },
	'unsharp3threshold' => { 321 => 0x51 },
	'unsharp4color' => { 321 => 0x64 },
	'unsharp4halowidth' => { 321 => 0x6a },
	'unsharp4intensity' => { 321 => 0x68 },
	'unsharp4threshold' => { 321 => 0x6c },
	'unsharpcount' => { 321 => 0x0 },
	'unsharpmask' => { 115 => 0x90, 316 => 0x76a43200 },
	'unsharpmaskfineness' => { 79 => 0xe, 109 => 0x20309 },
	'unsharpmaskstrength' => { 109 => 0x20308 },
	'unsharpmaskthreshold' => { 79 => 0xf, 109 => 0x2030a },
	'uprightcentermode' => { 534 => 'UprightCenterMode', 536 => 'UprightCenterMode' },
	'uprightcenternormx' => { 534 => 'UprightCenterNormX', 536 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 534 => 'UprightCenterNormY', 536 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 534 => 'UprightDependentDigest', 536 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 534 => 'UprightFocalLength35mm', 536 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 534 => 'UprightFocalMode', 536 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 534 => 'UprightFourSegments_0', 536 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 534 => 'UprightFourSegments_1', 536 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 534 => 'UprightFourSegments_2', 536 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 534 => 'UprightFourSegments_3', 536 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 534 => 'UprightFourSegmentsCount', 536 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 534 => 'UprightGuidedDependentDigest', 536 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 534 => 'UprightPreview', 536 => 'UprightPreview' },
	'uprighttransform_0' => { 534 => 'UprightTransform_0', 536 => 'UprightTransform_0' },
	'uprighttransform_1' => { 534 => 'UprightTransform_1', 536 => 'UprightTransform_1' },
	'uprighttransform_2' => { 534 => 'UprightTransform_2', 536 => 'UprightTransform_2' },
	'uprighttransform_3' => { 534 => 'UprightTransform_3', 536 => 'UprightTransform_3' },
	'uprighttransform_4' => { 534 => 'UprightTransform_4', 536 => 'UprightTransform_4' },
	'uprighttransform_5' => { 534 => 'UprightTransform_5', 536 => 'UprightTransform_5' },
	'uprighttransformcount' => { 534 => 'UprightTransformCount', 536 => 'UprightTransformCount' },
	'uprightversion' => { 534 => 'UprightVersion', 536 => 'UprightVersion' },
	'urgency' => { 148 => 0xa, 552 => 'Urgency' },
	'url' => { 174 => 'URL', 359 => 'URL', 423 => 0x40b, 554 => 'url' },
	'url_list' => { 423 => 0x41e },
	'urla-platform' => { 554 => [\'url','urlA-platform'] },
	'urlurl' => { 554 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 90 => 0x10a },
	'usableshootingmodes' => { 90 => 0x109 },
	'usage' => { 555 => 'usage' },
	'usageterms' => { 568 => 'UsageTerms' },
	'usbpowerdelivery' => { 260 => 0x9ac, 263 => 0x762, 264 => 0x7c2, 265 => 0x664, 266 => 0x694, 267 => 0x6fc },
	'usedialwithouthold' => { 339 => 0xc3, 340 => 0xbf, 341 => 0xbf, 342 => 0xbf },
	'useguidelines' => { 532 => 'useGuidelines' },
	'usepanoramaviewer' => { 146 => 'UsePanoramaViewer' },
	'usercollection' => { 429 => 'collection.user' },
	'usercomment' => { 103 => 0x805, 125 => 0x9286, 540 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 75 => 0xd8, 76 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 75 => 0xda, 76 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 75 => 0xdc, 76 => 0xf4 },
	'userfields' => { 526 => 'UserFields' },
	'userlabel' => { 437 => 0x2b, 438 => 0x68, 439 => 0x51, 440 => 0x76, 441 => 0x5a },
	'userprofile' => { 365 => 0x302, 369 => 0x34c, 372 => 0x3038 },
	'userrating' => { 429 => 'rating.user', 435 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 89 => 0x7, 90 => 0x501 },
	'uspsnumber' => { 554 => 'uspsNumber' },
	'utmeasting' => { 185 => 'Easting' },
	'utmmapdatum' => { 185 => 'Datum' },
	'utmnorthing' => { 185 => 'Northing' },
	'utmzone' => { 185 => 'Zone' },
	'uuid' => { 534 => 'UUID', 536 => 'UUID' },
	'uv-irfiltercorrection' => { 365 => 0x325 },
	'validbits' => { 349 => 0x611, 350 => 0x102c },
	'validcropcorners' => { 360 => 'ValidCropCorners' },
	'validpixeldepth' => { 353 => 0x611 },
	'variablelowpassfilter' => { 479 => 0x2028 },
	'variousmodes' => { 157 => 0x26 },
	'variousmodes2' => { 157 => 0x3a },
	'variprogram' => { 256 => 0xab },
	'varraydacnominalvalues' => { 155 => 0x191e },
	'vendor' => { 435 => 'vndr' },
	'vendorinfo' => { 138 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 138 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 138 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 138 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 124 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 133 => 0x0, 360 => 'Version', 425 => 'Version', 429 => 'version', 534 => 'Version', 536 => 'Version', 545 => 'Version' },
	'versioncreatedate' => { 516 => 0xd100 },
	'versionid' => { 565 => 'VersionID' },
	'versionidentifier' => { 554 => 'versionIdentifier' },
	'versionmodifydate' => { 516 => 0xd101 },
	'versions' => { 565 => 'Versions' },
	'versionscomments' => { 565 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 565 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 565 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 565 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 565 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 565 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 565 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 565 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 565 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 565 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 565 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 323 => '3.2', 324 => '47.2', 326 => '79.1', 341 => 0x11d, 342 => 0x135 },
	'verticalclockoverlaps' => { 155 => 0x412 },
	'verticalfuncbutton' => { 324 => '42.2', 326 => '67.1', 341 => 0x115, 342 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 341 => 0x1b7, 342 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 324 => '43.1' },
	'verticalfuncplusdials' => { 326 => '68.1' },
	'verticalisobutton' => { 267 => 0x792 },
	'verticalmovieafonbutton' => { 341 => 0x1f9, 342 => 0x211 },
	'verticalmoviefuncbutton' => { 341 => 0x1e1, 342 => 0x1f9 },
	'verticalmultiselector' => { 324 => '42.1', 326 => '66.1', 327 => '66.1', 337 => '66.1', 341 => 0x18f, 342 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 341 => 0x125, 342 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 90 => [0x510,0x51d] },
	'vibrance' => { 527 => 'Vibrance', 534 => 'Vibrance', 536 => 'Vibrance' },
	'vibrationreduction' => { 287 => [0x75,0x82,0x1ae], 295 => '586.1', 302 => '590.2', 306 => 0x4 },
	'videoalphamode' => { 564 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 564 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 564 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 564 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 548 => 'videoBitRate' },
	'videobitratemode' => { 548 => 'videoBitRateMode' },
	'videoburstmode' => { 370 => 0xbb },
	'videoburstresolution' => { 370 => 0xb3 },
	'videocodec' => { 72 => 0x74 },
	'videocolorspace' => { 564 => 'videoColorSpace' },
	'videocompression' => { 133 => 0x3806 },
	'videocompressor' => { 564 => 'videoCompressor' },
	'videodisplayaspectratio' => { 548 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 548 => 'videoEncodingProfile' },
	'videofieldorder' => { 564 => 'videoFieldOrder' },
	'videoframerate' => { 370 => 0x27, 564 => 'videoFrameRate' },
	'videoframesize' => { 564 => 'videoFrameSize' },
	'videoframesizeh' => { 564 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 564 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 564 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 564 => 'videoModDate' },
	'videopixelaspectratio' => { 564 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 564 => 'videoPixelDepth' },
	'videopreburst' => { 370 => 0xc1 },
	'videoquality' => { 119 => 0x4003 },
	'videorecordingmode' => { 133 => 0x3803 },
	'videoshottype' => { 548 => 'VideoShotType' },
	'videoshottypeidentifier' => { 548 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 548 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 548 => 'videoStreamsCount' },
	'viewfinder' => { 418 => 0x455 },
	'viewfinderdisplay' => { 323 => '12.4', 324 => '6.3' },
	'viewfinderwarning' => { 323 => '13.4', 333 => '3.5', 334 => '6.2', 338 => '4.4' },
	'viewfinderwarnings' => { 90 => 0x40a },
	'viewinfoduringexposure' => { 90 => 0x407 },
	'viewingmode' => { 467 => 0x2f, 484 => 0x18 },
	'viewingmode2' => { 467 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 267 => 0x7d2, 340 => 0x2a9 },
	'viewpoint' => { 553 => 'viewpoint' },
	'vignette' => { 455 => 0x139 },
	'vignetteamount' => { 534 => 'VignetteAmount', 536 => 'VignetteAmount' },
	'vignettecoefficient1' => { 307 => 0x24 },
	'vignettecoefficient2' => { 307 => 0x34 },
	'vignettecoefficient3' => { 307 => 0x44 },
	'vignettecontrol' => { 256 => 0x2a, 316 => 0x76a43205 },
	'vignettecontrolintensity' => { 316 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 531 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 307 => 0x0 },
	'vignettemidpoint' => { 534 => 'VignetteMidpoint', 536 => 'VignetteMidpoint' },
	'vignetting' => { 445 => 0x1011, 452 => 0xa052 },
	'vignettingcorrection' => { 125 => 0x7031, 452 => 0xa053, 479 => 0x2011 },
	'vignettingcorrparams' => { 125 => 0x7032, 510 => 0x64a, 511 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 452 => 0xa054 },
	'virtualfocallength' => { 549 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 339 => 0x161, 340 => 0x167, 341 => 0x167, 342 => 0x17f },
	'virtualimagexcenter' => { 549 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 549 => 'VirtualImageYCenter' },
	'visualcolor' => { 548 => 'VisualColour' },
	'visualtechnique' => { 553 => 'visualTechnique' },
	'voicememo' => { 454 => 0x216 },
	'volume' => { 554 => 'volume' },
	'vr_0x66' => { 287 => 0x66 },
	'vrdoffset' => { 69 => 0xd0 },
	'vrmode' => { 260 => 0x342, 262 => 0x226, 265 => 0x212, 266 => 0x226, 267 => 0x226, 306 => 0x6 },
	'vrtype' => { 306 => 0x8 },
	'waterdepth' => { 125 => 0x9403, 541 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 204 => 0x19a },
	'wb_bluelevel6500k' => { 204 => 0x18a },
	'wb_bluelevelcustom' => { 204 => 0x18e },
	'wb_bluelevelscloudy' => { 204 => 0x106 },
	'wb_bluelevelsdaylight' => { 204 => 0xea },
	'wb_bluelevelsflash' => { 204 => 0x122 },
	'wb_bluelevelsfluorescent' => { 204 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 204 => 0x254 },
	'wb_bluelevelsshade' => { 204 => 0x176 },
	'wb_bluelevelstungsten' => { 204 => 0xce },
	'wb_gbrglevels' => { 204 => 0xae, 207 => 0x4 },
	'wb_glevel' => { 349 => 0x11f },
	'wb_glevel3000k' => { 349 => 0x113 },
	'wb_glevel3300k' => { 349 => 0x114 },
	'wb_glevel3600k' => { 349 => 0x115 },
	'wb_glevel3900k' => { 349 => 0x116 },
	'wb_glevel4000k' => { 349 => 0x117 },
	'wb_glevel4300k' => { 349 => 0x118 },
	'wb_glevel4500k' => { 349 => 0x119 },
	'wb_glevel4800k' => { 349 => 0x11a },
	'wb_glevel5300k' => { 349 => 0x11b },
	'wb_glevel6000k' => { 349 => 0x11c },
	'wb_glevel6600k' => { 349 => 0x11d },
	'wb_glevel7500k' => { 349 => 0x11e },
	'wb_grbglevels' => { 224 => 0x0, 486 => 0x7303 },
	'wb_grbglevelsauto' => { 86 => 0x2, 486 => 0x7302 },
	'wb_grbglevelscloudy' => { 86 => 0x12 },
	'wb_grbglevelscustom1' => { 86 => 0x42 },
	'wb_grbglevelscustom2' => { 86 => 0x4a },
	'wb_grbglevelsdaylight' => { 86 => 0xa },
	'wb_grbglevelsflash' => { 86 => 0x32 },
	'wb_grbglevelsfluorescent' => { 86 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 86 => 0x2a },
	'wb_grbglevelstungsten' => { 86 => 0x1a },
	'wb_grbglevelsunderwater' => { 86 => 0x3a },
	'wb_rbgglevels' => { 221 => 0x0 },
	'wb_rblevels' => { 225 => 0x270, 256 => 0xc, 349 => 0x100 },
	'wb_rblevels1' => { 376 => 0x2 },
	'wb_rblevels2' => { 376 => 0x5 },
	'wb_rblevels3' => { 376 => 0x8 },
	'wb_rblevels3000k' => { 349 => 0x102 },
	'wb_rblevels3300k' => { 349 => 0x103 },
	'wb_rblevels3500k' => { 204 => 0x430 },
	'wb_rblevels3600k' => { 349 => 0x104 },
	'wb_rblevels3900k' => { 349 => 0x105 },
	'wb_rblevels4' => { 376 => 0xb },
	'wb_rblevels4000k' => { 349 => 0x106 },
	'wb_rblevels4300k' => { 349 => 0x107 },
	'wb_rblevels4500k' => { 349 => 0x108 },
	'wb_rblevels4800k' => { 349 => 0x109 },
	'wb_rblevels5' => { 376 => 0xe },
	'wb_rblevels5300k' => { 349 => 0x10a },
	'wb_rblevels6' => { 376 => 0x11 },
	'wb_rblevels6000k' => { 349 => 0x10b },
	'wb_rblevels6500k' => { 204 => 0x420 },
	'wb_rblevels6600k' => { 349 => 0x10c },
	'wb_rblevels7' => { 376 => 0x14 },
	'wb_rblevels7500k' => { 349 => 0x10d },
	'wb_rblevelsauto' => { 225 => 0x272, 353 => 0x110 },
	'wb_rblevelscloudy' => { 204 => 0x3f0, 206 => 0x10, 225 => 0x296, 353 => 0x121 },
	'wb_rblevelscoolwhitef' => { 204 => 0x308, 206 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 353 => 0x132 },
	'wb_rblevelscustom' => { 204 => 0x424, 206 => 0x1c },
	'wb_rblevelscwb1' => { 349 => 0x10e },
	'wb_rblevelscwb2' => { 349 => 0x10f },
	'wb_rblevelscwb3' => { 349 => 0x110 },
	'wb_rblevelscwb4' => { 349 => 0x111 },
	'wb_rblevelsdaylight' => { 204 => [0x3ec,0x528], 206 => 0xc, 225 => 0x274 },
	'wb_rblevelsdaylightf' => { 206 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 353 => 0x130 },
	'wb_rblevelsdaywhitef' => { 206 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 353 => 0x131 },
	'wb_rblevelseveningsunlight' => { 353 => 0x124 },
	'wb_rblevelsfineweather' => { 353 => 0x122 },
	'wb_rblevelsflash' => { 204 => [0x3f4,0x304], 206 => 0x18, 225 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 225 => 0x290 },
	'wb_rblevelsincandescent' => { 225 => 0x282 },
	'wb_rblevelsshade' => { 204 => 0x418, 206 => 0x20, 225 => 0x2b2, 353 => 0x120 },
	'wb_rblevelstungsten' => { 204 => 0x3e8, 206 => 0x8, 353 => 0x123 },
	'wb_rblevelsused' => { 353 => 0x100 },
	'wb_rblevelswhitef' => { 206 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 353 => 0x133 },
	'wb_redlevel3500k' => { 204 => 0x198 },
	'wb_redlevel6500k' => { 204 => 0x188 },
	'wb_redlevelcustom' => { 204 => 0x18c },
	'wb_redlevelscloudy' => { 204 => 0xf8 },
	'wb_redlevelsdaylight' => { 204 => 0xdc },
	'wb_redlevelsflash' => { 204 => 0x114 },
	'wb_redlevelsfluorescent' => { 204 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 204 => 0x1be },
	'wb_redlevelsshade' => { 204 => 0x168 },
	'wb_redlevelstungsten' => { 204 => 0xc0 },
	'wb_rgbglevels' => { 223 => 0x0 },
	'wb_rgblevels' => { 204 => [0x546,0x96], 366 => 0xd, 367 => 0x413, 372 => 0x3036, 418 => 0x107, 488 => 0x117c, 489 => 0x1180, 490 => 0x115c, 491 => 0x11d8, 492 => 0x11b4, 493 => 0x106c, 494 => 0x264, 495 => 0x264, 496 => 0x252 },
	'wb_rgblevels1' => { 377 => 0x2 },
	'wb_rgblevels2' => { 377 => 0x6 },
	'wb_rgblevels2500k' => { 486 => 0x782d },
	'wb_rgblevels3' => { 377 => 0xa },
	'wb_rgblevels3200k' => { 486 => 0x782c },
	'wb_rgblevels4' => { 377 => 0xe },
	'wb_rgblevels4500k' => { 486 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 377 => 0x12 },
	'wb_rgblevels6' => { 377 => 0x16 },
	'wb_rgblevels6000k' => { 486 => 0x782b },
	'wb_rgblevels7' => { 377 => 0x1a },
	'wb_rgblevels8500k' => { 486 => 0x782a },
	'wb_rgblevelsauto' => { 456 => 0x0 },
	'wb_rgblevelscloudy' => { 486 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 456 => 0x15 },
	'wb_rgblevelscustom2' => { 456 => 0x18 },
	'wb_rgblevelscustom3' => { 456 => 0x1b },
	'wb_rgblevelsdaylight' => { 456 => 0x3, 486 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 456 => 0x12, 486 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 456 => 0xf, 486 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 486 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 486 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 486 => 0x7828 },
	'wb_rgblevelsincandescent' => { 456 => 0xc },
	'wb_rgblevelsovercast' => { 456 => 0x9 },
	'wb_rgblevelsshade' => { 456 => 0x6, 486 => 0x7825 },
	'wb_rgblevelstungsten' => { 486 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 457 => 0x0 },
	'wb_rgblevelsunknown1' => { 457 => 0x3 },
	'wb_rgblevelsunknown2' => { 457 => 0x6 },
	'wb_rgblevelsunknown3' => { 457 => 0x9 },
	'wb_rgblevelsunknown4' => { 457 => 0xc },
	'wb_rgblevelsunknown5' => { 457 => 0xf },
	'wb_rgblevelsunknown6' => { 457 => 0x12 },
	'wb_rgblevelsunknown7' => { 457 => 0x15 },
	'wb_rgblevelsunknown8' => { 457 => 0x18 },
	'wb_rgblevelsunknown9' => { 457 => 0x1b },
	'wb_rgbmuldaylight' => { 155 => 0x852 },
	'wb_rgbmulflash' => { 155 => 0x855 },
	'wb_rgbmulfluorescent' => { 155 => 0x854 },
	'wb_rgbmultungsten' => { 155 => 0x853 },
	'wb_rggbblacklevels' => { 38 => 0x25 },
	'wb_rggblevels' => { 125 => 0x7313, 207 => 0x4, 222 => 0x0, 226 => 0x13e8, 227 => 0x38, 486 => 0x7313 },
	'wb_rggblevelsasshot' => { 41 => 0x0, 42 => 0x0, 43 => 0x19, 44 => 0x55, 45 => 0x69, 46 => 0x69, 47 => 0x22, 48 => 0x3f, 51 => 0x3f, 52 => 0x3f, 53 => 0x3f, 54 => 0x47 },
	'wb_rggblevelsauto' => { 38 => 0x1, 41 => 0x5, 42 => 0x8, 43 => 0x1e, 44 => 0x5a, 45 => 0x6e, 47 => 0x18, 48 => 0x44, 51 => 0x44, 52 => 0x44, 53 => 0x44, 54 => 0x4c, 226 => 0x1478, 227 => 0x114, 452 => 0xa022, 486 => 0x7312 },
	'wb_rggblevelsblack' => { 452 => 0xa028 },
	'wb_rggblevelscloudy' => { 38 => 0xd, 41 => 0x1e, 42 => 0x30, 43 => 0x2d, 44 => 0xa0, 45 => 0xd7, 46 => 0x78, 47 => 0x31, 48 => 0x58, 51 => 0x71, 52 => 0x8a, 53 => 0x8f, 54 => 0x92, 226 => 0x1408, 227 => 0x60, 409 => 0x20f, 417 => 0x14 },
	'wb_rggblevelscustom' => { 38 => 0x1d, 48 => 0x80, 226 => 0x1468, 227 => 0x100 },
	'wb_rggblevelscustom1' => { 43 => 0x41 },
	'wb_rggblevelscustom2' => { 43 => 0x46 },
	'wb_rggblevelsdaylight' => { 38 => 0x5, 41 => 0x14, 42 => 0x20, 43 => 0x23, 44 => 0x96, 45 => 0xcd, 46 => 0x6e, 47 => 0x27, 48 => 0x4e, 51 => 0x67, 52 => 0x80, 53 => 0x85, 54 => 0x88, 226 => 0x13f8, 227 => 0x4c, 409 => 0x20d, 417 => 0x2 },
	'wb_rggblevelsflash' => { 38 => 0x19, 41 => 0x32, 42 => 0x50, 43 => 0x3c, 44 => 0xb4, 45 => 0xeb, 46 => 0x87, 47 => 0x45, 48 => 0x6c, 51 => 0x85, 52 => 0x9e, 53 => 0xa3, 54 => 0xa6, 226 => 0x1448, 409 => 0x214, 417 => 0x41 },
	'wb_rggblevelsfluorescent' => { 38 => 0x15, 41 => 0x28, 42 => 0x40, 43 => 0x37, 44 => 0xaa, 45 => 0xe1, 46 => 0x82, 47 => 0x3b, 48 => 0x62, 51 => 0x7b, 52 => 0x94, 53 => 0x99, 54 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 227 => 0xc4, 409 => 0x211, 417 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 417 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 227 => 0xb0, 409 => 0x212, 417 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 226 => 0x1438, 227 => 0x9c, 409 => 0x213, 417 => 0x38 },
	'wb_rggblevelshtmercury' => { 227 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 452 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 452 => 0xa024 },
	'wb_rggblevelskelvin' => { 38 => 0x21, 41 => 0x2d, 42 => 0x48, 44 => 0xaf, 45 => 0xe6, 47 => 0x40, 48 => 0x67, 51 => 0x80, 52 => 0x99, 53 => 0x9e, 54 => 0xa1 },
	'wb_rggblevelsmeasured' => { 41 => 0xa, 42 => 0x10, 44 => 0x5f, 45 => 0x73, 48 => 0x49, 51 => 0x49, 52 => 0x49, 53 => 0x49, 54 => 0x51 },
	'wb_rggblevelspc1' => { 47 => 0x90, 48 => 0x71 },
	'wb_rggblevelspc2' => { 47 => 0x95, 48 => 0x76 },
	'wb_rggblevelspc3' => { 47 => 0x9a, 48 => 0x7b },
	'wb_rggblevelsshade' => { 38 => 0x9, 41 => 0x19, 42 => 0x28, 43 => 0x28, 44 => 0x9b, 45 => 0xd2, 46 => 0x73, 47 => 0x2c, 48 => 0x53, 51 => 0x6c, 52 => 0x85, 53 => 0x8a, 54 => 0x8d, 227 => 0x74, 409 => 0x20e, 417 => 0xb },
	'wb_rggblevelstungsten' => { 38 => 0x11, 41 => 0x23, 42 => 0x38, 43 => 0x32, 44 => 0xa5, 45 => 0xdc, 46 => 0x7d, 47 => 0x36, 48 => 0x5d, 51 => 0x76, 52 => 0x8f, 53 => 0x94, 54 => 0x97, 226 => 0x1428, 227 => 0x88, 409 => 0x210, 417 => 0x1d },
	'wb_rggblevelsuncorrected' => { 452 => 0xa021 },
	'wb_rggblevelsunknown' => { 41 => 0xf, 42 => 0x18, 44 => 0x64, 45 => 0x78, 47 => 0x1d, 51 => 0x4e, 52 => 0x4e, 53 => 0x4e, 54 => 0x56, 417 => 0x53 },
	'wb_rggblevelsunknown10' => { 41 => 0x5f, 42 => 0x98, 44 => 0x91, 45 => 0xa5, 46 => 0xb4, 47 => 0x72, 51 => 0x9e, 52 => 0x7b, 53 => 0x7b, 54 => 0x83 },
	'wb_rggblevelsunknown11' => { 41 => 0x64, 42 => 0xa0, 44 => 0xb9, 45 => [0xaa,0xaf], 46 => 0xb9, 47 => 0x77, 51 => 0xa3, 52 => 0xa3, 53 => 0x80, 54 => 0xab },
	'wb_rggblevelsunknown12' => { 41 => 0x69, 42 => 0xa8, 44 => 0xbe, 45 => 0xb4, 46 => 0xbe, 47 => 0x7c, 51 => 0xa8, 52 => 0xa8, 53 => 0xa8, 54 => 0xb0 },
	'wb_rggblevelsunknown13' => { 41 => 0x6e, 42 => 0xb0, 44 => 0xc3, 45 => 0xb9, 46 => 0xc3, 47 => 0x81, 51 => 0xad, 52 => 0xad, 53 => 0xad, 54 => 0xb5 },
	'wb_rggblevelsunknown14' => { 44 => 0xc8, 45 => 0xbe, 46 => 0xc8, 47 => 0x86, 51 => 0xb2, 52 => 0xb2, 53 => 0xb2, 54 => 0xba },
	'wb_rggblevelsunknown15' => { 44 => 0xcd, 45 => 0xc3, 46 => 0xcd, 47 => 0x8b, 51 => 0xb7, 52 => 0xb7, 53 => 0xb7, 54 => 0xbf },
	'wb_rggblevelsunknown16' => { 44 => 0xd2, 45 => 0xc8, 46 => 0xd2, 47 => 0x9f, 52 => 0xbc, 53 => 0xbc, 54 => 0xc4 },
	'wb_rggblevelsunknown17' => { 44 => 0xd7, 45 => 0xf0, 46 => 0xd7, 52 => 0xc1, 53 => 0xc1, 54 => 0xc9 },
	'wb_rggblevelsunknown18' => { 44 => 0xdc, 45 => 0xf5, 46 => 0xdc, 52 => 0xc6, 53 => 0xc6, 54 => 0xce },
	'wb_rggblevelsunknown19' => { 44 => 0xe1, 45 => 0xfa, 46 => 0xe1, 52 => 0xcb, 53 => 0xcb, 54 => 0xd3 },
	'wb_rggblevelsunknown2' => { 41 => 0x37, 42 => 0x58, 44 => 0x69, 45 => 0x7d, 46 => 0x8c, 47 => 0x4a, 51 => 0x53, 52 => 0x53, 53 => 0x53, 54 => 0x5b },
	'wb_rggblevelsunknown20' => { 44 => 0xe6, 45 => 0xff, 46 => 0xe6, 52 => 0xd0, 53 => 0xd0, 54 => 0xd8 },
	'wb_rggblevelsunknown21' => { 44 => 0xeb, 45 => 0x104, 46 => 0xeb, 53 => 0xd5, 54 => 0xdd },
	'wb_rggblevelsunknown22' => { 44 => 0xf0, 45 => 0x109, 46 => 0xf0, 53 => 0xda, 54 => 0xe2 },
	'wb_rggblevelsunknown23' => { 44 => 0xf5, 45 => 0x10e, 46 => 0xf5, 53 => 0xdf, 54 => 0xe7 },
	'wb_rggblevelsunknown24' => { 44 => 0xfa, 45 => 0x113, 46 => 0xfa, 53 => 0xe4, 54 => 0xec },
	'wb_rggblevelsunknown25' => { 44 => 0xff, 45 => 0x118, 46 => 0xff, 53 => 0xe9, 54 => 0xf1 },
	'wb_rggblevelsunknown26' => { 44 => 0x104, 45 => 0x11d, 46 => 0x104, 53 => 0xee, 54 => 0xf6 },
	'wb_rggblevelsunknown27' => { 44 => 0x109, 45 => 0x122, 46 => 0x109, 53 => 0xf3, 54 => 0xfb },
	'wb_rggblevelsunknown28' => { 44 => 0x10e, 46 => 0x10e, 53 => 0xf8, 54 => 0x100 },
	'wb_rggblevelsunknown29' => { 44 => 0x113, 46 => 0x113, 53 => 0xfd, 54 => 0x105 },
	'wb_rggblevelsunknown3' => { 41 => 0x3c, 42 => 0x60, 44 => 0x6e, 45 => 0x82, 46 => 0x91, 47 => 0x4f, 51 => 0x58, 52 => 0x58, 53 => 0x58, 54 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x118, 53 => 0x102 },
	'wb_rggblevelsunknown31' => { 46 => 0x11d },
	'wb_rggblevelsunknown32' => { 46 => 0x122 },
	'wb_rggblevelsunknown33' => { 46 => 0x127 },
	'wb_rggblevelsunknown4' => { 41 => 0x41, 42 => 0x68, 44 => 0x73, 45 => 0x87, 46 => 0x96, 47 => 0x54, 51 => 0x5d, 52 => 0x5d, 53 => 0x5d, 54 => 0x65 },
	'wb_rggblevelsunknown5' => { 41 => 0x46, 42 => 0x70, 44 => 0x78, 45 => 0x8c, 46 => 0x9b, 47 => 0x59, 51 => 0x62, 52 => 0x62, 53 => 0x62, 54 => 0x6a },
	'wb_rggblevelsunknown6' => { 41 => 0x4b, 42 => 0x78, 44 => 0x7d, 45 => 0x91, 46 => 0xa0, 47 => 0x5e, 51 => 0x8a, 52 => 0x67, 53 => 0x67, 54 => 0x6f },
	'wb_rggblevelsunknown7' => { 41 => 0x50, 42 => 0x80, 44 => 0x82, 45 => 0x96, 46 => 0xa5, 47 => 0x63, 51 => 0x8f, 52 => 0x6c, 53 => 0x6c, 54 => 0x74 },
	'wb_rggblevelsunknown8' => { 41 => 0x55, 42 => 0x88, 44 => 0x87, 45 => 0x9b, 46 => 0xaa, 47 => 0x68, 51 => 0x94, 52 => 0x71, 53 => 0x71, 54 => 0x79 },
	'wb_rggblevelsunknown9' => { 41 => 0x5a, 42 => 0x90, 44 => 0x8c, 45 => 0xa0, 46 => 0xaf, 47 => 0x6d, 51 => 0x99, 52 => 0x76, 53 => 0x76, 54 => 0x7e },
	'wb_rggblevelsuserselected' => { 417 => 0x5c },
	'wbadjblueamber' => { 109 => 0x20106 },
	'wbadjbluebalance' => { 322 => 0x8 },
	'wbadjcolortemp' => { 109 => 0x20102, 114 => 0x1a },
	'wbadjlighting' => { 322 => 0x14 },
	'wbadjmagentagreen' => { 109 => 0x20105 },
	'wbadjmode' => { 322 => 0x10 },
	'wbadjredbalance' => { 322 => 0x0 },
	'wbadjrggblevels' => { 109 => 0x20125, 114 => 0x6 },
	'wbadjtemperature' => { 322 => 0x18 },
	'wbadjtint' => { 322 => 0x25 },
	'wbblue' => { 133 => 0x144c },
	'wbbluelevel' => { 365 => 0x324, 370 => 0x8006, 375 => 0x26 },
	'wbbracketingsteps' => { 218 => 0x10, 219 => 0x10, 296 => 0x174d },
	'wbbracketmode' => { 61 => 0x9 },
	'wbbracketshotnumber' => { 204 => 0x2b, 445 => 0x101a },
	'wbbracketvalueab' => { 61 => 0xc },
	'wbbracketvaluegm' => { 61 => 0xd },
	'wbbutton' => { 264 => 0x806, 267 => 0x80a },
	'wbbuttonplaybackmode' => { 340 => 0x1c5 },
	'wbfinetuneactive' => { 114 => 0x24 },
	'wbfinetunesaturation' => { 114 => 0x28 },
	'wbfinetunetone' => { 114 => 0x2c },
	'wbgreen' => { 133 => 0x144b },
	'wbgreenlevel' => { 365 => 0x323, 370 => 0x8005, 375 => 0x25 },
	'wbmediaimagesizesetting' => { 90 => 0x708 },
	'wbmode' => { 206 => 0x4, 350 => 0x1015 },
	'wbred' => { 133 => 0x144a },
	'wbredlevel' => { 365 => 0x322, 370 => 0x8004, 375 => 0x24 },
	'wbscale' => { 207 => 0x0 },
	'wbshiftab' => { 79 => 0xc, 370 => 0x46, 389 => 0x10 },
	'wbshiftab_gm' => { 479 => 0x2014 },
	'wbshiftab_gm_precise' => { 479 => 0x2026 },
	'wbshiftcreativecontrol' => { 370 => 0x92 },
	'wbshiftgm' => { 79 => 0xd, 370 => 0x47, 389 => 0x11 },
	'wbshiftintelligentauto' => { 370 => 0x8b },
	'wbtype1' => { 376 => 0x1, 377 => 0x1 },
	'wbtype2' => { 376 => 0x4, 377 => 0x5 },
	'wbtype3' => { 376 => 0x7, 377 => 0x9 },
	'wbtype4' => { 376 => 0xa, 377 => 0xd },
	'wbtype5' => { 376 => 0xd, 377 => 0x11 },
	'wbtype6' => { 376 => 0x10, 377 => 0x15 },
	'wbtype7' => { 376 => 0x13, 377 => 0x19 },
	'webstatement' => { 568 => 'WebStatement' },
	'weightedflatsubject' => { 525 => 'weightedFlatSubject' },
	'what' => { 534 => 'What', 536 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 79 => 0x8, 82 => 0x7, 118 => 0x7, 119 => [0x19,0x2012], 125 => [0xa403,0xfe4e], 133 => 0x1002, 155 => 0x3fc, 156 => 0xfa0d, 157 => 0x40, 168 => 0x1a, 198 => 0x3, 199 => 0xe, 200 => 0x4, 201 => 0xb, 203 => 0x115, 256 => 0x5, 305 => 0x7, 365 => 0x304, 370 => 0x3, 372 => 0x3033, 409 => 0x19, 416 => 0x7, 444 => 0x26, 445 => 0x1003, 455 => [0x88,0x3c,0x7,0x58], 465 => 0xf, 466 => 0xe, 479 => [0x115,0xb054], 534 => 'WhiteBalance', 536 => 'WhiteBalance', 540 => 'WhiteBalance' },
	'whitebalance0' => { 193 => 'WhiteBalance0' },
	'whitebalance1' => { 193 => 'WhiteBalance1' },
	'whitebalance2' => { 193 => 'WhiteBalance2', 345 => 0x500 },
	'whitebalanceadj' => { 109 => 0x20101, 114 => 0x18, 316 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 384 => 0x0 },
	'whitebalancebias' => { 119 => 0x2011, 350 => 0x304, 370 => 0x23 },
	'whitebalanceblue' => { 79 => 0x7 },
	'whitebalancebracket' => { 345 => 0x502, 350 => 0x303 },
	'whitebalancebracketing' => { 133 => 0x1102, 201 => 0x22, 204 => 0x2c, 476 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 341 => 0x1c5, 342 => 0x1dd },
	'whitebalancecomp' => { 353 => 0x1001 },
	'whitebalancedetected' => { 155 => 0x3fb },
	'whitebalancefinetune' => { 133 => 0x100a, 201 => 0x38, 203 => 0x112, 256 => [0xb,0x3f], 445 => 0x1004, 465 => 0x6, 466 => 0x5, 479 => 0x112 },
	'whitebalancemode' => { 155 => 0x3fa, 409 => 0x1a },
	'whitebalancered' => { 79 => 0x6 },
	'whitebalanceset' => { 388 => 0xa },
	'whitebalancesetting' => { 201 => 0x23, 465 => 0x5, 466 => 0x4, 467 => 0x16, 484 => 0xd },
	'whitebalancesetup' => { 452 => 0x41 },
	'whitebalancetemperature' => { 345 => 0x501 },
	'whiteboard' => { 350 => 0x301 },
	'whitelevel' => { 125 => 0xc61d, 409 => 0x7e, 486 => 0x787f },
	'whitepoint' => { 125 => 0x13e, 369 => 0x35d, 409 => 0x201, 560 => 'WhitePoint' },
	'whites2012' => { 534 => 'Whites2012', 536 => 'Whites2012' },
	'whitesadj' => { 516 => 0x9017 },
	'wholeareatracking' => { 2 => 0x1a },
	'wideadapter' => { 445 => 0x1017 },
	'widefocuszone' => { 198 => 0x2f },
	'widerange' => { 454 => 0x20f },
	'wififirmwaredate' => { 440 => 0x42 },
	'wififirmwareversion' => { 440 => 0x3c },
	'windmode' => { 155 => 0x3f4 },
	'windnoisereduction' => { 262 => 0x352, 265 => 0x2d6, 266 => 0x2fe, 267 => 0x2fe },
	'windowlocation' => { 435 => 'WLOC' },
	'windowsatom' => { 535 => 'windowsAtom' },
	'windowsatomextension' => { 535 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 535 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 535 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 554 => 'wordCount' },
	'work' => { 427 => "\xa9wrk" },
	'workcolorspace' => { 109 => 0x10200, 114 => 0x270 },
	'workflowtag' => { 548 => 'WorkflowTag' },
	'workflowtagcvid' => { 548 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 548 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 548 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 548 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 542 => 'WorkToDo' },
	'worldtimelocation' => { 370 => 0x3a, 409 => 0x22, 415 => '0.1' },
	'writer' => { 196 => 'WM/Writer' },
	'writer-editor' => { 148 => 0x7a },
	'x3filllight' => { 455 => 0x12 },
	'xattrmditemwherefroms' => { 191 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 191 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 429 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 429 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 125 => 0x9a00 },
	'xiaomipreviewvideocover' => { 429 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 125 => 0x9999 },
	'xilinxversion' => { 155 => 0x414 },
	'xml' => { 153 => 'xml ' },
	'xmp' => { 112 => 0xffff00f6, 126 => 'XMP', 136 => 'XMP Data/XMP' },
	'xmptoolkit' => { 561 => 'xmptk' },
	'xpauthor' => { 125 => 0x9c9d },
	'xpcomment' => { 125 => 0x9c9c },
	'xpkeywords' => { 125 => 0x9c9e },
	'xposition' => { 125 => 0x11e },
	'xpsubject' => { 125 => 0x9c9f },
	'xptitle' => { 125 => 0x9c9b },
	'xresolution' => { 125 => 0x11a, 151 => 0x3, 424 => 0x0, 560 => 'XResolution' },
	'xyresolution' => { 129 => 0x3 },
	'yaw' => { 121 => 0x7, 435 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 272 => 0x8, 450 => 0x0 },
	'ycbcrcoefficients' => { 125 => 0x211, 560 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 125 => 0x213, 560 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 125 => 0x212, 560 => 'YCbCrSubSampling' },
	'year' => { 427 => 'yrrc', 429 => 'year', 435 => 'yrrc' },
	'yearcreated' => { 157 => 0x10, 166 => 0xc },
	'yellowhsl' => { 109 => 0x20912 },
	'yield' => { 556 => 'yield' },
	'yposition' => { 125 => 0x11f },
	'yresolution' => { 125 => 0x11b, 151 => 0x5, 424 => 0x4, 560 => 'YResolution' },
	'zebrapatterntonerange' => { 340 => 0x211, 341 => 0x211, 342 => 0x229 },
	'zoneidentifier' => { 126 => 'ZoneIdentifier' },
	'zonematching' => { 203 => 0x10a, 206 => [0x3a,0x4a], 479 => 0xb024 },
	'zonematchingmode' => { 201 => 0x14 },
	'zonematchingon' => { 200 => 0x75 },
	'zonematchingvalue' => { 465 => 0x1f },
	'zoomedpreviewlength' => { 350 => 0xf05 },
	'zoomedpreviewsize' => { 350 => 0xf06 },
	'zoomedpreviewstart' => { 350 => 0xf04 },
	'zoomsourcewidth' => { 37 => 0x24 },
	'zoomstepcount' => { 348 => 0x300, 350 => 0x100d },
	'zoomtargetwidth' => { 37 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acnespotremoval' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adjustmentdata' => 1,
	'adjustmentssettingsstatisticslightmap' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfok3iii' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsspecial' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaisused' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateformattrack' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'androidrelease' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'apdi' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcoreaccel0' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcoregyro0' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiounwarped' => 1,
	'aspectratiowarped' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachbinary' => 1,
	'attachfileextension' => 1,
	'attachfilename' => 1,
	'attachlongfilename' => 1,
	'attachlongpathname' => 1,
	'attachments' => 1,
	'attachmethod' => 1,
	'attachmimetype' => 1,
	'attachnum' => 1,
	'attachpathname' => 1,
	'attachsize' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobluetooth' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiokeys' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioprotuneoption' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoboostscore' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autoprotune' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyenable' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitratesetting' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'blush' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'cafpointinfo' => 1,
	'cafpointsinfocus' => 1,
	'cafpointsselected' => 1,
	'cafsensitivity' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfor6m2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedelaytimer' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelcolordata' => 1,
	'channelcolorindicates' => 1,
	'channelcolorspace' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelopacity' => 1,
	'channeloptions' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationdatapresent' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'closedcaptiontrack' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confidencemapimage' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastdetectaf' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'controllevel' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coordinateunits' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcircle' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapimage' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecodename' => 1,
	'devicecontainer' => 1,
	'devicehardwarerevision' => 1,
	'deviceid' => 1,
	'devicemake' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'diagonalfieldofview' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'digitalzoomamount' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djidebug' => 1,
	'djimetadata' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'droneinfo' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'durationsetting' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicstabilizationon' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exceptionendtime' => 1,
	'exceptionstarttime' => 1,
	'exefilename' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimemax' => 1,
	'exposuretimemin' => 1,
	'exposuretimes' => 1,
	'exposuretype' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedlanguagetag' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'eyebrows' => 1,
	'eyeenlarge' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'faceslimming' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishedimage' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firmwareversion56' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'forcedsubtitletrack' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalinfo' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'gkudata' => 1,
	'glamoursettings' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'google' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goudarequesttext' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpsinfo9' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdgainmapinfo' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgaincurve' => 1,
	'hdrgaincurvesize' => 1,
	'hdrgaininfo' => 1,
	'hdrgainmap' => 1,
	'hdrgm' => 1,
	'hdrimage' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrpsoftware' => 1,
	'hdrtoninginfo' => 1,
	'hdrvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'headshrinking' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hindsightsettings' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizoncontrol' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3-2' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imagename' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'initparamstext' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'insta360info' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isomax' => 1,
	'isomin' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsoninfo' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leglonger' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensprojection' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligogpsinfo' => 1,
	'ligojson' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'lipstick' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loggingmetadatatext' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magneticvariation' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotericohpentax2' => 1,
	'makernotericohpentax3' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mappingsignature' => 1,
	'mappingxcoefficients' => 1,
	'mappingxmode' => 1,
	'mappingycoefficients' => 1,
	'mappingymode' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxanalogiso' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediabox' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'mediamode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8v1' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'menusettingsz8' => 1,
	'mergedimage' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meteringframecount' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'mouthmodify' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'non-primarysourcetrack' => 1,
	'normallinetransfertiming' => 1,
	'noseslimming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'oneplus' => 1,
	'oneplustrailerlen' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationdatapresent' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalpayloadframecount' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadframe' => 1,
	'payloadmetadatatext' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdbage' => 1,
	'pdbcreatedate' => 1,
	'pdbfilename' => 1,
	'pdbmodifydate' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'polynomialcoefficients' => 1,
	'polynomialpower' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'powerprofile' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingnotes' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protocol' => 1,
	'protune' => 1,
	'protuneisomode' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'qualcommdualcamera' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawdevsubifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'rectifacetext' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rovegps' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'schedulecapture' => 1,
	'schedulecapturetime' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'serialnumber2' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'shotlogdatatext' => 1,
	'shotparamstext' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmaexif' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signaturelength' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'slowmotionrate' => 1,
	'slowmotionregions' => 1,
	'slowmotionregionsdurationepoch' => 1,
	'slowmotionregionsdurationflags' => 1,
	'slowmotionregionsdurationtimescale' => 1,
	'slowmotionregionsdurationvalue' => 1,
	'slowmotionregionsstarttimeepoch' => 1,
	'slowmotionregionsstarttimeflags' => 1,
	'slowmotionregionsstarttimescale' => 1,
	'slowmotionregionsstarttimevalue' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smoother' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwaredate' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedrampsetting' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spotmeter' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticmetadatatext' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitletrack' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'summarytext' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncronizedtrack' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'teethwhitening' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodetrack' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timelogtext' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transcripttrack' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uniformresourcename' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'uniqueidentifier' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_grpl' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'unusedloggingmetadata' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videokeys' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'visualsampledesc' => 1,
	'vivo' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitening' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zifannotations' => 1,
	'zifmetadata' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomscalenormalization' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2025, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
