<?php
require_once(__DIR__ . "/class_session.inc");
require_once(__DIR__ . "/class_layout.inc");
require_once(__DIR__ . "/class_metric.inc");
require_once(__DIR__ . "/metric_template.inc");

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$req_list = $session->getrequest("list");
if (isset($req_list)) {
    $layout_hosts = [];
    $host_dir = dir($symon['host_tree']);
    while ($host = $host_dir->read()) {
        if ($host != "." &&
            $host != ".." &&
            is_dir($symon['host_tree']."/".$host)) {
            $layout_hosts[] = $host;
        }
    }
    sort($layout_hosts);
    print json_encode($layout_hosts, JSON_THROW_ON_ERROR);
    return;
}

$req_machine = $session->getrequest("machine");
$req_type = $session->getrequest("type");
$req_start = $session->getrequest("start");
$req_stop = $session->getrequest("stop");
$req_step = $session->getrequest("step");
if (isset($req_machine) &&
    isset($req_type) &&
    is_numeric($req_start) &&
    is_numeric($req_stop) &&
    is_numeric($req_step)) {
    $m = new Metric($req_machine, $req_type, $req_start, $req_stop, $req_step);
    $m->render();
}
?>
