# -*- coding: utf-8 -*- #
# Copyright 2025 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This file is autogenerated and should not be edited by hand.
# AUTOGEN_CLI_VERSION: HEAD
"""The super-group for the IAM CLI."""

from googlecloudsdk.calliope import base
from surface.iam import _init_extensions as extensions


@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
@base.Autogenerated
class IamAlpha(extensions.IamAlpha):
  """Manage IAM service accounts and keys.

  The gcloud iam command group lets you manage Google Cloud Identity &
  Access Management (IAM) service accounts and keys.

  Cloud IAM authorizes who can take action on specific resources, giving you
  full control and visibility to manage cloud resources centrally. For
  established enterprises with complex organizational structures, hundreds of
  workgroups and potentially many more projects, Cloud IAM provides a unified
  view into security policy across your entire organization, with built-in
  auditing to ease compliance processes.

  More information on Cloud IAM can be found here:
  https://cloud.google.com/iam and detailed documentation can be found here:
  https://cloud.google.com/iam/docs/.
  """


@base.ReleaseTracks(base.ReleaseTrack.BETA)
@base.Autogenerated
class IamBeta(extensions.IamBeta):
  """Manage IAM service accounts and keys.

  The gcloud iam command group lets you manage Google Cloud Identity &
  Access Management (IAM) service accounts and keys.

  Cloud IAM authorizes who can take action on specific resources, giving you
  full control and visibility to manage cloud resources centrally. For
  established enterprises with complex organizational structures, hundreds of
  workgroups and potentially many more projects, Cloud IAM provides a unified
  view into security policy across your entire organization, with built-in
  auditing to ease compliance processes.

  More information on Cloud IAM can be found here:
  https://cloud.google.com/iam and detailed documentation can be found here:
  https://cloud.google.com/iam/docs/.
  """


@base.ReleaseTracks(base.ReleaseTrack.GA)
@base.Autogenerated
class IamGa(extensions.IamGa):
  """Manage IAM service accounts and keys.

  The gcloud iam command group lets you manage Google Cloud Identity &
  Access Management (IAM) service accounts and keys.

  Cloud IAM authorizes who can take action on specific resources, giving you
  full control and visibility to manage cloud resources centrally. For
  established enterprises with complex organizational structures, hundreds of
  workgroups and potentially many more projects, Cloud IAM provides a unified
  view into security policy across your entire organization, with built-in
  auditing to ease compliance processes.

  More information on Cloud IAM can be found here:
  https://cloud.google.com/iam and detailed documentation can be found here:
  https://cloud.google.com/iam/docs/.
  """
