/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windbg;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;
import sun.jvm.hotspot.debugger.windows.amd64.WindowsAMD64CFrame;
import sun.jvm.hotspot.debugger.windows.x86.WindowsX86CFrame;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;
import sun.jvm.hotspot.utilities.AddressOps;

class WindbgCDebugger
implements CDebugger {
    private WindbgDebugger dbg;

    WindbgCDebugger(WindbgDebugger dbg) {
        this.dbg = dbg;
    }

    @Override
    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    @Override
    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    @Override
    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        for (LoadObject obj : objs) {
            if (!AddressOps.lte(obj.getBase(), pc) || pc.minus(obj.getBase()) >= obj.getSize()) continue;
            return obj;
        }
        return null;
    }

    @Override
    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        if (this.dbg.getCPU().equals("x86")) {
            X86ThreadContext context = (X86ThreadContext)thread.getContext();
            Address ebp = context.getRegisterAsAddress(6);
            if (ebp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(14);
            if (pc == null) {
                return null;
            }
            return new WindowsX86CFrame(this.dbg, ebp, pc);
        }
        if (this.dbg.getCPU().equals("amd64")) {
            AMD64ThreadContext context = (AMD64ThreadContext)thread.getContext();
            Address rbp = context.getRegisterAsAddress(10);
            if (rbp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(17);
            if (pc == null) {
                return null;
            }
            return new WindowsAMD64CFrame(this.dbg, rbp, pc);
        }
        return null;
    }

    @Override
    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    @Override
    public ProcessControl getProcessControl() throws DebuggerException {
        return null;
    }

    @Override
    public boolean canDemangle() {
        return false;
    }

    @Override
    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }
}

