/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class Symbol
extends VMObject {
    private static long baseOffset;
    private static CIntegerField length;
    private static CIntegerField idHash;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Symbol");
        length = type.getCIntegerField("_length");
        baseOffset = type.getField("_body").getOffset();
        idHash = type.getCIntegerField("_identity_hash");
    }

    public static Symbol create(Address addr) {
        if (addr == null) {
            return null;
        }
        return new Symbol(addr);
    }

    Symbol(Address addr) {
        super(addr);
    }

    public boolean isSymbol() {
        return true;
    }

    public long getLength() {
        return length.getValue(this.addr);
    }

    public byte getByteAt(long index) {
        return this.addr.getJByteAt(baseOffset + index);
    }

    public int identityHash() {
        return (int)idHash.getValue(this.addr);
    }

    public boolean equals(byte[] modUTF8Chars) {
        int l = (int)this.getLength();
        if (l != modUTF8Chars.length) {
            return false;
        }
        while (l-- > 0) {
            if (modUTF8Chars[l] == this.getByteAt(l)) continue;
            return false;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(l == -1, "we should be at the beginning");
        }
        return true;
    }

    public byte[] asByteArray() {
        int length = (int)this.getLength();
        byte[] result = new byte[length];
        for (int index = 0; index < length; ++index) {
            result[index] = this.getByteAt(index);
        }
        return result;
    }

    public String asString() {
        try {
            return Symbol.readModifiedUTF8(this.asByteArray());
        }
        catch (Exception e) {
            System.err.println(this.addr);
            e.printStackTrace();
            return null;
        }
    }

    public boolean startsWith(String str) {
        return this.asString().startsWith(str);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("#" + this.asString());
    }

    public int fastCompare(Symbol other) {
        return (int)this.addr.minus(other.addr);
    }

    private static String readModifiedUTF8(byte[] buf) throws IOException {
        int len = buf.length;
        byte[] tmp = new byte[len + 2];
        tmp[0] = (byte)(len >>> 8 & 0xFF);
        tmp[1] = (byte)(len >>> 0 & 0xFF);
        System.arraycopy(buf, 0, tmp, 2, len);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tmp));
        return dis.readUTF();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Symbol.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

