/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import com.sun.java.swing.action.ActionManager;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.action.StateChangeAction;
import com.sun.java.swing.ui.CommonToolBar;
import com.sun.java.swing.ui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.SAPanel;
import sun.jvm.hotspot.ui.ThreadInfoPanel;
import sun.jvm.hotspot.ui.action.HSDBActionManager;

public class JavaThreadsPanel
extends SAPanel
implements ActionListener {
    private JavaThreadsTableModel dataModel;
    private StatusBar statusBar;
    private JTable threadTable;
    private List cachedThreads = new ArrayList();

    public JavaThreadsPanel() {
        VM.getVM().registerVMResumedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JavaThreadsPanel.this.decache();
            }
        });
        VM.getVM().registerVMSuspendedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JavaThreadsPanel.this.cache();
            }
        });
        this.cache();
        this.setLayout(new BorderLayout());
        this.dataModel = new JavaThreadsTableModel(this.cachedThreads);
        this.statusBar = new StatusBar();
        this.threadTable = new JTable(this.dataModel, new JavaThreadsColumnModel());
        this.threadTable.setSelectionMode(0);
        this.threadTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    JavaThreadsPanel.this.fireShowThreadOopInspector();
                }
            }
        });
        this.add((Component)new JavaThreadsToolBar(this.statusBar), "North");
        this.add((Component)new ThreadPanel(this.threadTable), "Center");
        this.add((Component)this.statusBar, "South");
        this.registerActions();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("inspect-command")) {
            this.fireShowThreadOopInspector();
        } else if (command.equals("memory-command")) {
            this.fireShowThreadStackMemory();
        } else if (command.equals("thread-info-command")) {
            this.fireShowThreadInfo();
        } else if (command.equals("find-crashes-command")) {
            if (this.fireShowThreadCrashes()) {
                this.statusBar.setMessage("Some thread crashes were encountered");
            } else {
                this.statusBar.setMessage("No thread crashes encountered");
            }
        } else if (command.equals("jstack-command")) {
            this.fireShowJavaStackTrace();
        }
    }

    protected void registerActions() {
        this.registerAction("inspect-command");
        this.registerAction("memory-command");
        this.registerAction("find-crashes-command");
        this.registerAction("jstack-command");
        ActionManager manager = ActionManager.getInstance();
        manager.setActionEnabled("inspect-command", false);
        manager.setActionEnabled("memory-command", false);
        manager.setActionEnabled("jstack-command", false);
    }

    private void registerAction(String actionName) {
        ActionManager manager = ActionManager.getInstance();
        DelegateAction action = manager.getDelegateAction(actionName);
        action.addActionListener(this);
    }

    private void fireShowThreadOopInspector() {
        int i = this.threadTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        JavaThread t = this.dataModel.getJavaThread(i);
        this.showThreadOopInspector(t);
    }

    private void fireShowThreadStackMemory() {
        int i = this.threadTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.showThreadStackMemory(this.dataModel.getJavaThread(i));
    }

    private void fireShowJavaStackTrace() {
        int i = this.threadTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.showJavaStackTrace(this.dataModel.getJavaThread(i));
    }

    private void fireShowThreadInfo() {
        int i = this.threadTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.showThreadInfo(this.dataModel.getJavaThread(i));
    }

    private boolean fireShowThreadCrashes() {
        boolean crash = false;
        Iterator iter = this.cachedThreads.iterator();
        block0: while (iter.hasNext()) {
            JavaThread t = ((CachedThread)iter.next()).getThread();
            RegisterMap tmpMap = t.newRegisterMap(false);
            for (Frame tmpFrame = t.getCurrentFrameGuess(); tmpFrame != null && !tmpFrame.isFirstFrame(); tmpFrame = tmpFrame.sender(tmpMap)) {
                if (!tmpFrame.isSignalHandlerFrameDbg()) continue;
                this.showThreadStackMemory(t);
                crash = true;
                continue block0;
            }
        }
        return crash;
    }

    private void cache() {
        Threads threads = VM.getVM().getThreads();
        for (JavaThread t = threads.first(); t != null; t = t.next()) {
            if (!t.isJavaThread()) continue;
            this.cachedThreads.add(new CachedThread(t));
        }
    }

    private void decache() {
        this.cachedThreads.clear();
    }

    private class CachedThread {
        private JavaThread thread;
        private String threadID;
        private String threadName;
        private boolean computed;

        public CachedThread(JavaThread thread) {
            this.thread = thread;
        }

        public JavaThread getThread() {
            return this.thread;
        }

        public String getThreadID() {
            if (!this.computed) {
                this.compute();
            }
            return this.threadID;
        }

        public String getThreadName() {
            if (!this.computed) {
                this.compute();
            }
            return this.threadName;
        }

        private void compute() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.thread.printThreadIDOn(new PrintStream(bos));
            this.threadID = bos.toString();
            this.threadName = this.thread.getThreadName();
            this.computed = true;
        }
    }

    private class JavaThreadsTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"OS Thread ID", "Java Thread Name"};
        private List elements;

        public JavaThreadsTableModel(List threads) {
            this.elements = threads;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.elements.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            CachedThread thread = this.getRow(row);
            switch (col) {
                case 0: {
                    return thread.getThreadID();
                }
                case 1: {
                    return thread.getThreadName();
                }
            }
            throw new RuntimeException("Index (" + col + ", " + row + ") out of bounds");
        }

        public JavaThread getJavaThread(int index) {
            return this.getRow(index).getThread();
        }

        private CachedThread getRow(int row) {
            return (CachedThread)this.elements.get(row);
        }

        private String threadIDAt(int index) {
            return ((CachedThread)JavaThreadsPanel.this.cachedThreads.get(index)).getThreadID();
        }

        private String threadNameAt(int index) {
            try {
                return ((CachedThread)JavaThreadsPanel.this.cachedThreads.get(index)).getThreadName();
            }
            catch (AddressException e) {
                return "<Error: AddressException>";
            }
            catch (NullPointerException e) {
                return "<Error: NullPointerException>";
            }
        }
    }

    private class JavaThreadsColumnModel
    extends DefaultTableColumnModel {
        private String[] columnNames = new String[]{"OS Thread ID", "Java Thread Name"};

        public JavaThreadsColumnModel() {
            int PREF_WIDTH = 80;
            int MAX_WIDTH = 100;
            int HUGE_WIDTH = 140;
            TableColumn column = new TableColumn(0, MAX_WIDTH);
            column.setHeaderValue(this.columnNames[0]);
            column.setMaxWidth(MAX_WIDTH);
            column.setResizable(false);
            this.addColumn(column);
            column = new TableColumn(1, HUGE_WIDTH);
            column.setHeaderValue(this.columnNames[1]);
            column.setResizable(false);
            this.addColumn(column);
        }
    }

    private class JavaThreadsToolBar
    extends CommonToolBar {
        public JavaThreadsToolBar(StatusBar status) {
            super(HSDBActionManager.getInstance(), status);
        }

        @Override
        protected void addComponents() {
            this.addButton(this.manager.getAction("inspect-command"));
            this.addButton(this.manager.getAction("memory-command"));
            this.addButton(this.manager.getAction("jstack-command"));
            this.addToggleButton(this.manager.getStateChangeAction("thread-info-command"));
            this.addButton(this.manager.getAction("find-crashes-command"));
        }
    }

    private class ThreadPanel
    extends JPanel {
        private JSplitPane splitPane;
        private JTable threadTable;
        private ThreadInfoPanel threadInfo;
        private int dividerSize;
        private int dividerLocation = -1;
        private boolean actionsEnabled = false;

        public ThreadPanel(JTable table) {
            this.setLayout(new BorderLayout());
            this.threadInfo = new ThreadInfoPanel();
            this.threadTable = table;
            this.splitPane = new JSplitPane(0);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setTopComponent(new JScrollPane(table));
            this.dividerSize = this.splitPane.getDividerSize();
            this.splitPane.setDividerSize(0);
            this.add((Component)this.splitPane, "Center");
            ActionManager manager = HSDBActionManager.getInstance();
            StateChangeAction action = manager.getStateChangeAction("thread-info-command");
            if (action != null) {
                action.setItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent evt) {
                        if (evt.getStateChange() == 1) {
                            ThreadPanel.this.showOutputPane();
                        } else {
                            ThreadPanel.this.hideOutputPane();
                        }
                    }
                });
            }
            ListSelectionModel selModel = table.getSelectionModel();
            selModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    if (!evt.getValueIsAdjusting()) {
                        ThreadPanel.this.setActionsEnabled(true);
                        if (ThreadPanel.this.isInfoVisible()) {
                            ThreadPanel.this.showCurrentThreadInfo();
                        }
                    }
                }
            });
        }

        private boolean isInfoVisible() {
            return this.splitPane.getBottomComponent() != null;
        }

        private void showOutputPane() {
            if (this.splitPane.getBottomComponent() == null) {
                this.splitPane.setBottomComponent(this.threadInfo);
                if (this.dividerLocation == -1) {
                    Dimension pSize = this.getSize();
                    this.dividerLocation = pSize.height / 2;
                }
                this.splitPane.setDividerSize(this.dividerSize);
                this.splitPane.setDividerLocation(this.dividerLocation);
                this.showCurrentThreadInfo();
            }
        }

        private void hideOutputPane() {
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.remove(this.threadInfo);
            this.splitPane.setDividerSize(0);
        }

        private void showCurrentThreadInfo() {
            int row = this.threadTable.getSelectedRow();
            if (row >= 0) {
                this.threadInfo.setJavaThread(JavaThreadsPanel.this.dataModel.getJavaThread(row));
            }
        }

        private void setActionsEnabled(boolean enabled) {
            if (this.actionsEnabled != enabled) {
                ActionManager manager = ActionManager.getInstance();
                manager.setActionEnabled("inspect-command", enabled);
                manager.setActionEnabled("memory-command", enabled);
                manager.setActionEnabled("jstack-command", enabled);
                this.actionsEnabled = enabled;
            }
        }
    }
}

