/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.tree;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;

public class BadAddressTreeNodeAdapter
extends FieldTreeNodeAdapter {
    private String message;

    private static String generateMessage(long addr, String kind) {
        return "** BAD " + kind + " " + Long.toHexString(addr) + " **";
    }

    public BadAddressTreeNodeAdapter(Address addr, MetadataField field, boolean treeTableMode) {
        super(field.getID(), treeTableMode);
        this.message = BadAddressTreeNodeAdapter.generateMessage(addr.minus(null), "METADATA");
    }

    public BadAddressTreeNodeAdapter(Address addr, OopField field, boolean treeTableMode) {
        super(field.getID(), treeTableMode);
        this.message = BadAddressTreeNodeAdapter.generateMessage(addr.minus(null), "OOP");
    }

    public BadAddressTreeNodeAdapter(OopHandle addr, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.message = BadAddressTreeNodeAdapter.generateMessage(addr.minus(null), "OOP");
    }

    public BadAddressTreeNodeAdapter(long addr, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.message = BadAddressTreeNodeAdapter.generateMessage(addr, "ADDRESS");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public SimpleTreeNode getChild(int index) {
        throw new RuntimeException("Should not call this");
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getIndexOfChild(SimpleTreeNode child) {
        throw new RuntimeException("Should not call this");
    }

    @Override
    public String getValue() {
        return this.message;
    }
}

