/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GenericArray;

public class KlassArray
extends GenericArray {
    private static long dataFieldOffset;
    protected static Type elemType;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        elemType = db.lookupType("Klass*");
        Type type = db.lookupType("Array<Klass*>");
        dataFieldOffset = type.getAddressField("_data").getOffset();
    }

    public KlassArray(Address addr) {
        super(addr, dataFieldOffset);
    }

    public Klass getAt(int i) {
        return (Klass)Metadata.instantiateWrapperFor(this.getAddressAt(i));
    }

    @Override
    public Type getElemType() {
        return elemType;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                KlassArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

