/*
 *                            COPYRIGHT
 *
 *  up2ps, simple unixplot file to ps file program converter
 *  Copyright (C) 2001 Luis Claudio Gamba Lopes
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact address for Email:
 *  lcgamboa@yahoo.com
 *
 */

#include<iostream>
#include<fstream>
#include<string>

#include<stdio.h>


using namespace std;

float SCALE= 3.0;
	
int
main (int argc, char **argv)
{
  int x1, y1, x2, y2, r;
  string s;
  string fname;

  for (int d = 1; d < argc; d++)
    {
      fname = argv[d];
      FILE *fi, *fo;
      float sx,sy;

      fi = fopen (fname.c_str (), "r");
      fname += ".ps";
      fo = fopen (fname.c_str (), "w");
      fprintf (fo,
	       "%!\n\%\%BoundingBox: 18 25 572 579\n/Courier findfont 12 scalefont setfont\n0 0 0 setrgbcolor\n0.1 setlinewidth newpath\n");
      while (!feof (fi))
	{
	  switch (getc (fi))
	    {
	    case 's':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      x2 = getc (fi) + (getc (fi) * 256);
	      y2 = getc (fi) + (getc (fi) * 256);

	      sx= x2/600.0;
	      sy= y2/800.0;
	      if(sx<sy)
	        SCALE=sy;
	      else
		SCALE=sx;      
//	      printf ("s--%i %i %i %i ???\n", x1, y1, x2, y2);
	      break;
	    case 'l':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      x2 = getc (fi) + (getc (fi) * 256);
	      y2 = getc (fi) + (getc (fi) * 256);
	      fprintf (fo, "%0.4f %0.4f moveto %0.4f %0.4f lineto\n",
		       x1 / SCALE, y1 / SCALE, x2 / SCALE, y2 / SCALE);
	      break;
	    case 'c':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      r = getc (fi) + (getc (fi) * 256);
	      fprintf (fo, "stroke newpath\n%0.4f %0.4f %0.4f 0 360 arc\n",x1 / SCALE, y1 / SCALE, r / SCALE);
	      break;
	    case 'n':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      fprintf (fo, "%0.4f %0.4f lineto\n", x1 / SCALE, y1 / SCALE);
	      break;
	    case 'm':
	      x1 = (getc (fi) * 256) + getc (fi);
	      y1 = (getc (fi) * 256) + getc (fi);
	      fprintf (fo,"%0.4f %0.4f moveto\n", x1 / SCALE, y1 / SCALE);
	      break;
	    case 'a':
	      x1 = (getc (fi) * 256) + getc (fi);
	      y1 = (getc (fi) * 256) + getc (fi);
	      x2 = (getc (fi) * 256) + getc (fi);
	      y2 = (getc (fi) * 256) + getc (fi);
	      r = (getc (fi) * 256) + getc (fi);
/*	      printf
		("a--stroke newpath\n%0.4f %0.4f %0.4f %0.4f %0.4f arc\n",
		x1 / SCALE, y1 / SCALE, x2 / SCALE, y2 / SCALE, r / SCALE);
*/
        	break;
	    case 'e':
	      break;
	    case 't':
	      while (r != '\n')
		r = getc (fi);
	      break;
	    };
	};
      fprintf (fo, "stroke showpage");
      fclose (fi);
      fclose (fo);
    };
};
